/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.SshApiBundle;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConnectionConfigPatchConverter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import java.util.UUID;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Tag(value="sshConfig")
public class SshConfig
implements Cloneable {
    public static final int DEFAULT_PORT = 22;
    @NonNls
    public static final String DEFAULT_KEY_PATH = "/.ssh/id_rsa";
    private static final int DEFAULT_INVALID_PORT = -1;
    @NotNull
    private String myId;
    private boolean isProjectLevel;
    @NotNull
    private String myHost = "";
    @NotNull
    private String myLiteralPort = "";
    private int myPort = -1;
    @Deprecated
    @NotNull
    private String myLiteralLocalPort = "";
    @Deprecated
    private int myLocalPort = -1;
    @NotNull
    private String myUsername = "";
    @NotNull
    private AuthType myAuthType = AuthType.KEY_PAIR;
    @NotNull
    private String myKeyPath = "";
    @NotNull
    private NameFormat myNameFormat;
    @Nullable
    @NlsSafe
    private String myCustomName;
    @Nullable
    private SshConnectionConfigPatch myConnectionConfigPatch;
    @Attribute(value="useOpenSSHConfig")
    @NotNull
    private String mySerializedUseOpenSSHConfig = "";

    @Attribute(value="id")
    @NotNull
    @NonNls
    public String getId() {
        String string = this.myId;
        if (string == null) {
            SshConfig.F(0);
        }
        return string;
    }

    public void setId(@NotNull String id) {
        if (id == null) {
            SshConfig.F(1);
        }
        this.myId = id;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setProjectLevel(boolean projectLevel) {
        this.isProjectLevel = projectLevel;
    }

    @Attribute(value="host")
    @NotNull
    @NlsSafe
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            SshConfig.F(2);
        }
        return string;
    }

    public void setHost(@Nullable String host) {
        this.myHost = StringUtil.notNullize((String)host);
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = Math.max(port, -1);
        this.myLiteralPort = String.valueOf(this.myPort);
    }

    @Attribute(value="port")
    @NotNull
    @NlsSafe
    public String getLiteralPort() {
        String string = this.myLiteralPort;
        if (string == null) {
            SshConfig.F(3);
        }
        return string;
    }

    public void setLiteralPort(@Nullable String literalPort) {
        this.myLiteralPort = StringUtil.notNullize((String)literalPort);
        this.myPort = SshConfig.parseSshPort(literalPort);
    }

    @Deprecated
    @Attribute(value="localPort")
    @NotNull
    public String getLiteralLocalPort() {
        String string = this.myLiteralLocalPort;
        if (string == null) {
            SshConfig.F(4);
        }
        return string;
    }

    @Deprecated
    public void setLiteralLocalPort(@Nullable String literalLocalPort) {
        this.myLiteralLocalPort = StringUtil.notNullize((String)literalLocalPort);
        this.myLocalPort = SshConfig.parseSshPort(literalLocalPort);
    }

    @Deprecated
    @Transient
    public int getLocalPort() {
        return this.myLocalPort;
    }

    @Deprecated
    public void setLocalPort(int localPort) {
        this.myLocalPort = Math.max(localPort, -1);
        this.myLiteralLocalPort = String.valueOf(this.myLocalPort);
    }

    @Attribute(value="username")
    @NlsSafe
    @NotNull
    public String getUsername() {
        String string = this.myUsername;
        if (string == null) {
            SshConfig.F(5);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.myUsername = StringUtil.notNullize((String)username);
    }

    @Attribute(value="authType")
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            SshConfig.F(6);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.F(7);
        }
        this.myAuthType = authType;
    }

    @Attribute(value="keyPath")
    @NotNull
    public String getKeyPath() {
        String string = this.myKeyPath;
        if (string == null) {
            SshConfig.F(8);
        }
        return string;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.myKeyPath = StringUtil.notNullize((String)keyPath);
    }

    @Transient
    public boolean isOpenSshConfigUsageForced() {
        if (StringUtil.isEmpty((String)this.mySerializedUseOpenSSHConfig)) {
            return !PlatformUtils.isDataGrip();
        }
        return Boolean.parseBoolean(this.mySerializedUseOpenSSHConfig);
    }

    @Transient
    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.mySerializedUseOpenSSHConfig = String.valueOf(useOpenSSHConfig);
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConnectionConfigPatch;
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConnectionConfigPatch = patch;
    }

    public void mergeKeyPath(@Nullable String keyPath) {
        if (!StringUtil.isEmpty((String)this.myKeyPath)) {
            return;
        }
        if (StringUtil.isEmpty((String)keyPath)) {
            return;
        }
        this.myKeyPath = keyPath;
    }

    @Transient
    @NotNull
    public String getName() {
        String string = this.myNameFormat.getName(this);
        if (string == null) {
            SshConfig.F(9);
        }
        return string;
    }

    @Deprecated
    @Attribute(value="nameFormat")
    @NotNull
    public NameFormat getSerializedNameFormat() {
        NameFormat nameFormat = this.myNameFormat;
        if (nameFormat == null) {
            SshConfig.F(10);
        }
        return nameFormat;
    }

    @Deprecated
    public void setSerializedNameFormat(@Nullable NameFormat nameFormat) {
        this.myNameFormat = nameFormat == null ? NameFormat.INITIAL : nameFormat;
    }

    @Deprecated
    @Attribute(value="customName")
    @Nullable
    public String getSerializedCustomName() {
        return this.myCustomName;
    }

    @Deprecated
    public void setSerializedCustomName(@Nullable String customName) {
        this.myCustomName = StringUtil.nullize((String)customName, (boolean)true);
    }

    public void setCustomName(@Nullable String customName) {
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            this.myCustomName = null;
            if (this.myNameFormat == NameFormat.CUSTOM) {
                this.myNameFormat = NameFormat.DESCRIPTIVE;
            }
            return;
        }
        this.F(customName);
    }

    public void mergeCustomName(@Nullable String customName) {
        if (this.myCustomName != null && this.myNameFormat == NameFormat.CUSTOM) {
            return;
        }
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            return;
        }
        this.F(customName);
    }

    private void F(@NotNull String string) {
        if (string == null) {
            SshConfig.F(11);
        }
        if (string.equals(NameFormat.DESCRIPTIVE.getName(this))) {
            this.myCustomName = null;
            this.myNameFormat = NameFormat.DESCRIPTIVE;
        } else {
            this.myCustomName = string;
            this.myNameFormat = NameFormat.CUSTOM;
        }
    }

    @Nullable
    public String getCustomName() {
        return this.myNameFormat == NameFormat.CUSTOM ? this.myCustomName : null;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String string = this.myNameFormat.getPresentableShortName(this);
        if (string == null) {
            SshConfig.F(12);
        }
        return string;
    }

    @Nls
    @Nullable
    public String getPresentableAddition() {
        return this.myNameFormat.getPresentableAddition(this);
    }

    @Nls
    @NotNull
    public String getPresentableFullName() {
        String string = this.getPresentableShortName();
        if (string == null) {
            SshConfig.F(13);
        }
        return string;
    }

    @NotNull
    public AuthData getAuthDataFromForPasswordSafe() {
        AuthData authData = new AuthData();
        switch (this.myAuthType) {
            case PASSWORD: {
                Pair<Credentials, Boolean> pair = this.getPasswordCredentialsFromPasswordSafe();
                authData.setPasswordAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                break;
            }
            case KEY_PAIR: {
                Pair<Credentials, Boolean> pair = this.getPassphraseCredentialsFromPasswordSafe();
                authData.setKeyAuth((Credentials)pair.getFirst(), (Boolean)pair.getSecond());
                break;
            }
        }
        AuthData authData2 = authData;
        if (authData2 == null) {
            SshConfig.F(14);
        }
        return authData2;
    }

    @Nullable
    public Credentials getCredentials() {
        return switch (this.myAuthType) {
            case AuthType.PASSWORD -> (Credentials)this.getPasswordCredentialsFromPasswordSafe().getFirst();
            case AuthType.KEY_PAIR -> (Credentials)this.getPassphraseCredentialsFromPasswordSafe().getFirst();
            default -> null;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshConfig sshConfig = (SshConfig)o;
        return this.isProjectLevel == sshConfig.isProjectLevel && this.myId.equals(sshConfig.myId) && this.myHost.equals(sshConfig.myHost) && this.myLiteralPort.equals(sshConfig.myLiteralPort) && this.myLiteralLocalPort.equals(sshConfig.myLiteralLocalPort) && this.myUsername.equals(sshConfig.myUsername) && this.myAuthType == sshConfig.myAuthType && this.myKeyPath.equals(sshConfig.myKeyPath) && this.myNameFormat == sshConfig.myNameFormat && this.mySerializedUseOpenSSHConfig.equals(sshConfig.mySerializedUseOpenSSHConfig) && Objects.equals(this.myCustomName, sshConfig.myCustomName) && Objects.equals(this.myConnectionConfigPatch, sshConfig.myConnectionConfigPatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.isProjectLevel(), this.getHost(), this.getLiteralPort(), this.getLiteralLocalPort(), this.getAuthType(), this.getKeyPath(), this.getUsername(), this.myNameFormat, this.myCustomName, this.isOpenSshConfigUsageForced(), this.getConnectionConfigPatch()});
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentials remoteCredentials = this.copyToCredentials(this.getAuthDataFromForPasswordSafe());
        if (remoteCredentials == null) {
            SshConfig.F(15);
        }
        return remoteCredentials;
    }

    @NotNull
    public RemoteCredentials copyToCredentials(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.F(16);
        }
        RemoteCredentialsHolder remoteCredentialsHolder = new RemoteCredentialsHolder();
        remoteCredentialsHolder.setHost(this.getHost());
        remoteCredentialsHolder.setLiteralPort(this.getLiteralPort());
        remoteCredentialsHolder.setAuthType(this.getAuthType());
        remoteCredentialsHolder.setUserName(this.getUsername());
        remoteCredentialsHolder.setPassword(data.getPassword());
        remoteCredentialsHolder.setPassphrase(data.getPassphrase());
        remoteCredentialsHolder.setStorePassword(data.isSavePassword());
        remoteCredentialsHolder.setStorePassphrase(data.isSavePassphrase());
        remoteCredentialsHolder.setPrivateKeyFile(this.getKeyPath());
        remoteCredentialsHolder.setOpenSshConfigUsageForced(this.isOpenSshConfigUsageForced());
        remoteCredentialsHolder.setConnectionConfigPatch(this.getConnectionConfigPatch());
        RemoteCredentialsHolder remoteCredentialsHolder2 = remoteCredentialsHolder;
        if (remoteCredentialsHolder2 == null) {
            SshConfig.F(17);
        }
        return remoteCredentialsHolder2;
    }

    @NotNull
    public static SshConfig create(boolean projectLevel, String host, int port, String username, AuthType authType, @Nullable String keyPath) {
        SshConfig sshConfig = new SshConfig(true);
        sshConfig.setProjectLevel(projectLevel);
        sshConfig.setHost(host);
        sshConfig.setPort(port);
        sshConfig.setUsername(username);
        sshConfig.setAuthType(authType);
        sshConfig.setKeyPath(keyPath);
        SshConfig sshConfig2 = sshConfig;
        if (sshConfig2 == null) {
            SshConfig.F(18);
        }
        return sshConfig2;
    }

    @Deprecated
    public SshConfig() {
        this(false);
    }

    public SshConfig(boolean latestFormat) {
        this.myId = UUID.randomUUID().toString();
        this.myNameFormat = latestFormat ? NameFormat.DESCRIPTIVE : NameFormat.INITIAL;
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPasswordCredentialsFromPasswordSafe() {
        return SshConfig.F(this, AuthType.PASSWORD);
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPassphraseCredentialsFromPasswordSafe() {
        return SshConfig.F(this, AuthType.KEY_PAIR);
    }

    public void eraseAuthDataFromPasswordSafe() {
        for (AuthType authType : AuthType.values()) {
            if (authType == AuthType.OPEN_SSH) continue;
            PasswordSafe.getInstance().set(SshConfig.F(this, false, authType), null, false);
        }
        this.F();
    }

    public void saveAuthDataToPasswordSafe(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.F(19);
        }
        Credentials credentials = null;
        boolean bl = false;
        Credentials credentials2 = null;
        boolean bl2 = false;
        switch (this.getAuthType()) {
            case PASSWORD: {
                String string = data.getPassword();
                bl = !data.isSavePassword();
                credentials = string == null ? null : new Credentials(null, string);
                break;
            }
            case KEY_PAIR: {
                String string = data.getPassphrase();
                bl2 = !data.isSavePassphrase();
                credentials2 = string == null ? null : new Credentials(null, string);
                break;
            }
            default: {
                return;
            }
        }
        PasswordSafe.getInstance().set(SshConfig.F(this, bl, AuthType.PASSWORD), credentials, bl);
        PasswordSafe.getInstance().set(SshConfig.F(this, bl2, AuthType.KEY_PAIR), credentials2, bl2);
        this.saveConfigPatchCredentialsToPasswordSafe(this.myConnectionConfigPatch);
    }

    public void setConnectionConfigPatchAuthData() {
        Credentials credentials;
        if (this.myConnectionConfigPatch != null && this.myConnectionConfigPatch.getProxyParams() != null && (credentials = this.F(this.myConnectionConfigPatch.getProxyParams())) != null) {
            this.F(this.myConnectionConfigPatch.getProxyParams(), credentials);
        }
    }

    private CredentialAttributes F(SshConnectionConfigPatch.ProxyParams proxyParams) {
        String string = CredentialAttributesKt.generateServiceName((String)"SshProxyServerPassword", (String)(SshConfig.F(proxyParams.getProxyHost(), "<host>") + ":" + SshConfig.F(String.valueOf(proxyParams.getProxyPort()), "<port>") + " " + this.getId()));
        return new CredentialAttributes(string, null, false);
    }

    private void F(SshConnectionConfigPatch.ProxyParams proxyParams) {
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = proxyParams.getAuthData();
        if (proxyAuthData != null) {
            PasswordSafe.getInstance().set(this.F(proxyParams), new Credentials(proxyAuthData.getUsername(), proxyAuthData.getPassword()));
        }
    }

    private void F() {
        if (this.myConnectionConfigPatch != null && this.myConnectionConfigPatch.getProxyParams() != null) {
            PasswordSafe.getInstance().set(this.F(this.myConnectionConfigPatch.getProxyParams()), null);
        }
    }

    private Credentials F(SshConnectionConfigPatch.ProxyParams proxyParams) {
        return PasswordSafe.getInstance().get(this.F(proxyParams));
    }

    private void F(SshConnectionConfigPatch.ProxyParams proxyParams, Credentials credentials) {
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = proxyParams.getAuthData();
        if (proxyAuthData != null) {
            String string = credentials.getUserName();
            String string2 = credentials.getPasswordAsString();
            if (string != null && !string2.isEmpty()) {
                proxyAuthData.setUsername(string);
                proxyAuthData.setPassword(string2);
            } else {
                proxyParams.setAuthData(null);
            }
        }
    }

    public void saveConfigPatchCredentialsToPasswordSafe(SshConnectionConfigPatch patch) {
        if (patch != null && patch.getProxyParams() != null) {
            SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = patch.getProxyParams().getAuthData();
            if (proxyAuthData != null) {
                this.F(patch.getProxyParams());
            } else {
                this.F();
            }
        }
    }

    @NotNull
    public PresentableId createPresentableId() {
        PresentableId presentableId = Objects.requireNonNull(PresentableId.createId((String)this.getId(), (String)this.getName()));
        if (presentableId == null) {
            SshConfig.F(20);
        }
        return presentableId;
    }

    public SshConfigVisibility getVisibility() {
        return this.isProjectLevel ? SshConfigVisibility.Project : SshConfigVisibility.App;
    }

    public SshConfig clone() {
        SshConfig sshConfig;
        try {
            sshConfig = (SshConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
        return sshConfig;
    }

    public String toString() {
        return "SshConfig{myId='" + this.myId + "', isProjectLevel=" + this.isProjectLevel + ", myHost='" + this.myHost + "', myLiteralPort='" + this.myLiteralPort + "', myPort=" + this.myPort + ", myLiteralLocalPort='" + this.myLiteralLocalPort + "', myLocalPort=" + this.myLocalPort + ", myUsername='" + this.myUsername + "', myAuthType=" + String.valueOf(this.myAuthType) + ", myKeyPath='" + this.myKeyPath + "', myNameFormat=" + String.valueOf((Object)this.myNameFormat) + ", mySerializedUseOpenSSHConfig=" + this.mySerializedUseOpenSSHConfig + ", myConnectionConfigPatch=" + String.valueOf(this.myConnectionConfigPatch) + "}";
    }

    @NotNull
    private static Pair<Credentials, Boolean> F(SshConfig sshConfig, @NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.F(21);
        }
        if (authType == AuthType.OPEN_SSH) {
            throw new IllegalStateException("Unexpected AuthType " + String.valueOf(authType));
        }
        CredentialAttributes credentialAttributes = SshConfig.F(sshConfig, false, authType);
        Credentials credentials = PasswordSafe.getInstance().get(credentialAttributes);
        boolean bl = credentials == null ? true : PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(credentialAttributes, credentials);
        return new Pair((Object)credentials, (Object)bl);
    }

    private static CredentialAttributes F(SshConfig sshConfig, Boolean bl, @NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.F(22);
        }
        String string = switch (authType) {
            case AuthType.PASSWORD -> "Password";
            case AuthType.KEY_PAIR -> "Passphrase";
            default -> throw new IllegalStateException("Unexpected AuthType " + String.valueOf(authType));
        };
        String string2 = CredentialAttributesKt.generateServiceName((String)("SshConfig" + string), (String)(SshConfig.F(sshConfig.getHost(), "<host>") + ":" + SshConfig.F(sshConfig.getLiteralPort(), "<port>") + " " + sshConfig.getId()));
        return new CredentialAttributes(string2, null, bl.booleanValue());
    }

    @NotNull
    private static String F(@Nullable String string, @NotNull String string2) {
        if (string2 == null) {
            SshConfig.F(23);
        }
        String string3 = StringUtil.isEmpty((String)string) ? string2 : string;
        if (string3 == null) {
            SshConfig.F(24);
        }
        return string3;
    }

    public static void parseContent(@NotNull String name, @NotNull SshConfig config) {
        Pair<String, String> pair;
        if (name == null) {
            SshConfig.F(25);
        }
        if (config == null) {
            SshConfig.F(26);
        }
        if ((pair = SshConfig.F(name, '@', "<username>")) == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setUsername((String)pair.getSecond());
        pair = SshConfig.F(name, ':', "<host>");
        if (pair == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setHost((String)pair.getSecond());
        boolean bl = false;
        Pair<String, String> pair2 = SshConfig.F(name, ':', "<port>");
        if (pair2 != null) {
            bl = true;
            name = (String)pair2.getFirst();
            config.setLiteralPort((String)pair2.getSecond());
        }
        if ((pair2 = SshConfig.F(name, ' ', "<port>")) == null) {
            return;
        }
        name = (String)pair2.getFirst();
        if (bl) {
            config.setLiteralLocalPort((String)pair2.getSecond());
        } else {
            config.setLiteralPort((String)pair2.getSecond());
            config.setLiteralLocalPort("");
        }
        if ("(p)".equals(name) || "password".equals(name)) {
            config.setAuthType(AuthType.PASSWORD);
        } else if ("(k)".equals(name) || "key".equals(name)) {
            config.setAuthType(AuthType.KEY_PAIR);
        } else if ("(o)".equals(name) || "agent".equals(name)) {
            config.setAuthType(AuthType.OPEN_SSH);
        }
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> F(@NotNull String string, char c, @Nullable String string2) {
        int n;
        if (string == null) {
            SshConfig.F(27);
        }
        if ((n = string.indexOf(c)) < 0) {
            return null;
        }
        String string3 = string.substring(0, n);
        if (string2 != null && string2.equals(string3)) {
            string3 = null;
        }
        return new Pair((Object)string.substring(n + 1), (Object)string3);
    }

    public static int parseSshPort(@Nullable String port) {
        return Math.max(StringUtil.parseInt((String)port, (int)-1), -1);
    }

    private static /* synthetic */ void F(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 7, 11, 16, 19, 21, 22, 23, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customName";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralLocalPort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedNameFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableShortName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFullName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthDataFromForPasswordSafe";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentableId";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNotEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setNonemptyCustomName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyToCredentials";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAuthDataToPasswordSafe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAndMemoryOnlyStatus";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeNotEmpty";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cutPiece";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 7, 11, 16, 19, 21, 22, 23, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }

    public static abstract sealed class NameFormat
    extends Enum<NameFormat> {
        public static final /* enum */ NameFormat INITIAL = new NameFormat(){

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    1.B(0);
                }
                @NonNls String string = switch (config.getAuthType()) {
                    default -> throw new MatchException(null, null);
                    case AuthType.PASSWORD -> "p";
                    case AuthType.KEY_PAIR -> "k";
                    case AuthType.OPEN_SSH -> "o";
                };
                String string2 = NameFormat.F(config) + " (" + string + ")";
                if (string2 == null) {
                    1.B(1);
                }
                return string2;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    1.B(2);
                }
                String string = DESCRIPTIVE.getPresentableShortName(config);
                if (string == null) {
                    1.B(3);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    1.B(4);
                }
                String string = DESCRIPTIVE.getPresentableAddition(config);
                if (string == null) {
                    1.B(5);
                }
                return string;
            }

            private static /* synthetic */ void B(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableAddition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        };
        public static final /* enum */ NameFormat DESCRIPTIVE = new NameFormat(){

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    2.B(0);
                }
                @NonNls String string = switch (config.getAuthType()) {
                    default -> throw new MatchException(null, null);
                    case AuthType.PASSWORD -> "password";
                    case AuthType.KEY_PAIR -> "key";
                    case AuthType.OPEN_SSH -> "agent";
                };
                String string2 = NameFormat.F(config) + " " + string;
                if (string2 == null) {
                    2.B(1);
                }
                return string2;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    2.B(2);
                }
                @Nullable String string = config.getUsername();
                @Nullable String string2 = config.getHost();
                @Nullable String string3 = config.getLiteralPort();
                String string4 = (String)(StringUtil.isEmpty((String)string) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.username", new Object[0]) + ">" : string) + "@" + (String)(StringUtil.isEmpty((String)string2) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.host", new Object[0]) + ">" : string2) + ":" + (String)(StringUtil.isEmpty((String)string3) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.port", new Object[0]) + ">" : string3) + (String)(config.getLocalPort() == -1 ? "" : ":" + config.getLocalPort());
                if (string4 == null) {
                    2.B(3);
                }
                return string4;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    2.B(4);
                }
                String string = switch (config.getAuthType()) {
                    default -> throw new MatchException(null, null);
                    case AuthType.PASSWORD -> SshApiBundle.message("ssh.config.name.presentation.auth.password", new Object[0]);
                    case AuthType.KEY_PAIR -> SshApiBundle.message("ssh.config.name.presentation.auth.key", new Object[0]);
                    case AuthType.OPEN_SSH -> SshApiBundle.message("ssh.config.name.presentation.auth.openssh.agent", new Object[0]);
                };
                if (string == null) {
                    2.B(5);
                }
                return string;
            }

            private static /* synthetic */ void B(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableAddition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        };
        public static final /* enum */ NameFormat CUSTOM = new NameFormat(){

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    3.B(0);
                }
                if (config.myCustomName != null) {
                    String string = config.myCustomName;
                    if (string == null) {
                        3.B(1);
                    }
                    return string;
                }
                String string = DESCRIPTIVE.getName(config);
                if (string == null) {
                    3.B(2);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    3.B(3);
                }
                if (config.myCustomName != null) {
                    String string = config.myCustomName;
                    if (string == null) {
                        3.B(4);
                    }
                    return string;
                }
                String string = DESCRIPTIVE.getPresentableShortName(config);
                if (string == null) {
                    3.B(5);
                }
                return string;
            }

            @Override
            @Nls
            @Nullable
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    3.B(6);
                }
                if (config.myCustomName != null) {
                    return null;
                }
                return DESCRIPTIVE.getPresentableAddition(config);
            }

            private static /* synthetic */ void B(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4, 5 -> new IllegalStateException(string);
                };
            }
        };
        private static final /* synthetic */ NameFormat[] $VALUES;

        public static NameFormat[] values() {
            return (NameFormat[])$VALUES.clone();
        }

        public static NameFormat valueOf(String name) {
            return Enum.valueOf(NameFormat.class, name);
        }

        @NonNls
        @NotNull
        public abstract String getName(@NotNull SshConfig var1);

        @Nls
        @NotNull
        public abstract String getPresentableShortName(@NotNull SshConfig var1);

        @Nls
        @Nullable
        public abstract String getPresentableAddition(@NotNull SshConfig var1);

        @NotNull
        private static String F(@NotNull SshConfig sshConfig) {
            if (sshConfig == null) {
                NameFormat.F(0);
            }
            String string = SshConfig.F(sshConfig.getUsername(), "<username>") + "@" + SshConfig.F(sshConfig.getHost(), "<host>") + ":" + SshConfig.F(sshConfig.getLiteralPort(), "<port>") + (String)(sshConfig.getLocalPort() == -1 ? "" : ":" + sshConfig.getLocalPort());
            if (string == null) {
                NameFormat.F(1);
            }
            return string;
        }

        private static /* synthetic */ NameFormat[] F() {
            return new NameFormat[]{INITIAL, DESCRIPTIVE, CUSTOM};
        }

        static {
            $VALUES = NameFormat.F();
        }

        private static /* synthetic */ void F(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBasicDescription";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class AuthData
    implements Cloneable {
        private String myPassword;
        private boolean mySavePassword;
        private String myPassphrase;
        private boolean mySavePassphrase;

        @Contract(value="!null, null->fail")
        public void setPasswordAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.F();
            if (credentials != null) {
                this.setPassword(credentials.getPasswordAsString());
                this.setSavePassword(memoryOnly == false);
            }
        }

        @Contract(value="!null, null->fail")
        public void setKeyAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.F();
            if (credentials != null) {
                this.setPassphrase(credentials.getPasswordAsString());
                this.setSavePassphrase(memoryOnly == false);
            }
        }

        private void F() {
            this.myPassword = null;
            this.mySavePassword = false;
            this.myPassphrase = null;
            this.mySavePassphrase = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthData authData = (AuthData)o;
            return this.mySavePassword == authData.mySavePassword && this.mySavePassphrase == authData.mySavePassphrase && Objects.equals(this.myPassword, authData.myPassword) && Objects.equals(this.myPassphrase, authData.myPassphrase);
        }

        public int hashCode() {
            return Objects.hash(this.getPassword(), this.isSavePassword(), this.getPassphrase(), this.isSavePassphrase());
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isSavePassword() {
            return this.mySavePassword;
        }

        public void setSavePassword(boolean savePassword) {
            this.mySavePassword = savePassword;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public void setPassphrase(String passphrase) {
            this.myPassphrase = passphrase;
        }

        public boolean isSavePassphrase() {
            return this.mySavePassphrase;
        }

        public void setSavePassphrase(boolean savePassphrase) {
            this.mySavePassphrase = savePassphrase;
        }

        public AuthData clone() {
            try {
                return (AuthData)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        public boolean hasNoCredentials(@NotNull AuthType authType, @NotNull String keyPath) {
            if (authType == null) {
                AuthData.F(0);
            }
            if (keyPath == null) {
                AuthData.F(1);
            }
            return switch (authType) {
                default -> throw new MatchException(null, null);
                case AuthType.OPEN_SSH -> false;
                case AuthType.PASSWORD -> {
                    if (this.myPassword == null) {
                        yield true;
                    }
                    yield false;
                }
                case AuthType.KEY_PAIR -> keyPath.isEmpty() || this.myPassphrase == null && SshConfigManager.getInstance(null).isPassphraseMayBeRequired(keyPath);
            };
        }

        @NotNull
        public static AuthData create(@Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase) {
            AuthData authData = new AuthData();
            authData.setPassword(password);
            authData.setSavePassword(savePassword);
            authData.setPassphrase(passphrase);
            authData.setSavePassphrase(savePassphrase);
            AuthData authData2 = authData;
            if (authData2 == null) {
                AuthData.F(2);
            }
            return authData2;
        }

        @NotNull
        public static AuthData create(@NotNull RemoteCredentials credentials) {
            if (credentials == null) {
                AuthData.F(3);
            }
            return AuthData.create(credentials.getPassword(), credentials.getPassphrase(), credentials.isStorePassword(), credentials.isStorePassphrase());
        }

        @NotNull
        public static AuthData create(@NotNull AuthType authType, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
            if (authType == null) {
                AuthData.F(4);
            }
            AuthData authData = new AuthData();
            AuthData authData2 = switch (authType) {
                default -> throw new MatchException(null, null);
                case AuthType.OPEN_SSH -> authData;
                case AuthType.PASSWORD -> {
                    authData.setPassword(credentials == null ? null : credentials.getPasswordAsString());
                    authData.setSavePassword(saveCredentialsInPermanentStore);
                    yield authData;
                }
                case AuthType.KEY_PAIR -> {
                    authData.setPassphrase(credentials == null ? null : credentials.getPasswordAsString());
                    authData.setSavePassphrase(saveCredentialsInPermanentStore);
                    yield authData;
                }
            };
            if (authData2 == null) {
                AuthData.F(5);
            }
            return authData2;
        }

        private static /* synthetic */ void F(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyPath";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNoCredentials";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

