/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re;

import com.intellij.re.PluginRestoredDatabaseSnapshot;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import liquibase.GlobalConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.exception.LiquibaseParseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.json.JsonSnapshotParser;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class PluginJsonSnapshotParser
extends JsonSnapshotParser {
    public DatabaseSnapshot parse(String path, ResourceAccessor resourceAccessor) throws LiquibaseParseException {
        PluginRestoredDatabaseSnapshot pluginRestoredDatabaseSnapshot;
        block12: {
            ExYaml yaml = new ExYaml();
            InputStream stream = resourceAccessor.openStream(null, path);
            try {
                if (stream == null) {
                    throw new LiquibaseParseException(path + " does not exist");
                }
                Map parsedYaml = this.getParsedYamlFromInputStream(yaml, stream);
                Map rootList = (Map)parsedYaml.get("snapshot");
                if (rootList == null) {
                    throw new LiquibaseParseException("Could not find root snapshot node");
                }
                String shortName = (String)((Map)rootList.get("database")).get("shortName");
                Database database = (Database)DatabaseFactory.getInstance().getDatabase(shortName).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                database.setConnection((DatabaseConnection)new OfflineConnection("offline:" + shortName, null));
                PluginRestoredDatabaseSnapshot snapshot = new PluginRestoredDatabaseSnapshot(database);
                ParsedNode snapshotNode = new ParsedNode(null, "snapshot");
                snapshotNode.setValue((Object)rootList);
                Map metadata = (Map)rootList.get("metadata");
                if (metadata != null) {
                    snapshot.getMetadata().putAll(metadata);
                }
                snapshot.load(snapshotNode, resourceAccessor);
                pluginRestoredDatabaseSnapshot = snapshot;
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LiquibaseParseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new LiquibaseParseException((Throwable)e);
                }
            }
            stream.close();
        }
        return pluginRestoredDatabaseSnapshot;
    }

    private Map getParsedYamlFromInputStream(Yaml yaml, InputStream stream) throws LiquibaseParseException {
        Map parsedYaml;
        try (InputStreamReader inputStreamReader = new InputStreamReader(stream, (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());){
            parsedYaml = (Map)yaml.load((Reader)inputStreamReader);
        }
        catch (Exception e) {
            throw new LiquibaseParseException("Syntax error in " + this.getSupportedFileExtensions()[0] + ": " + e.getMessage(), (Throwable)e);
        }
        return parsedYaml;
    }

    private static class ExYaml
    extends Yaml {
        private static final int CODE_POINT_LIMIT = 314572800;

        public ExYaml() {
            super((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            this.loadingConfig = new LoaderOptions();
            this.loadingConfig.setCodePointLimit(314572800);
        }
    }
}

