/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;

@ApiStatus.Internal
public abstract class RuleSet {
    private volatile Set<String> ruleIds;

    public abstract List<Rule> allRules();

    public abstract List<Rule> rulesForSentence(AnalyzedSentence var1);

    public Set<String> allRuleIds() {
        Set<String> result = this.ruleIds;
        if (result == null) {
            this.ruleIds = result = Collections.unmodifiableSet(this.allRules().stream().map(Rule::getId).collect(Collectors.toSet()));
        }
        return result;
    }

    public static RuleSet plain(List<Rule> rules) {
        final List<Rule> allRules = Collections.unmodifiableList(rules);
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                return allRules;
            }
        };
    }

    public static RuleSet textLemmaHinted(List<? extends Rule> rules) {
        return RuleSet.hinted(rules, true);
    }

    public static RuleSet textHinted(List<? extends Rule> rules) {
        return RuleSet.hinted(rules, false);
    }

    private static RuleSet hinted(List<? extends Rule> rules, boolean withLemmaHints) {
        final List<? extends Rule> allRules = Collections.unmodifiableList(rules);
        final HashMap byToken = new HashMap();
        final HashMap<String, BitSet> byLemma = new HashMap<String, BitSet>();
        final BitSet unclassified = new BitSet();
        for (int i = 0; i < allRules.size(); ++i) {
            Rule rule = allRules.get(i);
            boolean classified = false;
            if (rule instanceof AbstractTokenBasedRule) {
                AbstractTokenBasedRule.TokenHint firstHint;
                AbstractTokenBasedRule.TokenHint[] tokenHints = ((AbstractTokenBasedRule)rule).tokenHints;
                AbstractTokenBasedRule.TokenHint tokenHint = tokenHints == null ? null : (firstHint = withLemmaHints ? tokenHints[0] : (AbstractTokenBasedRule.TokenHint)Arrays.stream(tokenHints).filter(th -> !th.inflected).findFirst().orElse(null));
                if (firstHint != null) {
                    classified = true;
                    HashMap<String, BitSet> map = firstHint.inflected ? byLemma : byToken;
                    for (String hint : firstHint.lowerCaseValues) {
                        map.computeIfAbsent(hint, __ -> new BitSet()).set(i);
                    }
                }
            }
            if (classified) continue;
            unclassified.set(i);
        }
        return new RuleSet(){

            @Override
            public List<Rule> allRules() {
                return allRules;
            }

            @Override
            public List<Rule> rulesForSentence(AnalyzedSentence sentence) {
                BitSet set;
                BitSet included = new BitSet();
                included.or(unclassified);
                if (!byLemma.isEmpty()) {
                    for (String lemma : sentence.getLemmaSet()) {
                        set = (BitSet)byLemma.get(lemma);
                        if (set == null) continue;
                        included.or(set);
                    }
                }
                for (String token : sentence.getTokenSet()) {
                    set = (BitSet)byToken.get(token);
                    if (set == null) continue;
                    included.or(set);
                }
                return 2.filterList(included, allRules);
            }
        };
    }

    @ApiStatus.Internal
    public static <T> List<T> filterList(BitSet includedIndices, List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        int i = -1;
        while ((i = includedIndices.nextSetBit(i + 1)) >= 0) {
            result.add(list.get(i));
        }
        return result;
    }
}

