/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEvent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEventsQueue;
import com.intellij.kotlin.jupyter.core.editor.highlighting.restarter.NotebookHighlightingRestarter;
import com.intellij.kotlin.jupyter.core.editor.highlighting.service.DaemonAnalyzerStatusService;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueueImpl;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueue;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "eventsQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEvent;", "psiFileRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/psi/PsiFile;", "getPsiFileRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "psiFileRef$delegate", "Lkotlin/Lazy;", "mergeEvents", "events", "", "pushEvent", "", "event", "pullEvents", "clear", "requestHLRestart", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nHighlightingEventsQueueImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlightingEventsQueueImpl.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueueImpl\n+ 2 NotebookHighlightingRestarter.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/restarter/NotebookHighlightingRestarter\n+ 3 NotebookHighlightingRestarter.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/restarter/NotebookHighlightingRestarter$scheduleRegularUpdate$2\n+ 4 NotebookHighlightingRestarter.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/restarter/NotebookHighlightingRestarter$scheduleRegularUpdate$1\n+ 5 sync.kt\ncom/intellij/kotlin/jupyter/core/util/SyncKt\n+ 6 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,111:1\n53#2,7:112\n25#2,3:119\n28#2,4:123\n32#2,4:128\n60#2,4:132\n57#3:122\n56#4:127\n15#5,3:136\n13#6:139\n*S KotlinDebug\n*F\n+ 1 HighlightingEventsQueueImpl.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueueImpl\n*L\n105#1:112,7\n105#1:119,3\n105#1:123,4\n105#1:128,4\n105#1:132,4\n105#1:122\n105#1:127\n28#1:136,3\n23#1:139\n*E\n"})
public final class HighlightingEventsQueueImpl
extends HighlightingComponent
implements HighlightingEventsQueue {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @NotNull
    private final ConcurrentLinkedQueue<HighlightingEvent> eventsQueue;
    @NotNull
    private final Lazy psiFileRef$delegate;
    @NotNull
    private static final Logger LOG;

    public HighlightingEventsQueueImpl(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        this.project = project;
        this.notebookVirtualFile = notebookVirtualFile;
        this.eventsQueue = new ConcurrentLinkedQueue();
        this.psiFileRef$delegate = LazyKt.lazy(() -> HighlightingEventsQueueImpl.psiFileRef_delegate$lambda$0(this));
    }

    private final AtomicReference<PsiFile> getPsiFileRef() {
        Lazy lazy = this.psiFileRef$delegate;
        return (AtomicReference)lazy.getValue();
    }

    private final HighlightingEvent mergeEvents(List<HighlightingEvent> events) {
        if (events.isEmpty()) {
            return null;
        }
        int focusCell = ((HighlightingEvent)kotlin.collections.CollectionsKt.first(events)).getFocusCell();
        Integer prevFocusCell = null;
        Set changedCells = new LinkedHashSet();
        for (HighlightingEvent event : events) {
            Collection<Integer> eventCells = event.getChangedCells();
            if (eventCells != null) {
                changedCells.addAll(eventCells);
            }
            focusCell = event.getFocusCell();
            prevFocusCell = event.getPreviousFocusCell();
            CollectionsKt.addIfNotNull((Collection)changedCells, (Object)prevFocusCell);
        }
        changedCells.add(focusCell);
        return new HighlightingEvent(focusCell, prevFocusCell, changedCells, false);
    }

    @Override
    public void pushEvent(@NotNull HighlightingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventsQueue.add(event);
        if (event.isCustomEditorEvent()) {
            this.requestHLRestart();
        }
    }

    @Override
    @Nullable
    public HighlightingEvent pullEvents() {
        List events = new ArrayList();
        try {
            while (this.eventsQueue.poll() != null) {
                HighlightingEvent event;
                events.add(event);
            }
            ProgressManager.checkCanceled();
            return this.mergeEvents(events);
        }
        catch (ProcessCanceledException t) {
            this.eventsQueue.addAll(events);
            throw t;
        }
    }

    @Override
    public void clear() {
        this.eventsQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void requestHLRestart() {
        boolean bl;
        void file$iv$iv;
        void $this$iv;
        PsiFile psi;
        PsiFile psiFile = this.getPsiFileRef().get();
        if (psiFile == null) {
            HighlightingEventsQueueImpl $this$requestHLRestart_u24lambda_u240 = this;
            boolean bl2 = false;
            PsiFile foundPsi = UtilKt.findPsiFile($this$requestHLRestart_u24lambda_u240.notebookVirtualFile.getFile(), $this$requestHLRestart_u24lambda_u240.project);
            $this$requestHLRestart_u24lambda_u240.getPsiFileRef().set(foundPsi);
            psiFile = foundPsi;
        }
        if ((psi = psiFile) == null) {
            LOG.error("Cannot find psi file for notebook file: " + this.notebookVirtualFile.getFile());
            return;
        }
        NotebookHighlightingRestarter notebookHighlightingRestarter = NotebookHighlightingRestarter.INSTANCE;
        PsiFile file$iv = psi;
        long delayDelta$iv = 300L;
        boolean $i$f$scheduleRegularUpdate = false;
        void var8_9 = $this$iv;
        PsiFile psiFile2 = file$iv;
        Job associatedJob$iv$iv = NotebookHighlightingRestarter.access$getUpdateJob$p();
        boolean $i$f$shouldStartAfterPreChecks = false;
        Project project = file$iv$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DaemonAnalyzerStatusService analyzer$iv$iv = DaemonAnalyzerStatusService.Companion.getInstance(project);
        Job job = associatedJob$iv$iv;
        boolean bl3 = job != null ? job.isActive() : false;
        if (bl3) {
            boolean bl4 = false;
            bl = false;
        } else if (analyzer$iv$iv.getDaemonRunning()) {
            boolean bl5 = false;
            bl = false;
        } else {
            bl = true;
        }
        if (bl) {
            NotebookHighlightingRestarter.access$setUpdateJob$p(BuildersKt.launch$default((CoroutineScope)NotebookHighlightingRestarter.access$getRegularUpdateScope$p(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file$iv, delayDelta$iv, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                int I$0;
                int label;
                final /* synthetic */ PsiFile $file;
                final /* synthetic */ long $delayDelta;
                {
                    this.$file = $file;
                    this.$delayDelta = $delayDelta;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var3_3 = NotebookHighlightingRestarter.INSTANCE;
                            var4_5 = this.$file;
                            delayDelta$iv = this.$delayDelta;
                            $i$f$performHLStartupTemplate = 0;
                            v0 = file$iv.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
                            analyzer$iv = DaemonAnalyzerStatusService.Companion.getInstance(v0);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                            this.L$1 = file$iv;
                            this.L$2 = analyzer$iv;
                            this.J$0 = delayDelta$iv;
                            this.I$0 = $i$f$performHLStartupTemplate;
                            this.label = 1;
                            v1 = DelayKt.delay((long)delayDelta$iv, (Continuation)((Continuation)this));
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl30
                        }
                        case 1: {
                            $i$f$performHLStartupTemplate = this.I$0;
                            delayDelta$iv = this.J$0;
                            analyzer$iv = (DaemonAnalyzerStatusService)this.L$2;
                            file$iv = (PsiFile)this.L$1;
                            this_$iv = (NotebookHighlightingRestarter)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl30:
                            // 4 sources

                            while (analyzer$iv.getDaemonRunning()) {
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                                this.L$1 = file$iv;
                                this.L$2 = analyzer$iv;
                                this.J$0 = delayDelta$iv;
                                this.I$0 = $i$f$performHLStartupTemplate;
                                this.label = 2;
                                v2 = DelayKt.delay((long)150L, (Continuation)((Continuation)this));
                                if (v2 != var2_2) continue;
                                return var2_2;
                            }
                            break;
                        }
                        case 2: {
                            $i$f$performHLStartupTemplate = this.I$0;
                            delayDelta$iv = this.J$0;
                            analyzer$iv = (DaemonAnalyzerStatusService)this.L$2;
                            file$iv = (PsiFile)this.L$1;
                            this_$iv = (NotebookHighlightingRestarter)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            ** GOTO lbl30
                        }
                    }
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)file$iv);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)analyzer$iv);
                    this.J$0 = delayDelta$iv;
                    this.I$0 = $i$f$performHLStartupTemplate;
                    this.label = 3;
                    v3 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(file$iv){
                        final /* synthetic */ PsiFile $file;
                        {
                            this.$file = $file;
                        }

                        public final void invoke() {
                            UtilKt.restartAnalyzing(this.$file, NotebookHighlightingRestarter.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    if (v3 == var2_2) {
                        return var2_2;
                    }
                    ** GOTO lbl68
                    {
                        case 3: {
                            $i$f$performHLStartupTemplate = this.I$0;
                            delayDelta$iv = this.J$0;
                            analyzer$iv = (DaemonAnalyzerStatusService)this.L$2;
                            file$iv = (PsiFile)this.L$1;
                            this_$iv = (NotebookHighlightingRestarter)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl68:
                            // 2 sources

                            $i$a$-scheduleRegularUpdate-NotebookHighlightingRestarter$scheduleRegularUpdate$1 = false;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
        }
    }

    @Override
    public void dispose() {
        this.clear();
    }

    private static final AtomicReference psiFileRef_delegate$lambda$0(HighlightingEventsQueueImpl this$0) {
        Object object;
        boolean $i$f$withReadAccess = false;
        if (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed()) {
            boolean bl = false;
            object = new AtomicReference<PsiFile>(UtilKt.findPsiFile(this$0.notebookVirtualFile.getFile(), this$0.project));
        } else {
            object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(this$0){
                final /* synthetic */ HighlightingEventsQueueImpl this$0;
                {
                    this.this$0 = highlightingEventsQueueImpl;
                }

                public final T compute() {
                    boolean bl = false;
                    return (T)new AtomicReference<PsiFile>(UtilKt.findPsiFile(HighlightingEventsQueueImpl.access$getNotebookVirtualFile$p(this.this$0).getFile(), HighlightingEventsQueueImpl.access$getProject$p(this.this$0)));
                }
            });
        }
        return (AtomicReference)object;
    }

    static {
        Companion $this$notebookLogger$iv = Companion = new Companion(null);
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEventsQueueImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

