/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 42278257800146L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1400220810 + -31198, -1400220810 + -((char)-26650), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1400220810 + -31197, -1400220810 + -((char)-27850), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 112939323042902L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.F();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1136901180 + -((char)-602), 1136901180 + (char)-12953, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1136901180 + -((char)-603), -1137032250 - -((char)-10152), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1136901180 + -((char)-596), -1137032250 - -((char)-13650), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 96284336477609L;
                Object object = this.lock;
                String string = SshAgentIpcService.F();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-240382380 - -12690, -240382380 - -7195, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-240382380 - -12689, -240382380 - -20255, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-240382380 - -12688, 240382380 - 16824, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-240382380 - -12695, 240382380 - 19562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-240382380 - -12694, -240382380 - -4420, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-240382380 - -12693, -240382380 - -24414, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-240382380 - -12695, 240382380 - 19562, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-240382380 - -12692, -240382380 - -18496, (int)l2));
            if (ActionTimestamp.F() != null) {
                SshAgentIpcService.F("BvDmw");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 2049331649574L;
                    string = SshAgentIpcService.F();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 39960415571373L;
                String string2 = SshAgentIpcService.F();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = string2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(39845280 + 27211, -39845280 + -32584, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27210, -39845280 + -((char)-32560), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27209, -39845280 + -8175, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(39845280 + 27211, -39845280 + -32584, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27208, -39845280 + -12729, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(39845280 + 27211, -39845280 + -32584, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27223, -39845280 + -23708, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27222, 39845280 + 7579, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27209, -39845280 + -8175, (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(39845280 + 27211, -39845280 + -32584, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(39845280 + 27215, -39845280 + -1306, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(39845280 + 27221, 39845280 + 11472, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 55572560943277L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(20840130 + (char)-23386, 20840130 + (char)-12515, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 19462033885079L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1537057890 - -8373, 1537057890 + 21495, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00bf\u00de\u0010h\u0091aV\u0014\u00d9?C\u001cI\u0095~\u00c7\u00ff\u000eY\u0014L\u00d9n\u008eE\u007f\u00b1R\u00a7\u00f1I\u0011\u00ca\u00cd\u00cfG$\u00d8%\u00a5";
                        var4_3 = "\u00bf\u00de\u0010h\u0091aV\u0014\u00d9?C\u001cI\u0095~\u00c7\u00ff\u000eY\u0014L\u00d9n\u008eE\u007f\u00b1R\u00a7\u00f1I\u0011\u00ca\u00cd\u00cfG$\u00d8%\u00a5".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 84;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 4;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 76;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 109;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 15;
                                        break;
                                    }
                                    default: {
                                        v11 = 10;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFBBC5) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 28;
                            case 1 -> 14;
                            case 2 -> 160;
                            case 3 -> 84;
                            case 4 -> 214;
                            case 5 -> 102;
                            case 6 -> 21;
                            case 7 -> 177;
                            case 8 -> 6;
                            case 9 -> 249;
                            case 10 -> 218;
                            case 11 -> 125;
                            case 12 -> 89;
                            case 13 -> 183;
                            case 14 -> 50;
                            case 15 -> 12;
                            case 16 -> 162;
                            case 17 -> 129;
                            case 18 -> 33;
                            case 19 -> 178;
                            case 20 -> 5;
                            case 21 -> 83;
                            case 22 -> 195;
                            case 23 -> 138;
                            case 24 -> 45;
                            case 25 -> 60;
                            case 26 -> 131;
                            case 27 -> 236;
                            case 28 -> 225;
                            case 29 -> 250;
                            case 30 -> 153;
                            case 31 -> 57;
                            case 32 -> 126;
                            case 33 -> 200;
                            case 34 -> 85;
                            case 35 -> 74;
                            case 36 -> 206;
                            case 37 -> 229;
                            case 38 -> 56;
                            case 39 -> 97;
                            case 40 -> 52;
                            case 41 -> 190;
                            case 42 -> 134;
                            case 43 -> 67;
                            case 44 -> 186;
                            case 45 -> 172;
                            case 46 -> 222;
                            case 47 -> 122;
                            case 48 -> 42;
                            case 49 -> 69;
                            case 50 -> 37;
                            case 51 -> 216;
                            case 52 -> 197;
                            case 53 -> 141;
                            case 54 -> 16;
                            case 55 -> 36;
                            case 56 -> 113;
                            case 57 -> 63;
                            case 58 -> 215;
                            case 59 -> 61;
                            case 60 -> 32;
                            case 61 -> 237;
                            case 62 -> 161;
                            case 63 -> 103;
                            case 64 -> 22;
                            case 65 -> 51;
                            case 66 -> 142;
                            case 67 -> 170;
                            case 68 -> 116;
                            case 69 -> 109;
                            case 70 -> 135;
                            case 71 -> 175;
                            case 72 -> 121;
                            case 73 -> 150;
                            case 74 -> 38;
                            case 75 -> 132;
                            case 76 -> 245;
                            case 77 -> 0;
                            case 78 -> 49;
                            case 79 -> 11;
                            case 80 -> 165;
                            case 81 -> 112;
                            case 82 -> 111;
                            case 83 -> 196;
                            case 84 -> 68;
                            case 85 -> 34;
                            case 86 -> 148;
                            case 87 -> 13;
                            case 88 -> 149;
                            case 89 -> 252;
                            case 90 -> 108;
                            case 91 -> 117;
                            case 92 -> 158;
                            case 93 -> 171;
                            case 94 -> 40;
                            case 95 -> 242;
                            case 96 -> 105;
                            case 97 -> 47;
                            case 98 -> 94;
                            case 99 -> 130;
                            case 100 -> 72;
                            case 101 -> 173;
                            case 102 -> 163;
                            case 103 -> 145;
                            case 104 -> 233;
                            case 105 -> 54;
                            case 106 -> 66;
                            case 107 -> 182;
                            case 108 -> 151;
                            case 109 -> 136;
                            case 110 -> 127;
                            case 111 -> 143;
                            case 112 -> 167;
                            case 113 -> 251;
                            case 114 -> 128;
                            case 115 -> 1;
                            case 116 -> 96;
                            case 117 -> 100;
                            case 118 -> 31;
                            case 119 -> 194;
                            case 120 -> 4;
                            case 121 -> 240;
                            case 122 -> 91;
                            case 123 -> 24;
                            case 124 -> 98;
                            case 125 -> 227;
                            case 126 -> 41;
                            case 127 -> 110;
                            case 128 -> 77;
                            case 129 -> 71;
                            case 130 -> 39;
                            case 131 -> 53;
                            case 132 -> 244;
                            case 133 -> 243;
                            case 134 -> 106;
                            case 135 -> 15;
                            case 136 -> 155;
                            case 137 -> 43;
                            case 138 -> 2;
                            case 139 -> 78;
                            case 140 -> 114;
                            case 141 -> 181;
                            case 142 -> 205;
                            case 143 -> 64;
                            case 144 -> 35;
                            case 145 -> 76;
                            case 146 -> 46;
                            case 147 -> 168;
                            case 148 -> 228;
                            case 149 -> 95;
                            case 150 -> 86;
                            case 151 -> 133;
                            case 152 -> 203;
                            case 153 -> 70;
                            case 154 -> 137;
                            case 155 -> 176;
                            case 156 -> 209;
                            case 157 -> 210;
                            case 158 -> 18;
                            case 159 -> 202;
                            case 160 -> 156;
                            case 161 -> 29;
                            case 162 -> 169;
                            case 163 -> 30;
                            case 164 -> 180;
                            case 165 -> 224;
                            case 166 -> 7;
                            case 167 -> 253;
                            case 168 -> 191;
                            case 169 -> 221;
                            case 170 -> 157;
                            case 171 -> 9;
                            case 172 -> 92;
                            case 173 -> 220;
                            case 174 -> 219;
                            case 175 -> 73;
                            case 176 -> 201;
                            case 177 -> 193;
                            case 178 -> 226;
                            case 179 -> 154;
                            case 180 -> 25;
                            case 181 -> 189;
                            case 182 -> 212;
                            case 183 -> 44;
                            case 184 -> 185;
                            case 185 -> 118;
                            case 186 -> 159;
                            case 187 -> 65;
                            case 188 -> 93;
                            case 189 -> 174;
                            case 190 -> 187;
                            case 191 -> 164;
                            case 192 -> 204;
                            case 193 -> 188;
                            case 194 -> 82;
                            case 195 -> 238;
                            case 196 -> 139;
                            case 197 -> 8;
                            case 198 -> 246;
                            case 199 -> 55;
                            case 200 -> 192;
                            case 201 -> 20;
                            case 202 -> 27;
                            case 203 -> 23;
                            case 204 -> 119;
                            case 205 -> 140;
                            case 206 -> 90;
                            case 207 -> 198;
                            case 208 -> 59;
                            case 209 -> 255;
                            case 210 -> 247;
                            case 211 -> 26;
                            case 212 -> 81;
                            case 213 -> 207;
                            case 214 -> 80;
                            case 215 -> 58;
                            case 216 -> 211;
                            case 217 -> 213;
                            case 218 -> 217;
                            case 219 -> 107;
                            case 220 -> 87;
                            case 221 -> 75;
                            case 222 -> 184;
                            case 223 -> 230;
                            case 224 -> 123;
                            case 225 -> 10;
                            case 226 -> 239;
                            case 227 -> 208;
                            case 228 -> 19;
                            case 229 -> 48;
                            case 230 -> 234;
                            case 231 -> 101;
                            case 232 -> 115;
                            case 233 -> 88;
                            case 234 -> 104;
                            case 235 -> 99;
                            case 236 -> 3;
                            case 237 -> 254;
                            case 238 -> 232;
                            case 239 -> 179;
                            case 240 -> 152;
                            case 241 -> 144;
                            case 242 -> 166;
                            case 243 -> 231;
                            case 244 -> 124;
                            case 245 -> 120;
                            case 246 -> 223;
                            case 247 -> 147;
                            case 248 -> 248;
                            case 249 -> 17;
                            case 250 -> 62;
                            case 251 -> 241;
                            case 252 -> 235;
                            case 253 -> 79;
                            case 254 -> 146;
                            default -> 199;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.F("V3RqWc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 94846951535885L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.F();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9767, -1188804900 - -((char)-2852), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9771, -1188804900 - -((char)-246), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9776, -1188673830 + -((char)-8657), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9767, -1188804900 - -((char)-2852), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9771, -1188804900 - -((char)-246), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1188804900 - (char)-9775, 1188804900 - (char)-10593, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 94881059922585L;
                        String string3 = SshAgentIpcService.F();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(937412640 - (char)-16550, -937412640 - -20294, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(937412640 - (char)-16549, 937412640 - 32501, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 136375079887199L;
                String string2 = SshAgentIpcService.F();
                this.assertConnectionThread();
                Object object2 = this.lock;
                string = string2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22347, -1278325710 - -((char)-23624), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22351, -1278325710 - -17794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22324, 1278325710 - 27101, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22351, -1278325710 - -17794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22349, -1278325710 - -16977, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22347, -1278325710 - -((char)-23624), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22351, -1278325710 - -17794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22335, -1278325710 - -((char)-32275), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22347, -1278325710 - -((char)-23624), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22351, -1278325710 - -17794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22334, -1278325710 - -24354, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22347, -1278325710 - -((char)-23624), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22351, -1278325710 - -17794, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1278325710 - (char)-22337, 1278325710 - 18381, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 27157533503508L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                string = SshAgentIpcService.F();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30070, -455337180 - -((char)-23683), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(455337180 - (char)-30074, -455337180 - -((char)-23077), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30057, -455337180 - -((char)-22953), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30054, 455337180 - (char)-15648, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30070, -455337180 - -((char)-23683), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(455337180 - (char)-30074, -455337180 - -((char)-23077), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30055, 455337180 - (char)-8531, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30070, -455337180 - -((char)-23683), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(455337180 - (char)-30074, -455337180 - -((char)-23077), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30052, 455337180 - (char)-9228, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30070, -455337180 - -((char)-23683), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(455337180 - (char)-30074, -455337180 - -((char)-23077), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30053, 455337180 - (char)-23860, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30070, -455337180 - -((char)-23683), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(455337180 - (char)-30074, -455337180 - -((char)-23077), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(455337180 - (char)-30114, -455337180 - -((char)-19476), (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(455337180 - (char)-30115, -455337180 - -((char)-14951), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0096\u00bdwT\u00d0\u00bf9\u00d1\u0014\u0010\u000e\u009f\u00c53\u0005\u00ea\u009c\u00c0\u00cd\u00d5\u0084\u00ec\u0014\u0004 \u00de\u0016\u00f7\u00df\u0006t\u00a5+W1\u009e\u0018\u00e7\u00a0\u0001 b|\u00c2s\rMc\u00e4\\\u00e7@\u00dc\u00ff\u00e0\u00fd\u009c\u000f\u00faf\u0000\t\u00db\u00af\u0018p*\u00e9\u00d3\u0089\u0013\u0005p\u00aa\u00ab\u00b6;\b\u00e8X\u00b8\u0099{ J\u00c0\u0014\u00ab\u0085\u0090/\u00bfPN\u00a1:\u00b7!\u007f8\u00c8%V\u00e8\u000b\u00c8>\u0005\u0003o\u00c5\u000e\u00f6\u001e\u00eb\u00b0\u00cd\u0091j\u008eaW\u00dc\u00dd\u0012q>u\u00ae\u00ea\u00c3\u00b7\u00a8\u0082\t\u0016\u00aaP\u00cf\u0092\u00fb\f2'\u0010m4\u00f9\u00c4\u00bb\u0016\u00ad\u00bd82\u0003q\u001a \u0085\u00df\t`x\u00b9\u009bM\u00b3\u0019]\u00a4\u0010$\u0007\u00d0\u00a2\u009e\u00da\t$\u00ac\u0001\u0091\u0017H\u00ec\u00cfF?`\u00f3\u00b4\u00f9H\u008a\u00a0\u00bb\u0095\u0091~\u0003\f\u00cd\u00d5\u00c4i\u0017\u0080S\u0082~\u00a0;\u009e\u0017\u00dc\b\u00e1\u00f1\u0010\u00aa\u00b0\u0097S\u0091\u00e1r\u008d}\u00a3\t\u00bd}}Ns\u0083\u00c1\u00e8f\u0098d|\u00ac\u00d2L\u00dbr\u00c5\u00d0\r\u00d0\b\u00fb\u008a\u00da\u00c37k\u00c3\u00a9\f\u008a\u00d5\u00e43\u00ed\u0017v!j\u00e9\u001b\u000eF8\u001b\u00b2\u00ea',/FA\tt\u00d6\u00db\u007f0\u00b4)~\u0088\u00d1\u0091|\u00c1I\u0084rl\u00afH,\u001f-m\u00d1*x\u0014\u0002\u0098\u00b7\u0092E\u0010\u000f\u0016\u0085J\u0087\u0001\u0090\u0018=D^\u00be\u008d\u0091D_\u008aF\u008d^X\u00fa\u0004\u0004\u00117\u000e\u001f\u00d13\u008a\u00e1\u0082\u0080|\u0096\u007f\u00e5fv\u00b0\u0088t\u00e4\u00e3\u009e\u00d1m\u00edk\u00e1T\u00c7\u00c2\u00ed\u00ca\u00ed\u000e\u00a9\u000b\u00d8l\u00ae\u0004\u00a4\u00f1_\u00fdO~\u00b5\u0015\u001d\u0004\u0016\n\u00b4X\u00b1\u00b5\u00ac\u0097\u0001\u00f3\u00e2\u0094#1\u00f2\u00b0.\u00d1$)\u00c5\u0094\b\u0015\u00d2\u001evE>\u009fN9\u00b1k\u00ca\u009dk9\u001b>Dy\u0012\u000e\u00d6\u00c0\u0018\u00f2|\u00fd\u0019)S\u00f4\u008bQ>:V\u0019\u00e8\u0007\u00cd\u00d1\u0003\u00a7\u0097\u0015E\u0007[\u00a8\u00b5\u00e4\u00a6\u0092u(\u00e5.@ck\u00ba\u00b7\u00f6v>m;\u00f6\u00aa`&9\u00e3\u00ff&\u00b9D\u00c2b\\\u00f1\u00ff\u00af\u00b76\u00bbI\u00fc\u0093\u00e0\u0010\u00e9o?@\u000f\u00ffrM\u00c1\"\u0082;2\u0092+P\u00c8\u00f1\u0080\u001e\"Hk\u00b9\u00ea\u00e4\u00e1\u00b0\u00ba\u00e6`U\u00c6\u00d1\u0098\u00a2-\u008d\u0006M\u009bd\u00cd\u00b6\u00c8\u00d1L5\u00bd\u00fd&\u008bU/\u0088\u000e\u00ea\u00d9\u00ef\u00b4v,\u00b1\u00e7\u00c3\u0091z\u009f\u00b8`\u001b\u00cb+\u00cc\u00ef\u00e9\u00f2\u00d7`X\u00e6\u0084p7\u00abX]z\u00a2\u000e\u00937\u00f8\u00af\u00c8\u00b9!m\n\u009c\u0083\u00e2\u00fd8T>\u009e\u00ce[\u0018\u00b0\u00d7\u00a3}\u0005\u001ck\u00e3\u00d1_w\u00d8\u00f0\u00ed\\\u00b4\u008d\u009e'mjl_\t);\u001d\u00d7$)8\t\u0081\u00d1\u0007\u00b3*\n\u0000\"\u008b\b\u008e\u00a8\r\b\u000f\u00d2\u00cc\u00bb\n(G)\u0017\b\u00e5T\u00b3\u00be-F\u0091Yl\t\t\u0018\u00c8\u00b6\u0093\u00a6}2\u00df|";
                var4_3 = "\u0096\u00bdwT\u00d0\u00bf9\u00d1\u0014\u0010\u000e\u009f\u00c53\u0005\u00ea\u009c\u00c0\u00cd\u00d5\u0084\u00ec\u0014\u0004 \u00de\u0016\u00f7\u00df\u0006t\u00a5+W1\u009e\u0018\u00e7\u00a0\u0001 b|\u00c2s\rMc\u00e4\\\u00e7@\u00dc\u00ff\u00e0\u00fd\u009c\u000f\u00faf\u0000\t\u00db\u00af\u0018p*\u00e9\u00d3\u0089\u0013\u0005p\u00aa\u00ab\u00b6;\b\u00e8X\u00b8\u0099{ J\u00c0\u0014\u00ab\u0085\u0090/\u00bfPN\u00a1:\u00b7!\u007f8\u00c8%V\u00e8\u000b\u00c8>\u0005\u0003o\u00c5\u000e\u00f6\u001e\u00eb\u00b0\u00cd\u0091j\u008eaW\u00dc\u00dd\u0012q>u\u00ae\u00ea\u00c3\u00b7\u00a8\u0082\t\u0016\u00aaP\u00cf\u0092\u00fb\f2'\u0010m4\u00f9\u00c4\u00bb\u0016\u00ad\u00bd82\u0003q\u001a \u0085\u00df\t`x\u00b9\u009bM\u00b3\u0019]\u00a4\u0010$\u0007\u00d0\u00a2\u009e\u00da\t$\u00ac\u0001\u0091\u0017H\u00ec\u00cfF?`\u00f3\u00b4\u00f9H\u008a\u00a0\u00bb\u0095\u0091~\u0003\f\u00cd\u00d5\u00c4i\u0017\u0080S\u0082~\u00a0;\u009e\u0017\u00dc\b\u00e1\u00f1\u0010\u00aa\u00b0\u0097S\u0091\u00e1r\u008d}\u00a3\t\u00bd}}Ns\u0083\u00c1\u00e8f\u0098d|\u00ac\u00d2L\u00dbr\u00c5\u00d0\r\u00d0\b\u00fb\u008a\u00da\u00c37k\u00c3\u00a9\f\u008a\u00d5\u00e43\u00ed\u0017v!j\u00e9\u001b\u000eF8\u001b\u00b2\u00ea',/FA\tt\u00d6\u00db\u007f0\u00b4)~\u0088\u00d1\u0091|\u00c1I\u0084rl\u00afH,\u001f-m\u00d1*x\u0014\u0002\u0098\u00b7\u0092E\u0010\u000f\u0016\u0085J\u0087\u0001\u0090\u0018=D^\u00be\u008d\u0091D_\u008aF\u008d^X\u00fa\u0004\u0004\u00117\u000e\u001f\u00d13\u008a\u00e1\u0082\u0080|\u0096\u007f\u00e5fv\u00b0\u0088t\u00e4\u00e3\u009e\u00d1m\u00edk\u00e1T\u00c7\u00c2\u00ed\u00ca\u00ed\u000e\u00a9\u000b\u00d8l\u00ae\u0004\u00a4\u00f1_\u00fdO~\u00b5\u0015\u001d\u0004\u0016\n\u00b4X\u00b1\u00b5\u00ac\u0097\u0001\u00f3\u00e2\u0094#1\u00f2\u00b0.\u00d1$)\u00c5\u0094\b\u0015\u00d2\u001evE>\u009fN9\u00b1k\u00ca\u009dk9\u001b>Dy\u0012\u000e\u00d6\u00c0\u0018\u00f2|\u00fd\u0019)S\u00f4\u008bQ>:V\u0019\u00e8\u0007\u00cd\u00d1\u0003\u00a7\u0097\u0015E\u0007[\u00a8\u00b5\u00e4\u00a6\u0092u(\u00e5.@ck\u00ba\u00b7\u00f6v>m;\u00f6\u00aa`&9\u00e3\u00ff&\u00b9D\u00c2b\\\u00f1\u00ff\u00af\u00b76\u00bbI\u00fc\u0093\u00e0\u0010\u00e9o?@\u000f\u00ffrM\u00c1\"\u0082;2\u0092+P\u00c8\u00f1\u0080\u001e\"Hk\u00b9\u00ea\u00e4\u00e1\u00b0\u00ba\u00e6`U\u00c6\u00d1\u0098\u00a2-\u008d\u0006M\u009bd\u00cd\u00b6\u00c8\u00d1L5\u00bd\u00fd&\u008bU/\u0088\u000e\u00ea\u00d9\u00ef\u00b4v,\u00b1\u00e7\u00c3\u0091z\u009f\u00b8`\u001b\u00cb+\u00cc\u00ef\u00e9\u00f2\u00d7`X\u00e6\u0084p7\u00abX]z\u00a2\u000e\u00937\u00f8\u00af\u00c8\u00b9!m\n\u009c\u0083\u00e2\u00fd8T>\u009e\u00ce[\u0018\u00b0\u00d7\u00a3}\u0005\u001ck\u00e3\u00d1_w\u00d8\u00f0\u00ed\\\u00b4\u008d\u009e'mjl_\t);\u001d\u00d7$)8\t\u0081\u00d1\u0007\u00b3*\n\u0000\"\u008b\b\u008e\u00a8\r\b\u000f\u00d2\u00cc\u00bb\n(G)\u0017\b\u00e5T\u00b3\u00be-F\u0091Yl\t\t\u0018\u00c8\u00b6\u0093\u00a6}2\u00df|".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 15;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "|\u001b\u00d7\f\u00c1\u00d5\u00fc\u00d4\u0087E\u0091\u008a\u00a6\u00fc_\u00fcO\u0084\u00f8 \u00bf}?\u00b4E\u00f1\u008e\u0095\u0085\u0014D\u00c4\u00fdt\u0097\u00db\u0096\u00af\u00a7C\u00d1\u00bd\u0084\u00db\u00e11\u008a\u00dc\u0095n";
                    var4_3 = "|\u001b\u00d7\f\u00c1\u00d5\u00fc\u00d4\u0087E\u0091\u008a\u00a6\u00fc_\u00fcO\u0084\u00f8 \u00bf}?\u00b4E\u00f1\u008e\u0095\u0085\u0014D\u00c4\u00fdt\u0097\u00db\u0096\u00af\u00a7C\u00d1\u00bd\u0084\u00db\u00e11\u008a\u00dc\u0095n".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 107;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 10;
                            break;
                        }
                        case 1: {
                            v15 = 114;
                            break;
                        }
                        case 2: {
                            v15 = 4;
                            break;
                        }
                        case 3: {
                            v15 = 98;
                            break;
                        }
                        case 4: {
                            v15 = 126;
                            break;
                        }
                        case 5: {
                            v15 = 63;
                            break;
                        }
                        default: {
                            v15 = 44;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x6A4A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 204;
                case 1 -> 86;
                case 2 -> 11;
                case 3 -> 34;
                case 4 -> 52;
                case 5 -> 213;
                case 6 -> 117;
                case 7 -> 139;
                case 8 -> 92;
                case 9 -> 165;
                case 10 -> 206;
                case 11 -> 1;
                case 12 -> 45;
                case 13 -> 150;
                case 14 -> 43;
                case 15 -> 32;
                case 16 -> 33;
                case 17 -> 13;
                case 18 -> 20;
                case 19 -> 247;
                case 20 -> 207;
                case 21 -> 54;
                case 22 -> 226;
                case 23 -> 228;
                case 24 -> 132;
                case 25 -> 240;
                case 26 -> 127;
                case 27 -> 178;
                case 28 -> 170;
                case 29 -> 221;
                case 30 -> 209;
                case 31 -> 64;
                case 32 -> 44;
                case 33 -> 111;
                case 34 -> 5;
                case 35 -> 96;
                case 36 -> 243;
                case 37 -> 61;
                case 38 -> 110;
                case 39 -> 129;
                case 40 -> 23;
                case 41 -> 199;
                case 42 -> 107;
                case 43 -> 120;
                case 44 -> 227;
                case 45 -> 58;
                case 46 -> 251;
                case 47 -> 125;
                case 48 -> 250;
                case 49 -> 8;
                case 50 -> 189;
                case 51 -> 146;
                case 52 -> 234;
                case 53 -> 195;
                case 54 -> 108;
                case 55 -> 245;
                case 56 -> 196;
                case 57 -> 191;
                case 58 -> 210;
                case 59 -> 9;
                case 60 -> 4;
                case 61 -> 98;
                case 62 -> 248;
                case 63 -> 147;
                case 64 -> 118;
                case 65 -> 201;
                case 66 -> 174;
                case 67 -> 203;
                case 68 -> 40;
                case 69 -> 183;
                case 70 -> 38;
                case 71 -> 103;
                case 72 -> 81;
                case 73 -> 14;
                case 74 -> 158;
                case 75 -> 50;
                case 76 -> 113;
                case 77 -> 148;
                case 78 -> 78;
                case 79 -> 192;
                case 80 -> 104;
                case 81 -> 143;
                case 82 -> 91;
                case 83 -> 22;
                case 84 -> 252;
                case 85 -> 176;
                case 86 -> 188;
                case 87 -> 173;
                case 88 -> 119;
                case 89 -> 217;
                case 90 -> 190;
                case 91 -> 249;
                case 92 -> 216;
                case 93 -> 157;
                case 94 -> 133;
                case 95 -> 47;
                case 96 -> 57;
                case 97 -> 82;
                case 98 -> 101;
                case 99 -> 109;
                case 100 -> 166;
                case 101 -> 222;
                case 102 -> 159;
                case 103 -> 84;
                case 104 -> 12;
                case 105 -> 65;
                case 106 -> 200;
                case 107 -> 255;
                case 108 -> 68;
                case 109 -> 56;
                case 110 -> 87;
                case 111 -> 202;
                case 112 -> 39;
                case 113 -> 244;
                case 114 -> 121;
                case 115 -> 236;
                case 116 -> 28;
                case 117 -> 193;
                case 118 -> 122;
                case 119 -> 29;
                case 120 -> 233;
                case 121 -> 115;
                case 122 -> 187;
                case 123 -> 131;
                case 124 -> 35;
                case 125 -> 46;
                case 126 -> 239;
                case 127 -> 71;
                case 128 -> 223;
                case 129 -> 80;
                case 130 -> 164;
                case 131 -> 208;
                case 132 -> 18;
                case 133 -> 69;
                case 134 -> 105;
                case 135 -> 181;
                case 136 -> 62;
                case 137 -> 149;
                case 138 -> 27;
                case 139 -> 102;
                case 140 -> 70;
                case 141 -> 83;
                case 142 -> 15;
                case 143 -> 85;
                case 144 -> 212;
                case 145 -> 254;
                case 146 -> 116;
                case 147 -> 95;
                case 148 -> 42;
                case 149 -> 185;
                case 150 -> 36;
                case 151 -> 16;
                case 152 -> 242;
                case 153 -> 51;
                case 154 -> 126;
                case 155 -> 53;
                case 156 -> 232;
                case 157 -> 31;
                case 158 -> 175;
                case 159 -> 205;
                case 160 -> 30;
                case 161 -> 66;
                case 162 -> 55;
                case 163 -> 179;
                case 164 -> 145;
                case 165 -> 214;
                case 166 -> 138;
                case 167 -> 25;
                case 168 -> 211;
                case 169 -> 237;
                case 170 -> 17;
                case 171 -> 230;
                case 172 -> 89;
                case 173 -> 63;
                case 174 -> 112;
                case 175 -> 2;
                case 176 -> 141;
                case 177 -> 21;
                case 178 -> 88;
                case 179 -> 106;
                case 180 -> 224;
                case 181 -> 172;
                case 182 -> 130;
                case 183 -> 60;
                case 184 -> 0;
                case 185 -> 76;
                case 186 -> 97;
                case 187 -> 161;
                case 188 -> 10;
                case 189 -> 229;
                case 190 -> 152;
                case 191 -> 90;
                case 192 -> 142;
                case 193 -> 231;
                case 194 -> 124;
                case 195 -> 198;
                case 196 -> 160;
                case 197 -> 241;
                case 198 -> 19;
                case 199 -> 72;
                case 200 -> 7;
                case 201 -> 253;
                case 202 -> 67;
                case 203 -> 186;
                case 204 -> 41;
                case 205 -> 182;
                case 206 -> 123;
                case 207 -> 180;
                case 208 -> 235;
                case 209 -> 99;
                case 210 -> 140;
                case 211 -> 136;
                case 212 -> 168;
                case 213 -> 225;
                case 214 -> 163;
                case 215 -> 94;
                case 216 -> 73;
                case 217 -> 154;
                case 218 -> 135;
                case 219 -> 162;
                case 220 -> 197;
                case 221 -> 246;
                case 222 -> 48;
                case 223 -> 151;
                case 224 -> 238;
                case 225 -> 169;
                case 226 -> 134;
                case 227 -> 144;
                case 228 -> 194;
                case 229 -> 37;
                case 230 -> 156;
                case 231 -> 59;
                case 232 -> 215;
                case 233 -> 171;
                case 234 -> 220;
                case 235 -> 49;
                case 236 -> 218;
                case 237 -> 3;
                case 238 -> 93;
                case 239 -> 137;
                case 240 -> 155;
                case 241 -> 77;
                case 242 -> 167;
                case 243 -> 26;
                case 244 -> 75;
                case 245 -> 114;
                case 246 -> 219;
                case 247 -> 177;
                case 248 -> 100;
                case 249 -> 79;
                case 250 -> 128;
                case 251 -> 184;
                case 252 -> 6;
                case 253 -> 74;
                case 254 -> 24;
                default -> 153;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 37706323262668L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(805294080 + (char)-17713, 805294080 + (char)-11444, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 133881470121593L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.F();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1250407800 + -((char)-13811), 1250407800 + (char)-24316, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1250407800 + -((char)-13808), 1250407800 + 28564, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1250407800 + -((char)-13809), 1250407800 + (char)-23525, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00ee\u00f3\u0001\u00b2\u0010\u00c3\u0088\u0099\u0010@T%\u00e7.\u00d2\u00b6\u00e2\u0016\u00a0\u00e9-\u00e7\u0002\u00fd\u00d6";
                    var4_3 = "\u00ee\u00f3\u0001\u00b2\u0010\u00c3\u0088\u0099\u0010@T%\u00e7.\u00d2\u00b6\u00e2\u0016\u00a0\u00e9-\u00e7\u0002\u00fd\u00d6".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 42;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00a7c\u00d2Z\u00e05\u00c3\u00e9IgA\u0001\u00b9\u00c9z\u0084\f\u0093V\u00c54^\u00c8X\u00d7q'\u0082\u000fs\u00dfE\u00b1;\u00e1\u0010B\u0004\u00f2\u00a4L\u008bp\u0098.\u00bf=-\u00c4\u00a6\u0084\u000bJ\u00e3\u0001/\u00da\u00c6c";
                        var4_3 = "\u00a7c\u00d2Z\u00e05\u00c3\u00e9IgA\u0001\u00b9\u00c9z\u0084\f\u0093V\u00c54^\u00c8X\u00d7q'\u0082\u000fs\u00dfE\u00b1;\u00e1\u0010B\u0004\u00f2\u00a4L\u008bp\u0098.\u00bf=-\u00c4\u00a6\u0084\u000bJ\u00e3\u0001/\u00da\u00c6c".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 94;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 100;
                                break;
                            }
                            case 1: {
                                v15 = 31;
                                break;
                            }
                            case 2: {
                                v15 = 49;
                                break;
                            }
                            case 3: {
                                v15 = 97;
                                break;
                            }
                            case 4: {
                                v15 = 87;
                                break;
                            }
                            case 5: {
                                v15 = 126;
                                break;
                            }
                            default: {
                                v15 = 33;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7603) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 133;
                    case 1 -> 233;
                    case 2 -> 255;
                    case 3 -> 102;
                    case 4 -> 88;
                    case 5 -> 125;
                    case 6 -> 199;
                    case 7 -> 246;
                    case 8 -> 220;
                    case 9 -> 94;
                    case 10 -> 167;
                    case 11 -> 181;
                    case 12 -> 173;
                    case 13 -> 24;
                    case 14 -> 156;
                    case 15 -> 240;
                    case 16 -> 146;
                    case 17 -> 41;
                    case 18 -> 107;
                    case 19 -> 83;
                    case 20 -> 193;
                    case 21 -> 184;
                    case 22 -> 91;
                    case 23 -> 209;
                    case 24 -> 101;
                    case 25 -> 127;
                    case 26 -> 243;
                    case 27 -> 108;
                    case 28 -> 253;
                    case 29 -> 230;
                    case 30 -> 92;
                    case 31 -> 226;
                    case 32 -> 80;
                    case 33 -> 218;
                    case 34 -> 129;
                    case 35 -> 126;
                    case 36 -> 59;
                    case 37 -> 112;
                    case 38 -> 82;
                    case 39 -> 207;
                    case 40 -> 168;
                    case 41 -> 1;
                    case 42 -> 6;
                    case 43 -> 62;
                    case 44 -> 28;
                    case 45 -> 202;
                    case 46 -> 248;
                    case 47 -> 113;
                    case 48 -> 33;
                    case 49 -> 15;
                    case 50 -> 137;
                    case 51 -> 4;
                    case 52 -> 106;
                    case 53 -> 77;
                    case 54 -> 57;
                    case 55 -> 234;
                    case 56 -> 150;
                    case 57 -> 109;
                    case 58 -> 30;
                    case 59 -> 70;
                    case 60 -> 204;
                    case 61 -> 164;
                    case 62 -> 145;
                    case 63 -> 191;
                    case 64 -> 157;
                    case 65 -> 19;
                    case 66 -> 3;
                    case 67 -> 241;
                    case 68 -> 31;
                    case 69 -> 122;
                    case 70 -> 189;
                    case 71 -> 186;
                    case 72 -> 211;
                    case 73 -> 180;
                    case 74 -> 232;
                    case 75 -> 114;
                    case 76 -> 25;
                    case 77 -> 64;
                    case 78 -> 179;
                    case 79 -> 48;
                    case 80 -> 5;
                    case 81 -> 8;
                    case 82 -> 110;
                    case 83 -> 196;
                    case 84 -> 151;
                    case 85 -> 50;
                    case 86 -> 134;
                    case 87 -> 154;
                    case 88 -> 254;
                    case 89 -> 236;
                    case 90 -> 20;
                    case 91 -> 217;
                    case 92 -> 192;
                    case 93 -> 79;
                    case 94 -> 22;
                    case 95 -> 14;
                    case 96 -> 155;
                    case 97 -> 65;
                    case 98 -> 11;
                    case 99 -> 7;
                    case 100 -> 215;
                    case 101 -> 161;
                    case 102 -> 23;
                    case 103 -> 244;
                    case 104 -> 12;
                    case 105 -> 0;
                    case 106 -> 72;
                    case 107 -> 103;
                    case 108 -> 63;
                    case 109 -> 183;
                    case 110 -> 93;
                    case 111 -> 141;
                    case 112 -> 235;
                    case 113 -> 201;
                    case 114 -> 120;
                    case 115 -> 228;
                    case 116 -> 162;
                    case 117 -> 84;
                    case 118 -> 123;
                    case 119 -> 51;
                    case 120 -> 197;
                    case 121 -> 210;
                    case 122 -> 206;
                    case 123 -> 104;
                    case 124 -> 9;
                    case 125 -> 67;
                    case 126 -> 38;
                    case 127 -> 140;
                    case 128 -> 221;
                    case 129 -> 223;
                    case 130 -> 185;
                    case 131 -> 27;
                    case 132 -> 85;
                    case 133 -> 13;
                    case 134 -> 76;
                    case 135 -> 69;
                    case 136 -> 100;
                    case 137 -> 177;
                    case 138 -> 148;
                    case 139 -> 86;
                    case 140 -> 89;
                    case 141 -> 124;
                    case 142 -> 190;
                    case 143 -> 55;
                    case 144 -> 54;
                    case 145 -> 152;
                    case 146 -> 200;
                    case 147 -> 251;
                    case 148 -> 172;
                    case 149 -> 252;
                    case 150 -> 213;
                    case 151 -> 98;
                    case 152 -> 42;
                    case 153 -> 47;
                    case 154 -> 169;
                    case 155 -> 229;
                    case 156 -> 219;
                    case 157 -> 136;
                    case 158 -> 143;
                    case 159 -> 144;
                    case 160 -> 176;
                    case 161 -> 222;
                    case 162 -> 96;
                    case 163 -> 138;
                    case 164 -> 139;
                    case 165 -> 46;
                    case 166 -> 56;
                    case 167 -> 247;
                    case 168 -> 135;
                    case 169 -> 87;
                    case 170 -> 111;
                    case 171 -> 121;
                    case 172 -> 52;
                    case 173 -> 119;
                    case 174 -> 116;
                    case 175 -> 165;
                    case 176 -> 153;
                    case 177 -> 142;
                    case 178 -> 214;
                    case 179 -> 43;
                    case 180 -> 203;
                    case 181 -> 90;
                    case 182 -> 212;
                    case 183 -> 187;
                    case 184 -> 205;
                    case 185 -> 166;
                    case 186 -> 249;
                    case 187 -> 105;
                    case 188 -> 160;
                    case 189 -> 131;
                    case 190 -> 18;
                    case 191 -> 73;
                    case 192 -> 216;
                    case 193 -> 66;
                    case 194 -> 198;
                    case 195 -> 26;
                    case 196 -> 74;
                    case 197 -> 10;
                    case 198 -> 78;
                    case 199 -> 34;
                    case 200 -> 237;
                    case 201 -> 49;
                    case 202 -> 53;
                    case 203 -> 21;
                    case 204 -> 178;
                    case 205 -> 158;
                    case 206 -> 99;
                    case 207 -> 242;
                    case 208 -> 44;
                    case 209 -> 75;
                    case 210 -> 81;
                    case 211 -> 37;
                    case 212 -> 36;
                    case 213 -> 238;
                    case 214 -> 40;
                    case 215 -> 147;
                    case 216 -> 58;
                    case 217 -> 118;
                    case 218 -> 195;
                    case 219 -> 35;
                    case 220 -> 250;
                    case 221 -> 194;
                    case 222 -> 130;
                    case 223 -> 45;
                    case 224 -> 170;
                    case 225 -> 71;
                    case 226 -> 182;
                    case 227 -> 231;
                    case 228 -> 68;
                    case 229 -> 225;
                    case 230 -> 188;
                    case 231 -> 128;
                    case 232 -> 97;
                    case 233 -> 239;
                    case 234 -> 117;
                    case 235 -> 174;
                    case 236 -> 60;
                    case 237 -> 2;
                    case 238 -> 245;
                    case 239 -> 227;
                    case 240 -> 132;
                    case 241 -> 224;
                    case 242 -> 32;
                    case 243 -> 163;
                    case 244 -> 95;
                    case 245 -> 115;
                    case 246 -> 149;
                    case 247 -> 61;
                    case 248 -> 208;
                    case 249 -> 39;
                    case 250 -> 17;
                    case 251 -> 171;
                    case 252 -> 175;
                    case 253 -> 159;
                    case 254 -> 16;
                    default -> 29;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 94231884944478L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "^B[b><\u0019\u0007\tYHHhs~\u0004\u001b\u000e";
                    var5_4 = "^B[b><\u0019\u0007\tYHHhs~\u0004\u001b\u000e".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 17;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 36;
                                    break;
                                }
                                case 1: {
                                    v11 = 54;
                                    break;
                                }
                                case 2: {
                                    v11 = 56;
                                    break;
                                }
                                case 3: {
                                    v11 = 29;
                                    break;
                                }
                                case 4: {
                                    v11 = 74;
                                    break;
                                }
                                case 5: {
                                    v11 = 65;
                                    break;
                                }
                                default: {
                                    v11 = 59;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 75718549859136L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u001a\u0005$/K|P\u0004\u001c\u001b(5\n\u0010\u0004#5G~H:\u0005*\t\u0010\u0004#5G~H6\u000f\r\u0017\u0002>8MsR6\b92Lz";
                    var5_4 = "\u001a\u0005$/K|P\u0004\u001c\u001b(5\n\u0010\u0004#5G~H:\u0005*\t\u0010\u0004#5G~H6\u000f\r\u0017\u0002>8MsR6\b92Lz".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 79;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "!6\u0013\u0019zBj\u0006!6\u0013\u0019vH";
                        var5_4 = "!6\u0013\u0019zBj\u0006!6\u0013\u0019vH".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 126;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 28;
                                break;
                            }
                            case 1: {
                                v15 = 36;
                                break;
                            }
                            case 2: {
                                v15 = 2;
                                break;
                            }
                            case 3: {
                                v15 = 20;
                                break;
                            }
                            case 4: {
                                v15 = 109;
                                break;
                            }
                            case 5: {
                                v15 = 82;
                                break;
                            }
                            default: {
                                v15 = 115;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 97189315774109L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1499178660 - -29692, -1499178660 - -13068, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 100447479822160L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "]\u000e\u00ae\u001d\u00da\u0003N\u0002x\u0005\u0093\u00dfQ\u00e3\u00c6\r\u00a0\f\u0001\u00d39\u00159!\u00f8\u00a3\u0003\u00ac\u0088\u0010&\u00bf\u0016N\u00e43\u00a9\u00d8#\u0018\u009b\u0096}3\u00a8&\u0005^\u0099\u00e8+\u00f13\u000b\u00b2S9\u0099\u00996\u0099\u00ad\u00cd\u00c1\u0005\u00f0\u00105]\u00dd\rT\u00f5L\u00e8(\u00b3\u00de\u0094V\u00eb_\u0092\u00af'\u00d8HU\u0081\u0085\u009e\u000e#\u008aX\u00df\u0016\u0093A\u0090\u00aeoJ\u00cb";
                    var4_3 = "]\u000e\u00ae\u001d\u00da\u0003N\u0002x\u0005\u0093\u00dfQ\u00e3\u00c6\r\u00a0\f\u0001\u00d39\u00159!\u00f8\u00a3\u0003\u00ac\u0088\u0010&\u00bf\u0016N\u00e43\u00a9\u00d8#\u0018\u009b\u0096}3\u00a8&\u0005^\u0099\u00e8+\u00f13\u000b\u00b2S9\u0099\u00996\u0099\u00ad\u00cd\u00c1\u0005\u00f0\u00105]\u00dd\rT\u00f5L\u00e8(\u00b3\u00de\u0094V\u00eb_\u0092\u00af'\u00d8HU\u0081\u0085\u009e\u000e#\u008aX\u00df\u0016\u0093A\u0090\u00aeoJ\u00cb".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 18;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00f8aT\f5\u00e2\n{\u00ce\u00f5\u00bf\u00b2`.\u0092\u001cL\u00bebk\u00a6\u00f8\u007f\u00dd\u00a6\u00bd\u00dd}\u000e67\u00cbF\u009e&Z\u00ff|T\u009d\u001f\u00d2skH\u009b6AE\u008cs7cb\u0085Q\u00bf\u00ce\u00af\u0001\f\u00c4E(\u008f\u0013\u00c35SC\u00e7Z%\u00ce\u00f3\u00f2\u009b\u00cfS\u00ed\u00ae\u00fb\u00c5\u00bcsdc\u00d7\u001c\u00f2R\u00da\u00e6";
                        var4_3 = "\u00f8aT\f5\u00e2\n{\u00ce\u00f5\u00bf\u00b2`.\u0092\u001cL\u00bebk\u00a6\u00f8\u007f\u00dd\u00a6\u00bd\u00dd}\u000e67\u00cbF\u009e&Z\u00ff|T\u009d\u001f\u00d2skH\u009b6AE\u008cs7cb\u0085Q\u00bf\u00ce\u00af\u0001\f\u00c4E(\u008f\u0013\u00c35SC\u00e7Z%\u00ce\u00f3\u00f2\u009b\u00cfS\u00ed\u00ae\u00fb\u00c5\u00bcsdc\u00d7\u001c\u00f2R\u00da\u00e6".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 101;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 24;
                                break;
                            }
                            case 1: {
                                v15 = 48;
                                break;
                            }
                            case 2: {
                                v15 = 126;
                                break;
                            }
                            case 3: {
                                v15 = 111;
                                break;
                            }
                            case 4: {
                                v15 = 45;
                                break;
                            }
                            case 5: {
                                v15 = 84;
                                break;
                            }
                            default: {
                                v15 = 23;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x4BC5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 201;
                    case 1 -> 32;
                    case 2 -> 5;
                    case 3 -> 41;
                    case 4 -> 80;
                    case 5 -> 72;
                    case 6 -> 3;
                    case 7 -> 192;
                    case 8 -> 140;
                    case 9 -> 222;
                    case 10 -> 47;
                    case 11 -> 113;
                    case 12 -> 161;
                    case 13 -> 185;
                    case 14 -> 203;
                    case 15 -> 127;
                    case 16 -> 146;
                    case 17 -> 128;
                    case 18 -> 17;
                    case 19 -> 211;
                    case 20 -> 149;
                    case 21 -> 109;
                    case 22 -> 84;
                    case 23 -> 45;
                    case 24 -> 79;
                    case 25 -> 15;
                    case 26 -> 88;
                    case 27 -> 196;
                    case 28 -> 83;
                    case 29 -> 189;
                    case 30 -> 213;
                    case 31 -> 59;
                    case 32 -> 209;
                    case 33 -> 20;
                    case 34 -> 143;
                    case 35 -> 206;
                    case 36 -> 175;
                    case 37 -> 224;
                    case 38 -> 205;
                    case 39 -> 249;
                    case 40 -> 26;
                    case 41 -> 66;
                    case 42 -> 151;
                    case 43 -> 19;
                    case 44 -> 55;
                    case 45 -> 220;
                    case 46 -> 91;
                    case 47 -> 226;
                    case 48 -> 227;
                    case 49 -> 85;
                    case 50 -> 160;
                    case 51 -> 242;
                    case 52 -> 136;
                    case 53 -> 73;
                    case 54 -> 163;
                    case 55 -> 96;
                    case 56 -> 240;
                    case 57 -> 173;
                    case 58 -> 237;
                    case 59 -> 134;
                    case 60 -> 244;
                    case 61 -> 65;
                    case 62 -> 188;
                    case 63 -> 102;
                    case 64 -> 8;
                    case 65 -> 71;
                    case 66 -> 182;
                    case 67 -> 33;
                    case 68 -> 36;
                    case 69 -> 130;
                    case 70 -> 218;
                    case 71 -> 40;
                    case 72 -> 139;
                    case 73 -> 53;
                    case 74 -> 54;
                    case 75 -> 159;
                    case 76 -> 12;
                    case 77 -> 18;
                    case 78 -> 210;
                    case 79 -> 11;
                    case 80 -> 229;
                    case 81 -> 251;
                    case 82 -> 245;
                    case 83 -> 49;
                    case 84 -> 106;
                    case 85 -> 61;
                    case 86 -> 99;
                    case 87 -> 191;
                    case 88 -> 174;
                    case 89 -> 58;
                    case 90 -> 228;
                    case 91 -> 78;
                    case 92 -> 112;
                    case 93 -> 48;
                    case 94 -> 145;
                    case 95 -> 138;
                    case 96 -> 16;
                    case 97 -> 56;
                    case 98 -> 252;
                    case 99 -> 250;
                    case 100 -> 29;
                    case 101 -> 177;
                    case 102 -> 75;
                    case 103 -> 142;
                    case 104 -> 60;
                    case 105 -> 135;
                    case 106 -> 52;
                    case 107 -> 117;
                    case 108 -> 24;
                    case 109 -> 225;
                    case 110 -> 231;
                    case 111 -> 39;
                    case 112 -> 219;
                    case 113 -> 156;
                    case 114 -> 200;
                    case 115 -> 137;
                    case 116 -> 35;
                    case 117 -> 243;
                    case 118 -> 233;
                    case 119 -> 69;
                    case 120 -> 221;
                    case 121 -> 103;
                    case 122 -> 187;
                    case 123 -> 125;
                    case 124 -> 95;
                    case 125 -> 230;
                    case 126 -> 76;
                    case 127 -> 31;
                    case 128 -> 183;
                    case 129 -> 92;
                    case 130 -> 57;
                    case 131 -> 94;
                    case 132 -> 98;
                    case 133 -> 133;
                    case 134 -> 63;
                    case 135 -> 254;
                    case 136 -> 107;
                    case 137 -> 232;
                    case 138 -> 9;
                    case 139 -> 153;
                    case 140 -> 101;
                    case 141 -> 235;
                    case 142 -> 108;
                    case 143 -> 81;
                    case 144 -> 141;
                    case 145 -> 2;
                    case 146 -> 30;
                    case 147 -> 234;
                    case 148 -> 119;
                    case 149 -> 118;
                    case 150 -> 165;
                    case 151 -> 51;
                    case 152 -> 46;
                    case 153 -> 37;
                    case 154 -> 121;
                    case 155 -> 64;
                    case 156 -> 110;
                    case 157 -> 132;
                    case 158 -> 0;
                    case 159 -> 157;
                    case 160 -> 4;
                    case 161 -> 204;
                    case 162 -> 239;
                    case 163 -> 105;
                    case 164 -> 236;
                    case 165 -> 13;
                    case 166 -> 122;
                    case 167 -> 169;
                    case 168 -> 223;
                    case 169 -> 50;
                    case 170 -> 194;
                    case 171 -> 86;
                    case 172 -> 144;
                    case 173 -> 168;
                    case 174 -> 197;
                    case 175 -> 6;
                    case 176 -> 22;
                    case 177 -> 27;
                    case 178 -> 38;
                    case 179 -> 44;
                    case 180 -> 154;
                    case 181 -> 21;
                    case 182 -> 74;
                    case 183 -> 114;
                    case 184 -> 166;
                    case 185 -> 111;
                    case 186 -> 124;
                    case 187 -> 198;
                    case 188 -> 167;
                    case 189 -> 253;
                    case 190 -> 97;
                    case 191 -> 62;
                    case 192 -> 43;
                    case 193 -> 89;
                    case 194 -> 193;
                    case 195 -> 104;
                    case 196 -> 170;
                    case 197 -> 241;
                    case 198 -> 246;
                    case 199 -> 68;
                    case 200 -> 1;
                    case 201 -> 178;
                    case 202 -> 184;
                    case 203 -> 255;
                    case 204 -> 180;
                    case 205 -> 186;
                    case 206 -> 7;
                    case 207 -> 217;
                    case 208 -> 147;
                    case 209 -> 25;
                    case 210 -> 158;
                    case 211 -> 115;
                    case 212 -> 179;
                    case 213 -> 67;
                    case 214 -> 164;
                    case 215 -> 23;
                    case 216 -> 148;
                    case 217 -> 82;
                    case 218 -> 214;
                    case 219 -> 90;
                    case 220 -> 195;
                    case 221 -> 34;
                    case 222 -> 202;
                    case 223 -> 116;
                    case 224 -> 152;
                    case 225 -> 172;
                    case 226 -> 131;
                    case 227 -> 216;
                    case 228 -> 171;
                    case 229 -> 150;
                    case 230 -> 208;
                    case 231 -> 155;
                    case 232 -> 10;
                    case 233 -> 247;
                    case 234 -> 70;
                    case 235 -> 93;
                    case 236 -> 28;
                    case 237 -> 77;
                    case 238 -> 162;
                    case 239 -> 129;
                    case 240 -> 207;
                    case 241 -> 199;
                    case 242 -> 42;
                    case 243 -> 248;
                    case 244 -> 212;
                    case 245 -> 100;
                    case 246 -> 126;
                    case 247 -> 190;
                    case 248 -> 238;
                    case 249 -> 181;
                    case 250 -> 87;
                    case 251 -> 120;
                    case 252 -> 123;
                    case 253 -> 176;
                    case 254 -> 215;
                    default -> 14;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 73127063289430L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(950126430 - 19962, 950126430 - (char)-26968, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 37476940216154L;
                    String string = SshAgentIpcService.F();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-944359350 + -((char)-14367), -944490420 - -((char)-7617), (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 52023274125977L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00cft\u00b6z\u00ef\u0003\u00c2$A";
                var4_3 = "\u00cft\u00b6z\u00ef\u0003\u00c2$A".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 120;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 115;
                                break;
                            }
                            case 1: {
                                v11 = 120;
                                break;
                            }
                            case 2: {
                                v11 = 126;
                                break;
                            }
                            case 3: {
                                v11 = 105;
                                break;
                            }
                            case 4: {
                                v11 = 60;
                                break;
                            }
                            case 5: {
                                v11 = 4;
                                break;
                            }
                            default: {
                                v11 = 75;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x732) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 230;
                    case 1 -> 200;
                    case 2 -> 64;
                    case 3 -> 218;
                    case 4 -> 13;
                    case 5 -> 242;
                    case 6 -> 42;
                    case 7 -> 209;
                    case 8 -> 29;
                    case 9 -> 144;
                    case 10 -> 147;
                    case 11 -> 173;
                    case 12 -> 181;
                    case 13 -> 241;
                    case 14 -> 191;
                    case 15 -> 114;
                    case 16 -> 177;
                    case 17 -> 109;
                    case 18 -> 193;
                    case 19 -> 145;
                    case 20 -> 24;
                    case 21 -> 226;
                    case 22 -> 17;
                    case 23 -> 228;
                    case 24 -> 71;
                    case 25 -> 124;
                    case 26 -> 97;
                    case 27 -> 229;
                    case 28 -> 81;
                    case 29 -> 207;
                    case 30 -> 75;
                    case 31 -> 254;
                    case 32 -> 25;
                    case 33 -> 70;
                    case 34 -> 6;
                    case 35 -> 52;
                    case 36 -> 100;
                    case 37 -> 26;
                    case 38 -> 66;
                    case 39 -> 156;
                    case 40 -> 58;
                    case 41 -> 62;
                    case 42 -> 202;
                    case 43 -> 120;
                    case 44 -> 247;
                    case 45 -> 149;
                    case 46 -> 119;
                    case 47 -> 102;
                    case 48 -> 232;
                    case 49 -> 168;
                    case 50 -> 223;
                    case 51 -> 197;
                    case 52 -> 249;
                    case 53 -> 187;
                    case 54 -> 30;
                    case 55 -> 136;
                    case 56 -> 167;
                    case 57 -> 250;
                    case 58 -> 195;
                    case 59 -> 235;
                    case 60 -> 105;
                    case 61 -> 141;
                    case 62 -> 46;
                    case 63 -> 31;
                    case 64 -> 117;
                    case 65 -> 203;
                    case 66 -> 115;
                    case 67 -> 165;
                    case 68 -> 214;
                    case 69 -> 248;
                    case 70 -> 142;
                    case 71 -> 60;
                    case 72 -> 172;
                    case 73 -> 134;
                    case 74 -> 41;
                    case 75 -> 221;
                    case 76 -> 245;
                    case 77 -> 151;
                    case 78 -> 28;
                    case 79 -> 74;
                    case 80 -> 47;
                    case 81 -> 2;
                    case 82 -> 10;
                    case 83 -> 129;
                    case 84 -> 85;
                    case 85 -> 11;
                    case 86 -> 210;
                    case 87 -> 51;
                    case 88 -> 178;
                    case 89 -> 56;
                    case 90 -> 217;
                    case 91 -> 122;
                    case 92 -> 128;
                    case 93 -> 152;
                    case 94 -> 78;
                    case 95 -> 213;
                    case 96 -> 162;
                    case 97 -> 93;
                    case 98 -> 95;
                    case 99 -> 116;
                    case 100 -> 63;
                    case 101 -> 35;
                    case 102 -> 204;
                    case 103 -> 234;
                    case 104 -> 174;
                    case 105 -> 160;
                    case 106 -> 111;
                    case 107 -> 201;
                    case 108 -> 182;
                    case 109 -> 175;
                    case 110 -> 171;
                    case 111 -> 38;
                    case 112 -> 110;
                    case 113 -> 88;
                    case 114 -> 184;
                    case 115 -> 113;
                    case 116 -> 18;
                    case 117 -> 107;
                    case 118 -> 76;
                    case 119 -> 48;
                    case 120 -> 118;
                    case 121 -> 67;
                    case 122 -> 186;
                    case 123 -> 161;
                    case 124 -> 143;
                    case 125 -> 20;
                    case 126 -> 135;
                    case 127 -> 65;
                    case 128 -> 4;
                    case 129 -> 9;
                    case 130 -> 43;
                    case 131 -> 253;
                    case 132 -> 196;
                    case 133 -> 166;
                    case 134 -> 192;
                    case 135 -> 84;
                    case 136 -> 139;
                    case 137 -> 68;
                    case 138 -> 94;
                    case 139 -> 157;
                    case 140 -> 131;
                    case 141 -> 112;
                    case 142 -> 33;
                    case 143 -> 179;
                    case 144 -> 73;
                    case 145 -> 86;
                    case 146 -> 244;
                    case 147 -> 54;
                    case 148 -> 216;
                    case 149 -> 126;
                    case 150 -> 198;
                    case 151 -> 211;
                    case 152 -> 87;
                    case 153 -> 189;
                    case 154 -> 239;
                    case 155 -> 246;
                    case 156 -> 252;
                    case 157 -> 16;
                    case 158 -> 55;
                    case 159 -> 205;
                    case 160 -> 53;
                    case 161 -> 183;
                    case 162 -> 190;
                    case 163 -> 140;
                    case 164 -> 90;
                    case 165 -> 219;
                    case 166 -> 215;
                    case 167 -> 103;
                    case 168 -> 225;
                    case 169 -> 127;
                    case 170 -> 208;
                    case 171 -> 164;
                    case 172 -> 138;
                    case 173 -> 7;
                    case 174 -> 137;
                    case 175 -> 14;
                    case 176 -> 133;
                    case 177 -> 72;
                    case 178 -> 34;
                    case 179 -> 89;
                    case 180 -> 185;
                    case 181 -> 108;
                    case 182 -> 238;
                    case 183 -> 243;
                    case 184 -> 130;
                    case 185 -> 83;
                    case 186 -> 37;
                    case 187 -> 69;
                    case 188 -> 224;
                    case 189 -> 123;
                    case 190 -> 80;
                    case 191 -> 206;
                    case 192 -> 82;
                    case 193 -> 49;
                    case 194 -> 180;
                    case 195 -> 21;
                    case 196 -> 59;
                    case 197 -> 3;
                    case 198 -> 12;
                    case 199 -> 220;
                    case 200 -> 199;
                    case 201 -> 23;
                    case 202 -> 155;
                    case 203 -> 231;
                    case 204 -> 188;
                    case 205 -> 104;
                    case 206 -> 132;
                    case 207 -> 98;
                    case 208 -> 5;
                    case 209 -> 176;
                    case 210 -> 91;
                    case 211 -> 146;
                    case 212 -> 19;
                    case 213 -> 240;
                    case 214 -> 170;
                    case 215 -> 101;
                    case 216 -> 57;
                    case 217 -> 99;
                    case 218 -> 0;
                    case 219 -> 163;
                    case 220 -> 255;
                    case 221 -> 44;
                    case 222 -> 148;
                    case 223 -> 222;
                    case 224 -> 169;
                    case 225 -> 50;
                    case 226 -> 92;
                    case 227 -> 77;
                    case 228 -> 61;
                    case 229 -> 22;
                    case 230 -> 233;
                    case 231 -> 39;
                    case 232 -> 154;
                    case 233 -> 32;
                    case 234 -> 227;
                    case 235 -> 121;
                    case 236 -> 125;
                    case 237 -> 96;
                    case 238 -> 251;
                    case 239 -> 159;
                    case 240 -> 212;
                    case 241 -> 158;
                    case 242 -> 150;
                    case 243 -> 45;
                    case 244 -> 36;
                    case 245 -> 40;
                    case 246 -> 27;
                    case 247 -> 15;
                    case 248 -> 194;
                    case 249 -> 236;
                    case 250 -> 106;
                    case 251 -> 79;
                    case 252 -> 237;
                    case 253 -> 153;
                    case 254 -> 8;
                    default -> 1;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

