/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.introspector;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u0004\u0018\u00010\u000b*\u00020\bH\u0002\u001a\f\u0010\r\u001a\u00020\b*\u00020\bH\u0002\"$\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"PERMIT_CLASSES_INTROSPECTION", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPERMIT_CLASSES_INTROSPECTION", "()Lcom/intellij/openapi/util/Key;", "cleanupDynamicTableSource", "", "extractDataType", "Lcom/intellij/database/types/DasType;", "Lorg/codehaus/jettison/json/JSONObject;", "parseDataType", "mapType", "intellij.database.dialects.snowflake"})
public final class SFlakeIntrospectorKt {
    @NotNull
    private static final Key<Boolean> PERMIT_CLASSES_INTROSPECTION;

    @NotNull
    public static final Key<Boolean> getPERMIT_CLASSES_INTROSPECTION() {
        return PERMIT_CLASSES_INTROSPECTION;
    }

    private static final String cleanupDynamicTableSource(String $this$cleanupDynamicTableSource) {
        Object object;
        int nlIdx = StringsKt.indexOf$default((CharSequence)$this$cleanupDynamicTableSource, (char)'\n', (int)0, (boolean)false, (int)6, null);
        if (nlIdx == -1) {
            return $this$cleanupDynamicTableSource;
        }
        int prevNl = nlIdx;
        int n = $this$cleanupDynamicTableSource.length();
        for (int i = nlIdx; i < n; ++i) {
            char c = $this$cleanupDynamicTableSource.charAt(i);
            if (c == '\n') {
                prevNl = i;
            }
            if (!CharsKt.isWhitespace((char)c)) break;
        }
        if (prevNl == nlIdx) {
            object = $this$cleanupDynamicTableSource;
        } else {
            String string = $this$cleanupDynamicTableSource.substring(0, nlIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = $this$cleanupDynamicTableSource.substring(prevNl);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = string + string2;
        }
        return object;
    }

    private static final DasType extractDataType(JSONObject $this$extractDataType) {
        String string = $this$extractDataType.optString("type", null);
        if (string == null || (string = SFlakeIntrospectorKt.mapType(string)) == null) {
            return (DasType)DasTypeSystemBase.UNKNOWN;
        }
        String name2 = string;
        int prec = $this$extractDataType.optInt("length", -1);
        int scale = 0;
        if (prec == -1) {
            prec = $this$extractDataType.optInt("precision", -1);
            scale = $this$extractDataType.optInt("scale", 0);
            if (prec == 0) {
                prec = scale;
                scale = 0;
            }
        }
        DataType dataType = DataTypeFactory.of(null, (String)name2, (int)prec, (int)scale, null, null, (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        DataType dataType2 = dataType;
        return DasUnresolvedTypeReference.Companion.of(dataType2);
    }

    private static final JSONObject parseDataType(String $this$parseDataType) {
        try {
            return new JSONObject($this$parseDataType);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static final String mapType(String $this$mapType) {
        return switch ($this$mapType) {
            case "FIXED" -> "NUMBER";
            case "TEXT" -> "VARCHAR";
            case "REAL" -> "DOUBLE";
            case "TIMESTAMP_TZ" -> "TIMESTAMPTZ";
            case "TIMESTAMP_LTZ" -> "TIMESTAMPLTZ";
            case "TIMESTAMP_NTZ" -> "TIMESTAMPNTZ";
            default -> $this$mapType;
        };
    }

    public static final /* synthetic */ String access$cleanupDynamicTableSource(String $receiver) {
        return SFlakeIntrospectorKt.cleanupDynamicTableSource($receiver);
    }

    public static final /* synthetic */ JSONObject access$parseDataType(String $receiver) {
        return SFlakeIntrospectorKt.parseDataType($receiver);
    }

    public static final /* synthetic */ DasType access$extractDataType(JSONObject $receiver) {
        return SFlakeIntrospectorKt.extractDataType($receiver);
    }

    static {
        Key key = Key.create((String)"PERMIT_CLASSES_INTROSPECTION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PERMIT_CLASSES_INTROSPECTION = key;
    }
}

