/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public abstract class AbstractKotlinInplaceVariableIntroducer<D extends KtCallableDeclaration, KotlinType>
extends InplaceVariableIntroducer<KtExpression> {
    private static final Key<AbstractKotlinInplaceVariableIntroducer> ACTIVE_INTRODUCER = Key.create((String)"ACTIVE_INTRODUCER");
    private static final Function0<Boolean> TRUE = new Function0<Boolean>(){

        public Boolean invoke() {
            return true;
        }
    };
    private static final Consumer<? super JComponent> DO_NOTHING = __ -> {};
    private final boolean myReplaceOccurrence;
    protected D myDeclaration;
    private final boolean isVar;
    private final boolean myDoNotChangeVar;
    @Nullable
    protected final KotlinType myExprType;
    private final boolean noTypeInference;
    private final List<ControlWrapper> panelControls = new ArrayList<ControlWrapper>();
    private JPanel contentPanel;
    private boolean myRestart = false;

    public AbstractKotlinInplaceVariableIntroducer(PsiNamedElement elementToRename, Editor editor, Project project, @Nls String title, KtExpression[] occurrences, @Nullable KtExpression expr, boolean replaceOccurrence, D declaration, boolean isVar, boolean doNotChangeVar, @Nullable KotlinType exprType2, boolean noTypeInference) {
        super(elementToRename, editor, project, title, (PsiElement[])occurrences, (PsiElement)expr);
        this.myReplaceOccurrence = replaceOccurrence;
        this.myDeclaration = declaration;
        this.isVar = isVar;
        this.myDoNotChangeVar = doNotChangeVar;
        this.myExprType = exprType2;
        this.noTypeInference = noTypeInference;
        String advertisementActionId = this.getAdvertisementActionId();
        if (advertisementActionId != null) {
            this.showDialogAdvertisement(advertisementActionId);
        }
    }

    protected void restart(RefactoringActionHandler handler2) {
        this.myRestart = true;
        PsiFile file = this.myDeclaration.getContainingFile();
        TemplateState state = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (state != null) {
            state.gotoEnd(true);
        }
        handler2.invoke(this.myProject, this.myEditor, file, null);
    }

    @Nullable
    protected String getAdvertisementActionId() {
        return null;
    }

    @NotNull
    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel(new GridBagLayout());
            this.contentPanel.setBorder(null);
        }
        JPanel jPanel = this.contentPanel;
        if (jPanel == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected final void addPanelControl(@NotNull ControlWrapper panelControl) {
        if (panelControl == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(1);
        }
        this.panelControls.add(panelControl);
    }

    protected final void addPanelControl(@Nullable Function0<JComponent> initializer2) {
        if (initializer2 != null) {
            this.addPanelControl(new ControlWrapper(initializer2));
        }
    }

    protected void initPanelControls() {
        this.addPanelControl(this.getCreateVarCheckBox());
        this.addPanelControl(this.getCreateExplicitTypeCheckBox());
    }

    protected final void updatePanelControls() {
        JPanel panel = this.getContentPanel();
        panel.removeAll();
        int count = 1;
        for (ControlWrapper panelControl : this.panelControls) {
            if (!panelControl.isAvailable()) continue;
            panelControl.initialize();
            panel.add((Component)panelControl.getComponent(), new GridBagConstraints(0, count, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)0, (int)5), 0, 0));
            ++count;
        }
        this.revalidate();
    }

    @NotNull
    protected final JComponent getComponent() {
        this.panelControls.clear();
        this.initPanelControls();
        this.updatePanelControls();
        return this.getContentPanel();
    }

    protected abstract String renderType(KotlinType var1);

    @Nullable
    protected final Function0<JComponent> getCreateExplicitTypeCheckBox() {
        if (this.myExprType == null || this.noTypeInference) {
            return null;
        }
        return new Function0<JComponent>(){

            public JComponent invoke() {
                NonFocusableCheckBox exprTypeCheckbox = new NonFocusableCheckBox(KotlinBundle.message((String)"checkbox.text.specify.type.explicitly", (Object[])new Object[0]));
                exprTypeCheckbox.setSelected(false);
                exprTypeCheckbox.addActionListener(new ActionListener(){
                    final /* synthetic */ JCheckBox val$exprTypeCheckbox;
                    {
                        this.val$exprTypeCheckbox = jCheckBox;
                    }

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        WriteCommandAction.runWriteCommandAction((Project)AbstractKotlinInplaceVariableIntroducer.this.myProject, (String)AbstractKotlinInplaceVariableIntroducer.this.getCommandName(), (String)AbstractKotlinInplaceVariableIntroducer.this.getCommandName(), () -> {
                            if (this.val$exprTypeCheckbox.isSelected()) {
                                String renderedType = AbstractKotlinInplaceVariableIntroducer.this.renderType(AbstractKotlinInplaceVariableIntroducer.this.myExprType);
                                AbstractKotlinInplaceVariableIntroducer.this.myDeclaration.setTypeReference(new KtPsiFactory(AbstractKotlinInplaceVariableIntroducer.this.myProject).createType(renderedType));
                            } else {
                                AbstractKotlinInplaceVariableIntroducer.this.myDeclaration.setTypeReference(null);
                            }
                        }, (PsiFile[])new PsiFile[0]);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$2$1", "actionPerformed"));
                    }
                });
                return exprTypeCheckbox;
            }
        };
    }

    @Nullable
    protected final Function0<JComponent> getCreateVarCheckBox() {
        if (this.myDoNotChangeVar) {
            return null;
        }
        return new Function0<JComponent>(){

            public JComponent invoke() {
                NonFocusableCheckBox varCheckbox = new NonFocusableCheckBox(KotlinBundle.message((String)"checkbox.text.declare.with.var", (Object[])new Object[0]));
                varCheckbox.setSelected(AbstractKotlinInplaceVariableIntroducer.this.isVar);
                varCheckbox.addActionListener(new ActionListener(){
                    final /* synthetic */ JCheckBox val$varCheckbox;
                    {
                        this.val$varCheckbox = jCheckBox;
                    }

                    @Override
                    public void actionPerformed(@NotNull ActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        WriteCommandAction.runWriteCommandAction((Project)AbstractKotlinInplaceVariableIntroducer.this.myProject, (String)AbstractKotlinInplaceVariableIntroducer.this.getCommandName(), (String)AbstractKotlinInplaceVariableIntroducer.this.getCommandName(), () -> {
                            PsiDocumentManager.getInstance((Project)AbstractKotlinInplaceVariableIntroducer.this.myProject).commitDocument(AbstractKotlinInplaceVariableIntroducer.this.myEditor.getDocument());
                            KtPsiFactory psiFactory = new KtPsiFactory(AbstractKotlinInplaceVariableIntroducer.this.myProject);
                            PsiElement keyword = this.val$varCheckbox.isSelected() ? psiFactory.createVarKeyword() : psiFactory.createValKeyword();
                            PsiElement valOrVar = AbstractKotlinInplaceVariableIntroducer.this.myDeclaration instanceof KtProperty ? ((KtProperty)AbstractKotlinInplaceVariableIntroducer.this.myDeclaration).getValOrVarKeyword() : ((KtParameter)AbstractKotlinInplaceVariableIntroducer.this.myDeclaration).getValOrVarKeyword();
                            valOrVar.replace(keyword);
                        }, (PsiFile[])new PsiFile[0]);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$3$1", "actionPerformed"));
                    }
                });
                return varCheckbox;
            }
        };
    }

    protected final void runWriteActionAndRestartRefactoring(Runnable runnable) {
        Ref greedyToRight = new Ref();
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)this.getCommandName(), (String)this.getCommandName(), () -> {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myEditor.getDocument());
            ASTNode identifier = this.myDeclaration.getNode().findChildByType((IElementType)KtTokens.IDENTIFIER);
            if (identifier != null) {
                RangeHighlighter[] highlighters;
                TextRange range2 = identifier.getTextRange();
                for (RangeHighlighter highlighter : highlighters = this.myEditor.getMarkupModel().getAllHighlighters()) {
                    if (highlighter.getStartOffset() != range2.getStartOffset() || highlighter.getEndOffset() != range2.getEndOffset()) continue;
                    greedyToRight.set((Object)highlighter.isGreedyToRight());
                    highlighter.setGreedyToRight(false);
                }
            }
            runnable.run();
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageUtil.getTopLevelEditor((Editor)this.myEditor));
            if (templateState != null) {
                this.myEditor.putUserData(INTRODUCE_RESTART, (Object)true);
                templateState.gotoEnd(true);
            }
        }, (PsiFile[])new PsiFile[0]);
        ApplicationManager.getApplication().runReadAction(() -> {
            ASTNode identifier = this.myDeclaration.getNode().findChildByType((IElementType)KtTokens.IDENTIFIER);
            if (identifier != null) {
                RangeHighlighter[] highlighters;
                TextRange range2 = identifier.getTextRange();
                for (RangeHighlighter highlighter : highlighters = this.myEditor.getMarkupModel().getAllHighlighters()) {
                    if (highlighter.getStartOffset() != range2.getStartOffset() || highlighter.getEndOffset() != range2.getEndOffset()) continue;
                    highlighter.setGreedyToRight(((Boolean)greedyToRight.get()).booleanValue());
                }
            }
        });
        if (this.myEditor.getUserData(INTRODUCE_RESTART) == Boolean.TRUE) {
            this.myInitialName = this.myDeclaration.getName();
            this.performInplaceRefactoring(this.getSuggestionsForNextRun());
        }
    }

    private LinkedHashSet<String> getSuggestionsForNextRun() {
        LinkedHashSet<String> nameSuggestions;
        String currentName = this.myDeclaration.getName();
        if (this.myNameSuggestions.contains(currentName)) {
            nameSuggestions = this.myNameSuggestions;
        } else {
            nameSuggestions = new LinkedHashSet<String>();
            nameSuggestions.add(currentName);
            nameSuggestions.addAll(this.myNameSuggestions);
        }
        return nameSuggestions;
    }

    protected void revalidate() {
        this.getContentPanel().revalidate();
        if (this.myTarget != null) {
            this.myBalloon.revalidate((PositionTracker)new PositionTracker.Static(this.myTarget));
        }
    }

    protected abstract void addTypeReferenceVariable(TemplateBuilderImpl var1);

    protected abstract TemplateEditingListener createTypeReferencePostprocessor();

    protected void addAdditionalVariables(TemplateBuilderImpl builder2) {
        this.addTypeReferenceVariable(builder2);
    }

    protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope, @NotNull PsiFile containingFile) {
        if (refs == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(2);
        }
        if (stringUsages == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(4);
        }
        if (containingFile == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(5);
        }
        this.myEditor.putUserData(INTRODUCE_RESTART, (Object)false);
        this.myEditor.getCaretModel().moveToOffset(this.getNameIdentifier().getTextOffset());
        boolean result2 = super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)InjectedLanguageUtil.getTopLevelEditor((Editor)this.myEditor));
        if (templateState != null) {
            if (this.myDeclaration.getTypeReference() != null) {
                final TemplateEditingListener postprocessor = this.createTypeReferencePostprocessor();
                templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                    public void templateFinished(@NotNull Template template2, boolean brokenOff) {
                        if (template2 == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if (!AbstractKotlinInplaceVariableIntroducer.this.myRestart) {
                            postprocessor.templateFinished(template2, brokenOff);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$4", "templateFinished"));
                    }
                });
            }
            templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template2, boolean brokenOff) {
                    if (template2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        AbstractKotlinInplaceVariableIntroducer.this.onCancel(AbstractKotlinInplaceVariableIntroducer.this.myRestart);
                    }
                }

                public void templateCancelled(Template template2) {
                    AbstractKotlinInplaceVariableIntroducer.this.onCancel(AbstractKotlinInplaceVariableIntroducer.this.myRestart);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$5", "templateFinished"));
                }
            });
        }
        return result2;
    }

    protected void onCancel(boolean restart) {
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        return CollectionsKt.map((Iterable)ArraysKt.filterIsInstance((Object[])this.getOccurrences(), KtSimpleNameExpression.class), (Function1)new Function1<KtSimpleNameExpression, PsiReference>(this){

            public PsiReference invoke(KtSimpleNameExpression expression) {
                return ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)expression);
            }
        });
    }

    public boolean performInplaceRefactoring(LinkedHashSet<String> nameSuggestions) {
        if (super.performInplaceRefactoring(nameSuggestions)) {
            this.myEditor.putUserData(ACTIVE_INTRODUCER, (Object)this);
            return true;
        }
        return false;
    }

    public void finish(boolean success) {
        super.finish(success);
        this.myEditor.putUserData(ACTIVE_INTRODUCER, null);
    }

    protected void moveOffsetAfter(boolean success) {
        if (!this.myReplaceOccurrence || this.myExprMarker == null) {
            this.myEditor.getCaretModel().moveToOffset(this.myDeclaration.getTextRange().getEndOffset());
        } else {
            int startOffset = this.myExprMarker.getStartOffset();
            PsiFile file = this.myDeclaration.getContainingFile();
            PsiElement elementAt = file.findElementAt(startOffset);
            if (elementAt != null) {
                this.myEditor.getCaretModel().moveToOffset(elementAt.getTextRange().getEndOffset());
            } else {
                this.myEditor.getCaretModel().moveToOffset(this.myExprMarker.getEndOffset());
            }
        }
    }

    public void stopIntroduce() {
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)this.myEditor);
        if (templateState != null) {
            Runnable runnable = () -> templateState.gotoEnd(true);
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable, this.getCommandName(), (Object)this.getCommandName());
        }
    }

    @Nullable
    public static AbstractKotlinInplaceVariableIntroducer getActiveInstance(@NotNull Editor editor) {
        if (editor == null) {
            AbstractKotlinInplaceVariableIntroducer.$$$reportNull$$$0(6);
        }
        return (AbstractKotlinInplaceVariableIntroducer)((Object)editor.getUserData(ACTIVE_INTRODUCER));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panelControl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPanelControl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateAndStart";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getActiveInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    protected static final class ControlWrapper {
        @NotNull
        private final Function0<JComponent> factory;
        @NotNull
        private final Function0<Boolean> condition;
        @NotNull
        private final Consumer<? super JComponent> initializer;
        private JComponent component;

        public ControlWrapper(@NotNull Function0<JComponent> factory2, @NotNull Function0<Boolean> condition2, @NotNull Consumer<? super JComponent> initializer2) {
            if (factory2 == null) {
                ControlWrapper.$$$reportNull$$$0(0);
            }
            if (condition2 == null) {
                ControlWrapper.$$$reportNull$$$0(1);
            }
            if (initializer2 == null) {
                ControlWrapper.$$$reportNull$$$0(2);
            }
            this.factory = factory2;
            this.condition = condition2;
            this.initializer = initializer2;
        }

        public ControlWrapper(@NotNull Function0<JComponent> factory2) {
            if (factory2 == null) {
                ControlWrapper.$$$reportNull$$$0(3);
            }
            this(factory2, TRUE, DO_NOTHING);
        }

        public boolean isAvailable() {
            return (Boolean)this.condition.invoke();
        }

        public void initialize() {
            this.initializer.accept(this.getComponent());
        }

        @NotNull
        public JComponent getComponent() {
            if (this.component == null) {
                this.component = (JComponent)this.factory.invoke();
            }
            JComponent jComponent = this.component;
            if (jComponent == null) {
                ControlWrapper.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$ControlWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/AbstractKotlinInplaceVariableIntroducer$ControlWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

