/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.VtlArgumentList;
import com.intellij.velocity.psi.VtlExpression;
import com.intellij.velocity.psi.VtlLiteralExpressionType;
import com.intellij.velocity.psi.directives.VtlParse;
import com.intellij.velocity.psi.files.VtlFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VtlFileReferencesInspection
extends VtlInspectionBase {
    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        if (element instanceof VtlParse) {
            VtlArgumentList argumentList = ((VtlParse)element).getArgumentList();
            if (argumentList == null) {
                return;
            }
            VtlExpression[] arguments = argumentList.getArguments();
            String message = VelocityBundle.message("vtl.only.first.parse.argument.will.be.parsed", new Object[0]);
            for (int i = 1; i < arguments.length; ++i) {
                holder.registerProblem((PsiElement)arguments[i], message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
            }
            if (arguments.length > 0 && (arguments[0].textMatches("\"\"") || arguments[0].textMatches("''"))) {
                holder.registerProblem((PsiElement)arguments[0], VelocityBundle.message("file.reference.inspection.relative.path.expected", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        } else if (element instanceof VtlLiteralExpressionType.VtlStringLiteral) {
            PsiFile file = element.getContainingFile();
            if (file instanceof VtlFile && ((VtlFile)file).isIdeTemplateFile()) {
                return;
            }
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof FileReference) || reference.resolve() != null) continue;
                holder.registerProblem(reference);
            }
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "VtlFileReferencesInspection";
    }
}

