/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class ReturnNode
extends Node {
    private Node valueNode;

    public ReturnNode(SourcePosition position, Node valueNode) {
        super(position);
        this.valueNode = this.adopt(valueNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        ReturnNode other = (ReturnNode)node;
        if (this.getValue() == null && other.getValue() == null) {
            return true;
        }
        if (this.getValue() == null || other.getValue() == null) {
            return false;
        }
        return this.getValue().isSame(other.getValue());
    }

    public NodeType getNodeType() {
        return NodeType.RETURNNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitReturnNode(this);
    }

    public Node getValue() {
        return this.valueNode;
    }

    @Deprecated
    public Node getValueNode() {
        return this.getValue();
    }

    public void setValue(Node value) {
        this.valueNode = this.adopt(value);
    }
}

