/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.lux;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.ide.model.LxCacheableImage;
import com.jetbrains.rd.ide.model.LxCachedImage;
import com.jetbrains.rd.ide.model.LxDiffImage;
import com.jetbrains.rd.ide.model.LxImage;
import com.jetbrains.rd.ide.model.LxImageContent;
import com.jetbrains.rd.ide.model.LxNonCacheableImage;
import com.jetbrains.rd.ide.model.LxPngImageContent;
import com.jetbrains.rd.platform.codeWithMe.lux.ImageDiff;
import com.jetbrains.rd.platform.codeWithMe.lux.LuxImageCacheKt;
import com.jetbrains.rd.platform.codeWithMe.util.SizeBoundedLRUCache;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.SunWritableRaster;
import sun.java2d.StateTrackable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 \u00042\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache;", "", "<init>", "()V", "Companion", "Frontend", "Backend", "BackendInternalStatCollector", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nLuxImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,480:1\n13#2:481\n*S KotlinDebug\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache\n*L\n25#1:481\n*E\n"})
public final class LuxImageCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    private static final int CACHE_SIZE = 0x3200000;
    private static final int LARGE_IMAGE_THRESHOLD = 0x200000;
    private static final int INCREMENTAL_CODING_MIN_IMAGE_SIZE = 10000;
    private static final double MAX_CHANGED_PART_TO_SEND_INCREMENTALLY = 0.7;

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LuxImageCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LuxImageCache.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\nH\u0002J:\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060 \u0012\u0004\u0012\u00020\u001d0\u001fJ\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend;", "", "<init>", "()V", "cache", "Lcom/jetbrains/rd/platform/codeWithMe/util/SizeBoundedLRUCache;", "", "lastImage", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lkotlin/jvm/internal/EnhancedNullability;", "Ljava/awt/image/BufferedImage;", "statsCollector", "Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector;", "Lcom/jetbrains/rd/ide/model/LxImage;", "luxId", "img", "Ljava/awt/Image;", "bgColor", "Ljava/awt/Color;", "sx", "sy", "width", "height", "allowIncrementalCoding", "", "isBigEnoughToEnableIncrementalCoding", "image", "createImageId", "onItemsRemoved", "", "handler", "Lkotlin/Function1;", "", "clear", "imageContentIsUntrackable", "intellij.platform.split"})
    @SourceDebugExtension(value={"SMAP\nLuxImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n1#2:481\n*E\n"})
    public static final class Backend {
        @NotNull
        private final SizeBoundedLRUCache<Integer> cache = new SizeBoundedLRUCache(0x3200000);
        @NotNull
        private final Cache<Integer, BufferedImage> lastImage;
        @NotNull
        private final BackendInternalStatCollector statsCollector;

        public Backend() {
            Cache cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
            Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
            this.lastImage = cache;
            this.statsCollector = new BackendInternalStatCollector();
        }

        @NotNull
        public final LxImage cache(int luxId, @NotNull Image img, @Nullable Color bgColor, int sx, int sy, int width, int height, boolean allowIncrementalCoding) {
            ImageDiff diff;
            BufferedImage sameSizeCached;
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            int id2 = this.createImageId(img, bgColor, sx, sy, width, height);
            if (this.cache.contains(id2)) {
                this.statsCollector.fireUsedCache(id2, img, (Function0<? extends LxImageContent>)((Function0)() -> Backend.cache$lambda$0(img, bgColor, sx, sy, width, height)));
                return (LxImage)new LxCachedImage(id2);
            }
            BufferedImage renderedImg = LuxImageCacheKt.access$toBufferedImage(img, bgColor, sx, sy, width, height);
            if (allowIncrementalCoding) {
                BufferedImage bufferedImage = (BufferedImage)this.lastImage.getIfPresent((Object)luxId);
                if (bufferedImage != null) {
                    BufferedImage bufferedImage2;
                    BufferedImage it = bufferedImage2 = bufferedImage;
                    boolean bl = false;
                    v1 = it.getWidth() == width && it.getHeight() == height ? bufferedImage2 : null;
                } else {
                    v1 = null;
                }
            } else {
                v1 = sameSizeCached = null;
            }
            if (sameSizeCached != null && !Intrinsics.areEqual((Object)(diff = ImageDiff.Companion.createFor(sameSizeCached, renderedImg, 0.7)).getContent(), (Object)renderedImg)) {
                this.lastImage.put((Object)luxId, (Object)renderedImg);
                BufferedImage bufferedImage = diff.getContent();
                LxImageContent content = bufferedImage != null ? LuxImageCacheKt.access$toLxImageContent(bufferedImage) : null;
                this.statsCollector.fireDiff(content, img);
                return (LxImage)new LxDiffImage(diff.getX(), diff.getY(), content);
            }
            LxImageContent imageContent = LuxImageCacheKt.access$toLxImageContent(renderedImg);
            int imageContentSize = LuxImageCacheKt.access$getImageContentSize(imageContent);
            if (imageContentSize <= 0x200000) {
                boolean keepForDiff;
                boolean bl = keepForDiff = allowIncrementalCoding && this.isBigEnoughToEnableIncrementalCoding(renderedImg);
                if (keepForDiff) {
                    this.lastImage.put((Object)luxId, (Object)renderedImg);
                }
                if (this.imageContentIsUntrackable(img)) {
                    this.statsCollector.fireNonCached(imageContent, img);
                    return (LxImage)new LxNonCacheableImage(imageContent, keepForDiff);
                }
                this.cache.putOrUpdate(id2, imageContentSize);
                this.statsCollector.fireCached(id2, imageContent, img);
                return (LxImage)new LxCacheableImage(id2, imageContent, keepForDiff);
            }
            this.statsCollector.fireNonCached(imageContent, img);
            return (LxImage)new LxNonCacheableImage(imageContent, false);
        }

        private final boolean isBigEnoughToEnableIncrementalCoding(BufferedImage image) {
            return image.getWidth() * image.getHeight() >= 10000;
        }

        private final int createImageId(Image img, Color bgColor, int sx, int sy, int width, int height) {
            int hashCode = img.hashCode();
            Color color = bgColor;
            hashCode = hashCode * 31 + (color != null ? ((Object)color).hashCode() : 0);
            hashCode = hashCode * 31 + sx;
            hashCode = hashCode * 31 + sy;
            hashCode = hashCode * 31 + width;
            hashCode = hashCode * 31 + height;
            return hashCode;
        }

        public final void onItemsRemoved(@NotNull Function1<? super List<Integer>, Unit> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.cache.addListener(new SizeBoundedLRUCache.Listener<Integer>(handler){
                final /* synthetic */ Function1<List<Integer>, Unit> $handler;
                {
                    this.$handler = $handler;
                }

                public void itemsWasRemoved(List<Integer> items) {
                    Intrinsics.checkNotNullParameter(items, (String)"items");
                    this.$handler.invoke(items);
                }
            });
        }

        public final void clear(int luxId) {
            this.lastImage.invalidate((Object)luxId);
        }

        public final void clear() {
            this.statsCollector.dumpCacheStats();
            this.statsCollector.clear();
            this.cache.forceClearCache();
            this.lastImage.invalidateAll();
        }

        public final boolean imageContentIsUntrackable(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return image.getClass() == BufferedImage.class && SunWritableRaster.stealTrackable(((BufferedImage)image).getRaster().getDataBuffer()).getState() == StateTrackable.State.UNTRACKABLE;
        }

        private static final LxImageContent cache$lambda$0(Image $img, Color $bgColor, int $sx, int $sy, int $width, int $height) {
            return LuxImageCacheKt.access$toLxImageContent($img, $bgColor, $sx, $sy, $width, $height);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0006\u0010\u001b\u001a\u00020\u000eJ\u001e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector;", "", "<init>", "()V", "isContentCheckEnabled", "", "lastCachedContentHashes", "", "", "", "seenImages", "Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector$ImageKey;", "Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector$ImageData;", "fireUsedCache", "", "id", "img", "Ljava/awt/Image;", "imageContentProvider", "Lkotlin/Function0;", "Lcom/jetbrains/rd/ide/model/LxImageContent;", "fireCached", "imageContent", "fireNonCached", "fireDiff", "diffImageContent", "validateCachedContent", "dumpCacheStats", "dumpBatch", "title", "", "data", "", "isPowerOfTwo", "value", "clear", "updateSeen", "createImageContentHash", "ImageKey", "ImageData", "intellij.platform.split"})
    @SourceDebugExtension(value={"SMAP\nLuxImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,480:1\n1#2:481\n1056#3:482\n13812#4,2:483\n*S KotlinDebug\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector\n*L\n287#1:482\n315#1:483,2\n*E\n"})
    public static final class BackendInternalStatCollector {
        private final boolean isContentCheckEnabled = Boolean.parseBoolean(System.getProperty("lux.image.cache.stats", "false"));
        @NotNull
        private final Map<Integer, Long> lastCachedContentHashes = new LinkedHashMap();
        @NotNull
        private final Map<ImageKey, ImageData> seenImages = new LinkedHashMap();

        public final void fireUsedCache(int id2, @NotNull Image img, @NotNull Function0<? extends LxImageContent> imageContentProvider) {
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            Intrinsics.checkNotNullParameter(imageContentProvider, (String)"imageContentProvider");
            if (this.isContentCheckEnabled) {
                LxImageContent imageContent = (LxImageContent)imageContentProvider.invoke();
                ImageData data = this.updateSeen(imageContent, img);
                int n = data.getUsedCachedCount();
                data.setUsedCachedCount(n + 1);
                this.validateCachedContent(id2, imageContent);
            }
        }

        public final void fireCached(int id2, @NotNull LxImageContent imageContent, @NotNull Image img) {
            Intrinsics.checkNotNullParameter((Object)imageContent, (String)"imageContent");
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            if (logger.isDebugEnabled()) {
                logger.debug("Cached " + LuxImageCacheKt.access$getImageContentSize(imageContent) + " image: " + img);
            }
            if (this.isContentCheckEnabled) {
                ImageData data = this.updateSeen(imageContent, img);
                int n = data.getSentCachedCount();
                data.setSentCachedCount(n + 1);
                if (this.isPowerOfTwo(data.getSentCount())) {
                    logger.info("Re-sent cache for: " + data, new Throwable());
                }
                this.validateCachedContent(id2, imageContent);
            }
        }

        public final void fireNonCached(@NotNull LxImageContent imageContent, @NotNull Image img) {
            Intrinsics.checkNotNullParameter((Object)imageContent, (String)"imageContent");
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            if (logger.isDebugEnabled()) {
                logger.debug("Skipped cache " + LuxImageCacheKt.access$getImageContentSize(imageContent) + " image: " + img);
            }
            if (this.isContentCheckEnabled) {
                ImageData data = this.updateSeen(imageContent, img);
                int n = data.getSentNonCachedCount();
                data.setSentNonCachedCount(n + 1);
                if (this.isPowerOfTwo(data.getSentCount())) {
                    logger.info("Re-sent non-cached dupe for: " + data, new Throwable());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void fireDiff(@Nullable LxImageContent diffImageContent, @NotNull Image img) {
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            if (logger.isDebugEnabled()) {
                int n;
                Logger logger = logger;
                LxImageContent lxImageContent = diffImageContent;
                if (lxImageContent != null) {
                    void it;
                    LxImageContent lxImageContent2 = lxImageContent;
                    Logger logger2 = logger;
                    boolean bl = false;
                    int n2 = LuxImageCacheKt.access$getImageContentSize((LxImageContent)it);
                    logger = logger2;
                    n = n2;
                } else {
                    n = 0;
                }
                logger.debug("Diff with size " + n + " generated for image: " + img);
            }
        }

        private final void validateCachedContent(int id2, LxImageContent imageContent) {
            block3: {
                block2: {
                    long contentHash = this.createImageContentHash(imageContent);
                    Long oldHash = this.lastCachedContentHashes.replace(id2, contentHash);
                    if (oldHash == null) break block2;
                    long l = contentHash;
                    if (oldHash != l) break block3;
                }
                return;
            }
            logger.warn("Wrong cached content", new Throwable());
        }

        public final void dumpCacheStats() {
            if (this.isContentCheckEnabled) {
                List goodCached = new ArrayList();
                List partiallyCached = new ArrayList();
                List unique = new ArrayList();
                List nonCachedDupes = new ArrayList();
                for (ImageData data : this.seenImages.values()) {
                    List category = data.getSentCount() == 1 && data.getUsedCachedCount() == 0 ? unique : (data.getSentCount() == 1 ? goodCached : (data.getUsedCachedCount() != 0 ? partiallyCached : nonCachedDupes));
                    ((Collection)category).add(data);
                }
                logger.info("--- lux cache stat ---");
                this.dumpBatch("--- successfully cached ---", goodCached);
                this.dumpBatch("--- partially cached ---", partiallyCached);
                this.dumpBatch("--- unique images ---", unique);
                this.dumpBatch("--- cache misses ---", nonCachedDupes);
                logger.info("=== lux cache stat ===");
            }
        }

        private final void dumpBatch(String title, List<ImageData> data) {
            logger.info(title);
            Iterable $this$sortedBy$iv = data;
            boolean $i$f$sortedBy = false;
            for (ImageData entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ImageData it = (ImageData)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getContentSize());
                    it = (ImageData)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getContentSize()));
                }
            })) {
                logger.info(entry.toString());
            }
        }

        private final boolean isPowerOfTwo(int value) {
            return value > 1 && (value & value - 1) == 0;
        }

        public final void clear() {
            if (this.isContentCheckEnabled) {
                logger.info("cache cleared");
            }
            this.seenImages.clear();
        }

        private final ImageData updateSeen(LxImageContent imageContent, Image img) {
            Intrinsics.checkNotNull((Object)imageContent, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.LxPngImageContent");
            LxPngImageContent cfr_ignored_0 = (LxPngImageContent)imageContent;
            long contentHash = this.createImageContentHash(imageContent);
            ImageKey imageKey = new ImageKey(contentHash);
            ImageData imageData = this.seenImages.computeIfAbsent(imageKey, arg_0 -> BackendInternalStatCollector.updateSeen$lambda$1(arg_0 -> BackendInternalStatCollector.updateSeen$lambda$0(img, imageContent, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)imageData, (String)"computeIfAbsent(...)");
            return imageData;
        }

        private final long createImageContentHash(LxImageContent imageContent) {
            Intrinsics.checkNotNull((Object)imageContent, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.LxPngImageContent");
            LxPngImageContent cfr_ignored_0 = (LxPngImageContent)imageContent;
            long result2 = 0L;
            byte[] $this$forEach$iv = ((LxPngImageContent)imageContent).getBytes();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                byte element$iv;
                byte it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                result2 = result2 * (long)31 + (long)it;
            }
            return result2;
        }

        private static final ImageData updateSeen$lambda$0(Image $img, LxImageContent $imageContent, ImageKey it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ImageData($img.toString(), ((LxPngImageContent)$imageContent).getBytes().length, 0, 0, 0);
        }

        private static final ImageData updateSeen$lambda$1(Function1 $tmp0, Object p0) {
            return (ImageData)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector$ImageData;", "", "imgToString", "", "contentSize", "", "sentCachedCount", "sentNonCachedCount", "usedCachedCount", "<init>", "(Ljava/lang/String;IIII)V", "getImgToString", "()Ljava/lang/String;", "getContentSize", "()I", "getSentCachedCount", "setSentCachedCount", "(I)V", "getSentNonCachedCount", "setSentNonCachedCount", "getUsedCachedCount", "setUsedCachedCount", "sentCount", "getSentCount", "toString", "intellij.platform.split"})
        private static final class ImageData {
            @NotNull
            private final String imgToString;
            private final int contentSize;
            private int sentCachedCount;
            private int sentNonCachedCount;
            private int usedCachedCount;

            public ImageData(@NotNull String imgToString, int contentSize, int sentCachedCount, int sentNonCachedCount, int usedCachedCount) {
                Intrinsics.checkNotNullParameter((Object)imgToString, (String)"imgToString");
                this.imgToString = imgToString;
                this.contentSize = contentSize;
                this.sentCachedCount = sentCachedCount;
                this.sentNonCachedCount = sentNonCachedCount;
                this.usedCachedCount = usedCachedCount;
            }

            @NotNull
            public final String getImgToString() {
                return this.imgToString;
            }

            public final int getContentSize() {
                return this.contentSize;
            }

            public final int getSentCachedCount() {
                return this.sentCachedCount;
            }

            public final void setSentCachedCount(int n) {
                this.sentCachedCount = n;
            }

            public final int getSentNonCachedCount() {
                return this.sentNonCachedCount;
            }

            public final void setSentNonCachedCount(int n) {
                this.sentNonCachedCount = n;
            }

            public final int getUsedCachedCount() {
                return this.usedCachedCount;
            }

            public final void setUsedCachedCount(int n) {
                this.usedCachedCount = n;
            }

            public final int getSentCount() {
                return this.sentCachedCount + this.sentNonCachedCount;
            }

            @NotNull
            public String toString() {
                return "Sent times: " + StringsKt.padStart$default((String)String.valueOf(this.getSentCount()), (int)3, (char)'\u0000', (int)2, null) + " (Non cached: " + StringsKt.padStart$default((String)String.valueOf(this.sentNonCachedCount), (int)3, (char)'\u0000', (int)2, null) + ", Used cache: " + StringsKt.padStart$default((String)String.valueOf(this.usedCachedCount), (int)4, (char)'\u0000', (int)2, null) + "), size: " + StringsKt.padStart$default((String)String.valueOf(this.contentSize), (int)6, (char)'\u0000', (int)2, null) + " - " + this.imgToString;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$BackendInternalStatCollector$ImageKey;", "", "contentHash", "", "<init>", "(J)V", "getContentHash", "()J", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.split"})
        private static final class ImageKey {
            private final long contentHash;

            public ImageKey(long contentHash) {
                this.contentHash = contentHash;
            }

            public final long getContentHash() {
                return this.contentHash;
            }

            public final long component1() {
                return this.contentHash;
            }

            @NotNull
            public final ImageKey copy(long contentHash) {
                return new ImageKey(contentHash);
            }

            public static /* synthetic */ ImageKey copy$default(ImageKey imageKey, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = imageKey.contentHash;
                }
                return imageKey.copy(l);
            }

            @NotNull
            public String toString() {
                return "ImageKey(contentHash=" + this.contentHash + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.contentHash);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ImageKey)) {
                    return false;
                }
                ImageKey imageKey = (ImageKey)other;
                return this.contentHash == imageKey.contentHash;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "CACHE_SIZE", "", "LARGE_IMAGE_THRESHOLD", "INCREMENTAL_CODING_MIN_IMAGE_SIZE", "MAX_CHANGED_PART_TO_SEND_INCREMENTALLY", "", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\n\u001aN\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t \r*%\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t0\u000e\u00a2\u0006\u0002\b\u000b0\u0005\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Frontend;", "", "<init>", "()V", "cache", "", "", "Lcom/jetbrains/rd/ide/model/LxImageContent;", "lastImage", "Ljava/awt/image/BufferedImage;", "imageCache", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "kotlin.jvm.PlatformType", "", "getCachedImage", "luxId", "model", "Lcom/jetbrains/rd/ide/model/LxImage;", "contentToImage", "content", "withCache", "", "clear", "", "removeAll", "keys", "", "intellij.platform.split"})
    @SourceDebugExtension(value={"SMAP\nLuxImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxImageCache.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Frontend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,480:1\n1#2:481\n*E\n"})
    public static final class Frontend {
        @NotNull
        private final Map<Integer, LxImageContent> cache = new LinkedHashMap();
        @NotNull
        private final Map<Integer, BufferedImage> lastImage = new LinkedHashMap();
        @NotNull
        private final Map<LxImageContent, BufferedImage> imageCache;

        public Frontend() {
            Map map = ContainerUtil.createSoftValueMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createSoftValueMap(...)");
            this.imageCache = map;
        }

        @Nullable
        public final BufferedImage getCachedImage(int luxId, @NotNull LxImage model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            LxImage lxImage = model;
            if (lxImage instanceof LxCachedImage) {
                LxImageContent lxImageContent = this.cache.get(((LxCachedImage)model).getId());
                if (lxImageContent == null) {
                    Frontend $this$getCachedImage_u24lambda_u240 = this;
                    boolean bl = false;
                    logger.warn("Image " + ((LxCachedImage)model).getId() + " has no data and not in cache");
                    return null;
                }
                LxImageContent content = lxImageContent;
                return this.contentToImage(content, true);
            }
            if (lxImage instanceof LxCacheableImage) {
                BufferedImage content;
                this.cache.put(((LxCacheableImage)model).getId(), ((LxCacheableImage)model).getContent());
                BufferedImage it = content = this.contentToImage(((LxCacheableImage)model).getContent(), true);
                boolean bl = false;
                if (((LxCacheableImage)model).getKeepForDiff()) {
                    this.lastImage.put(luxId, it);
                }
                return content;
            }
            if (lxImage instanceof LxNonCacheableImage) {
                BufferedImage content;
                BufferedImage it = content = this.contentToImage(((LxNonCacheableImage)model).getContent(), false);
                boolean bl = false;
                if (((LxNonCacheableImage)model).getKeepForDiff()) {
                    this.lastImage.put(luxId, it);
                }
                return content;
            }
            if (lxImage instanceof LxDiffImage) {
                BufferedImage baseImage = this.lastImage.get(luxId);
                if (baseImage == null) {
                    logger.warn("No base image found for luxId=" + luxId);
                    return null;
                }
                LxImageContent lxImageContent = ((LxDiffImage)model).getContent();
                ImageDiff diff = new ImageDiff(((LxDiffImage)model).getX(), ((LxDiffImage)model).getY(), lxImageContent != null ? LuxImageCacheKt.access$toImage(lxImageContent) : null);
                BufferedImage image = diff.applyTo(baseImage);
                this.lastImage.put(luxId, image);
                return image;
            }
            throw new IllegalStateException(("unknown type of image: " + model).toString());
        }

        private final BufferedImage contentToImage(LxImageContent content, boolean withCache) {
            BufferedImage bufferedImage = this.imageCache.get(content);
            if (bufferedImage != null) {
                BufferedImage it = bufferedImage;
                boolean bl = false;
                return it;
            }
            BufferedImage image = LuxImageCacheKt.access$toImage(content);
            if (withCache) {
                this.imageCache.put(content, image);
            }
            return image;
        }

        public final void clear(int luxId) {
            this.lastImage.remove(luxId);
        }

        public final void removeAll(@NotNull List<Integer> keys) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Iterator<Integer> iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = ((Number)iterator.next()).intValue();
                LxImageContent content = this.cache.remove(key);
                if (content == null) continue;
                this.imageCache.remove(content);
            }
        }
    }
}

