/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.EditLibraryDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxEditor;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxRenderer;
import com.intellij.webcore.libraries.ui.PerFileMappingsDialogWrapper;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.intellij.webcore.libraries.ui.ScriptingLibraryTableModel;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibrariesPanel {
    private JPanel myMainPanel;
    private JButton myAddLibraryButton;
    private JButton myRemoveLibraryButton;
    private JButton myEditLibraryButton;
    private JPanel myScriptingLibrariesPanel;
    private JBTable myLibraryTable;
    private JButton myDownloadButton;
    private JButton myManageScopesButton;
    private boolean areMappingsChanged;
    private final Project myProject;
    private final LangScriptingContextProvider myProvider;
    private final ScriptingLibraryManager myLibraryManager;
    private final ScriptingLibraryMappings myLibraryMappings;
    private final ScriptingLibraryTableModel myLibTableModel;

    public ScriptingLibrariesPanel(@NotNull LangScriptingContextProvider provider, @NotNull Project project, @NotNull ScriptingLibraryManager libraryManager) {
        if (provider == null) {
            ScriptingLibrariesPanel.W(0);
        }
        if (project == null) {
            ScriptingLibrariesPanel.W(1);
        }
        if (libraryManager == null) {
            ScriptingLibrariesPanel.W(2);
        }
        this.areMappingsChanged = false;
        this.myProject = project;
        this.myProvider = provider;
        this.a();
        this.myLibraryMappings = provider.getLibraryMappings(project);
        this.myLibraryManager = libraryManager;
        this.myLibraryTable.setShowGrid(false);
        this.myLibTableModel = new ScriptingLibraryTableModel(libraryManager, this.myLibraryMappings);
        this.myLibraryTable.setModel((TableModel)this.myLibTableModel);
        this.myLibraryTable.setRowHeight((int)((double)this.myLibraryTable.getRowHeight() * 1.2));
        JTableHeader jTableHeader = this.myLibraryTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableColumn tableColumn = this.myLibraryTable.getColumnModel().getColumn(0);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, ScriptingLibrariesPanel.W(jTableHeader, tableColumn));
        tableColumn.setCellRenderer(new PartlySelectedCheckBoxRenderer());
        tableColumn.setCellEditor(new PartlySelectedCheckBoxEditor(this));
        this.myLibraryTable.getColumnModel().getColumn(1).setCellRenderer(new LibraryNameCellRenderer());
        SwingHelper.setNoBorderCellRendererFor((TableColumn)this.myLibraryTable.getColumnModel().getColumn(1));
        int n2 = this.myLibraryTable.getFontMetrics(this.myLibraryTable.getFont()).stringWidth(ScriptingLibraryTableModel.getLongestLibraryLevelName()) + JBUIScale.scale((int)10);
        ScriptingLibrariesPanel.setColumnWidth(this.myLibraryTable.getColumnModel().getColumn(2), n2);
        this.myLibraryTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e2) {
                if (e2.getKeyChar() == ' ') {
                    int[] nArray = ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRows();
                    boolean bl2 = true;
                    for (int n2 : nArray) {
                        if (ScriptingLibraryTableModel.EnabledState.ON == ScriptingLibrariesPanel.this.myLibTableModel.getValueAt(n2, 0)) continue;
                        bl2 = false;
                    }
                    for (int n2 : nArray) {
                        if (!bl2 && ScriptingLibraryTableModel.EnabledState.ON != ScriptingLibrariesPanel.this.myLibTableModel.getValueAt(n2, 0)) {
                            ScriptingLibrariesPanel.this.myLibTableModel.setValueAt(Boolean.TRUE, n2, 0);
                            continue;
                        }
                        if (!bl2) continue;
                        ScriptingLibrariesPanel.this.myLibTableModel.setValueAt(Boolean.FALSE, n2, 0);
                    }
                }
            }
        });
        this.myDownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibrariesPanel.this.W(ScriptingLibrariesPanel.this.getPanel());
            }
        });
        this.myManageScopesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibrariesPanel.this.S();
            }
        });
        this.myScriptingLibrariesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)WebCoreBundle.message((String)"library.table.border.title", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myAddLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.W();
                if (scriptingLibraryModel != null) {
                    ScriptingLibrariesPanel.this.selectLibrary(scriptingLibraryModel.getName());
                }
            }
        });
        this.myRemoveLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                int[] nArray = ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRows();
                ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
                for (int n2 : nArray) {
                    ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.myLibTableModel.getLibraryAt(n2);
                    if (scriptingLibraryModel == null || scriptingLibraryModel.isPredefined()) continue;
                    arrayList.add(scriptingLibraryModel);
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)object.next();
                    ScriptingLibrariesPanel.this.d(scriptingLibraryModel.getName());
                }
            }
        });
        this.myEditLibraryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String string = ScriptingLibrariesPanel.this.myLibTableModel.getLibNameAt(ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow());
                ScriptingLibrariesPanel.this.S(string);
            }
        });
        this.myRemoveLibraryButton.setEnabled(false);
        this.myEditLibraryButton.setEnabled(false);
        this.myLibraryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                ScriptingLibrariesPanel.this.T();
            }
        });
        this.myLibraryTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                ScriptingLibraryModel scriptingLibraryModel;
                int n2;
                if (e2.getClickCount() == 2 && (n2 = ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow()) != -1 && (scriptingLibraryModel = ScriptingLibrariesPanel.this.myLibTableModel.getLibraryAt(ScriptingLibrariesPanel.this.myLibraryTable.getSelectedRow())) != null && !scriptingLibraryModel.isPredefined()) {
                    ScriptingLibrariesPanel.this.S(scriptingLibraryModel.getName());
                }
            }
        });
    }

    private static int W(@NotNull JTableHeader jTableHeader, @NotNull TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer;
        if (jTableHeader == null) {
            ScriptingLibrariesPanel.W(3);
        }
        if (tableColumn == null) {
            ScriptingLibrariesPanel.W(4);
        }
        if ((tableCellRenderer = tableColumn.getHeaderRenderer()) == null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, tableColumn.getModelIndex());
        int n2 = component.getPreferredSize().width;
        if (component instanceof JComponent) {
            Insets insets = ((JComponent)component).getInsets();
            n2 += Math.max(0, insets.left - insets.right);
        }
        return n2;
    }

    static void setColumnWidth(@NotNull TableColumn column, int width) {
        if (column == null) {
            ScriptingLibrariesPanel.W(5);
        }
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ScriptingLibrariesPanel.W(6);
        }
        return jPanel;
    }

    private void d(String string) {
        ApplicationManager.getApplication().runWriteAction(() -> this.myLibTableModel.removeLibrary(string));
    }

    private ScriptingLibraryModel W() {
        EditLibraryDialog editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.new.dialog.title", (Object[])new Object[0]), this.myProvider, this.myProject);
        if (editLibraryDialog.showAndGet()) {
            ScriptingLibraryModel scriptingLibraryModel = this.myLibTableModel.createLibrary(editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls(), editLibraryDialog.getLibraryLevel(), false);
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            return scriptingLibraryModel;
        }
        return null;
    }

    private void T() {
        int[] nArray;
        boolean bl2;
        int n2 = this.myLibraryTable.getSelectedRowCount();
        boolean bl3 = bl2 = n2 == 1;
        if (bl2) {
            ScriptingLibraryModel scriptingLibraryModel = this.myLibTableModel.getLibraryAt(this.myLibraryTable.getSelectedRow());
            bl2 = scriptingLibraryModel != null && !scriptingLibraryModel.isPredefined();
        }
        this.myEditLibraryButton.setEnabled(bl2);
        boolean bl4 = n2 > 0;
        for (int n3 : nArray = this.myLibraryTable.getSelectedRows()) {
            ScriptingLibraryModel scriptingLibraryModel = this.myLibTableModel.getLibraryAt(n3);
            if (scriptingLibraryModel == null || !scriptingLibraryModel.isPredefined()) continue;
            bl4 = false;
            break;
        }
        this.myRemoveLibraryButton.setEnabled(bl4);
    }

    private void S(String string) {
        ScriptingLibraryModel scriptingLibraryModel;
        EditLibraryDialog editLibraryDialog;
        if (string == null) {
            return;
        }
        ScriptingLibraryModel scriptingLibraryModel2 = this.myLibTableModel.getLibrary(string);
        if (scriptingLibraryModel2 != null && (editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.edit.dialog.title", (Object[])new Object[0]), this.myProvider, this.myProject, scriptingLibraryModel2)).showAndGet() && (scriptingLibraryModel = this.myLibTableModel.updateLibrary(string, editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls())) != null) {
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            scriptingLibraryModel.setLibraryLevel(editLibraryDialog.getLibraryLevel());
        }
    }

    public boolean isModified() {
        return this.myLibTableModel.isChanged() || this.areMappingsChanged;
    }

    public void resetTable() {
        this.myLibTableModel.resetTable();
        this.areMappingsChanged = false;
    }

    public void apply() {
        this.myLibraryMappings.updateAssociations(() -> this.q());
    }

    private void q() {
        this.myLibTableModel.applyChanges();
        Map map = this.myLibraryMappings.getMappings();
        for (ScriptingLibraryModel scriptingLibraryModel : map.values()) {
            if (!(scriptingLibraryModel instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ((ScriptingLibraryMappings.CompoundLibrary)scriptingLibraryModel).applyChanges();
        }
    }

    private void W(@NotNull Component component) {
        DownloadWebLibraryDialog downloadWebLibraryDialog;
        if (component == null) {
            ScriptingLibrariesPanel.W(7);
        }
        if ((downloadWebLibraryDialog = new DownloadWebLibraryDialog(this.myProject, this.myProvider)).showAndGet()) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = downloadWebLibraryDialog.getSelection();
            if (downloadableFileSetDescriptionWithUrl == null) {
                return;
            }
            if (this.isModified()) {
                WriteAction.run(() -> {
                    this.apply();
                    this.myLibraryManager.commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
                });
            }
            ApplicationManager.getApplication().invokeLater(() -> downloadableFileSetDescriptionWithUrl.downloadLibrary(this.myProject, this.myProvider, component, () -> this.W((DownloadableFileSetDescription)downloadableFileSetDescriptionWithUrl)));
        }
    }

    private void W(DownloadableFileSetDescription downloadableFileSetDescription) {
        this.myLibTableModel.fireLibTableChanged(true);
        String string = LangScriptingContextProvider.getIdeLibraryName(downloadableFileSetDescription);
        this.selectLibrary(string);
        if (ModuleHelper.getModules((Project)this.myProject).length > 1) {
            this.configureModules();
        }
    }

    protected void selectLibrary(String libName) {
        int n2 = this.myLibTableModel.getLibraryIndex(libName);
        if (n2 >= 0) {
            this.myLibraryTable.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void S() {
        this.myLibTableModel.applyMappings();
        ScriptingContextsConfigurable scriptingContextsConfigurable = new ScriptingContextsConfigurable(this.myProject, this.myLibraryMappings);
        PerFileMappingsDialogWrapper perFileMappingsDialogWrapper = new PerFileMappingsDialogWrapper(this.getPanel(), scriptingContextsConfigurable);
        perFileMappingsDialogWrapper.setTitle(WebCoreBundle.message((String)"library.usage_scope.dialog.title", (Object[])new Object[]{this.myProvider.getLanguage().getDisplayName()}));
        if (perFileMappingsDialogWrapper.showAndGet() && scriptingContextsConfigurable.isModified()) {
            this.areMappingsChanged = true;
            this.myLibTableModel.fireLibTableChanged(false);
        }
    }

    int configureModules() {
        String string;
        ScriptingLibraryModel scriptingLibraryModel;
        if (ModuleHelper.getModules((Project)this.myProject).length == 1) {
            return -1;
        }
        int n2 = this.myLibraryTable.getSelectedRow();
        if (n2 >= 0 && (scriptingLibraryModel = this.myLibraryManager.getLibraryByName(string = this.myLibTableModel.getLibNameAt(n2))) != null) {
            if (scriptingLibraryModel.isPredefined()) {
                return -1;
            }
            ModuleScopeSelectionDialog moduleScopeSelectionDialog = new ModuleScopeSelectionDialog(this.myProject, scriptingLibraryModel.getAssociatedModules(), null, scriptingLibraryModel.getName());
            if (moduleScopeSelectionDialog.showAndGet()) {
                Set<Module> set = moduleScopeSelectionDialog.getSelectedModules();
                if (!scriptingLibraryModel.getAssociatedModules().equals(set)) {
                    scriptingLibraryModel.setAssociatedModules(set);
                    this.myLibraryMappings.updateMappings();
                    this.areMappingsChanged = true;
                }
                return set.size();
            }
            return scriptingLibraryModel.getAssociatedModules().size();
        }
        return -1;
    }

    private static boolean W(@Nullable ScriptingLibraryModel scriptingLibraryModel) {
        if (scriptingLibraryModel == null) {
            return false;
        }
        return ContainerUtil.and((Iterable)scriptingLibraryModel.getSourceFilePointers(), virtualFilePointer -> virtualFilePointer.getFile() != null) && ContainerUtil.and((Iterable)scriptingLibraryModel.getCompactFilePointers(), virtualFilePointer -> virtualFilePointer.getFile() != null);
    }

    private static /* synthetic */ void W(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationAreaComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumWidthToFitColumnTitle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColumnWidth";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDownloadDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void a() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScriptingLibrariesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 7, 1, 0, 3, 7, 7, null, null, null));
        this.myLibraryTable = jBTable = new JBTable();
        jBTable.setShowHorizontalLines(false);
        jBTable.setShowVerticalLines(false);
        jBTable.setStriped(false);
        jBScrollPane.setViewportView((Component)jBTable);
        this.myAddLibraryButton = jButton5 = new JButton();
        this.W(jButton5, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.add"));
        jPanel.add((Component)jButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveLibraryButton = jButton4 = new JButton();
        this.W(jButton4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.remove"));
        jPanel.add((Component)jButton4, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditLibraryButton = jButton3 = new JButton();
        this.W(jButton3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.edit"));
        jPanel.add((Component)jButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDownloadButton = jButton2 = new JButton();
        this.W(jButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.download.name"));
        jButton2.setToolTipText(DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.download.tooltip"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myManageScopesButton = jButton = new JButton();
        this.W(jButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.manage_scopes.name"));
        jPanel.add((Component)jButton, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void W(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private class LibraryNameCellRenderer
    extends DefaultTableCellRenderer {
        private LibraryNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ScriptingLibraryModel scriptingLibraryModel;
            boolean bl2;
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row >= 0 && row < ScriptingLibrariesPanel.this.myLibTableModel.getRowCount() && !(bl2 = ScriptingLibrariesPanel.W(scriptingLibraryModel = ScriptingLibrariesPanel.this.myLibTableModel.getLibraryAt(row))) && !isSelected) {
                this.setForeground((Color)JBColor.red);
            }
            return component;
        }
    }
}

