/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.dom;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.RequiredBeanType;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DefineAttributeQuickFix;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class SpringDomInspectionUtils {
    private static final Function<DomElement, String> DOM_NAME_FUNCTION = DomElement::getXmlElementName;
    private final DomElementAnnotationHolder holder;

    public SpringDomInspectionUtils(DomElementAnnotationHolder holder) {
        this.holder = holder;
    }

    public static boolean hasAny(DomElement ... values) {
        for (DomElement value : values) {
            if (!DomUtil.hasXml((DomElement)value)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMoreThanOne(DomElement ... values) {
        int count = 0;
        for (DomElement value : values) {
            if (!DomUtil.hasXml((DomElement)value) || (count = (int)((short)(count + 1))) <= 1) continue;
            return true;
        }
        return false;
    }

    public void oneOfRequired(DomElement element, DomElement ... elements) {
        if (SpringDomInspectionUtils.hasMoreThanOne(elements) || !SpringDomInspectionUtils.hasAny(elements)) {
            this.onlyOneOfProblem(element, elements);
        }
    }

    public void oneOfOrAllRequired(DomElement element, GenericAttributeValue ... values) {
        if (!SpringDomInspectionUtils.hasAny((DomElement[])values)) {
            this.holder.createProblem(element, SpringDomInspectionUtils.getDomElementNamesMessage("spring.dom.one.or.all.of.attributes", (DomElement[])values), new LocalQuickFix[0]);
        }
    }

    public boolean onlyOneOf(DomElement element, GenericAttributeValue ... values) {
        if (SpringDomInspectionUtils.hasMoreThanOne((DomElement[])values)) {
            this.onlyOneOfProblem(element, (DomElement[])values);
            return true;
        }
        return false;
    }

    public void ifExistsOtherRequired(DomElement element, GenericAttributeValue exists, GenericAttributeValue required) {
        if (SpringDomInspectionUtils.hasAny(new DomElement[]{exists}) && !SpringDomInspectionUtils.hasAny(new DomElement[]{required})) {
            String requiredName = (String)DOM_NAME_FUNCTION.fun((Object)required);
            this.holder.createProblem(element, SpringApiBundle.message("spring.dom.if.exists.other.required", DOM_NAME_FUNCTION.fun((Object)exists), requiredName), new LocalQuickFix[]{new DefineAttributeQuickFix(requiredName)});
        }
    }

    public void attributeSuperfluous(GenericAttributeValue value) {
        if (SpringDomInspectionUtils.hasAny(new DomElement[]{value})) {
            this.holder.createProblem((DomElement)value, SpringApiBundle.message("spring.dom.superfluous.attribute", DOM_NAME_FUNCTION.fun((Object)value)), new LocalQuickFix[]{new RemoveDomElementQuickFix((DomElement)value)}).highlightWholeElement();
        }
    }

    public <T> void attributeWithDefaultSuperfluous(GenericAttributeValue<T> value, T defaultValue) {
        if (SpringDomInspectionUtils.hasAny(new DomElement[]{value}) && defaultValue.equals(value.getValue())) {
            this.holder.createProblem(value, SpringApiBundle.message("spring.dom.superfluous.attribute.with.default", DOM_NAME_FUNCTION.fun(value), value.getStringValue()), new LocalQuickFix[]{new RemoveDomElementQuickFix(value)}).highlightWholeElement();
        }
    }

    private void onlyOneOfProblem(DomElement element, DomElement ... elements) {
        this.holder.createProblem(element, SpringDomInspectionUtils.getDomElementNamesMessage("spring.dom.only.one.of", elements), new LocalQuickFix[0]);
    }

    @InspectionMessage
    private static String getDomElementNamesMessage(String key, DomElement ... elements) {
        ArrayList<CallSite> elementNames = new ArrayList<CallSite>();
        for (DomElement element : elements) {
            String elementName = (String)DOM_NAME_FUNCTION.fun((Object)element);
            String name = element instanceof GenericAttributeValue ? "'" + elementName + "'" : "<" + elementName + ">";
            elementNames.add((CallSite)((Object)name));
        }
        return SpringApiBundle.message(key, NlsMessages.formatOrList(elementNames));
    }

    public void beanOfType(GenericAttributeValue<SpringBeanPointer<?>> springBeanAttribute, String beanClass) {
        SpringBeanPointer pointer = (SpringBeanPointer)springBeanAttribute.getValue();
        if (pointer == null) {
            return;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)pointer.getBeanClass(), (boolean)false, (String)beanClass)) {
            this.holder.createProblem(springBeanAttribute, SpringApiBundle.message("bean.must.be.of.type", beanClass), new LocalQuickFix[0]);
        }
    }

    public void explicitBeanRequired(DomElement domElement, GenericAttributeValue<SpringBeanPointer<?>> springBeanAttribute, String defaultBeanName) {
        String[] classNames;
        if (SpringDomInspectionUtils.hasAny(new DomElement[]{springBeanAttribute})) {
            return;
        }
        RequiredBeanType annotation = (RequiredBeanType)springBeanAttribute.getAnnotation(RequiredBeanType.class);
        assert (annotation != null) : springBeanAttribute;
        for (String beanClass : classNames = annotation.value()) {
            if (!SpringDomInspectionUtils.existsBean(domElement, beanClass, defaultBeanName)) continue;
            return;
        }
        this.holder.createProblem(domElement, SpringApiBundle.message("spring.dom.explicit.bean.reference.required", springBeanAttribute.getPresentation().getTypeName(), defaultBeanName), new LocalQuickFix[]{new DefineAttributeQuickFix((String)DOM_NAME_FUNCTION.fun(springBeanAttribute))});
    }

    public static boolean existsBean(DomElement domElement, String beanClass, String defaultBeanName) {
        PsiClass psiClass = DomJavaUtil.findClass((String)beanClass, (DomElement)domElement);
        if (psiClass == null) {
            return false;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes();
        if (!searchParameters.canSearch()) {
            return false;
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((PsiElement)domElement.getXmlTag());
        SpringBeanPointer<?> beanWithDefaultName = SpringModelSearchers.findBean(model, defaultBeanName);
        if (beanWithDefaultName == null) {
            return false;
        }
        return !model.processByClass(searchParameters, pointer -> !defaultBeanName.equals(pointer.getName()));
    }
}

