/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.StreamEx;

public class BatchSentenceTokenizer {
    private final List<String> texts;
    private final Map<String, List<Tokenizer.Token>> tokenized;

    public BatchSentenceTokenizer(List<String> texts, StandardSentenceTokenizer tokenizer) {
        this.texts = texts;
        this.tokenized = ((StreamEx)StreamEx.of(texts).distinct()).mapToEntry(arg_0 -> ((StandardSentenceTokenizer)tokenizer).tokenize(arg_0)).toMap();
    }

    public List<String> sentencesToParse() {
        return ((StreamEx)StreamEx.of(this.tokenized.values()).flatCollection(Function.identity()).map(Tokenizer.Token::getToken).distinct()).toList();
    }

    public LinkedHashMap<String, List<Tree>> textTrees(Map<String, Tree> sentenceTrees) {
        return (LinkedHashMap)((StreamEx)StreamEx.of(this.texts).distinct()).mapToEntry(s -> {
            List<Tokenizer.Token> sentences = this.tokenized.get(s);
            ArrayList<Tree> trees = new ArrayList<Tree>();
            for (Tokenizer.Token sentence : sentences) {
                trees.add(((Tree)sentenceTrees.get(sentence.getToken())).withStartOffset(sentence.getRange().getStart()));
            }
            return trees;
        }).toCustomMap(LinkedHashMap::new);
    }
}

