/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.core.KotlinAsJavaSmartPointerFactory;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.AuditTable;
import com.intellij.jpa.jpb.model.model.BaseEntity;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityCacheProvider;
import com.intellij.jpa.jpb.model.model.EntityListener;
import com.intellij.jpa.jpb.model.model.EntityPsiClassResolver;
import com.intellij.jpa.jpb.model.model.GenericGenerator;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.model.Method;
import com.intellij.jpa.jpb.model.model.MethodPsi;
import com.intellij.jpa.jpb.model.model.NamedQuery;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.model.SimpleEnumPsiType;
import com.intellij.jpa.jpb.model.model.SoftDeleteModel;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityPsi
extends Entity {
    private SmartPsiElementPointer<PsiClass> psiClassPointer;
    public static final Key<CachedValue<EntityPsi>> KEY = Key.create((String)(EntityPsi.class.getName() + ":CACHED_KEY"));
    private final Project project;
    private final EntityCacheProvider cacheProvider;

    protected EntityPsi(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EntityPsi.$$$reportNull$$$0(0);
        }
        this.project = psiClass.getProject();
        this.psiClassPointer = (SmartPsiElementPointer)EntityUtil.ra(() -> KotlinAsJavaSmartPointerFactory.Companion.createPointer(psiClass));
        this.cacheProvider = EntityCacheProvider.getInstance(this.project);
    }

    @NotNull
    public static EntityPsi getInstance(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EntityPsi.$$$reportNull$$$0(1);
        }
        EntityPsi entityPsi = (EntityPsi)EntityUtil.ra(() -> (EntityPsi)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            EntityPsi result = null;
            if (psiClass.isWritable()) {
                result = new EntityPsi(psiClass);
            } else {
                LibraryScopeCache libraryScopeCache = LibraryScopeCache.getInstance((Project)psiClass.getProject());
                if (libraryScopeCache.getLibrariesOnlyScope().accept(psiClass.getContainingFile().getVirtualFile())) {
                    result = new BaseEntity(psiClass);
                }
            }
            if (result == null) {
                result = new EntityPsi(psiClass);
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiClass.getNavigationElement()});
        }));
        if (entityPsi == null) {
            EntityPsi.$$$reportNull$$$0(2);
        }
        return entityPsi;
    }

    @Override
    public Module getModule() {
        PsiClass psiClass = this.getPsiClass();
        return (Module)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass), (Object[])new Object[]{psiClass.getNavigationElement()}));
    }

    @Override
    public boolean isPersistentEntity() {
        return this.cacheProvider.isPersistentEntity(this.getPsiClass());
    }

    @Override
    public boolean isMappedSuperclass() {
        return this.cacheProvider.isMappedSuperClass(this.getPsiClass());
    }

    @Override
    public boolean isImmutable() {
        PsiClass psiClass = this.getPsiClass();
        return (Boolean)EntityUtil.ra(() -> {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"org.hibernate.annotations.Immutable"});
            return annotation != null;
        });
    }

    @Override
    public boolean isDbView() {
        PsiClass psiClass = this.getPsiClass();
        return (Boolean)EntityUtil.ra(() -> {
            TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)psiClass);
            PsiDocCommentBase docComment = templateHelper == null ? null : templateHelper.getDocComment(psiClass);
            return docComment != null && docComment.getText().contains("Mapping for DB view");
        });
    }

    @Override
    public boolean isLombokGetter() {
        return this.cacheProvider.isLombokGetter(this.getPsiClass());
    }

    @Override
    public boolean isLombokSetter() {
        return this.cacheProvider.isLombokSetter(this.getPsiClass());
    }

    @Override
    public boolean isLombokAllArgsConstructor() {
        return this.cacheProvider.isLombokAllArgsConstructor(this.getPsiClass());
    }

    @Override
    public boolean isLombokNoArgsConstructor() {
        return this.cacheProvider.isLombokNoArgsConstructor(this.getPsiClass());
    }

    @Override
    public boolean isLombokBuilder() {
        return this.cacheProvider.isLombokBuilder(this.getPsiClass());
    }

    @Override
    public boolean isLombokSuperBuilder() {
        return this.cacheProvider.isLombokSuperBuilder(this.getPsiClass());
    }

    @Override
    public boolean isLombokToString() {
        return this.cacheProvider.isLombokToString(this.getPsiClass());
    }

    @Override
    public boolean isLombokOnlyExplicitlyIncluded() {
        return this.cacheProvider.isLombokOnlyExplicitlyIncluded(this.getPsiClass());
    }

    @Override
    public boolean isLombokData() {
        return this.cacheProvider.isLombokData(this.getPsiClass());
    }

    @Override
    public boolean isLombokEqualsAndHashCode() {
        return this.cacheProvider.isLombokEqualsAndHashCode(this.getPsiClass());
    }

    @Override
    public boolean isLombokRequiredArgsConstructor() {
        return this.cacheProvider.isLombokRequiredArgsConstructor(this.getPsiClass());
    }

    @Override
    public Entity.InheritanceType getInheritanceType() {
        return this.cacheProvider.getInheritanceType(this.getPsiClass());
    }

    @Override
    @NotNull
    public String getDiscriminatorLength() {
        String string = this.cacheProvider.getDiscriminatorLength(this.getPsiClass());
        if (string == null) {
            EntityPsi.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.cacheProvider.getDiscriminatorColumnName(this.getPsiClass());
    }

    @Override
    public Entity.DiscriminatorType getDiscriminatorType() {
        return this.cacheProvider.getDiscriminatorType(this.getPsiClass());
    }

    @Override
    public LinkedHashSet<AttributeOverride> getAttributeOverrides() {
        return this.cacheProvider.getAttributeOverrides(this.getPsiClass());
    }

    @Override
    public String getPrimaryKeyName() {
        return null;
    }

    @Override
    public String getPrimaryKeyJoinColumnName() {
        List<String> values = this.getPrimaryKeyJoinColumnNames();
        return values.isEmpty() ? null : values.get(0);
    }

    @Override
    public List<String> getPrimaryKeyJoinColumnNames() {
        return this.cacheProvider.getPrimaryKeyJoinColumnNames(this.getPsiClass());
    }

    @Override
    public String getPrimaryKeyReferencedColumnName() {
        return this.cacheProvider.getPrimaryKeyReferencedColumnName(this.getPsiClass());
    }

    @Override
    public String getPrimaryKeyColumnDefinition() {
        return this.cacheProvider.getPrimaryKeyColumnDefinition(this.getPsiClass());
    }

    @Override
    @NotNull
    public List<Index> getIndexes() {
        List<Index> list = this.cacheProvider.getIndexes(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public List<NamedQuery> getNamedQueries() {
        List<NamedQuery> list = this.cacheProvider.getNamedQueries(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<HibernateCustomTypeModel> getHibernateTypes() {
        List<HibernateCustomTypeModel> list = this.cacheProvider.getHibernateTypes(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public List<Index> getUniqueConstraints() {
        List<Index> list = this.cacheProvider.getUniqueConstraints(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<SimpleEnumPsiType> getNestedEnums() {
        List<SimpleEnumPsiType> list = Collections.emptyList();
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean isEmbeddable() {
        return this.cacheProvider.isEmbeddable(this.getPsiClass());
    }

    @Override
    @NotNull
    public List<Method> getMethods() {
        List<Method> list = this.cacheProvider.getMethods(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(9);
        }
        return list;
    }

    public List<MethodPsi> getAllMethodsPsi() {
        return this.cacheProvider.getAllMethodsPsi(this.getPsiClass());
    }

    @Override
    @Nullable
    public String getParentFqn() {
        return this.cacheProvider.getParentFqn(this.getPsiClass());
    }

    @Override
    public String getFqn() {
        if (this.isValid()) {
            return (String)EntityUtil.ra(() -> this.getPsiClass().getQualifiedName());
        }
        return "error.NonExistentClass";
    }

    @Override
    @Nullable
    public EntityPsi getParent() {
        return this.isValid() ? this.cacheProvider.getParent(this.getPsiClass()) : null;
    }

    @Override
    public String getPackageName() {
        if (this.isValid()) {
            return (String)EntityUtil.ra(() -> {
                String qualifiedName = this.getPsiClass().getQualifiedName();
                return ClassUtil.extractPackageName((String)qualifiedName);
            });
        }
        return "";
    }

    @Override
    public String getClassName() {
        if (this.isValid()) {
            return (String)EntityUtil.ra(() -> this.getPsiClass().getName());
        }
        return "error.NonExistentClass";
    }

    @Override
    public String getLabel() {
        return this.getClassName();
    }

    @Override
    @Nullable
    public String getName() {
        if (this.isValid()) {
            EntityUtil entityUtil = EntityUtil.getInstance(this.getPsiClass().getProject());
            return entityUtil.getEntityNameFromAnnotation(this.getPsiClass());
        }
        return "";
    }

    @Override
    @Nullable
    public String getCatalog() {
        return this.cacheProvider.getCatalog(this.getPsiClass());
    }

    @Override
    @Nullable
    public String getSchema() {
        return this.cacheProvider.getSchema(this.getPsiClass());
    }

    @Override
    public String getTable() {
        return this.cacheProvider.getTable(this.getPsiClass());
    }

    @Override
    @Nullable
    public String getComment() {
        return EntityUtil.getComment((PsiModifierListOwner)this.getPsiClass());
    }

    @Override
    public String getDiscriminator() {
        return this.cacheProvider.getDiscriminator(this.getPsiClass());
    }

    @Override
    public String getIdClassFqn() {
        return this.cacheProvider.getIdClassFqn(this.getPsiClass());
    }

    @Override
    @Nullable
    public SequenceGenerator getSequenceGenerator() {
        return this.cacheProvider.getSequenceGenerator(this.getPsiClass());
    }

    @Override
    @Nullable
    public GenericGenerator getGenericGenerator() {
        return EntityUtil.getGenericGenerator((PsiModifierListOwner)this.getPsiClass());
    }

    @Override
    public boolean isAbstractClass() {
        return (Boolean)EntityUtil.ra(() -> this.getPsiClass().hasModifierProperty("abstract"));
    }

    @Override
    @NotNull
    public List<EntityAttribute> getAttributes() {
        List<EntityAttribute> list = this.cacheProvider.getAttributes(this.getPsiClass());
        if (list == null) {
            EntityPsi.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public boolean isExtends(Entity root) {
        return (Boolean)EntityUtil.ra(() -> EntityUtil.isDeepInheritor(this.getPsiClass(), root.getFqn(), true));
    }

    @Override
    public boolean isAudited() {
        return (Boolean)EntityUtil.ra(() -> AnnotationUtil.findAnnotation((PsiModifierListOwner)this.getPsiClass(), (String[])new String[]{"org.hibernate.envers.Audited"}) != null);
    }

    @Override
    @Nullable
    public AuditTable getAuditTable() {
        return this.cacheProvider.getAuditTable(this.getPsiClass());
    }

    @Override
    public List<EntityListener> getEntityListeners() {
        return this.cacheProvider.getEntityListeners(this.getPsiClass());
    }

    @Override
    public SoftDeleteModel getSoftDelete() {
        PsiClass psiClass = this.getPsiClass();
        return (SoftDeleteModel)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            SoftDeleteModel result = SoftDeleteModel.Companion.instanceOf((PsiModifierListOwner)psiClass);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{psiClass.getNavigationElement()});
        });
    }

    @Override
    @NotNull
    public PsiClass getPsiClass() {
        PsiClass psiClass = (PsiClass)EntityUtil.ra(() -> this.psiClassPointer.getElement());
        if (psiClass == null) {
            throw new IllegalStateException("Entity PsiClass from SmartPsiElementPointer is null. The PsiClass reparse has completely invalidated the pointer (for example, the element referenced by the pointer has been deleted). This may be due to misuse of the cache.");
        }
        EntityPsiClassResolver classResolver = (EntityPsiClassResolver)EntityPsiClassResolver.Companion.getInstance((PsiElement)psiClass);
        if (classResolver != null) {
            PsiClass psiClass2 = classResolver.resolveClass(psiClass);
            if (psiClass2 == null) {
                EntityPsi.$$$reportNull$$$0(11);
            }
            return psiClass2;
        }
        PsiClass psiClass3 = psiClass;
        if (psiClass3 == null) {
            EntityPsi.$$$reportNull$$$0(12);
        }
        return psiClass3;
    }

    @Override
    public boolean isValid() {
        return EntityUtil.ra(() -> this.psiClassPointer.getElement()) != null;
    }

    public void replacePsiClass(PsiClass psiClass) {
        WriteCommandAction.writeCommandAction((Project)this.project).compute(() -> this.getPsiClass().replace((PsiElement)psiClass));
        this.psiClassPointer = (SmartPsiElementPointer)EntityUtil.ra(() -> SmartPointerManager.getInstance((Project)this.project).createSmartPsiElementPointer((PsiElement)psiClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/model/EntityPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/model/EntityPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiscriminatorLength";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedQueries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHibernateTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueConstraints";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedEnums";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

