/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class PsiNamedElementNodeDescriptor<T extends PsiNamedElement>
extends JavaeeNodeDescriptor<T> {
    private final T myElement;

    protected PsiNamedElementNodeDescriptor(T element, NodeDescriptor parentDescriptor, Object parameters) {
        super(element.getProject(), parentDescriptor, parameters, element);
        this.myElement = element;
    }

    public Color getNewColor() {
        PsiNamedElement element = (PsiNamedElement)this.getJamElement();
        if (CopyPasteManager.getInstance().isCutElement((Object)element)) {
            return CopyPasteManager.getCutColor();
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file == null ? null : FileStatusManager.getInstance((Project)this.myProject).getStatus(file).getColor();
    }

    public T updateElement() {
        return this.myElement;
    }

    public Icon getNewIcon() {
        int flags = 2;
        PsiElement element = (PsiElement)this.getJamElement();
        return element.getIcon(flags);
    }

    public String getNewNodeText() {
        return ((PsiNamedElement)this.getJamElement()).getName();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            PsiNamedElementNodeDescriptor.$$$reportNull$$$0(0);
        }
        super.uiDataSnapshot(sink);
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            PsiNamedElement element = (PsiNamedElement)this.getJamElement();
            return element != null && element.isValid() ? element : null;
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            PsiNamedElement element = (PsiNamedElement)this.getJamElement();
            if (!(element instanceof Navigatable)) return null;
            Navigatable o = (Navigatable)element;
            if (!element.isValid()) return null;
            Navigatable navigatable = o;
            return navigatable;
        });
    }

    public boolean isValid() {
        PsiNamedElement element = (PsiNamedElement)this.getJamElement();
        return element != null && element.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/javaee/module/view/nodes/PsiNamedElementNodeDescriptor", "uiDataSnapshot"));
    }
}

