/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.actions.DiagramActionWithPreparation;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uml.UmlIcons;
import com.intellij.uml.utils.DiagramBundle;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlAddNoteAction
extends DiagramActionWithPreparation<String> {
    public UmlAddNoteAction() {
        super(DiagramBundle.message("add.note.action.title", new Object[0]), "", UmlIcons.AddNote);
    }

    public UmlAddNoteAction(@Nls String name, @Nls String description, Icon icon) {
        super(name, description, icon);
    }

    @Override
    @Nullable
    @Nls
    public String prepare(@NotNull AnActionEvent e) {
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(0);
        }
        return Messages.showMultilineInputDialog((Project)e.getProject(), (String)DiagramBundle.message("dialog.message.note.text", new Object[0]), (String)DiagramBundle.message("dialog.title.add.a.note", new Object[0]), (String)"", (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
    }

    @Override
    public void execute(@NotNull DiagramBuilder builder, @Nls String description, AnActionEvent e) {
        if (builder == null) {
            UmlAddNoteAction.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)description)) {
            return;
        }
        DiagramDataModel<?> model = builder.getDataModel();
        DiagramNode<?> selectedNode = builder.getNodeObject(GraphSelectionService.getInstance().getSingleSelectedNode(builder.getGraph()));
        assert (selectedNode != null);
        DiagramNoteNode note = model.addNote(selectedNode, description);
        if (note != null) {
            builder.queryUpdate().withDataReload().withNodeSizeUpdate(note).run();
            Node noteNode = builder.getNode(note);
            NodeRealizer realizer = builder.getGraph().getRealizer(noteNode);
            NodeRealizer target = builder.getGraph().getRealizer(builder.getNode((DiagramNode<?>)note.getIdentifyingElement()));
            realizer.setCenterX(target.getCenterX());
            realizer.setY(target.getY() - realizer.getHeight() - 20.0);
            builder.queryUpdate().withDataReload().withPresentationUpdate().run();
            builder.notifyOtherBuilders();
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            UmlAddNoteAction.$$$reportNull$$$0(2);
        }
        if ((builder = UmlAddNoteAction.getBuilder(e)) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean isEnabled = Optional.ofNullable(GraphSelectionService.getInstance().getSingleSelectedNode(builder.getGraph())).map(builder::getNodeObject).filter(it -> !(it instanceof DiagramNoteNode) && !builder.getDataModel().getNotes().containsKey(it)).isPresent();
        e.getPresentation().setEnabled(isEnabled);
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            UmlAddNoteAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.name.add.note", new Object[0]);
        if (string == null) {
            UmlAddNoteAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/UmlAddNoteAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/UmlAddNoteAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

