/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.examples.server;

import com.intellij.httpClient.examples.server.GraphQLClientHttpHandler;
import com.intellij.httpClient.examples.server.GraphQLClientWebSocketHandler;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.examples.server.WebSocketClientHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/examples/server/HttpClientExamplesServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "handlers", "", "getHandlers", "()Ljava/util/List;", "handlers$delegate", "Lkotlin/Lazy;", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "isAccessible", "Lio/netty/handler/codec/http/HttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientExamplesServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,611:1\n1761#2,3:612\n295#2,2:615\n*S KotlinDebug\n*F\n+ 1 HttpClientExamplesServer.kt\ncom/intellij/httpClient/examples/server/HttpClientExamplesServer\n*L\n54#1:612,3\n66#1:615,2\n*E\n"})
public final class HttpClientExamplesServer
extends HttpRequestHandler {
    @NotNull
    private final Lazy handlers$delegate = LazyKt.lazy(HttpClientExamplesServer::handlers_delegate$lambda$0);

    private final List<HttpRequestHandler> getHandlers() {
        Lazy lazy = this.handlers$delegate;
        return (List)lazy.getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        HttpRequestHandler it;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/http-client/examples", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = this.getHandlers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (HttpRequestHandler)element$iv;
            boolean bl = false;
        } while (!it.isSupported(request));
        return true;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.isAccessible(request) && HttpClientExampleServerManager.Companion.getInstance().isRequestScheduled();
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Iterable $this$firstOrNull$iv = this.getHandlers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HttpRequestHandler it = (HttpRequestHandler)element$iv;
                boolean bl = false;
                if (!it.isSupported(request)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HttpRequestHandler httpRequestHandler = v0;
        if (httpRequestHandler == null) {
            return false;
        }
        HttpRequestHandler handler = httpRequestHandler;
        return handler.process(urlDecoder, request, context2);
    }

    private static final List handlers_delegate$lambda$0() {
        Object[] objectArray = new HttpRequestHandler[]{new WebSocketClientHandler(), new GraphQLClientWebSocketHandler(), new GraphQLClientHttpHandler()};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

