/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="YarnPnpDependencyTreeJsonFileManager", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bJ\"\u0010\r\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000b2\u000b\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002J\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeJsonFileManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeJsonFileManager$AllPathsState;", "<init>", "()V", "yarnPnpFileToDependencyTreeJsonMap", "", "", "store", "Ljava/nio/file/Path;", "pnpFilePath", "Lorg/jetbrains/annotations/NonNls;", "dependencyTreeJson", "writeNewFile", "getParentDir", "getState", "loadState", "", "state", "AllPathsState", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nYarnPnpDependencyTreeJsonFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpDependencyTreeJsonFileManager.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeJsonFileManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n13#2:81\n13#2:82\n1#3:83\n*S KotlinDebug\n*F\n+ 1 YarnPnpDependencyTreeJsonFileManager.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeJsonFileManager\n*L\n39#1:81\n43#1:82\n*E\n"})
public final class YarnPnpDependencyTreeJsonFileManager
implements PersistentStateComponent<AllPathsState> {
    @NotNull
    private final Map<String, String> yarnPnpFileToDependencyTreeJsonMap = new LinkedHashMap();

    @NotNull
    public final Path store(@NotNull String pnpFilePath, @NotNull String dependencyTreeJson) throws IOException {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)pnpFilePath, (String)"pnpFilePath");
        Intrinsics.checkNotNullParameter((Object)dependencyTreeJson, (String)"dependencyTreeJson");
        String string = this.yarnPnpFileToDependencyTreeJsonMap.get(pnpFilePath);
        if (string != null) {
            String it = string;
            boolean bl = false;
            path2 = Path.of(it, new String[0]);
        } else {
            path2 = null;
        }
        Path dependencyTreeJsonFilePath = path2;
        Path parentDir = this.getParentDir();
        if (dependencyTreeJsonFilePath != null && Intrinsics.areEqual((Object)dependencyTreeJsonFilePath.getParent(), (Object)parentDir)) {
            try {
                String content = Files.readString(dependencyTreeJsonFilePath);
                try {
                    if (!Intrinsics.areEqual((Object)content, (Object)dependencyTreeJson)) {
                        Files.writeString(dependencyTreeJsonFilePath, (CharSequence)dependencyTreeJson, new OpenOption[0]);
                    }
                    return dependencyTreeJsonFilePath;
                }
                catch (Exception e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(YarnPnpDependencyTreeJsonFileManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.info("Cannot write " + dependencyTreeJsonFilePath + " for " + pnpFilePath, (Throwable)e);
                }
            }
            catch (Exception exception) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(YarnPnpDependencyTreeJsonFileManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cannot read " + dependencyTreeJsonFilePath + ", pnpFile=" + pnpFilePath + " (exists: " + Files.isRegularFile(dependencyTreeJsonFilePath, new LinkOption[0]) + ")");
            }
        }
        return this.writeNewFile(pnpFilePath, dependencyTreeJson);
    }

    private final Path writeNewFile(String pnpFilePath, String dependencyTreeJson) {
        Path parentDir = this.getParentDir();
        Path path2 = Path.of(pnpFilePath, new String[0]).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        String pnpFileRootDirName = PathsKt.getName((Path)path2);
        File file = FileUtil.createTempFile((File)parentDir.toFile(), (String)(pnpFileRootDirName + "-dependency-tree"), null, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tmpFile = file;
        Path dependencyTreeJsonFilePath = tmpFile.toPath();
        Files.writeString(dependencyTreeJsonFilePath, (CharSequence)dependencyTreeJson, new OpenOption[0]);
        this.yarnPnpFileToDependencyTreeJsonMap.put(pnpFilePath, ((Object)dependencyTreeJsonFilePath).toString());
        Intrinsics.checkNotNull((Object)dependencyTreeJsonFilePath);
        return dependencyTreeJsonFilePath;
    }

    private final Path getParentDir() {
        Path path2 = Path.of(PathManager.getSystemPath(), new String[0]).resolve("javascript/yarn-pnp-dependency-tree");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @NotNull
    public AllPathsState getState() {
        Map map2;
        AllPathsState allPathsState;
        AllPathsState it = allPathsState = new AllPathsState();
        boolean bl = false;
        AllPathsState allPathsState2 = it;
        Map map3 = MapsKt.toMap(this.yarnPnpFileToDependencyTreeJsonMap);
        if (map3.isEmpty()) {
            AllPathsState allPathsState3 = allPathsState2;
            boolean bl2 = false;
            map2 = null;
            allPathsState2 = allPathsState3;
        } else {
            map2 = map3;
        }
        allPathsState2.setPnpFileToDependencyTreeMap(map2);
        return allPathsState;
    }

    public void loadState(@NotNull AllPathsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.yarnPnpFileToDependencyTreeJsonMap.clear();
        Map map2 = state.getPnpFileToDependencyTreeMap();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        this.yarnPnpFileToDependencyTreeJsonMap.putAll(map2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R,\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependencyTreeJsonFileManager$AllPathsState;", "", "<init>", "()V", "pnpFileToDependencyTreeMap", "", "", "getPnpFileToDependencyTreeMap", "()Ljava/util/Map;", "setPnpFileToDependencyTreeMap", "(Ljava/util/Map;)V", "intellij.javascript.backend"})
    public static final class AllPathsState {
        @Tag(value="pnp-file-to-dependency-tree-file-map")
        @MapAnnotation
        @Nullable
        private Map<String, String> pnpFileToDependencyTreeMap;

        @Nullable
        public final Map<String, String> getPnpFileToDependencyTreeMap() {
            return this.pnpFileToDependencyTreeMap;
        }

        public final void setPnpFileToDependencyTreeMap(@Nullable Map<String, String> map2) {
            this.pnpFileToDependencyTreeMap = map2;
        }
    }
}

