/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ESLintJsonProblemsParser {
    private static final Logger LOG = Logger.getInstance(ESLintJsonProblemsParser.class);
    private final JsonObject myObject;
    private final List<@InspectionMessage String> myFileLevelErrors;
    @NotNull
    private final List<EslintError> myErrors;
    public static final String UNKNOWN_SEVERITY = "Unknown message severity: %s\nbody:\n%s";

    private ESLintJsonProblemsParser(@NotNull JsonObject object) {
        if (object == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(0);
        }
        this.myObject = object;
        this.myFileLevelErrors = new SmartList();
        this.myErrors = new SmartList();
    }

    public static ESLintJsonProblemsParser parse(@NotNull JsonObject object) {
        if (object == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(1);
        }
        ESLintJsonProblemsParser parser2 = new ESLintJsonProblemsParser(object);
        parser2.parse();
        return parser2;
    }

    @Nullable
    @InspectionMessage
    public String getFileLevelError() {
        return this.myFileLevelErrors.isEmpty() ? null : this.myFileLevelErrors.stream().filter(it -> it != null).collect(Collectors.joining("\n"));
    }

    @NotNull
    public List<EslintError> getErrors() {
        List<EslintError> list = this.myErrors;
        if (list == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(2);
        }
        return list;
    }

    private void addFileLevelError(@NotNull @InspectionMessage String message) {
        if (message == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(3);
        }
        LOG.info(message);
        this.myFileLevelErrors.add(message);
    }

    private void parse() {
        String parseProblem = this.parseBody();
        if (parseProblem != null) {
            this.myFileLevelErrors.add(parseProblem);
        }
    }

    @Nullable
    @InspectionMessage
    private String parseBody() {
        JsonObject body = JsonUtil.getChildAsObject((JsonObject)this.myObject, (String)"body");
        JsonArray results = JsonUtil.getChildAsArray((JsonObject)body, (String)"results");
        if (results == null) {
            return JavaScriptBundle.message((String)"eslint.inspections.error.unexpected.language.service.response", (Object[])new Object[]{this.myObject.toString()});
        }
        if (results.isEmpty()) {
            return null;
        }
        JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)results.get(0), JsonObject.class);
        if (object == null) {
            return JavaScriptBundle.message((String)"eslint.inspections.error.unexpected.language.service.response", (Object[])new Object[]{this.myObject.toString()});
        }
        JsonElement messages = object.get("messages");
        if (messages == null) {
            return null;
        }
        JsonArray values = (JsonArray)ObjectUtils.tryCast((Object)messages, JsonArray.class);
        if (values == null) {
            return JavaScriptBundle.message((String)"eslint.inspections.error.messages.not.array", (Object[])new Object[]{messages.toString()});
        }
        if (values.isEmpty()) {
            return null;
        }
        Stream.Builder builder2 = Stream.builder();
        values.forEach(builder2);
        this.myErrors.addAll(builder2.build().map(message -> this.parseMessage((JsonElement)message)).filter(item -> item != null).toList());
        return null;
    }

    @Nullable
    private EslintError parseMessage(@NotNull JsonElement message) {
        JsonObject messageObject;
        if (message == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(4);
        }
        if ((messageObject = (JsonObject)ObjectUtils.tryCast((Object)message, JsonObject.class)) == null) {
            this.addFileLevelError(JavaScriptBundle.message((String)"eslint.inspections.error.can.not.parse.message", (Object[])new Object[]{message.toString()}));
            return null;
        }
        @NlsSafe String messageText = JsonUtil.getChildAsString((JsonObject)messageObject, (String)"message");
        if (messageText == null) {
            LOG.debug("Message without the text: " + message.toString());
            return null;
        }
        String ruleId = JsonUtil.getChildAsString((JsonObject)messageObject, (String)"ruleId");
        int line = JsonUtil.getChildAsInteger((JsonObject)messageObject, (String)"line", (int)0);
        int column = JsonUtil.getChildAsInteger((JsonObject)messageObject, (String)"column", (int)0);
        int endLine = JsonUtil.getChildAsInteger((JsonObject)messageObject, (String)"endLine", (int)-1);
        int endColumn = JsonUtil.getChildAsInteger((JsonObject)messageObject, (String)"endColumn", (int)-1);
        if (JsonUtil.getChildAsBoolean((JsonObject)messageObject, (String)"fatal", (boolean)false) && line <= 0 && column <= 0) {
            this.addFileLevelError(messageText);
            return null;
        }
        HighlightSeverity hs = this.readSeverity(messageObject);
        return hs == null ? null : new EslintError(line, column, endLine, endColumn, messageText, ruleId, hs, ESLintJsonProblemsParser.parseFixInfo(messageObject), ESLintJsonProblemsParser.parseSuggestions(messageObject));
    }

    @Nullable
    private static EslintError.FixInfo parseFixInfo(@Nullable JsonObject object) {
        @NlsSafe String description = JsonUtil.getChildAsString((JsonObject)object, (String)"desc");
        JsonObject fixObject = JsonUtil.getChildAsObject((JsonObject)object, (String)"fix");
        String text = JsonUtil.getChildAsString((JsonObject)fixObject, (String)"text");
        JsonArray range = JsonUtil.getChildAsArray((JsonObject)fixObject, (String)"range");
        if (text == null || range == null || range.size() != 2) {
            return null;
        }
        JsonElement first = range.get(0);
        JsonElement second = range.get(1);
        if (first instanceof JsonPrimitive && ((JsonPrimitive)first).isNumber() && second instanceof JsonPrimitive && ((JsonPrimitive)second).isNumber()) {
            return new EslintError.FixInfo(description, first.getAsInt(), second.getAsInt(), text);
        }
        return null;
    }

    @NotNull
    private static List<EslintError.FixInfo> parseSuggestions(@Nullable JsonObject object) {
        JsonArray suggestions = JsonUtil.getChildAsArray((JsonObject)object, (String)"suggestions");
        if (suggestions == null) {
            List<EslintError.FixInfo> list = Collections.emptyList();
            if (list == null) {
                ESLintJsonProblemsParser.$$$reportNull$$$0(5);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        suggestions.forEach(arg_0 -> ESLintJsonProblemsParser.lambda$parseSuggestions$3((List)result2, arg_0));
        SmartList smartList = result2;
        if (smartList == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Nullable
    private HighlightSeverity readSeverity(@NotNull JsonObject message) {
        if (message == null) {
            ESLintJsonProblemsParser.$$$reportNull$$$0(7);
        }
        HighlightSeverity hs = null;
        JsonElement severityP = message.get("severity");
        if (severityP.isJsonPrimitive() && severityP.getAsJsonPrimitive().isNumber()) {
            int intV = severityP.getAsJsonPrimitive().getAsInt();
            if (intV == 0) {
                return null;
            }
            if (intV == 1) {
                hs = HighlightSeverity.WARNING;
            } else if (intV == 2) {
                hs = HighlightSeverity.ERROR;
            } else {
                this.addFileLevelError(JavaScriptBundle.message((String)"eslint.inspections.error.unknown.message.severity", (Object[])new Object[]{intV, message.toString()}));
            }
        } else if (severityP.isJsonPrimitive() && severityP.getAsJsonPrimitive().isString()) {
            String stringSeverity = StringUtil.unquoteString((String)severityP.getAsJsonPrimitive().getAsString());
            if ("error".equals(stringSeverity)) {
                hs = HighlightSeverity.ERROR;
            } else if ("warning".equals(stringSeverity)) {
                hs = HighlightSeverity.WARNING;
            } else {
                this.addFileLevelError(JavaScriptBundle.message((String)"eslint.inspections.error.unknown.message.severity", (Object[])new Object[]{stringSeverity, message.toString()}));
            }
        } else {
            this.addFileLevelError(JavaScriptBundle.message((String)"eslint.inspections.error.unknown.message.severity", (Object[])new Object[]{severityP.toString(), message.toString()}));
        }
        return hs;
    }

    private static /* synthetic */ void lambda$parseSuggestions$3(List result2, JsonElement elt) {
        ContainerUtil.addIfNotNull((Collection)result2, elt instanceof JsonObject ? ESLintJsonProblemsParser.parseFixInfo((JsonObject)elt) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/ESLintJsonProblemsParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSuggestions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readSeverity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

