/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 41693851503089L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1690934070 + (char)-4972, -1690934070 + -((char)-3352), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1690934070 + (char)-4971, 1690934070 + (char)-5424, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 70274168626426L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.h();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(86244060 + 22503, 86244060 + 20314, (int)l2) + string + WindowsNamedPipeAgentIpc.b(86244060 + 22502, 86244060 + 20384, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(86244060 + 22505, 86244060 + 31951, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 27949050517536L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.h();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12516), -1698273990 + -((char)-24782), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12515), 1698273990 + 28379, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12514), 1698273990 + (char)-8019, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12505), -1698273990 + -((char)-30808), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12504), 1698273990 + (char)-27713, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12503), -1698273990 + -27900, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12505), -1698273990 + -((char)-30808), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1698273990 + -((char)-12502), 1698273990 + (char)-12871, (int)l2));
            if (ActionTimestamp.h() == null) {
                SshAgentIpcService.h(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 135691016749531L;
                    actionTimestampArray = SshAgentIpcService.h();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 77385980108857L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.h();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(740676570 - (char)-23092, -740676570 - -((char)-12329), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23093, -740676570 - -((char)-27996), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23090, -740676570 - -((char)-12620), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(740676570 - (char)-23092, -740676570 - -((char)-12329), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23091, 740676570 - 25874, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(740676570 - (char)-23092, -740676570 - -((char)-12329), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23096, 740676570 - (char)-25816, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23097, 740676570 - 32035, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23090, -740676570 - -((char)-12620), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(740676570 - (char)-23092, -740676570 - -((char)-12329), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(740676570 - (char)-23088, 740676570 - 28239, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(740676570 - (char)-23094, 740676570 - (char)-23547, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 91716695725509L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1964083950 + 26426, 1964083950 + 4925, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 112524636302527L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(788123910 - 1459, 788123910 - 14756, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00dd\u00fd\u00f1Zq\u0098A@\u00b8\u00189$\u00b9\u0099\u000b\u00c5\u00fc\u0018\u00e5\u0014J\u00a1\u0003\u00d74\u00eb\u0094\u00ab\u0080c\u00fb\u009f#\u0017\u0099\u009fC\u0095\u0015\u00b3";
                        var4_3 = "\u00dd\u00fd\u00f1Zq\u0098A@\u00b8\u00189$\u00b9\u0099\u000b\u00c5\u00fc\u0018\u00e5\u0014J\u00a1\u0003\u00d74\u00eb\u0094\u00ab\u0080c\u00fb\u009f#\u0017\u0099\u009fC\u0095\u0015\u00b3".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 63;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 34;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 2;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 48;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 32;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 29;
                                        break;
                                    }
                                    default: {
                                        v11 = 101;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x67ED) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 184;
                            case 1 -> 85;
                            case 2 -> 11;
                            case 3 -> 95;
                            case 4 -> 58;
                            case 5 -> 166;
                            case 6 -> 2;
                            case 7 -> 15;
                            case 8 -> 212;
                            case 9 -> 176;
                            case 10 -> 119;
                            case 11 -> 72;
                            case 12 -> 97;
                            case 13 -> 94;
                            case 14 -> 90;
                            case 15 -> 30;
                            case 16 -> 65;
                            case 17 -> 247;
                            case 18 -> 60;
                            case 19 -> 222;
                            case 20 -> 250;
                            case 21 -> 102;
                            case 22 -> 18;
                            case 23 -> 93;
                            case 24 -> 208;
                            case 25 -> 225;
                            case 26 -> 125;
                            case 27 -> 91;
                            case 28 -> 132;
                            case 29 -> 96;
                            case 30 -> 169;
                            case 31 -> 6;
                            case 32 -> 240;
                            case 33 -> 108;
                            case 34 -> 198;
                            case 35 -> 45;
                            case 36 -> 210;
                            case 37 -> 43;
                            case 38 -> 88;
                            case 39 -> 35;
                            case 40 -> 133;
                            case 41 -> 216;
                            case 42 -> 217;
                            case 43 -> 12;
                            case 44 -> 78;
                            case 45 -> 202;
                            case 46 -> 245;
                            case 47 -> 123;
                            case 48 -> 124;
                            case 49 -> 213;
                            case 50 -> 112;
                            case 51 -> 101;
                            case 52 -> 197;
                            case 53 -> 134;
                            case 54 -> 149;
                            case 55 -> 251;
                            case 56 -> 76;
                            case 57 -> 140;
                            case 58 -> 26;
                            case 59 -> 74;
                            case 60 -> 129;
                            case 61 -> 207;
                            case 62 -> 142;
                            case 63 -> 220;
                            case 64 -> 228;
                            case 65 -> 104;
                            case 66 -> 173;
                            case 67 -> 113;
                            case 68 -> 81;
                            case 69 -> 36;
                            case 70 -> 147;
                            case 71 -> 236;
                            case 72 -> 178;
                            case 73 -> 232;
                            case 74 -> 89;
                            case 75 -> 87;
                            case 76 -> 218;
                            case 77 -> 199;
                            case 78 -> 161;
                            case 79 -> 37;
                            case 80 -> 21;
                            case 81 -> 4;
                            case 82 -> 195;
                            case 83 -> 234;
                            case 84 -> 175;
                            case 85 -> 82;
                            case 86 -> 214;
                            case 87 -> 164;
                            case 88 -> 33;
                            case 89 -> 24;
                            case 90 -> 100;
                            case 91 -> 103;
                            case 92 -> 205;
                            case 93 -> 121;
                            case 94 -> 42;
                            case 95 -> 57;
                            case 96 -> 165;
                            case 97 -> 49;
                            case 98 -> 155;
                            case 99 -> 105;
                            case 100 -> 135;
                            case 101 -> 120;
                            case 102 -> 13;
                            case 103 -> 235;
                            case 104 -> 150;
                            case 105 -> 143;
                            case 106 -> 130;
                            case 107 -> 154;
                            case 108 -> 29;
                            case 109 -> 181;
                            case 110 -> 22;
                            case 111 -> 209;
                            case 112 -> 253;
                            case 113 -> 118;
                            case 114 -> 69;
                            case 115 -> 40;
                            case 116 -> 79;
                            case 117 -> 46;
                            case 118 -> 189;
                            case 119 -> 159;
                            case 120 -> 8;
                            case 121 -> 68;
                            case 122 -> 98;
                            case 123 -> 17;
                            case 124 -> 117;
                            case 125 -> 179;
                            case 126 -> 56;
                            case 127 -> 1;
                            case 128 -> 156;
                            case 129 -> 3;
                            case 130 -> 185;
                            case 131 -> 77;
                            case 132 -> 19;
                            case 133 -> 248;
                            case 134 -> 193;
                            case 135 -> 239;
                            case 136 -> 7;
                            case 137 -> 182;
                            case 138 -> 131;
                            case 139 -> 44;
                            case 140 -> 190;
                            case 141 -> 163;
                            case 142 -> 62;
                            case 143 -> 47;
                            case 144 -> 186;
                            case 145 -> 223;
                            case 146 -> 10;
                            case 147 -> 194;
                            case 148 -> 183;
                            case 149 -> 180;
                            case 150 -> 107;
                            case 151 -> 206;
                            case 152 -> 106;
                            case 153 -> 86;
                            case 154 -> 171;
                            case 155 -> 80;
                            case 156 -> 158;
                            case 157 -> 148;
                            case 158 -> 127;
                            case 159 -> 84;
                            case 160 -> 174;
                            case 161 -> 31;
                            case 162 -> 146;
                            case 163 -> 219;
                            case 164 -> 246;
                            case 165 -> 27;
                            case 166 -> 41;
                            case 167 -> 255;
                            case 168 -> 233;
                            case 169 -> 92;
                            case 170 -> 252;
                            case 171 -> 249;
                            case 172 -> 141;
                            case 173 -> 200;
                            case 174 -> 188;
                            case 175 -> 211;
                            case 176 -> 28;
                            case 177 -> 226;
                            case 178 -> 114;
                            case 179 -> 32;
                            case 180 -> 224;
                            case 181 -> 229;
                            case 182 -> 111;
                            case 183 -> 0;
                            case 184 -> 151;
                            case 185 -> 128;
                            case 186 -> 192;
                            case 187 -> 73;
                            case 188 -> 23;
                            case 189 -> 162;
                            case 190 -> 39;
                            case 191 -> 116;
                            case 192 -> 64;
                            case 193 -> 38;
                            case 194 -> 238;
                            case 195 -> 237;
                            case 196 -> 254;
                            case 197 -> 242;
                            case 198 -> 167;
                            case 199 -> 99;
                            case 200 -> 160;
                            case 201 -> 59;
                            case 202 -> 136;
                            case 203 -> 9;
                            case 204 -> 50;
                            case 205 -> 172;
                            case 206 -> 83;
                            case 207 -> 230;
                            case 208 -> 243;
                            case 209 -> 75;
                            case 210 -> 14;
                            case 211 -> 109;
                            case 212 -> 16;
                            case 213 -> 187;
                            case 214 -> 53;
                            case 215 -> 126;
                            case 216 -> 177;
                            case 217 -> 201;
                            case 218 -> 203;
                            case 219 -> 61;
                            case 220 -> 115;
                            case 221 -> 244;
                            case 222 -> 170;
                            case 223 -> 144;
                            case 224 -> 196;
                            case 225 -> 231;
                            case 226 -> 20;
                            case 227 -> 63;
                            case 228 -> 215;
                            case 229 -> 138;
                            case 230 -> 34;
                            case 231 -> 66;
                            case 232 -> 139;
                            case 233 -> 168;
                            case 234 -> 110;
                            case 235 -> 25;
                            case 236 -> 55;
                            case 237 -> 67;
                            case 238 -> 153;
                            case 239 -> 137;
                            case 240 -> 48;
                            case 241 -> 145;
                            case 242 -> 157;
                            case 243 -> 70;
                            case 244 -> 54;
                            case 245 -> 221;
                            case 246 -> 5;
                            case 247 -> 241;
                            case 248 -> 227;
                            case 249 -> 204;
                            case 250 -> 122;
                            case 251 -> 52;
                            case 252 -> 152;
                            case 253 -> 191;
                            case 254 -> 71;
                            default -> 51;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray == null) {
                ActionTimestamp.h(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 101347799634746L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.h();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(543678360 - (char)-32117, -543678360 - -26774, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(543678360 - (char)-32113, 543678360 - (char)-14064, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(543678360 - (char)-32122, -543678360 - -31278, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(543678360 - (char)-32117, -543678360 - -26774, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(543678360 - (char)-32113, 543678360 - (char)-14064, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(543678360 - (char)-32125, 543678360 - (char)-22156, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 139592571664015L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.h();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1839567450 - -2811, -1839567450 + -27565, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1839567450 - -2812, -1839567450 - -2713, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 121300744200413L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.h();
                this.assertConnectionThread();
                Object object2 = this.lock;
                actionTimestampArray = actionTimestampArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2017167300 - 22746, -2017167300 - -((char)-32035), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2017167300 - 22742, 2017167300 - 8789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2017167300 - 22739, -2017167300 - -18297, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2017167300 - 22742, 2017167300 - 8789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2017167300 - 22748, -2017167300 - -((char)-32254), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2017167300 - 22746, -2017167300 - -((char)-32035), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2017167300 - 22742, 2017167300 - 8789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2017167300 - 22726, -2017167300 - -7370, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2017167300 - 22746, -2017167300 - -((char)-32035), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2017167300 - 22742, 2017167300 - 8789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2017167300 - 22725, -2017167300 - -18663, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2017167300 - 22746, -2017167300 - -((char)-32035), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2017167300 - 22742, 2017167300 - 8789, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2017167300 - 22728, -2017167300 - -11296, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 81306791292330L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.h();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21197, -1234548330 + -((char)-27864), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21201, 1234548330 + 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21216, -1234548330 + -((char)-20046), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21213, 1234548330 + (char)-23256, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21197, -1234548330 + -((char)-27864), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21201, 1234548330 + 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21214, 1234548330 + (char)-21426, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21197, -1234548330 + -((char)-27864), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21201, 1234548330 + 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21211, -1234548330 + -20476, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21197, -1234548330 + -((char)-27864), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21201, 1234548330 + 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21212, -1234548330 + -((char)-31711), (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21197, -1234548330 + -((char)-27864), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21201, 1234548330 + 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21177, 1234548330 + (char)-21172, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1234548330 + (char)-21178, 1234548330 + 22563, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "6\u00ef\u00d9\u00e1\u00a9q~c\u0014\u009e\u008a\u00f4\u00aa\u00f2\u0090\u00baE\u0085L\u0082\u0018~\u00ef=\u0010C\u00ef\u00e8\u0098\u0006\u00f4\u00cc\u0081\u0085\u00c8\u00bc\u0018;\u00e7 7\u00ea\u00e6\u00bbKm\u00f0\u0090\u00ffZ\u00ec\u00eb\u00f20\u00da\u00a8\u00a3\u00cdvq+\t\u00bd`nvHQ\u00f7\u00f5\u00d8\u0005\u00edQ\u00a26\u00b6\b\r\u00dc\u00be\u00f6\u0017\u00b5\u00af\u0019\u0014\u00d2\u00e8\u0005}\u00a1b\u00e5\u008c\u0000\u00a8\u00990WI\u00a3)\u0082\u001b)D\u0005`w\u0013\u00f2\u0080\u001e\u00cc\u0082\u0093(\r\u00c1\u00e5\u00d5\u00037\u0016\u0080\u00c6#\u00dao\u00f7\u00f8\u0082\u0013$O@\u00c1m\f\u00d7\u00b7\u00dc\u001f\u0010\u008c3\u007f\u00db\u00c7\u008dJ\u00a5\u008b\u008b\u008a\u00eaS;\u00c7\u00f3\t8\u00ce\b\u00b2\u00d7\u00ee\"\u009d\u008c\u0010\u00aaL\u00bb4_pY\u001a\u00e9|\u00c6\u0014\u00da\u00e4\u00f6\b?-\u009b\u00a7\u000b\u0086\u00ac\u0011\u0014\u00ec\u00de\u00aeFn\r\u00f2\u00937\u0002\u00e7\u0089\u0006N\u007f\u0087\u009a,$\u0007\u0095_$\u0080\u009a\u00aa~]\u000bQ/\u00b5\u008fxS\u001c\u001a\u009d3\u0081\u00a1\u00c3%G\u00f3+&Pv\u00c4\u008f\u00d9\u00c3\u00f6\u00da\b\u0019s<\u0003G\u000b\u00a5\u00ce\fc?c\u0091\u00b1;\u0095\u00cfY\u008e\u0082NF!M+\u00df\u00b8\u00f2\u00b4\u00f6}\u00a5\f\u00ef\u00ac0\u00b5\u0012#Ue\u00ccD\u00b44\u00ea\u00c5\u00aa<\u00dc)\r\u0089\u00f6\u0013\u00d2\u008ds\u00af\u00d9\u0010`\u00fb\u00d7V\u0012d\u00d9\u00a8t5\u0085\u00d1%\u0082\u00f1\u001e\u0010\u00ee\u00b8\n\u00ea@\u00f9\u00f6\u00bd\u00a0\u0002\u00b0}\u00d9\u00eb\u001fEL\u00a2\u00f1+\u00fa!\u00b2\u009b\u00db\u0005\u001d\u00a4\u008d\u009d\u000bd\u009c\u008dU\u000e\u0007\u00d2c^\u0088\u00a6\u00eb\u00efeS\u000b`d\u0003\u00fa\u00bdV\u0014bi7\u008e\u0015m\u00e9\u00a2H\u008eh\u009e\u00d8\u0006\u0080\u00ab\u00bd\u00cf5\u00edJ\u0091 \u00ee\u00bbT)'\u0089\u00eeI\u00a2\u00ed\u0010P\u00bd\u0087\u00c1\u00968\u00f6\u0090a\u009aY\u0089J~\u009c\u001a\b(\u00ac\u00bf\u0017\u00e3\u000eP\u00a8\u00d6\u00bcS3j\u00cc#k>\u0007\u00d8\u00a2\u001b68_\u00d8\u0007XAo&Q\u00b2\u00e3(~\u0015\u0089\u00fb\u00fe\u00d1m\u00f0bD\u0010\u00d8!\u00be\u00f1\u00eb\u00b1\u00a5B\u0096f9vw5\u00ff\u00aa\u0006vL9\u00f9\u0000\u00fd\u0017\u00b6X\u0001\u00f6!\u000fG\u00dc\u00e0\u00eb;\u00bfp\u00fe\u00b4\bk\u0000\u00ee\u00f1\u0096\"\u0087\u0085\u00fa\u00c8 \u00dd@V\u00b7G\u0080\u008e\u0013\u00f9\u0091NQ\u0095z\u0091\u00ea\u00e7(7\u00fd\u001f\u00c8\u00bf))\u00abK\u00873\u000e<\u00c0\u008fh\u00d6\u00cf\u00cd\u00f0\u0003\u00c9\u009d8<\u00fc\u001b\u0084\u00b1\u009fC/\u001fg\u00b6\u0001\u0086P\u00d0\u00d5\u00d7o\u009d&E)\u0017\u00bb\u0003q\r\u009d5\u0091\n\u0084\r[\u00d3\u00a3\u00e9%B\u00e2z\u0018\u00ce\u00a8\u00d6m\u0007fC\u00c7\u009ba\u00c1\u00b3^\u00e8\u00e2[\u00e0\u009c&U\"\u0000\u0019>)\u00c1\u00c42\u00e09\u00d8c\u00f6\u00d3S\f\f\u0085\u00ac\u00b8Q\u00e1*9\u00e1R\u00f9\u00d6\u00a8\u00c4*\u00bf+\u00b0\u00d5\u0081B\u00c9?e\u00d7rt |^\t\u000b\u0093n\u0007\u0011\u0097\u00ac\u00e9\u00e0";
                var4_3 = "6\u00ef\u00d9\u00e1\u00a9q~c\u0014\u009e\u008a\u00f4\u00aa\u00f2\u0090\u00baE\u0085L\u0082\u0018~\u00ef=\u0010C\u00ef\u00e8\u0098\u0006\u00f4\u00cc\u0081\u0085\u00c8\u00bc\u0018;\u00e7 7\u00ea\u00e6\u00bbKm\u00f0\u0090\u00ffZ\u00ec\u00eb\u00f20\u00da\u00a8\u00a3\u00cdvq+\t\u00bd`nvHQ\u00f7\u00f5\u00d8\u0005\u00edQ\u00a26\u00b6\b\r\u00dc\u00be\u00f6\u0017\u00b5\u00af\u0019\u0014\u00d2\u00e8\u0005}\u00a1b\u00e5\u008c\u0000\u00a8\u00990WI\u00a3)\u0082\u001b)D\u0005`w\u0013\u00f2\u0080\u001e\u00cc\u0082\u0093(\r\u00c1\u00e5\u00d5\u00037\u0016\u0080\u00c6#\u00dao\u00f7\u00f8\u0082\u0013$O@\u00c1m\f\u00d7\u00b7\u00dc\u001f\u0010\u008c3\u007f\u00db\u00c7\u008dJ\u00a5\u008b\u008b\u008a\u00eaS;\u00c7\u00f3\t8\u00ce\b\u00b2\u00d7\u00ee\"\u009d\u008c\u0010\u00aaL\u00bb4_pY\u001a\u00e9|\u00c6\u0014\u00da\u00e4\u00f6\b?-\u009b\u00a7\u000b\u0086\u00ac\u0011\u0014\u00ec\u00de\u00aeFn\r\u00f2\u00937\u0002\u00e7\u0089\u0006N\u007f\u0087\u009a,$\u0007\u0095_$\u0080\u009a\u00aa~]\u000bQ/\u00b5\u008fxS\u001c\u001a\u009d3\u0081\u00a1\u00c3%G\u00f3+&Pv\u00c4\u008f\u00d9\u00c3\u00f6\u00da\b\u0019s<\u0003G\u000b\u00a5\u00ce\fc?c\u0091\u00b1;\u0095\u00cfY\u008e\u0082NF!M+\u00df\u00b8\u00f2\u00b4\u00f6}\u00a5\f\u00ef\u00ac0\u00b5\u0012#Ue\u00ccD\u00b44\u00ea\u00c5\u00aa<\u00dc)\r\u0089\u00f6\u0013\u00d2\u008ds\u00af\u00d9\u0010`\u00fb\u00d7V\u0012d\u00d9\u00a8t5\u0085\u00d1%\u0082\u00f1\u001e\u0010\u00ee\u00b8\n\u00ea@\u00f9\u00f6\u00bd\u00a0\u0002\u00b0}\u00d9\u00eb\u001fEL\u00a2\u00f1+\u00fa!\u00b2\u009b\u00db\u0005\u001d\u00a4\u008d\u009d\u000bd\u009c\u008dU\u000e\u0007\u00d2c^\u0088\u00a6\u00eb\u00efeS\u000b`d\u0003\u00fa\u00bdV\u0014bi7\u008e\u0015m\u00e9\u00a2H\u008eh\u009e\u00d8\u0006\u0080\u00ab\u00bd\u00cf5\u00edJ\u0091 \u00ee\u00bbT)'\u0089\u00eeI\u00a2\u00ed\u0010P\u00bd\u0087\u00c1\u00968\u00f6\u0090a\u009aY\u0089J~\u009c\u001a\b(\u00ac\u00bf\u0017\u00e3\u000eP\u00a8\u00d6\u00bcS3j\u00cc#k>\u0007\u00d8\u00a2\u001b68_\u00d8\u0007XAo&Q\u00b2\u00e3(~\u0015\u0089\u00fb\u00fe\u00d1m\u00f0bD\u0010\u00d8!\u00be\u00f1\u00eb\u00b1\u00a5B\u0096f9vw5\u00ff\u00aa\u0006vL9\u00f9\u0000\u00fd\u0017\u00b6X\u0001\u00f6!\u000fG\u00dc\u00e0\u00eb;\u00bfp\u00fe\u00b4\bk\u0000\u00ee\u00f1\u0096\"\u0087\u0085\u00fa\u00c8 \u00dd@V\u00b7G\u0080\u008e\u0013\u00f9\u0091NQ\u0095z\u0091\u00ea\u00e7(7\u00fd\u001f\u00c8\u00bf))\u00abK\u00873\u000e<\u00c0\u008fh\u00d6\u00cf\u00cd\u00f0\u0003\u00c9\u009d8<\u00fc\u001b\u0084\u00b1\u009fC/\u001fg\u00b6\u0001\u0086P\u00d0\u00d5\u00d7o\u009d&E)\u0017\u00bb\u0003q\r\u009d5\u0091\n\u0084\r[\u00d3\u00a3\u00e9%B\u00e2z\u0018\u00ce\u00a8\u00d6m\u0007fC\u00c7\u009ba\u00c1\u00b3^\u00e8\u00e2[\u00e0\u009c&U\"\u0000\u0019>)\u00c1\u00c42\u00e09\u00d8c\u00f6\u00d3S\f\f\u0085\u00ac\u00b8Q\u00e1*9\u00e1R\u00f9\u00d6\u00a8\u00c4*\u00bf+\u00b0\u00d5\u0081B\u00c9?e\u00d7rt |^\t\u000b\u0093n\u0007\u0011\u0097\u00ac\u00e9\u00e0".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 67;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f8k\u00f7\u00f7c\u00d8\u00ca\u0014\u0004\u00ed\u00149d\u00e8f;\u00d8\u0089\u00ac\u00f3Wfgg\u00bb-#lQ\u0014D\u0004M\u0099'\u0014\u00e27l\u00e0]og\u00e3\u00fcs\u0099aQ\u00ab";
                    var4_3 = "\u00f8k\u00f7\u00f7c\u00d8\u00ca\u0014\u0004\u00ed\u00149d\u00e8f;\u00d8\u0089\u00ac\u00f3Wfgg\u00bb-#lQ\u0014D\u0004M\u0099'\u0014\u00e27l\u00e0]og\u00e3\u00fcs\u0099aQ\u00ab".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 106;
                            break;
                        }
                        case 1: {
                            v15 = 81;
                            break;
                        }
                        case 2: {
                            v15 = 119;
                            break;
                        }
                        case 3: {
                            v15 = 60;
                            break;
                        }
                        case 4: {
                            v15 = 121;
                            break;
                        }
                        case 5: {
                            v15 = 73;
                            break;
                        }
                        default: {
                            v15 = 97;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFCE3B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 143;
                case 1 -> 17;
                case 2 -> 61;
                case 3 -> 67;
                case 4 -> 181;
                case 5 -> 140;
                case 6 -> 141;
                case 7 -> 133;
                case 8 -> 89;
                case 9 -> 148;
                case 10 -> 60;
                case 11 -> 81;
                case 12 -> 238;
                case 13 -> 214;
                case 14 -> 234;
                case 15 -> 203;
                case 16 -> 68;
                case 17 -> 52;
                case 18 -> 84;
                case 19 -> 69;
                case 20 -> 128;
                case 21 -> 82;
                case 22 -> 18;
                case 23 -> 185;
                case 24 -> 192;
                case 25 -> 191;
                case 26 -> 233;
                case 27 -> 90;
                case 28 -> 114;
                case 29 -> 45;
                case 30 -> 147;
                case 31 -> 164;
                case 32 -> 209;
                case 33 -> 190;
                case 34 -> 199;
                case 35 -> 239;
                case 36 -> 99;
                case 37 -> 108;
                case 38 -> 104;
                case 39 -> 42;
                case 40 -> 74;
                case 41 -> 228;
                case 42 -> 223;
                case 43 -> 227;
                case 44 -> 86;
                case 45 -> 0;
                case 46 -> 201;
                case 47 -> 242;
                case 48 -> 217;
                case 49 -> 213;
                case 50 -> 41;
                case 51 -> 210;
                case 52 -> 29;
                case 53 -> 35;
                case 54 -> 219;
                case 55 -> 137;
                case 56 -> 122;
                case 57 -> 39;
                case 58 -> 131;
                case 59 -> 180;
                case 60 -> 167;
                case 61 -> 173;
                case 62 -> 216;
                case 63 -> 117;
                case 64 -> 186;
                case 65 -> 23;
                case 66 -> 156;
                case 67 -> 118;
                case 68 -> 46;
                case 69 -> 21;
                case 70 -> 1;
                case 71 -> 27;
                case 72 -> 212;
                case 73 -> 121;
                case 74 -> 129;
                case 75 -> 37;
                case 76 -> 19;
                case 77 -> 132;
                case 78 -> 70;
                case 79 -> 166;
                case 80 -> 170;
                case 81 -> 188;
                case 82 -> 179;
                case 83 -> 111;
                case 84 -> 54;
                case 85 -> 142;
                case 86 -> 73;
                case 87 -> 241;
                case 88 -> 253;
                case 89 -> 204;
                case 90 -> 15;
                case 91 -> 237;
                case 92 -> 97;
                case 93 -> 62;
                case 94 -> 88;
                case 95 -> 87;
                case 96 -> 232;
                case 97 -> 195;
                case 98 -> 161;
                case 99 -> 236;
                case 100 -> 205;
                case 101 -> 138;
                case 102 -> 25;
                case 103 -> 235;
                case 104 -> 8;
                case 105 -> 152;
                case 106 -> 158;
                case 107 -> 146;
                case 108 -> 56;
                case 109 -> 36;
                case 110 -> 135;
                case 111 -> 26;
                case 112 -> 189;
                case 113 -> 174;
                case 114 -> 250;
                case 115 -> 130;
                case 116 -> 184;
                case 117 -> 22;
                case 118 -> 105;
                case 119 -> 194;
                case 120 -> 40;
                case 121 -> 248;
                case 122 -> 136;
                case 123 -> 125;
                case 124 -> 149;
                case 125 -> 177;
                case 126 -> 44;
                case 127 -> 107;
                case 128 -> 159;
                case 129 -> 102;
                case 130 -> 13;
                case 131 -> 224;
                case 132 -> 14;
                case 133 -> 24;
                case 134 -> 85;
                case 135 -> 91;
                case 136 -> 98;
                case 137 -> 243;
                case 138 -> 80;
                case 139 -> 38;
                case 140 -> 207;
                case 141 -> 251;
                case 142 -> 58;
                case 143 -> 176;
                case 144 -> 171;
                case 145 -> 30;
                case 146 -> 95;
                case 147 -> 144;
                case 148 -> 153;
                case 149 -> 50;
                case 150 -> 211;
                case 151 -> 175;
                case 152 -> 151;
                case 153 -> 72;
                case 154 -> 119;
                case 155 -> 16;
                case 156 -> 157;
                case 157 -> 150;
                case 158 -> 127;
                case 159 -> 218;
                case 160 -> 220;
                case 161 -> 226;
                case 162 -> 187;
                case 163 -> 165;
                case 164 -> 83;
                case 165 -> 92;
                case 166 -> 208;
                case 167 -> 178;
                case 168 -> 163;
                case 169 -> 103;
                case 170 -> 255;
                case 171 -> 206;
                case 172 -> 246;
                case 173 -> 183;
                case 174 -> 106;
                case 175 -> 47;
                case 176 -> 11;
                case 177 -> 20;
                case 178 -> 33;
                case 179 -> 200;
                case 180 -> 10;
                case 181 -> 110;
                case 182 -> 222;
                case 183 -> 249;
                case 184 -> 48;
                case 185 -> 231;
                case 186 -> 78;
                case 187 -> 240;
                case 188 -> 4;
                case 189 -> 221;
                case 190 -> 9;
                case 191 -> 76;
                case 192 -> 28;
                case 193 -> 172;
                case 194 -> 123;
                case 195 -> 49;
                case 196 -> 116;
                case 197 -> 126;
                case 198 -> 193;
                case 199 -> 96;
                case 200 -> 59;
                case 201 -> 3;
                case 202 -> 247;
                case 203 -> 65;
                case 204 -> 34;
                case 205 -> 225;
                case 206 -> 93;
                case 207 -> 196;
                case 208 -> 66;
                case 209 -> 43;
                case 210 -> 113;
                case 211 -> 229;
                case 212 -> 77;
                case 213 -> 168;
                case 214 -> 101;
                case 215 -> 5;
                case 216 -> 115;
                case 217 -> 252;
                case 218 -> 182;
                case 219 -> 215;
                case 220 -> 139;
                case 221 -> 31;
                case 222 -> 169;
                case 223 -> 244;
                case 224 -> 230;
                case 225 -> 154;
                case 226 -> 7;
                case 227 -> 32;
                case 228 -> 124;
                case 229 -> 198;
                case 230 -> 12;
                case 231 -> 53;
                case 232 -> 94;
                case 233 -> 112;
                case 234 -> 120;
                case 235 -> 162;
                case 236 -> 6;
                case 237 -> 100;
                case 238 -> 75;
                case 239 -> 134;
                case 240 -> 2;
                case 241 -> 245;
                case 242 -> 51;
                case 243 -> 160;
                case 244 -> 64;
                case 245 -> 254;
                case 246 -> 145;
                case 247 -> 79;
                case 248 -> 197;
                case 249 -> 71;
                case 250 -> 55;
                case 251 -> 155;
                case 252 -> 109;
                case 253 -> 202;
                case 254 -> 63;
                default -> 57;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 37290679679252L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1773639240 - -11953, 1773639240 - 11928, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 140726418589634L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.h();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1815188430 - -((char)-1396), -1815057360 + -((char)-1235), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1815188430 - -((char)-1397), 1815188430 - (char)-6356, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1815188430 - -((char)-1398), -1815188430 - -((char)-13699), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0085\u00f7\u00a3\u0099\u00fa\u00a2\u0092J\u0010\u00e4\u00d2~\u009c\u00fb\u00b9Kp$=\u0004 ^\u00e45\u0087";
                    var4_3 = "\u0085\u00f7\u00a3\u0099\u00fa\u00a2\u0092J\u0010\u00e4\u00d2~\u009c\u00fb\u00b9Kp$=\u0004 ^\u00e45\u0087".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 44;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "4;\u00b7\"*5\u00b52\u0090o\u001c\u00dc\u008dU\u00a9\u0000\u0005e\u00ab\u0084\u00ac#\u00cc\u008416dM2\u009d\u000b\u00fe\u00f7\u00d3\u000eX\u00a8~\u00c97\u00b4\u00de:%\u0014n\u00a6\u0088\u0090G\u0019D\u009f\u00d6$\u00ae+\u00e1.";
                        var4_3 = "4;\u00b7\"*5\u00b52\u0090o\u001c\u00dc\u008dU\u00a9\u0000\u0005e\u00ab\u0084\u00ac#\u00cc\u008416dM2\u009d\u000b\u00fe\u00f7\u00d3\u000eX\u00a8~\u00c97\u00b4\u00de:%\u0014n\u00a6\u0088\u0090G\u0019D\u009f\u00d6$\u00ae+\u00e1.".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 103;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 20;
                                break;
                            }
                            case 2: {
                                v15 = 18;
                                break;
                            }
                            case 3: {
                                v15 = 109;
                                break;
                            }
                            case 4: {
                                v15 = 75;
                                break;
                            }
                            case 5: {
                                v15 = 61;
                                break;
                            }
                            default: {
                                v15 = 35;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA17D) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 66;
                    case 1 -> 183;
                    case 2 -> 124;
                    case 3 -> 106;
                    case 4 -> 84;
                    case 5 -> 216;
                    case 6 -> 242;
                    case 7 -> 5;
                    case 8 -> 29;
                    case 9 -> 225;
                    case 10 -> 90;
                    case 11 -> 239;
                    case 12 -> 224;
                    case 13 -> 199;
                    case 14 -> 129;
                    case 15 -> 234;
                    case 16 -> 102;
                    case 17 -> 31;
                    case 18 -> 233;
                    case 19 -> 139;
                    case 20 -> 179;
                    case 21 -> 119;
                    case 22 -> 48;
                    case 23 -> 220;
                    case 24 -> 147;
                    case 25 -> 244;
                    case 26 -> 185;
                    case 27 -> 92;
                    case 28 -> 141;
                    case 29 -> 26;
                    case 30 -> 61;
                    case 31 -> 62;
                    case 32 -> 222;
                    case 33 -> 109;
                    case 34 -> 172;
                    case 35 -> 174;
                    case 36 -> 38;
                    case 37 -> 162;
                    case 38 -> 140;
                    case 39 -> 82;
                    case 40 -> 104;
                    case 41 -> 49;
                    case 42 -> 110;
                    case 43 -> 180;
                    case 44 -> 130;
                    case 45 -> 149;
                    case 46 -> 133;
                    case 47 -> 13;
                    case 48 -> 89;
                    case 49 -> 181;
                    case 50 -> 247;
                    case 51 -> 123;
                    case 52 -> 44;
                    case 53 -> 226;
                    case 54 -> 53;
                    case 55 -> 67;
                    case 56 -> 241;
                    case 57 -> 238;
                    case 58 -> 17;
                    case 59 -> 219;
                    case 60 -> 189;
                    case 61 -> 30;
                    case 62 -> 87;
                    case 63 -> 99;
                    case 64 -> 240;
                    case 65 -> 228;
                    case 66 -> 250;
                    case 67 -> 42;
                    case 68 -> 213;
                    case 69 -> 254;
                    case 70 -> 251;
                    case 71 -> 203;
                    case 72 -> 91;
                    case 73 -> 73;
                    case 74 -> 65;
                    case 75 -> 167;
                    case 76 -> 230;
                    case 77 -> 163;
                    case 78 -> 15;
                    case 79 -> 198;
                    case 80 -> 248;
                    case 81 -> 45;
                    case 82 -> 114;
                    case 83 -> 175;
                    case 84 -> 146;
                    case 85 -> 235;
                    case 86 -> 95;
                    case 87 -> 56;
                    case 88 -> 153;
                    case 89 -> 72;
                    case 90 -> 206;
                    case 91 -> 117;
                    case 92 -> 77;
                    case 93 -> 57;
                    case 94 -> 35;
                    case 95 -> 201;
                    case 96 -> 150;
                    case 97 -> 33;
                    case 98 -> 217;
                    case 99 -> 122;
                    case 100 -> 68;
                    case 101 -> 70;
                    case 102 -> 74;
                    case 103 -> 210;
                    case 104 -> 190;
                    case 105 -> 100;
                    case 106 -> 85;
                    case 107 -> 221;
                    case 108 -> 21;
                    case 109 -> 135;
                    case 110 -> 9;
                    case 111 -> 145;
                    case 112 -> 218;
                    case 113 -> 148;
                    case 114 -> 205;
                    case 115 -> 214;
                    case 116 -> 88;
                    case 117 -> 187;
                    case 118 -> 176;
                    case 119 -> 103;
                    case 120 -> 69;
                    case 121 -> 4;
                    case 122 -> 182;
                    case 123 -> 157;
                    case 124 -> 195;
                    case 125 -> 60;
                    case 126 -> 94;
                    case 127 -> 76;
                    case 128 -> 120;
                    case 129 -> 107;
                    case 130 -> 22;
                    case 131 -> 252;
                    case 132 -> 165;
                    case 133 -> 202;
                    case 134 -> 51;
                    case 135 -> 96;
                    case 136 -> 154;
                    case 137 -> 20;
                    case 138 -> 46;
                    case 139 -> 47;
                    case 140 -> 86;
                    case 141 -> 108;
                    case 142 -> 1;
                    case 143 -> 75;
                    case 144 -> 193;
                    case 145 -> 113;
                    case 146 -> 40;
                    case 147 -> 170;
                    case 148 -> 55;
                    case 149 -> 6;
                    case 150 -> 227;
                    case 151 -> 115;
                    case 152 -> 229;
                    case 153 -> 50;
                    case 154 -> 54;
                    case 155 -> 161;
                    case 156 -> 184;
                    case 157 -> 212;
                    case 158 -> 237;
                    case 159 -> 211;
                    case 160 -> 215;
                    case 161 -> 177;
                    case 162 -> 105;
                    case 163 -> 64;
                    case 164 -> 112;
                    case 165 -> 249;
                    case 166 -> 71;
                    case 167 -> 18;
                    case 168 -> 142;
                    case 169 -> 59;
                    case 170 -> 132;
                    case 171 -> 173;
                    case 172 -> 28;
                    case 173 -> 101;
                    case 174 -> 231;
                    case 175 -> 138;
                    case 176 -> 152;
                    case 177 -> 121;
                    case 178 -> 194;
                    case 179 -> 204;
                    case 180 -> 243;
                    case 181 -> 200;
                    case 182 -> 37;
                    case 183 -> 81;
                    case 184 -> 186;
                    case 185 -> 253;
                    case 186 -> 164;
                    case 187 -> 83;
                    case 188 -> 255;
                    case 189 -> 166;
                    case 190 -> 178;
                    case 191 -> 192;
                    case 192 -> 52;
                    case 193 -> 232;
                    case 194 -> 134;
                    case 195 -> 223;
                    case 196 -> 98;
                    case 197 -> 78;
                    case 198 -> 168;
                    case 199 -> 246;
                    case 200 -> 97;
                    case 201 -> 236;
                    case 202 -> 8;
                    case 203 -> 159;
                    case 204 -> 32;
                    case 205 -> 245;
                    case 206 -> 188;
                    case 207 -> 191;
                    case 208 -> 131;
                    case 209 -> 24;
                    case 210 -> 151;
                    case 211 -> 125;
                    case 212 -> 79;
                    case 213 -> 11;
                    case 214 -> 196;
                    case 215 -> 36;
                    case 216 -> 127;
                    case 217 -> 158;
                    case 218 -> 12;
                    case 219 -> 19;
                    case 220 -> 93;
                    case 221 -> 111;
                    case 222 -> 126;
                    case 223 -> 207;
                    case 224 -> 58;
                    case 225 -> 10;
                    case 226 -> 23;
                    case 227 -> 34;
                    case 228 -> 143;
                    case 229 -> 208;
                    case 230 -> 3;
                    case 231 -> 144;
                    case 232 -> 136;
                    case 233 -> 0;
                    case 234 -> 137;
                    case 235 -> 155;
                    case 236 -> 14;
                    case 237 -> 171;
                    case 238 -> 128;
                    case 239 -> 7;
                    case 240 -> 25;
                    case 241 -> 63;
                    case 242 -> 116;
                    case 243 -> 41;
                    case 244 -> 197;
                    case 245 -> 16;
                    case 246 -> 27;
                    case 247 -> 209;
                    case 248 -> 43;
                    case 249 -> 169;
                    case 250 -> 118;
                    case 251 -> 80;
                    case 252 -> 156;
                    case 253 -> 39;
                    case 254 -> 2;
                    default -> 160;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 82695205369399L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "v\u001b/\n/TV/\tq\u0011<\u0000b\u0016K3W";
                    var5_4 = "v\u001b/\n/TV/\tq\u0011<\u0000b\u0016K3W".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 15;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 18;
                                    break;
                                }
                                case 1: {
                                    v11 = 113;
                                    break;
                                }
                                case 2: {
                                    v11 = 82;
                                    break;
                                }
                                case 3: {
                                    v11 = 107;
                                    break;
                                }
                                case 4: {
                                    v11 = 69;
                                    break;
                                }
                                case 5: {
                                    v11 = 55;
                                    break;
                                }
                                default: {
                                    v11 = 106;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 119686159144144L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0012-4Z4k\u000e\u0004\u001438@\n\u0018,3@8i\u00162-:\t\u0018,3@8i\u0016>'\r\u001f*.M2d\f> )G3m";
                    var5_4 = "\u0012-4Z4k\u000e\u0004\u001438@\n\u0018,3@8i\u00162-:\t\u0018,3@8i\u0016>'\r\u001f*.M2d\f> )G3m".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 120;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Cti\u0006o?^\u0006Cti\u0006c5";
                        var5_4 = "Cti\u0006o?^\u0006Cti\u0006c5".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 35;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 35;
                                break;
                            }
                            case 1: {
                                v15 = 59;
                                break;
                            }
                            case 2: {
                                v15 = 37;
                                break;
                            }
                            case 3: {
                                v15 = 86;
                                break;
                            }
                            case 4: {
                                v15 = 37;
                                break;
                            }
                            case 5: {
                                v15 = 114;
                                break;
                            }
                            default: {
                                v15 = 26;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 57110823118962L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(643029420 - (char)-16973, -643029420 - -((char)-14923), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 3491862868765L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "B\u008a\u00b2\u000f\u00c7\u0003H\u0018G\u0005v\u00f5\u0012$0\rUv@\u001e\u008f\u0088\u0092\u00a9\u0081M\u00ae\u00ef\u0019\u0010\u0014\u00d0\u00af!M\u00fa\u00e1\u00da&\u00a7\u00b9\u00ff\u001dc\u009f \u0005\u00f5Rb\u00d0>3\u00a7a9\u00c1J\u00a21\u00c5A\u00b9\u00de\u00157o\u00f6\u00beZ\u00f3:\u000e\u00fc\u00ac2\u00c4\u001f\u00e4J\u0098\u00e7\u00f0G\u00e9[\u00b5X\u0005(\u00f19PHK\u00bcx\u0000\u000e|c\u008f\u00c8\u00db";
                    var4_3 = "B\u008a\u00b2\u000f\u00c7\u0003H\u0018G\u0005v\u00f5\u0012$0\rUv@\u001e\u008f\u0088\u0092\u00a9\u0081M\u00ae\u00ef\u0019\u0010\u0014\u00d0\u00af!M\u00fa\u00e1\u00da&\u00a7\u00b9\u00ff\u001dc\u009f \u0005\u00f5Rb\u00d0>3\u00a7a9\u00c1J\u00a21\u00c5A\u00b9\u00de\u00157o\u00f6\u00beZ\u00f3:\u000e\u00fc\u00ac2\u00c4\u001f\u00e4J\u0098\u00e7\u00f0G\u00e9[\u00b5X\u0005(\u00f19PHK\u00bcx\u0000\u000e|c\u008f\u00c8\u00db".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 65;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0010@&:u\u0090\u00ef\u009e\u00ee&\u00a9\u00c6\u0016M\u00f7\u00ecL\u00ac\u0003F\u0098S\fEc2\n\u009e\u00fa\u00feDy\u00b4\u00a7js\u00c2\u00b4X\u0018\u00f1p\u00a0\u008b\u00df,X\u00d8\u009a\u00b1<}!\u00b7\u00a2\u00f9Uo\u001f\u009e\u0086X\u0006\u00b5SM\u00f3b:\u00bb\u00c4\u00f1\u00ac\u0010^F<W\u0013\u0013\r\u00b8\u00de\u00c6\u001e\u009f#\u0003\u0088\u0007\u00d2jB";
                        var4_3 = "\u0010@&:u\u0090\u00ef\u009e\u00ee&\u00a9\u00c6\u0016M\u00f7\u00ecL\u00ac\u0003F\u0098S\fEc2\n\u009e\u00fa\u00feDy\u00b4\u00a7js\u00c2\u00b4X\u0018\u00f1p\u00a0\u008b\u00df,X\u00d8\u009a\u00b1<}!\u00b7\u00a2\u00f9Uo\u001f\u009e\u0086X\u0006\u00b5SM\u00f3b:\u00bb\u00c4\u00f1\u00ac\u0010^F<W\u0013\u0013\r\u00b8\u00de\u00c6\u001e\u009f#\u0003\u0088\u0007\u00d2jB".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 73;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 93;
                                break;
                            }
                            case 1: {
                                v15 = 36;
                                break;
                            }
                            case 2: {
                                v15 = 16;
                                break;
                            }
                            case 3: {
                                v15 = 86;
                                break;
                            }
                            case 4: {
                                v15 = 71;
                                break;
                            }
                            case 5: {
                                v15 = 110;
                                break;
                            }
                            default: {
                                v15 = 30;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x338B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 95;
                    case 1 -> 248;
                    case 2 -> 106;
                    case 3 -> 83;
                    case 4 -> 210;
                    case 5 -> 143;
                    case 6 -> 134;
                    case 7 -> 21;
                    case 8 -> 196;
                    case 9 -> 59;
                    case 10 -> 154;
                    case 11 -> 112;
                    case 12 -> 135;
                    case 13 -> 194;
                    case 14 -> 78;
                    case 15 -> 35;
                    case 16 -> 225;
                    case 17 -> 189;
                    case 18 -> 220;
                    case 19 -> 11;
                    case 20 -> 7;
                    case 21 -> 182;
                    case 22 -> 133;
                    case 23 -> 39;
                    case 24 -> 238;
                    case 25 -> 105;
                    case 26 -> 178;
                    case 27 -> 41;
                    case 28 -> 148;
                    case 29 -> 69;
                    case 30 -> 80;
                    case 31 -> 222;
                    case 32 -> 46;
                    case 33 -> 204;
                    case 34 -> 140;
                    case 35 -> 84;
                    case 36 -> 89;
                    case 37 -> 151;
                    case 38 -> 168;
                    case 39 -> 117;
                    case 40 -> 65;
                    case 41 -> 88;
                    case 42 -> 254;
                    case 43 -> 31;
                    case 44 -> 98;
                    case 45 -> 144;
                    case 46 -> 52;
                    case 47 -> 215;
                    case 48 -> 145;
                    case 49 -> 205;
                    case 50 -> 232;
                    case 51 -> 38;
                    case 52 -> 74;
                    case 53 -> 22;
                    case 54 -> 235;
                    case 55 -> 192;
                    case 56 -> 103;
                    case 57 -> 87;
                    case 58 -> 227;
                    case 59 -> 25;
                    case 60 -> 42;
                    case 61 -> 114;
                    case 62 -> 253;
                    case 63 -> 17;
                    case 64 -> 191;
                    case 65 -> 212;
                    case 66 -> 24;
                    case 67 -> 190;
                    case 68 -> 160;
                    case 69 -> 245;
                    case 70 -> 81;
                    case 71 -> 82;
                    case 72 -> 62;
                    case 73 -> 242;
                    case 74 -> 187;
                    case 75 -> 224;
                    case 76 -> 109;
                    case 77 -> 23;
                    case 78 -> 70;
                    case 79 -> 66;
                    case 80 -> 175;
                    case 81 -> 33;
                    case 82 -> 94;
                    case 83 -> 110;
                    case 84 -> 125;
                    case 85 -> 4;
                    case 86 -> 243;
                    case 87 -> 122;
                    case 88 -> 142;
                    case 89 -> 77;
                    case 90 -> 184;
                    case 91 -> 19;
                    case 92 -> 162;
                    case 93 -> 14;
                    case 94 -> 60;
                    case 95 -> 92;
                    case 96 -> 223;
                    case 97 -> 10;
                    case 98 -> 173;
                    case 99 -> 200;
                    case 100 -> 48;
                    case 101 -> 250;
                    case 102 -> 51;
                    case 103 -> 137;
                    case 104 -> 185;
                    case 105 -> 170;
                    case 106 -> 119;
                    case 107 -> 97;
                    case 108 -> 201;
                    case 109 -> 18;
                    case 110 -> 234;
                    case 111 -> 176;
                    case 112 -> 30;
                    case 113 -> 139;
                    case 114 -> 163;
                    case 115 -> 100;
                    case 116 -> 197;
                    case 117 -> 49;
                    case 118 -> 44;
                    case 119 -> 231;
                    case 120 -> 174;
                    case 121 -> 90;
                    case 122 -> 129;
                    case 123 -> 27;
                    case 124 -> 64;
                    case 125 -> 1;
                    case 126 -> 5;
                    case 127 -> 198;
                    case 128 -> 37;
                    case 129 -> 171;
                    case 130 -> 12;
                    case 131 -> 29;
                    case 132 -> 138;
                    case 133 -> 130;
                    case 134 -> 54;
                    case 135 -> 61;
                    case 136 -> 6;
                    case 137 -> 68;
                    case 138 -> 226;
                    case 139 -> 96;
                    case 140 -> 179;
                    case 141 -> 155;
                    case 142 -> 56;
                    case 143 -> 247;
                    case 144 -> 207;
                    case 145 -> 203;
                    case 146 -> 228;
                    case 147 -> 150;
                    case 148 -> 107;
                    case 149 -> 8;
                    case 150 -> 16;
                    case 151 -> 50;
                    case 152 -> 67;
                    case 153 -> 91;
                    case 154 -> 26;
                    case 155 -> 157;
                    case 156 -> 188;
                    case 157 -> 216;
                    case 158 -> 99;
                    case 159 -> 240;
                    case 160 -> 108;
                    case 161 -> 104;
                    case 162 -> 239;
                    case 163 -> 181;
                    case 164 -> 32;
                    case 165 -> 255;
                    case 166 -> 9;
                    case 167 -> 211;
                    case 168 -> 217;
                    case 169 -> 183;
                    case 170 -> 158;
                    case 171 -> 141;
                    case 172 -> 71;
                    case 173 -> 167;
                    case 174 -> 86;
                    case 175 -> 172;
                    case 176 -> 161;
                    case 177 -> 156;
                    case 178 -> 241;
                    case 179 -> 195;
                    case 180 -> 0;
                    case 181 -> 229;
                    case 182 -> 208;
                    case 183 -> 246;
                    case 184 -> 53;
                    case 185 -> 73;
                    case 186 -> 20;
                    case 187 -> 147;
                    case 188 -> 102;
                    case 189 -> 218;
                    case 190 -> 214;
                    case 191 -> 47;
                    case 192 -> 152;
                    case 193 -> 115;
                    case 194 -> 2;
                    case 195 -> 116;
                    case 196 -> 120;
                    case 197 -> 101;
                    case 198 -> 85;
                    case 199 -> 237;
                    case 200 -> 230;
                    case 201 -> 113;
                    case 202 -> 124;
                    case 203 -> 34;
                    case 204 -> 186;
                    case 205 -> 159;
                    case 206 -> 180;
                    case 207 -> 252;
                    case 208 -> 36;
                    case 209 -> 76;
                    case 210 -> 136;
                    case 211 -> 164;
                    case 212 -> 244;
                    case 213 -> 193;
                    case 214 -> 15;
                    case 215 -> 221;
                    case 216 -> 206;
                    case 217 -> 199;
                    case 218 -> 55;
                    case 219 -> 146;
                    case 220 -> 153;
                    case 221 -> 132;
                    case 222 -> 202;
                    case 223 -> 3;
                    case 224 -> 118;
                    case 225 -> 72;
                    case 226 -> 149;
                    case 227 -> 165;
                    case 228 -> 28;
                    case 229 -> 233;
                    case 230 -> 123;
                    case 231 -> 93;
                    case 232 -> 111;
                    case 233 -> 121;
                    case 234 -> 128;
                    case 235 -> 169;
                    case 236 -> 13;
                    case 237 -> 166;
                    case 238 -> 127;
                    case 239 -> 131;
                    case 240 -> 249;
                    case 241 -> 63;
                    case 242 -> 219;
                    case 243 -> 209;
                    case 244 -> 126;
                    case 245 -> 75;
                    case 246 -> 43;
                    case 247 -> 251;
                    case 248 -> 177;
                    case 249 -> 58;
                    case 250 -> 236;
                    case 251 -> 40;
                    case 252 -> 213;
                    case 253 -> 57;
                    case 254 -> 79;
                    default -> 45;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 61025387324421L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1802998920 - -16728, 1802998920 - 18860, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 2476211352094L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.h();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-1984793010 - -17532, -1984793010 - -6485, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 85132074119767L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00c9\u00ac]\u00897\u0003\u0082Ub";
                var4_3 = "\u00c9\u00ac]\u00897\u0003\u0082Ub".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 109;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 31;
                                break;
                            }
                            case 1: {
                                v11 = 73;
                                break;
                            }
                            case 2: {
                                v11 = 111;
                                break;
                            }
                            case 3: {
                                v11 = 16;
                                break;
                            }
                            case 4: {
                                v11 = 12;
                                break;
                            }
                            case 5: {
                                v11 = 126;
                                break;
                            }
                            default: {
                                v11 = 74;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x8D5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 86;
                    case 1 -> 130;
                    case 2 -> 236;
                    case 3 -> 33;
                    case 4 -> 110;
                    case 5 -> 213;
                    case 6 -> 25;
                    case 7 -> 152;
                    case 8 -> 31;
                    case 9 -> 238;
                    case 10 -> 44;
                    case 11 -> 200;
                    case 12 -> 169;
                    case 13 -> 117;
                    case 14 -> 251;
                    case 15 -> 133;
                    case 16 -> 48;
                    case 17 -> 36;
                    case 18 -> 53;
                    case 19 -> 39;
                    case 20 -> 237;
                    case 21 -> 151;
                    case 22 -> 77;
                    case 23 -> 149;
                    case 24 -> 50;
                    case 25 -> 46;
                    case 26 -> 114;
                    case 27 -> 52;
                    case 28 -> 67;
                    case 29 -> 54;
                    case 30 -> 248;
                    case 31 -> 65;
                    case 32 -> 137;
                    case 33 -> 51;
                    case 34 -> 104;
                    case 35 -> 28;
                    case 36 -> 14;
                    case 37 -> 182;
                    case 38 -> 41;
                    case 39 -> 208;
                    case 40 -> 5;
                    case 41 -> 207;
                    case 42 -> 55;
                    case 43 -> 222;
                    case 44 -> 11;
                    case 45 -> 178;
                    case 46 -> 2;
                    case 47 -> 160;
                    case 48 -> 180;
                    case 49 -> 124;
                    case 50 -> 129;
                    case 51 -> 99;
                    case 52 -> 230;
                    case 53 -> 56;
                    case 54 -> 231;
                    case 55 -> 10;
                    case 56 -> 179;
                    case 57 -> 245;
                    case 58 -> 141;
                    case 59 -> 193;
                    case 60 -> 91;
                    case 61 -> 189;
                    case 62 -> 47;
                    case 63 -> 214;
                    case 64 -> 217;
                    case 65 -> 19;
                    case 66 -> 107;
                    case 67 -> 201;
                    case 68 -> 190;
                    case 69 -> 0;
                    case 70 -> 228;
                    case 71 -> 192;
                    case 72 -> 40;
                    case 73 -> 168;
                    case 74 -> 229;
                    case 75 -> 17;
                    case 76 -> 240;
                    case 77 -> 90;
                    case 78 -> 119;
                    case 79 -> 136;
                    case 80 -> 82;
                    case 81 -> 49;
                    case 82 -> 232;
                    case 83 -> 184;
                    case 84 -> 45;
                    case 85 -> 27;
                    case 86 -> 70;
                    case 87 -> 112;
                    case 88 -> 147;
                    case 89 -> 250;
                    case 90 -> 206;
                    case 91 -> 223;
                    case 92 -> 170;
                    case 93 -> 234;
                    case 94 -> 9;
                    case 95 -> 225;
                    case 96 -> 68;
                    case 97 -> 226;
                    case 98 -> 197;
                    case 99 -> 181;
                    case 100 -> 64;
                    case 101 -> 4;
                    case 102 -> 188;
                    case 103 -> 203;
                    case 104 -> 96;
                    case 105 -> 128;
                    case 106 -> 187;
                    case 107 -> 221;
                    case 108 -> 79;
                    case 109 -> 235;
                    case 110 -> 18;
                    case 111 -> 75;
                    case 112 -> 247;
                    case 113 -> 199;
                    case 114 -> 211;
                    case 115 -> 3;
                    case 116 -> 241;
                    case 117 -> 135;
                    case 118 -> 212;
                    case 119 -> 205;
                    case 120 -> 103;
                    case 121 -> 26;
                    case 122 -> 111;
                    case 123 -> 126;
                    case 124 -> 150;
                    case 125 -> 120;
                    case 126 -> 252;
                    case 127 -> 109;
                    case 128 -> 134;
                    case 129 -> 157;
                    case 130 -> 93;
                    case 131 -> 95;
                    case 132 -> 194;
                    case 133 -> 37;
                    case 134 -> 164;
                    case 135 -> 156;
                    case 136 -> 38;
                    case 137 -> 66;
                    case 138 -> 146;
                    case 139 -> 13;
                    case 140 -> 61;
                    case 141 -> 62;
                    case 142 -> 186;
                    case 143 -> 81;
                    case 144 -> 15;
                    case 145 -> 102;
                    case 146 -> 131;
                    case 147 -> 177;
                    case 148 -> 142;
                    case 149 -> 24;
                    case 150 -> 20;
                    case 151 -> 167;
                    case 152 -> 35;
                    case 153 -> 83;
                    case 154 -> 218;
                    case 155 -> 57;
                    case 156 -> 71;
                    case 157 -> 159;
                    case 158 -> 1;
                    case 159 -> 191;
                    case 160 -> 59;
                    case 161 -> 140;
                    case 162 -> 34;
                    case 163 -> 154;
                    case 164 -> 87;
                    case 165 -> 16;
                    case 166 -> 63;
                    case 167 -> 253;
                    case 168 -> 105;
                    case 169 -> 215;
                    case 170 -> 73;
                    case 171 -> 22;
                    case 172 -> 246;
                    case 173 -> 106;
                    case 174 -> 32;
                    case 175 -> 98;
                    case 176 -> 242;
                    case 177 -> 94;
                    case 178 -> 121;
                    case 179 -> 144;
                    case 180 -> 216;
                    case 181 -> 69;
                    case 182 -> 176;
                    case 183 -> 78;
                    case 184 -> 145;
                    case 185 -> 123;
                    case 186 -> 224;
                    case 187 -> 255;
                    case 188 -> 76;
                    case 189 -> 42;
                    case 190 -> 161;
                    case 191 -> 174;
                    case 192 -> 233;
                    case 193 -> 185;
                    case 194 -> 148;
                    case 195 -> 139;
                    case 196 -> 171;
                    case 197 -> 72;
                    case 198 -> 183;
                    case 199 -> 239;
                    case 200 -> 125;
                    case 201 -> 132;
                    case 202 -> 220;
                    case 203 -> 172;
                    case 204 -> 244;
                    case 205 -> 30;
                    case 206 -> 153;
                    case 207 -> 204;
                    case 208 -> 202;
                    case 209 -> 97;
                    case 210 -> 101;
                    case 211 -> 43;
                    case 212 -> 162;
                    case 213 -> 118;
                    case 214 -> 195;
                    case 215 -> 143;
                    case 216 -> 173;
                    case 217 -> 210;
                    case 218 -> 92;
                    case 219 -> 88;
                    case 220 -> 158;
                    case 221 -> 85;
                    case 222 -> 60;
                    case 223 -> 163;
                    case 224 -> 198;
                    case 225 -> 7;
                    case 226 -> 166;
                    case 227 -> 138;
                    case 228 -> 23;
                    case 229 -> 254;
                    case 230 -> 243;
                    case 231 -> 21;
                    case 232 -> 116;
                    case 233 -> 80;
                    case 234 -> 89;
                    case 235 -> 155;
                    case 236 -> 84;
                    case 237 -> 175;
                    case 238 -> 6;
                    case 239 -> 122;
                    case 240 -> 58;
                    case 241 -> 127;
                    case 242 -> 165;
                    case 243 -> 29;
                    case 244 -> 74;
                    case 245 -> 219;
                    case 246 -> 8;
                    case 247 -> 196;
                    case 248 -> 12;
                    case 249 -> 209;
                    case 250 -> 115;
                    case 251 -> 113;
                    case 252 -> 108;
                    case 253 -> 100;
                    case 254 -> 227;
                    default -> 249;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

