/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.model.dbprop;

import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OracleDbProperties
extends DbProperties {
    public static final String ORACLE_DB_NAME = "orcl";
    public static final String ORACLE_SYSTEM_USER = "system";
    public static final String ORACLE_SYSTEM_PASSW = "oracle";

    public OracleDbProperties(DbType dbType) {
        this.dbType = dbType;
        this.user = "root";
        this.password = "root";
        this.setUrl("localhost", ORACLE_DB_NAME, "");
    }

    @Override
    @Nullable
    public String getHost() {
        String urlWithoutPrefix;
        String string = urlWithoutPrefix = this.dbType == DbType.ORACLE ? null : StringUtil.substringAfter((String)this.url, (String)"jdbc:oracle:thin:@");
        if (StringUtil.isEmpty((String)urlWithoutPrefix)) {
            return super.getHost();
        }
        int slash = urlWithoutPrefix.lastIndexOf(47);
        if (slash < 0) {
            slash = urlWithoutPrefix.lastIndexOf(":");
        }
        if (slash <= 0) {
            return "";
        }
        return urlWithoutPrefix.substring(0, slash);
    }

    @Override
    @Nullable
    public String substringWithLastSlash(boolean includeParams) {
        if (this.dbType == DbType.ORACLE) {
            return super.substringWithLastSlash(includeParams);
        }
        String url = this.url;
        if (!includeParams) {
            url = this.getUrlWithoutParams();
        }
        if (url == null) {
            return null;
        }
        int slash = url.lastIndexOf(47);
        if (slash < 0) {
            slash = url.lastIndexOf(":");
        }
        if (slash <= 0) {
            return null;
        }
        return url.substring(slash + 1);
    }

    @Override
    @NotNull
    public String getHostSeparator() {
        String string = this.dbType == DbType.ORACLE_SID ? ":" : super.getHostSeparator();
        if (string == null) {
            OracleDbProperties.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/jpb/model/core/model/dbprop/OracleDbProperties", "getHostSeparator"));
    }
}

