/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.common;

import com.intellij.CommonBundle;
import com.intellij.execution.CantRunException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.ws.common.CommonWsUtils;
import com.intellij.ws.common.ExternalProcessHandler;
import com.intellij.ws.common.FileUtils;
import com.intellij.ws.common.WSUtilsBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvokeExternalCodeUtil {
    private static final Logger LOG = Logger.getInstance((String)"webservicesplugin.invokeexternalcode");
    public static final Map<String, String> ourBasePath2TempEndorsedDirectory = new HashMap<String, String>();
    public static final String CLASS_PATH_SEPARATOR = System.getProperty("path.separator");

    private InvokeExternalCodeUtil() {
    }

    private static String buildDescriptionFromCommandsAndLaunchDir(File dir, String[] commands) {
        StringBuilder b = new StringBuilder();
        if (dir != null) {
            b.append(dir.getAbsolutePath()).append(">");
        }
        int initialLen = b.length();
        for (String s : commands) {
            if (initialLen != b.length()) {
                b.append(" ");
            }
            b.append(s);
        }
        return b.toString();
    }

    public static String toAntPath(@NotNull String outputPath) {
        if (outputPath == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(0);
        }
        return outputPath.replace(File.separatorChar, '/');
    }

    public static void navigateToPackage(@NotNull Module moduleForFile, @NotNull String packagePrefix, @NotNull String outputPath) {
        if (moduleForFile == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(1);
        }
        if (packagePrefix == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(2);
        }
        if (outputPath == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(3);
        }
        InvokeExternalCodeUtil.navigateToPackage(moduleForFile, packagePrefix, outputPath, true);
    }

    public static void navigateToPackage(@NotNull Module moduleForFile, @NotNull String packagePrefix, @NotNull String outputPath, boolean requestFocus) {
        PsiDirectory[] directories;
        PsiPackage aPackage;
        if (moduleForFile == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(4);
        }
        if (packagePrefix == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(5);
        }
        if (outputPath == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(6);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)moduleForFile.getProject()).findPackage(packagePrefix)) != null && (directories = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)moduleForFile))).length > 0) {
            PsiDirectory chosenDirectory = directories[0];
            VirtualFile relativeFile = UriUtil.findRelativeFile((String)outputPath, null);
            if (relativeFile != null) {
                for (PsiDirectory dir : directories) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)dir.getVirtualFile(), (boolean)false)) continue;
                    chosenDirectory = dir;
                    break;
                }
            }
            chosenDirectory.navigate(requestFocus);
        }
    }

    public static void invokeExternalProcess(ExternalProcessHandler handler, Project project) throws ExternalCodeException {
        InvokeExternalCodeUtil.invokeExternalProcess(handler, project, null, null, null, null);
    }

    public static void invokeExternalProcess2(ExternalProcessHandler handler, Project project, Runnable actionAtSuccess, Consumer<? super Exception> actionAtFailure, Computable<Boolean> isRerunAvailable, Runnable editAndRunAgain) {
        assert (actionAtSuccess != null);
        InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, isRerunAvailable, editAndRunAgain);
    }

    public static void invokeExternalProcess(ExternalProcessHandler handler, Project project, Runnable actionAtSuccess, Consumer<? super Exception> actionAtFailure, Computable<Boolean> isRerunAvailable, Runnable editAndRunAgain) throws ExternalCodeException {
        if (actionAtSuccess != null) {
            InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, isRerunAvailable, editAndRunAgain);
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ExternalCodeException[] result = new ExternalCodeException[1];
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    InvokeExternalCodeUtil.doInvoke(handler);
                }
                catch (ExternalCodeException e) {
                    result[0] = e;
                }
            }, WSUtilsBundle.message("invoke.external.code.progress", handler.getName()), true, project);
            if (result[0] != null) {
                throw result[0];
            }
        } else {
            InvokeExternalCodeUtil.doInvoke(handler);
        }
    }

    public static void runViaConsole(final @NotNull ExternalProcessHandler handler, @NotNull Project project, @NotNull Runnable actionAtSuccess, @NotNull Consumer<? super Exception> actionAtFailure, @Nullable Computable<Boolean> rerunAvailable, Runnable editAndRunAgain) {
        if (handler == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(8);
        }
        if (actionAtSuccess == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(9);
        }
        if (actionAtFailure == null) {
            InvokeExternalCodeUtil.$$$reportNull$$$0(10);
        }
        try {
            final OSProcessHandler processHandler = new OSProcessHandler(InvokeExternalCodeUtil.startProcess(handler), handler.describeExecution());
            final StringBuilder output = new StringBuilder();
            final StringBuilder errorOutput = new StringBuilder();
            ProcessListener processListener = new ProcessListener(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    processHandler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                    processHandler.removeProcessListener((ProcessListener)this);
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (handler instanceof ExternalProcessHandlerBase) {
                        ((ExternalProcessHandlerBase)((Object)handler)).onProcessTerminated();
                    }
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output.append(event.getText());
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        errorOutput.append(event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processHandler.addProcessListener(processListener);
            final ConsoleView myConsoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            myConsoleView.addMessageFilter(new Filter(){

                public Filter.Result applyFilter(@NotNull String line, int entireLength) {
                    if (line == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/ws/common/InvokeExternalCodeUtil$2", "applyFilter"));
                }
            });
            myConsoleView.attachToProcess((ProcessHandler)processHandler);
            DefaultActionGroup toolbarActions = new DefaultActionGroup();
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)myConsoleView.getComponent(), "Center");
            content.add((Component)ActionManager.getInstance().createActionToolbar("WebServicesInvokeExternal", (ActionGroup)toolbarActions, false).getComponent(), "West");
            final RunContentDescriptor myDescriptor = new RunContentDescriptor((ExecutionConsole)myConsoleView, (ProcessHandler)processHandler, (JComponent)content, handler.getName());
            Computable isRerunAvailable = () -> processHandler.isProcessTerminated() && rerunAvailable != null && (Boolean)rerunAvailable.compute() != false ? Boolean.TRUE : Boolean.FALSE;
            CloseAction closeAction = CommonWsUtils.createRunnerAction(myDescriptor, project);
            Runnable rerun = () -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                closeAction.perform();
                InvokeExternalCodeUtil.runViaConsole(handler, project, actionAtSuccess, actionAtFailure, rerunAvailable, editAndRunAgain);
            };
            toolbarActions.add((AnAction)new RerunAction(myConsoleView, rerun, (Computable<Boolean>)isRerunAvailable));
            toolbarActions.add((AnAction)new EditAndRerunAction(() -> {
                closeAction.perform();
                editAndRunAgain.run();
            }, (Computable<Boolean>)isRerunAvailable));
            toolbarActions.add((AnAction)closeAction);
            Runnable action = () -> {
                processHandler.startNotify();
                processHandler.waitFor();
                ApplicationManager.getApplication().invokeLater(() -> {
                    boolean showRunContent = true;
                    boolean wasErrorOutput = false;
                    try {
                        InvokeExternalCodeUtil.doFilter(handler, output.toString(), errorOutput.toString());
                        showRunContent = false;
                    }
                    catch (ExternalCodeException ex) {
                        actionAtFailure.consume((Object)ex);
                        wasErrorOutput = true;
                    }
                    if (showRunContent) {
                        RunContentManager contentManager = RunContentManager.getInstance((Project)project);
                        CommonWsUtils.showRunContent(contentManager, myDescriptor);
                        Disposable disposable = Disposer.newDisposable();
                        project.getMessageBus().connect(disposable).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

                            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                                if (executor == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                if (descriptor == myDescriptor) {
                                    Disposer.dispose((Disposable)myConsoleView);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/ws/common/InvokeExternalCodeUtil$3", "contentRemoved"));
                            }
                        });
                    }
                    if (!wasErrorOutput) {
                        Disposer.dispose((Disposable)myConsoleView);
                        actionAtSuccess.run();
                    }
                });
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(project, handler.getName(), action, null, null, PerformInBackgroundOption.ALWAYS_BACKGROUND);
        }
        catch (IOException e) {
            actionAtFailure.consume((Object)e);
        }
    }

    private static Process startProcess(ExternalProcessHandler handler) throws IOException {
        String[] commands = handler.getCommands();
        if (LOG.isDebugEnabled()) {
            for (String command : commands) {
                LOG.debug(command);
            }
        }
        return Runtime.getRuntime().exec(commands, null, handler.getLaunchDir());
    }

    public static void doInvoke(ExternalProcessHandler handler) throws ExternalCodeException {
        try {
            Process process = InvokeExternalCodeUtil.startProcess(handler);
            StreamReaderThread streamReaderThreadOut = new StreamReaderThread(process.getInputStream());
            StreamReaderThread streamReaderThreadErr = new StreamReaderThread(process.getErrorStream());
            Future outThreadReadControl = ApplicationManager.getApplication().executeOnPooledThread((Runnable)streamReaderThreadOut);
            Future errThreadReadControl = ApplicationManager.getApplication().executeOnPooledThread((Runnable)streamReaderThreadErr);
            process.waitFor();
            try {
                outThreadReadControl.get();
                errThreadReadControl.get();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            String message = streamReaderThreadErr.builder.toString();
            String outMessage = streamReaderThreadOut.builder.toString();
            InvokeExternalCodeUtil.doFilter(handler, outMessage, message);
        }
        catch (IOException | InterruptedException e) {
            throw new ExternalCodeException(e.getMessage());
        }
    }

    private static void doFilter(ExternalProcessHandler handler, String outMessage, String message) throws ExternalCodeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("err:" + message);
            LOG.debug("out:" + outMessage);
        }
        if (handler.getOutputConsumer() != null && !handler.getOutputConsumer().handle(outMessage, message)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(message, "\r\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            if (line.startsWith("log4j:") || line.startsWith("Note:") || line.startsWith("Info:") || line.startsWith("BUILD FAILED") || line.startsWith(": FINEST,")) continue;
            throw new ExternalCodeException(line);
        }
    }

    public static String buildClasspathForModule(Module moduleForFile) {
        PathsList classPath = InvokeExternalCodeUtil.configureClasspath(moduleForFile);
        return classPath.getPathsString();
    }

    private static PathsList configureClasspath(Module moduleForFile) {
        JavaParameters parameters = new JavaParameters();
        try {
            parameters.configureByModule(moduleForFile, 2);
        }
        catch (CantRunException e) {
            LOG.error((Throwable)e);
        }
        return parameters.getClassPath();
    }

    public static String[] buildClasspathStringsForModule(Module moduleForFile) {
        List pathList = InvokeExternalCodeUtil.configureClasspath(moduleForFile).getPathList();
        return ArrayUtilRt.toStringArray((Collection)pathList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleForFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionAtSuccess";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionAtFailure";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toAntPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToPackage";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "runViaConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ExternalCodeException
    extends Exception {
        public ExternalCodeException(String message) {
            super(message);
            LOG.info((Throwable)this);
        }

        public ExternalCodeException(IOException ex) {
            super(ex);
            LOG.info((Throwable)this);
        }
    }

    private static final class RerunAction
    extends BasicRerunAction {
        RerunAction(ConsoleView consoleView, Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), CommonBundle.message((String)"action.rerun", (Object[])new Object[0]), AllIcons.Actions.Rerun, rerun, isRerunAvailablePredicate);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), consoleView.getComponent());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RerunAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(((Boolean)this.myRerunAvailablePredicate.compute()).booleanValue());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RerunAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/common/InvokeExternalCodeUtil$RerunAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$RerunAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class EditAndRerunAction
    extends BasicRerunAction {
        EditAndRerunAction(Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(WSUtilsBundle.message("edit.refresh.action.text", new Object[0]), WSUtilsBundle.message("edit.refresh.action.text", new Object[0]), AllIcons.Actions.EditSource, rerun, isRerunAvailablePredicate);
        }
    }

    static class StreamReaderThread
    implements Runnable {
        private final InputStream in;
        private StringBuilder builder;

        StreamReaderThread(InputStream stream) {
            this.in = stream;
        }

        @Override
        public void run() {
            char[] buf = new char[128];
            this.builder = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(this.in, StandardCharsets.UTF_8);){
                int read;
                while ((read = reader.read(buf)) != -1) {
                    this.builder.append(buf, 0, read);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface OutputConsumer {
        public boolean handle(String var1, String var2) throws ExternalCodeException;
    }

    private static class BasicRerunAction
    extends AnAction {
        private final Runnable myRerunTask;
        protected final Computable<Boolean> myRerunAvailablePredicate;

        BasicRerunAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon, Runnable rerun, Computable<Boolean> isRerunAvailablePredicate) {
            super(text, description, icon);
            this.myRerunAvailablePredicate = isRerunAvailablePredicate;
            this.myRerunTask = rerun;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BasicRerunAction.$$$reportNull$$$0(0);
            }
            this.myRerunTask.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ws/common/InvokeExternalCodeUtil$BasicRerunAction", "actionPerformed"));
        }
    }

    public static class JavaExternalProcessHandler
    extends ExternalProcessHandlerBase
    implements ExternalProcessHandler {
        @NotNull
        private final Sdk jdk;
        @NotNull
        private final @NotNull String @NotNull [] classPath;
        protected final String className;
        private final String[] parameters;
        private final boolean myIncludeToolsJar;
        private Map<String, String> commandLineProperties;
        private final Module myModule;

        public JavaExternalProcessHandler(@NotNull String name, @NotNull @NonNls String _className, @NotNull Sdk sdk, String[] _classPath, String[] _parameters, Module module, boolean includeToolsJar) {
            if (name == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(0);
            }
            if (_className == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(1);
            }
            if (sdk == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(2);
            }
            super(name);
            this.myModule = module;
            if (LOG.isDebugEnabled()) {
                LOG.debug("About to execute " + _className);
                LOG.debug("Module " + String.valueOf(module));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finally using jdk:" + CommonWsUtils.getVMExecutablePathForSdk(sdk));
            }
            this.jdk = sdk;
            this.className = _className;
            this.classPath = _classPath != null ? (String[])Arrays.stream(_classPath).filter(it -> it != null).toArray(String[]::new) : ArrayUtilRt.EMPTY_STRING_ARRAY;
            this.parameters = _parameters;
            this.myIncludeToolsJar = includeToolsJar;
            HttpConfigurable.getInstance().getJvmProperties(false, null).forEach(p -> this.addCommandLineProperty((String)p.first, (String)p.second));
        }

        public JavaExternalProcessHandler(@NotNull String name, @NotNull @NonNls String _className, String[] _classPath, String[] _parameters, Module module, boolean includeToolsJar) {
            if (name == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(3);
            }
            if (_className == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(4);
            }
            this(name, _className, JavaExternalProcessHandler.evaluateJdkForModule(module), _classPath, _parameters, module, includeToolsJar);
        }

        public void addCommandLineProperty(@NonNls String property, String value) {
            if (this.commandLineProperties == null) {
                this.commandLineProperties = new HashMap<String, String>(2);
            }
            this.commandLineProperties.put(property, value);
        }

        public static Sdk evaluateJdkForModule(Module module) {
            Sdk _jdk;
            Sdk sdk = _jdk = module != null ? ModuleRootManager.getInstance((Module)module).getSdk() : null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using module jdk:" + (CommonWsUtils.isAcceptableSdk(_jdk) ? CommonWsUtils.getVMExecutablePathForSdk(_jdk) : null));
            }
            if (_jdk == null && module != null) {
                _jdk = ProjectRootManager.getInstance((Project)module.getProject()).getProjectSdk();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using project jdk:" + (CommonWsUtils.isAcceptableSdk(_jdk) ? CommonWsUtils.getVMExecutablePathForSdk(_jdk) : null));
                }
            }
            if (!CommonWsUtils.isAcceptableSdk(_jdk)) {
                _jdk = CommonWsUtils.getInternalJdk();
            }
            return _jdk;
        }

        @Override
        @NotNull
        public String getName() {
            String string = super.getName();
            if (string == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected List<String> buildCommands() {
            boolean hasClassPath = this.classPath.length > 0 || this.myIncludeToolsJar || this.commandLineProperties != null;
            ArrayList<String> parametersList = new ArrayList<String>(this.parameters.length + 3 + (hasClassPath ? 2 : 0) + (this.commandLineProperties != null ? this.commandLineProperties.size() : 0));
            parametersList.add(CommonWsUtils.getVMExecutablePathForSdk(this.jdk));
            if (hasClassPath) {
                parametersList.add("-classpath");
                StringBuilder builder = new StringBuilder();
                for (String u : this.classPath) {
                    if (!builder.isEmpty()) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    u = FileUtils.removeFileProtocolPrefixIfPresent(u);
                    builder.append(u);
                }
                if (this.myIncludeToolsJar) {
                    if (!builder.isEmpty()) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    builder.append(CommonWsUtils.getToolsJarPathForSdk(this.jdk));
                }
                HashSet modules = new HashSet();
                if (this.myModule != null) {
                    ModuleUtilCore.getDependencies((Module)this.myModule, modules);
                }
                for (Module module : modules) {
                    VirtualFile output = CompilerModuleExtension.getInstance((Module)module).getCompilerOutputPath();
                    if (output == null) continue;
                    if (!builder.isEmpty()) {
                        builder.append(CLASS_PATH_SEPARATOR);
                    }
                    builder.append(output.getPath());
                }
                parametersList.add(builder.toString());
            }
            if (this.commandLineProperties != null) {
                for (String key : this.commandLineProperties.keySet()) {
                    parametersList.add("-D" + key + "=" + this.commandLineProperties.get(key));
                }
            }
            parametersList.add("-Xmx" + this.getMemorySizeToLaunchVM() + "M");
            this.addInvokedClass(parametersList);
            ContainerUtil.addAll(parametersList, (Object[])this.parameters);
            ArrayList<String> arrayList = parametersList;
            if (arrayList == null) {
                JavaExternalProcessHandler.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        protected int getMemorySizeToLaunchVM() {
            return 128;
        }

        protected void addInvokedClass(List<? super String> parametersList) {
            parametersList.add(this.className);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "_className";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/common/InvokeExternalCodeUtil$JavaExternalProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$JavaExternalProcessHandler";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildCommands";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ANTExternalProcessHandler
    implements ExternalProcessHandler {
        private final ExternalProcessHandler myJavaExternalProcessHandler;
        private final String myName;
        private final String myAntFileText;

        public ANTExternalProcessHandler(@NotNull String name, String antFileText, String[] additionalClassPathForTasks, Module targetModule) {
            if (name == null) {
                ANTExternalProcessHandler.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myAntFileText = antFileText;
            try {
                File tempFile = FileUtil.createTempFile((String)"build", (String)".xml");
                tempFile.deleteOnExit();
                FileUtil.writeToFile((File)tempFile.getAbsoluteFile(), (String)antFileText);
                LinkedList<Object> parameters = new LinkedList<Object>();
                Object homeDir = PathManager.getHomePath() + "/lib/ant";
                homeDir = ((String)homeDir).replace('\\', '/');
                parameters.add("-Dant.home=" + (String)homeDir);
                if (additionalClassPathForTasks != null && additionalClassPathForTasks.length > 0) {
                    parameters.add("-cp");
                    StringBuilder additionalClassPath = new StringBuilder();
                    for (String a : additionalClassPathForTasks) {
                        if (!additionalClassPath.isEmpty()) {
                            additionalClassPath.append(CLASS_PATH_SEPARATOR);
                        }
                        additionalClassPath.append(a);
                    }
                    parameters.add(additionalClassPath.toString());
                }
                parameters.add("-f");
                parameters.add(tempFile.getCanonicalPath());
                this.myJavaExternalProcessHandler = new JavaExternalProcessHandler(this.myName, "org.apache.tools.ant.launch.Launcher", new String[]{(String)homeDir + "/lib/ant-launcher.jar"}, ArrayUtilRt.toStringArray(parameters), targetModule, true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ANTExternalProcessHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public String[] getCommands() {
            return this.myJavaExternalProcessHandler.getCommands();
        }

        @Override
        @Nullable
        public File getLaunchDir() {
            return this.myJavaExternalProcessHandler.getLaunchDir();
        }

        @Override
        public void setLaunchDir(@Nullable File launchDir) {
            this.myJavaExternalProcessHandler.setLaunchDir(launchDir);
        }

        @Override
        public OutputConsumer getOutputConsumer() {
            return this.myJavaExternalProcessHandler.getOutputConsumer();
        }

        @Override
        public void setOutputConsumer(OutputConsumer outputConsumer) {
            this.myJavaExternalProcessHandler.setOutputConsumer(outputConsumer);
        }

        @Override
        public String describeExecution() {
            return this.myJavaExternalProcessHandler.describeExecution() + "\nAnt file:\n" + this.myAntFileText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/common/InvokeExternalCodeUtil$ANTExternalProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$ANTExternalProcessHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class BatchExternalProcessHandler
    extends ExternalProcessHandlerBase
    implements ExternalProcessHandler {
        private final List<String> myParams;
        private String myBaseBatchFileName;

        public BatchExternalProcessHandler(@NotNull String name, @NotNull String baseBatchFileName, @NotNull List<String> params) {
            if (name == null) {
                BatchExternalProcessHandler.$$$reportNull$$$0(0);
            }
            if (baseBatchFileName == null) {
                BatchExternalProcessHandler.$$$reportNull$$$0(1);
            }
            if (params == null) {
                BatchExternalProcessHandler.$$$reportNull$$$0(2);
            }
            super(name);
            this.myBaseBatchFileName = baseBatchFileName;
            this.myParams = params;
        }

        @Override
        @NotNull
        protected List<String> buildCommands() {
            ArrayList<String> commands = new ArrayList<String>(this.myParams.size() + 2);
            if (SystemInfo.isWindows) {
                commands.add("cmd");
                commands.add("/c");
            }
            this.myBaseBatchFileName = this.myBaseBatchFileName + (SystemInfo.isWindows ? ".bat" : ".sh");
            commands.add(this.myBaseBatchFileName);
            commands.addAll(this.myParams);
            ArrayList<String> arrayList = commands;
            if (arrayList == null) {
                BatchExternalProcessHandler.$$$reportNull$$$0(3);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseBatchFileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/common/InvokeExternalCodeUtil$BatchExternalProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$BatchExternalProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildCommands";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static abstract class ExternalProcessHandlerBase {
        protected final String myName;
        protected String[] myCommands;
        protected File myLaunchDir;
        protected OutputConsumer myOutputConsumer;

        protected ExternalProcessHandlerBase(@NotNull String name) {
            if (name == null) {
                ExternalProcessHandlerBase.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                ExternalProcessHandlerBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        protected abstract List<String> buildCommands();

        public String @NotNull [] getCommands() {
            if (this.myCommands == null) {
                @NotNull List<String> commands = this.buildCommands();
                this.myCommands = ArrayUtilRt.toStringArray(commands);
            }
            if (this.myCommands == null) {
                ExternalProcessHandlerBase.$$$reportNull$$$0(2);
            }
            return this.myCommands;
        }

        @Nullable
        public File getLaunchDir() {
            return this.myLaunchDir;
        }

        public void setLaunchDir(@Nullable File launchDir) {
            this.myLaunchDir = launchDir;
        }

        @Nullable
        public OutputConsumer getOutputConsumer() {
            return this.myOutputConsumer;
        }

        public void setOutputConsumer(@Nullable OutputConsumer outputConsumer) {
            this.myOutputConsumer = outputConsumer;
        }

        public String describeExecution() {
            return InvokeExternalCodeUtil.buildDescriptionFromCommandsAndLaunchDir(this.myLaunchDir, this.getCommands());
        }

        public void onProcessTerminated() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ws/common/InvokeExternalCodeUtil$ExternalProcessHandlerBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ws/common/InvokeExternalCodeUtil$ExternalProcessHandlerBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommands";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

