/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class LombokOnXCompletionContributorFilter
extends CompletionContributor {
    private static final Collection<String> ONX_PARAMETERS = Arrays.asList("onConstructor", "onMethod", "onParam");
    private static final Collection<String> ONXABLE_ANNOTATION_FQNS = Arrays.asList("lombok.Getter", "lombok.Setter", "lombok.With", "lombok.experimental.Wither", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor", "lombok.EqualsAndHashCode");
    private static final Collection<String> ONXABLE_ANNOTATION_NAMES = ContainerUtil.map(ONXABLE_ANNOTATION_FQNS, StringUtil::getShortName);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            LombokOnXCompletionContributorFilter.$$$reportNull$$$0(0);
        }
        if (result == null) {
            LombokOnXCompletionContributorFilter.$$$reportNull$$$0(1);
        }
        if (PsiUtil.getLanguageLevel((Project)parameters.getPosition().getProject()).isLessThan(LanguageLevel.JDK_1_8)) {
            return;
        }
        result.runRemainingContributors(parameters, completionResult -> {
            LookupElement lookupElement = completionResult.getLookupElement();
            if (LombokOnXCompletionContributorFilter.shouldKeepItem(lookupElement)) {
                result.passResult(completionResult);
            }
        });
    }

    private static boolean shouldKeepItem(LookupElement item) {
        PsiMethod psiMethod;
        PsiClass containingClass;
        PsiElement psiElement;
        if (ONX_PARAMETERS.contains(item.getLookupString()) && (psiElement = item.getPsiElement()) instanceof PsiMethod && null != (containingClass = (psiMethod = (PsiMethod)psiElement).getContainingClass()) && containingClass.isAnnotationType() && ONXABLE_ANNOTATION_NAMES.contains(containingClass.getName())) {
            return !ONXABLE_ANNOTATION_FQNS.contains(containingClass.getQualifiedName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "de/plushnikov/intellij/plugin/completion/LombokOnXCompletionContributorFilter";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

