/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme.xmlUpdateHelper;

import com.google.gson.Gson;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsLoader;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class CssSchemeXmlAnalyzer {
    private static Set<String> allSupportedProperties;
    private static CssElementDescriptorFactory2 factory;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Use compare | verify | properties | media features");
            return;
        }
        CssSchemeXmlAnalyzer.initialize();
        switch (args[0]) {
            case "compare": {
                CssSchemeXmlAnalyzer.analyzeSpecs(args[1], args[2]);
                break;
            }
            case "verify": {
                CssSchemeXmlAnalyzer.verifyProperties(Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "properties": {
                CssSchemeXmlAnalyzer.getXmlProperties(args[1]);
                break;
            }
            case "media": {
                CssSchemeXmlAnalyzer.getXmlMediaFeatures(args[2]);
            }
        }
    }

    private static void getXmlMediaFeatures(String fileName) {
        CssDescriptorsHolder file = CssSchemeXmlAnalyzer.load(fileName);
        file.mediaFeatures.keySet().forEach(System.out::println);
    }

    private static void getXmlProperties(String fileName) {
        CssDescriptorsHolder file = CssSchemeXmlAnalyzer.load(fileName);
        file.properties.keySet().forEach(System.out::println);
    }

    private static void verifyProperties(String[] properties) {
        System.out.println("Relevant properties:");
        for (String property : properties) {
            if (!allSupportedProperties.contains(property)) continue;
            System.out.println(property);
        }
    }

    private static void analyzeSpecs(String fileName1, String fileName2) {
        CssDescriptorsHolder file1 = CssSchemeXmlAnalyzer.load(fileName1);
        CssDescriptorsHolder file2 = CssSchemeXmlAnalyzer.load(fileName2);
        if (file1 != null && file2 != null) {
            CssSchemeXmlAnalyzer.analyzeSpecsDifference(file1, file2);
        } else {
            System.err.println("Descriptors for provided filenames weren't loaded");
        }
    }

    private static void initialize() {
        factory = new CssElementDescriptorFactory2();
        factory.reload();
        if (allSupportedProperties == null) {
            try {
                Gson gson = new Gson();
                FileReader fr = new FileReader(CssSchemeXmlAnalyzer.class.getResource("all.json").getFile(), StandardCharsets.UTF_8);
                allSupportedProperties = ((AllProperties)gson.fromJson((Reader)fr, AllProperties.class)).properties;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void analyzeSpecsDifference(CssDescriptorsHolder file1, CssDescriptorsHolder file2) {
        CssSchemeXmlAnalyzer.analyzePropertiesDifference(file1, file2);
        CssSchemeXmlAnalyzer.analyzeNamedValuesDifference(file1, file2);
    }

    private static void analyzeNamedValuesDifference(CssDescriptorsHolder file1, CssDescriptorsHolder file2) {
        HashSet result = new HashSet(file1.namedValues.keySet());
        result.removeAll(file2.namedValues.keySet());
        System.out.println("\nPart 3:");
        result.stream().sorted().toList().forEach(System.out::println);
    }

    private static void analyzePropertiesDifference(CssDescriptorsHolder file1, CssDescriptorsHolder file2) {
        List<CssPropertyDescriptor> props1 = CssSchemeXmlAnalyzer.getRelevantProperties(file1);
        List<CssPropertyDescriptor> props2 = CssSchemeXmlAnalyzer.getRelevantProperties(file2);
        List<CssPropertyDescriptor> absentInNewProperties = CssSchemeXmlAnalyzer.getDifference(props1, props2);
        System.out.println("Relevant properties of the old version of spec that are missing in the new one");
        System.out.println("Part 1:");
        absentInNewProperties.stream().filter(p -> factory.findProperty(p.getPropertyName()).size() == 1).forEach(p -> System.out.println(p.getPropertyName()));
        System.out.println("\nPart 2:");
        absentInNewProperties.stream().filter(p -> factory.findProperty(p.getPropertyName()).size() != 1).forEach(p -> System.out.println(p.getPropertyName()));
    }

    private static List<CssPropertyDescriptor> getRelevantProperties(CssDescriptorsHolder file) {
        return file.properties.entrySet().stream().filter(p -> allSupportedProperties.contains(p.getKey())).map(p -> (Collection)p.getValue()).flatMap(Collection::stream).toList();
    }

    private static List<CssPropertyDescriptor> getDifference(List<CssPropertyDescriptor> props1, List<CssPropertyDescriptor> props2) {
        Set set2 = props2.stream().map(CssPropertyDescriptor::getPropertyName).collect(Collectors.toSet());
        return props1.stream().filter(property -> !set2.contains(property.getPropertyName())).toList();
    }

    private static CssDescriptorsHolder load(String fileName) {
        CssDescriptorsLoader loader = new CssDescriptorsLoader();
        URL resource = CssDescriptorsLoader.class.getResource("xml/" + fileName);
        if (resource == null) {
            System.out.println("Cannot find CSS scheme: " + fileName);
            return null;
        }
        loader.loadDescriptors(resource);
        return loader.getDescriptors();
    }

    private static class AllProperties {
        Set<String> properties;

        private AllProperties() {
        }
    }
}

