/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.json;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/json/GHActionJsonSchemaProviderFactory;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaProviderFactory;", "<init>", "()V", "getProviders", "", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "ActionJsonSchemaProvider", "WorkflowJsonSchemaProvider", "intellij.vcs.github.json"})
public final class GHActionJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new JsonSchemaFileProvider[]{new ActionJsonSchemaProvider(), new WorkflowJsonSchemaProvider()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/json/GHActionJsonSchemaProviderFactory$ActionJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "<init>", "()V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.vcs.github.json"})
    @SourceDebugExtension(value={"SMAP\nGHActionJsonSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHActionJsonSchemaProviderFactory.kt\norg/jetbrains/plugins/github/json/GHActionJsonSchemaProviderFactory$ActionJsonSchemaProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
    private static final class ActionJsonSchemaProvider
    implements JsonSchemaFileProvider {
        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return GithubYamlFileDetectionKt.isGithubActionFile((VirtualFile)file);
        }

        @NotNull
        public String getName() {
            String string = GithubBundle.message((String)"github.actions.action.file.json.schema", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            VirtualFile virtualFile;
            URL uRL = this.getClass().getResource("/schemas/github-action.json");
            if (uRL != null) {
                URL p0 = uRL;
                boolean bl = false;
                virtualFile = VfsUtil.findFileByURL((URL)p0);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/json/GHActionJsonSchemaProviderFactory$WorkflowJsonSchemaProvider;", "Lcom/jetbrains/jsonSchema/extension/JsonSchemaFileProvider;", "<init>", "()V", "isAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "getSchemaFile", "getSchemaType", "Lcom/jetbrains/jsonSchema/extension/SchemaType;", "intellij.vcs.github.json"})
    @SourceDebugExtension(value={"SMAP\nGHActionJsonSchemaProviderFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHActionJsonSchemaProviderFactory.kt\norg/jetbrains/plugins/github/json/GHActionJsonSchemaProviderFactory$WorkflowJsonSchemaProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
    private static final class WorkflowJsonSchemaProvider
    implements JsonSchemaFileProvider {
        public boolean isAvailable(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return GithubYamlFileDetectionKt.isGithubWorkflowFile((VirtualFile)file);
        }

        @NotNull
        public String getName() {
            String string = GithubBundle.message((String)"github.actions.workflow.file.json.schema", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Nullable
        public VirtualFile getSchemaFile() {
            VirtualFile virtualFile;
            URL uRL = this.getClass().getResource("/schemas/github-workflow.json");
            if (uRL != null) {
                URL p0 = uRL;
                boolean bl = false;
                virtualFile = VfsUtil.findFileByURL((URL)p0);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        @NotNull
        public SchemaType getSchemaType() {
            return SchemaType.embeddedSchema;
        }
    }
}

