/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.mysqlbase.MysqlBaseDomains;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class MysqlDomains
extends MysqlBaseDomains {
    public MysqlDomains(@NotNull Dbms dbms) {
        if (dbms == null) {
            MysqlDomains.$$$reportNull$$$0(0);
        }
        super(dbms, false, false);
        this.add((Domain)new TextDomain(this, "tinytext", ConversionPoint.VARCHAR, 255L){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof GridColumn && descriptor instanceof SizeProvider) {
                    return ((SizeProvider)descriptor).getSize() == 255 && descriptor.getType() == -1 && (StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"text") || StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$1", "isSuitable"));
            }
        });
        this.add((Domain)new TextDomain(this, "text", ConversionPoint.TEXT, 65535L){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof GridColumn && descriptor instanceof SizeProvider) {
                    return ((SizeProvider)descriptor).getSize() == 65535 && (StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"mediumtext") || StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$2", "isSuitable"));
            }
        });
        this.add(new TextDomain(this, "mediumtext", ConversionPoint.CLOB, 0xFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof GridColumn && descriptor instanceof SizeProvider) {
                    return (long)((SizeProvider)descriptor).getSize() == 0xFFFFFFL && (StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"longtext") || StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$3", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain(this, "longtext", ConversionPoint.CLOB, 0xFFFFFFFFL){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof GridColumn && descriptor instanceof SizeProvider) {
                    int precision = ((SizeProvider)descriptor).getSize();
                    return !(precision != 0x2AAAAAAA && precision != 0x1FFFFFFF || !StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"longtext") && !StringUtil.equalsIgnoreCase((CharSequence)descriptor.getTypeName(), (CharSequence)"varchar"));
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$4", "isSuitable"));
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 255L, 1L, true, false));
        this.add((Domain)new TextDomain(this, "varchar", ConversionPoint.VARCHAR, 21844L, TextDomain.Length.mandatory((long)4368L, (boolean)true)){

            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                if (descriptor == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (descriptor instanceof GridColumn) {
                    return super.isSuitable(descriptor) && descriptor.getType() == 12;
                }
                return super.isSuitable(descriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/mysql/MysqlDomains$5", "isSuitable"));
            }
        });
        this.add((Domain)new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21844L, TextDomain.Length.mandatory((long)4368L, (boolean)true)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/dialects/mysql/MysqlDomains", "<init>"));
    }
}

