/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.icons.AllIcons;
import com.intellij.java.frontback.impl.JavaFrontbackBundle;
import com.intellij.threadDumpParser.ThreadOperation;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.unscramble.DumpItem;
import com.intellij.unscramble.IconsCache;
import com.intellij.unscramble.MergeableDumpItem;
import com.intellij.unscramble.MergeableToken;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020#0\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\tR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lcom/intellij/unscramble/JavaThreadDumpItem;", "Lcom/intellij/unscramble/MergeableDumpItem;", "threadState", "Lcom/intellij/threadDumpParser/ThreadState;", "<init>", "(Lcom/intellij/threadDumpParser/ThreadState;)V", "name", "", "getName", "()Ljava/lang/String;", "stateDesc", "getStateDesc", "stackTrace", "getStackTrace", "isServiceThread", "", "interestLevel", "", "getInterestLevel", "()I", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "iconToolTip", "Lorg/jetbrains/annotations/Nls;", "getIconToolTip", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "isDeadLocked", "()Z", "internalAwaitingItems", "", "Lcom/intellij/unscramble/DumpItem;", "awaitingDumpItems", "getAwaitingDumpItems", "()Ljava/util/Set;", "setAwaitingItems", "", "awaitingItems", "mergeableToken", "Lcom/intellij/unscramble/MergeableToken;", "getMergeableToken", "()Lcom/intellij/unscramble/MergeableToken;", "JavaMergeableToken", "intellij.java.frontback.impl"})
@SourceDebugExtension(value={"SMAP\nDumpItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpItem.kt\ncom/intellij/unscramble/JavaThreadDumpItem\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,276:1\n1104#2,3:277\n*S KotlinDebug\n*F\n+ 1 DumpItem.kt\ncom/intellij/unscramble/JavaThreadDumpItem\n*L\n154#1:277,3\n*E\n"})
final class JavaThreadDumpItem
implements MergeableDumpItem {
    @NotNull
    private final ThreadState threadState;
    @NotNull
    private final String name;
    @NotNull
    private final String stackTrace;
    private final boolean isServiceThread;
    private final int interestLevel;
    @NotNull
    private final SimpleTextAttributes attributes;
    @NotNull
    private Set<? extends DumpItem> internalAwaitingItems;

    /*
     * WARNING - void declaration
     */
    public JavaThreadDumpItem(@NotNull ThreadState threadState) {
        SimpleTextAttributes simpleTextAttributes;
        Intrinsics.checkNotNullParameter((Object)threadState, (String)"threadState");
        this.threadState = threadState;
        String string = this.threadState.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        String string2 = this.threadState.getStackTrace();
        if (string2 == null) {
            string2 = "";
        }
        this.stackTrace = string2;
        this.isServiceThread = StringsKt.startsWith$default((String)this.getName(), (String)"Coroutines Debugger Cleaner", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.getName(), (String)"IntelliJ Suspend Helper", (boolean)false, (int)2, null);
        JavaThreadDumpItem javaThreadDumpItem = this;
        if (this.threadState.isEmptyStackTrace()) {
            v3 = -10;
        } else if (this.isServiceThread || this.threadState.isKnownJDKThread()) {
            v3 = -5;
        } else if (this.threadState.isSleeping()) {
            v3 = -2;
        } else if (this.threadState.getOperation() == ThreadOperation.SOCKET) {
            v3 = -1;
        } else {
            void $this$count$iv;
            CharSequence charSequence = this.getStackTrace();
            JavaThreadDumpItem javaThreadDumpItem2 = javaThreadDumpItem;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int n = count$iv;
            javaThreadDumpItem = javaThreadDumpItem2;
            v3 = javaThreadDumpItem.interestLevel = n;
        }
        if (this.threadState.isSleeping()) {
            simpleTextAttributes = DumpItem.SLEEPING_ATTRIBUTES;
        } else if (this.threadState.isEmptyStackTrace() || this.isServiceThread || this.threadState.isKnownJDKThread()) {
            simpleTextAttributes = DumpItem.UNINTERESTING_ATTRIBUTES;
        } else if (this.threadState.isEDT()) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_BOLD_ATTRIBUTES");
        } else {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_ATTRIBUTES");
        }
        this.attributes = simpleTextAttributes;
        this.internalAwaitingItems = SetsKt.emptySet();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getStateDesc() {
        StringBuilder stringBuilder;
        String string;
        String string2 = this.threadState.getThreadStateDetail();
        if (string2 == null) {
            string2 = this.threadState.getState();
        }
        String it = string2;
        boolean bl = false;
        if (it.length() > 30) {
            Intrinsics.checkNotNull((Object)it);
            string = StringsKt.take((String)it, (int)30) + "...";
        } else {
            string = stringBuilder;
        }
        void trimmedState = string;
        String extraState = this.threadState.getExtraState();
        StringBuilder $this$_get_stateDesc__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)trimmedState);
        if (((CharSequence)trimmedState).length() > 0 && !Intrinsics.areEqual((Object)trimmedState, (Object)"unknown") && !Intrinsics.areEqual((Object)trimmedState, (Object)"undefined")) {
            $this$_get_stateDesc__u24lambda_u241.append(" (" + (String)trimmedState + ")");
        }
        if (extraState != null) {
            $this$_get_stateDesc__u24lambda_u241.append(" [" + extraState + "]");
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String getStackTrace() {
        return this.stackTrace;
    }

    @Override
    public int getInterestLevel() {
        return this.interestLevel;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.threadState.isSleeping() ? AllIcons.Debugger.MuteBreakpoints : (this.threadState.getOperation() == ThreadOperation.CARRYING_VTHREAD ? AllIcons.Debugger.ThreadGroup : (this.threadState.isWaiting() ? AllIcons.Debugger.ThreadFrozen : (this.threadState.getOperation() == ThreadOperation.SOCKET ? AllIcons.Debugger.ThreadStates.Socket : (this.threadState.getOperation() == ThreadOperation.IO ? AllIcons.Actions.MenuSaveall : (this.threadState.isEDT() ? (this.threadState.isIdle() ? AllIcons.Debugger.ThreadStates.Idle : AllIcons.Actions.ProfileCPU) : AllIcons.Actions.Resume)))));
        Intrinsics.checkNotNull((Object)icon);
        Icon baseIcon = icon;
        return this.threadState.isVirtual() ? IconsCache.INSTANCE.getIconWithVirtualOverlay(baseIcon) : (this.threadState.isDaemon() ? IconsCache.INSTANCE.getIconWithDaemonOverlay(baseIcon) : baseIcon);
    }

    @Override
    @Nullable
    public String getIconToolTip() {
        return this.threadState.isVirtual() ? JavaFrontbackBundle.message("dump.item.java.thread.icon.tooltip.virtual", new Object[0]) : (this.threadState.isDaemon() ? JavaFrontbackBundle.message("dump.item.java.thread.icon.tooltip.daemon", new Object[0]) : null);
    }

    @Override
    @NotNull
    public SimpleTextAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isDeadLocked() {
        return this.threadState.isDeadlocked();
    }

    @Override
    @NotNull
    public Set<DumpItem> getAwaitingDumpItems() {
        return this.internalAwaitingItems;
    }

    public final void setAwaitingItems(@NotNull Set<? extends DumpItem> awaitingItems) {
        Intrinsics.checkNotNullParameter(awaitingItems, (String)"awaitingItems");
        this.internalAwaitingItems = awaitingItems;
    }

    @Override
    @NotNull
    public MergeableToken getMergeableToken() {
        return new JavaMergeableToken();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/unscramble/JavaThreadDumpItem$JavaMergeableToken;", "Lcom/intellij/unscramble/MergeableToken;", "<init>", "(Lcom/intellij/unscramble/JavaThreadDumpItem;)V", "comparableStackTrace", "", "item", "Lcom/intellij/unscramble/JavaThreadDumpItem;", "getItem", "()Lcom/intellij/unscramble/JavaThreadDumpItem;", "equals", "", "other", "", "hashCode", "", "intellij.java.frontback.impl"})
    private final class JavaMergeableToken
    implements MergeableToken {
        @NotNull
        private final String comparableStackTrace;

        public JavaMergeableToken() {
            CharSequence charSequence = StringsKt.substringAfter$default((String)JavaThreadDumpItem.this.getStackTrace(), (String)"\n", null, (int)2, null);
            Regex regex = new Regex("<0x\\d+>\\s");
            String string = "<merged>";
            this.comparableStackTrace = regex.replace(charSequence, string);
        }

        @Override
        @NotNull
        public JavaThreadDumpItem getItem() {
            return JavaThreadDumpItem.this;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (!(other instanceof JavaMergeableToken)) {
                return false;
            }
            ThreadState otherThreadState = ((JavaMergeableToken)other).getItem().threadState;
            if (JavaThreadDumpItem.this.threadState.isEDT()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getState(), (Object)otherThreadState.getState())) {
                return false;
            }
            if (JavaThreadDumpItem.this.threadState.isEmptyStackTrace() != otherThreadState.isEmptyStackTrace()) {
                return false;
            }
            if (JavaThreadDumpItem.this.threadState.isDaemon() != otherThreadState.isDaemon()) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getJavaThreadState(), (Object)otherThreadState.getJavaThreadState())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getThreadStateDetail(), (Object)otherThreadState.getThreadStateDetail())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getExtraState(), (Object)otherThreadState.getExtraState())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getAwaitingThreads(), (Object)otherThreadState.getAwaitingThreads())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)JavaThreadDumpItem.this.threadState.getDeadlockedThreads(), (Object)otherThreadState.getDeadlockedThreads())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comparableStackTrace, (Object)((JavaMergeableToken)other).comparableStackTrace);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{JavaThreadDumpItem.this.threadState.getState(), JavaThreadDumpItem.this.threadState.isEmptyStackTrace(), JavaThreadDumpItem.this.threadState.isDaemon(), JavaThreadDumpItem.this.threadState.getJavaThreadState(), JavaThreadDumpItem.this.threadState.getThreadStateDetail(), JavaThreadDumpItem.this.threadState.getExtraState(), JavaThreadDumpItem.this.threadState.getAwaitingThreads(), JavaThreadDumpItem.this.threadState.getDeadlockedThreads(), this.comparableStackTrace};
            return Objects.hash(objectArray);
        }
    }
}

