/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.embedding;

import com.intellij.html.embedding.BaseHtmlEmbeddedContentProvider;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.HtmlEmbeddedContentSupportHelperKt;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\nH$J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH$J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u0012\u0010\u001e\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0007H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/html/embedding/HtmlAttributeEmbeddedContentProvider;", "Lcom/intellij/html/embedding/BaseHtmlEmbeddedContentProvider;", "lexer", "Lcom/intellij/lexer/BaseHtmlLexer;", "<init>", "(Lcom/intellij/lexer/BaseHtmlLexer;)V", "myTagNameRead", "", "myWithinTag", "myTagName", "", "myAttributeName", "attributeName", "getAttributeName", "()Ljava/lang/CharSequence;", "tagName", "getTagName", "isInterestedInTag", "isInterestedInAttribute", "handleToken", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "range", "Lcom/intellij/openapi/util/TextRange;", "isStartOfEmbedment", "isAttributeEmbedmentToken", "findTheEndOfEmbedment", "Lkotlin/Pair;", "", "restoreState", "state", "", "hasState", "getState", "AttributeState", "intellij.xml.parser"})
public abstract class HtmlAttributeEmbeddedContentProvider
extends BaseHtmlEmbeddedContentProvider {
    private boolean myTagNameRead;
    private boolean myWithinTag;
    @Nullable
    private CharSequence myTagName;
    @Nullable
    private CharSequence myAttributeName;

    public HtmlAttributeEmbeddedContentProvider(@NotNull BaseHtmlLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)((Object)lexer), (String)"lexer");
        super(lexer);
    }

    @Nullable
    protected final CharSequence getAttributeName() {
        return this.myAttributeName;
    }

    @Nullable
    protected final CharSequence getTagName() {
        return this.myTagName;
    }

    protected abstract boolean isInterestedInTag(@NotNull CharSequence var1);

    protected abstract boolean isInterestedInAttribute(@NotNull CharSequence var1);

    @Override
    public void handleToken(@NotNull IElementType tokenType, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_START_TAG_START)) {
            this.myTagNameRead = false;
            this.embedment = false;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_NAME)) {
            Lexer baseLexer = this.getLexer().getDelegate();
            if (!this.myTagNameRead) {
                CharSequence charSequence = range.subSequence(baseLexer.getBufferSequence());
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
                CharSequence tagName = charSequence;
                this.myWithinTag = this.isInterestedInTag(tagName);
                if (this.myWithinTag) {
                    this.myTagName = tagName;
                }
                this.myTagNameRead = true;
            } else if (this.myWithinTag) {
                CharSequence charSequence = range.subSequence(baseLexer.getBufferSequence());
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
                CharSequence attributeName = charSequence;
                this.embedment = this.isInterestedInAttribute(attributeName);
                this.myAttributeName = this.embedment ? attributeName : null;
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_TAG_END) || Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_END_TAG_START) || Intrinsics.areEqual((Object)iElementType, (Object)XmlTokenType.XML_EMPTY_ELEMENT_END)) {
            this.myTagNameRead = tokenType == XmlTokenType.XML_END_TAG_START;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
            this.embedment = false;
        }
    }

    @Override
    protected boolean isStartOfEmbedment(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return this.myAttributeName != null && this.isAttributeEmbedmentToken(tokenType);
    }

    protected boolean isAttributeEmbedmentToken(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        BaseHtmlLexer baseHtmlLexer = this.getLexer();
        CharSequence charSequence = this.myAttributeName;
        Intrinsics.checkNotNull((Object)charSequence);
        return HtmlEmbeddedContentSupportHelperKt.isAttributeEmbedmentToken(baseHtmlLexer, tokenType, charSequence);
    }

    @Override
    @NotNull
    protected Pair<Integer, Integer> findTheEndOfEmbedment() {
        Lexer baseLexer = this.getLexer().getDelegate();
        LexerPosition lexerPosition = baseLexer.getCurrentPosition();
        Intrinsics.checkNotNullExpressionValue((Object)lexerPosition, (String)"getCurrentPosition(...)");
        LexerPosition position = lexerPosition;
        while (true) {
            IElementType iElementType = baseLexer.getTokenType();
            if (iElementType == null || !this.isAttributeEmbedmentToken(iElementType)) break;
            baseLexer.advance();
        }
        Pair result = new Pair((Object)baseLexer.getTokenStart(), (Object)baseLexer.getState());
        baseLexer.restore(position);
        return result;
    }

    @Override
    public void restoreState(@Nullable Object state) {
        if (state == null) {
            this.myTagNameRead = false;
            this.myWithinTag = false;
            this.myTagName = null;
            this.myAttributeName = null;
            this.embedment = false;
            return;
        }
        if (!(state instanceof AttributeState)) {
            return;
        }
        this.myTagNameRead = ((AttributeState)state).getTagNameRead();
        this.myWithinTag = ((AttributeState)state).getWithinTag();
        this.myTagName = ((AttributeState)state).getTagName();
        this.myAttributeName = ((AttributeState)state).getAttributeName();
        this.embedment = ((AttributeState)state).getEmbedment();
    }

    @Override
    public boolean hasState() {
        return this.myTagNameRead || this.myWithinTag || this.myTagName != null || this.myAttributeName != null || this.embedment;
    }

    @Override
    @Nullable
    public Object getState() {
        return this.hasState() ? new AttributeState(this.myTagNameRead, this.myWithinTag, this.myTagName, this.myAttributeName, this.embedment) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/html/embedding/HtmlAttributeEmbeddedContentProvider$AttributeState;", "Lcom/intellij/html/embedding/BaseHtmlEmbeddedContentProvider$BaseState;", "tagNameRead", "", "withinTag", "tagName", "", "attributeName", "embedment", "<init>", "(ZZLjava/lang/CharSequence;Ljava/lang/CharSequence;Z)V", "getTagNameRead", "()Z", "getWithinTag", "getTagName", "()Ljava/lang/CharSequence;", "getAttributeName", "intellij.xml.parser"})
    public static class AttributeState
    extends BaseHtmlEmbeddedContentProvider.BaseState {
        private final boolean tagNameRead;
        private final boolean withinTag;
        @Nullable
        private final CharSequence tagName;
        @Nullable
        private final CharSequence attributeName;

        public AttributeState(boolean tagNameRead, boolean withinTag, @Nullable CharSequence tagName, @Nullable CharSequence attributeName, boolean embedment) {
            super(embedment);
            this.tagNameRead = tagNameRead;
            this.withinTag = withinTag;
            this.tagName = tagName;
            this.attributeName = attributeName;
        }

        public final boolean getTagNameRead() {
            return this.tagNameRead;
        }

        public final boolean getWithinTag() {
            return this.withinTag;
        }

        @Nullable
        public final CharSequence getTagName() {
            return this.tagName;
        }

        @Nullable
        public final CharSequence getAttributeName() {
            return this.attributeName;
        }
    }
}

