/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterceptMethodConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public PsiReference @NotNull [] createReferences(GenericDomValue<String> genericDomValue, PsiElement element, ConvertContext context) {
        return InterceptMethodConverter.createReferences(genericDomValue, element);
    }

    private static PsiReference @NotNull [] createReferences(GenericDomValue<String> genericDomValue, PsiElement element) {
        PsiClass psiClass;
        String stringValue = genericDomValue.getStringValue();
        if (stringValue == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                InterceptMethodConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        LinkedHashSet<PsiReference> resolved = new LinkedHashSet<PsiReference>();
        CommonSpringBean springBean = (CommonSpringBean)DomUtil.getParentOfType(genericDomValue, SpringBean.class, (boolean)true);
        if (springBean == null) {
            springBean = (CommonSpringBean)DomUtil.getParentOfType(genericDomValue, DomSpringBean.class, (boolean)true);
        }
        PsiClass psiClass2 = psiClass = springBean != null ? PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) : null;
        if (psiClass == null || stringValue.contains(".")) {
            PsiReference reference;
            PsiElement psiElement;
            PsiReference[] javaClassReferences;
            PsiReference[] psiReferenceArray = javaClassReferences = InterceptMethodConverter.getJavaClassReferences(element);
            int n = psiReferenceArray.length;
            for (int i = 0; i < n && (psiElement = (reference = psiReferenceArray[i]).resolve()) != null; ++i) {
                resolved.add(reference);
                if (!(psiElement instanceof PsiClass)) continue;
                psiClass = (PsiClass)psiElement;
            }
            if (psiClass == null || stringValue.endsWith(psiClass.getName())) {
                if (javaClassReferences == null) {
                    InterceptMethodConverter.$$$reportNull$$$0(1);
                }
                return javaClassReferences;
            }
        }
        resolved.add(InterceptMethodConverter.createMethodReference(psiClass, element, stringValue));
        PsiReference[] psiReferenceArray = resolved.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            InterceptMethodConverter.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static PsiReference[] getJavaClassReferences(PsiElement element) {
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        provider.setSoft(true);
        return provider.getReferencesByElement(element);
    }

    private static PsiReference createMethodReference(final PsiClass psiClass, PsiElement element, String stringValue) {
        String className = psiClass.getName();
        final String methodName = !stringValue.contains(className) ? stringValue : stringValue.substring(stringValue.indexOf(className) + className.length() + 1).trim();
        TextRange textRange = methodName.isEmpty() ? TextRange.from((int)(element.getText().indexOf(className) + className.length() + 1), (int)0) : TextRange.from((int)element.getText().indexOf(methodName), (int)methodName.length());
        return new PsiReferenceBase<PsiElement>(element, textRange, true){

            public PsiElement resolve() {
                if (!methodName.isEmpty()) {
                    for (PsiMethod psiMethod : psiClass.findMethodsByName(methodName, true)) {
                        if (!psiMethod.hasModifierProperty("public")) continue;
                        return psiMethod;
                    }
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                PsiMethod[] psiMethods = psiClass.getAllMethods();
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(psiMethods.length);
                for (PsiMethod method : psiMethods) {
                    PsiClass containingClass = method.getContainingClass();
                    if (!method.hasModifierProperty("public") || method.isConstructor() || containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName())) continue;
                    methods.add(method);
                }
                Object[] objectArray = ArrayUtil.toObjectArray(methods);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.getElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            InterceptMethodConverter.$$$reportNull$$$0(3);
        }
        return s;
    }

    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            InterceptMethodConverter.$$$reportNull$$$0(4);
        }
        return s;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/model/xml/converters/InterceptMethodConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

