/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.model;

import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteCollation;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J:\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/sqlite/model/SqliteDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "<init>", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeIdentity", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "describeSqliteVirtualTable", "table", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "describeSqliteTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "describeSqliteColumn", "col", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "describeSqliteCheck", "chk", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "describeSqliteKey", "key", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "describeSqliteIndex", "index", "Lcom/intellij/database/dialects/sqlite/model/SqliteIndex;", "describeSqliteIndexingItems", "presentSqliteIndexColumn", "descendants", "", "collation", "i", "", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqliteDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteDescriptionService.kt\ncom/intellij/database/dialects/sqlite/model/SqliteDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class SqliteDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof SqliteVirtualTable ? this.describeSqliteVirtualTable((SqliteVirtualTable)e, context) : (basicElement instanceof SqliteTable ? this.describeSqliteTable((SqliteTable)e, context) : (basicElement instanceof SqliteTableColumn ? this.describeSqliteColumn((SqliteTableColumn)e, context) : (basicElement instanceof SqliteCheck ? this.describeSqliteCheck((SqliteCheck)e, context) : (basicElement instanceof SqliteKey ? this.describeSqliteKey((SqliteKey)e, context) : (basicElement instanceof SqliteIndex ? this.describeSqliteIndex((SqliteIndex)e, context) : super.content(e, context))))));
    }

    @Nullable
    protected String describeIdentity(@NotNull BasicLikeColumn column, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    private final String describeSqliteVirtualTable(SqliteVirtualTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(SqliteVirtualTable.TEMPORARY);
        ((Collection)context.getDescribed()).add(SqliteVirtualTable.MODULE_REF);
        ((Collection)context.getDescribed()).add(SqliteVirtualTable.ARGUMENTS);
        Object res = "virtual table ";
        if (table.isTemporary()) {
            res = "temp " + (String)res;
        }
        if (table.getModuleRef() != null) {
            res = (String)res + this.getName(table.getModuleRef(), (BasicElement)table.getModule());
        }
        res = (String)res + "(" + StringUtil.join((Collection)table.getArguments(), (String)",") + ")";
        return res;
    }

    private final String describeSqliteTable(SqliteTable table, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(SqliteTable.WITHOUT_ROW_ID);
        Object res = this.describeTable((BasicTable)table, context);
        if (table.isWithoutRowId()) {
            res = (String)res + " without rowid";
        }
        return res;
    }

    private final String describeSqliteColumn(SqliteTableColumn col, DescriptionService.Context context) {
        Object res;
        block1: {
            ((Collection)context.getDescribed()).add(SqliteTableColumn.ON_NULL_CONFLICT);
            ((Collection)context.getDescribed()).add(SqliteTableColumn.COLLATION_REF);
            res = null;
            res = DescriptionService.describeColumn$default((DescriptionService)this, (BasicLikeColumn)((BasicLikeColumn)col), (DescriptionService.Context)context, null, (int)4, null);
            if (col.getOnNullConflict() != null) {
                res = res + " on conflict " + col.getOnNullConflict();
            }
            BasicReferenceInfo<? extends SqliteCollation> basicReferenceInfo = col.getCollationRefInfo();
            if (basicReferenceInfo == null) break block1;
            BasicReferenceInfo<? extends SqliteCollation> it = basicReferenceInfo;
            boolean bl = false;
            res = res + " collate " + it.getName();
        }
        return res;
    }

    private final String describeSqliteCheck(SqliteCheck chk, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(SqliteCheck.ON_CONFLICT);
        Object res = this.describeCheck((BasicCheck)chk, context);
        if (chk.getOnConflict() != null) {
            res = (String)res + " on conflict " + chk.getOnConflict();
        }
        return res;
    }

    private final String describeSqliteKey(SqliteKey key, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(SqliteKey.ON_CONFLICT);
        Object res = this.describeKey((BasicKey)key, context);
        if (key.getOnConflict() != null) {
            res = (String)res + " on conflict " + StringUtil.toLowerCase((String)String.valueOf((Object)key.getOnConflict()));
        }
        return res;
    }

    private final String describeSqliteIndex(SqliteIndex index, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(SqliteIndex.CONDITION);
        ((Collection)context.getDescribed()).add(SqliteIndex.UNIQUE);
        ((Collection)context.getDescribed()).add(SqliteIndex.COL_NAMES);
        ((Collection)context.getDescribed()).add(SqliteIndex.REVERSE_COL_NAMES);
        ((Collection)context.getDescribed()).add(SqliteIndex.COLUMN_COLLATION_REFS);
        String inner = this.describeSqliteIndexingItems(index);
        String condition = index.getCondition();
        String d = (index.isUnique() ? "unique" : "index") + " (" + inner + ")";
        if (condition != null) {
            d = d + " when " + condition;
        }
        return d;
    }

    private final String describeSqliteIndexingItems(SqliteIndex index) {
        List list = index.getColNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
        List names = list;
        Set set = index.getReverseColNames();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getReverseColNames(...)");
        Set ds = set;
        List<? extends BasicReferenceInfo<? extends SqliteCollation>> list2 = index.getColumnCollationRefInfos();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getColumnCollationRefInfos(...)");
        List<? extends BasicReferenceInfo<? extends SqliteCollation>> col = list2;
        String representation = !((Collection)names).isEmpty() ? CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)names), (CharSequence)", ", null, null, (int)0, null, arg_0 -> SqliteDescriptionService.describeSqliteIndexingItems$lambda$0(this, index, ds, col, arg_0), (int)30, null) : "???";
        return representation;
    }

    private final String presentSqliteIndexColumn(SqliteIndex index, String column, Set<String> descendants, String collation, int i) {
        Object res = this.presentIndexColumn((BasicIndex)index, column, descendants, i);
        if (StringUtil.isNotEmpty((String)collation)) {
            res = (String)res + " collate " + collation;
        }
        return res;
    }

    private static final CharSequence describeSqliteIndexingItems$lambda$0(SqliteDescriptionService this$0, SqliteIndex $index, Set $ds, List $col, IndexedValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BasicReferenceInfo basicReferenceInfo = (BasicReferenceInfo)CollectionsKt.getOrNull((List)$col, (int)it.getIndex());
        return this$0.presentSqliteIndexColumn($index, (String)it.getValue(), $ds, basicReferenceInfo != null ? basicReferenceInfo.getName() : null, it.getIndex());
    }
}

