/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.AttributeValueSelfReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class IdReferenceProvider
extends PsiReferenceProvider {
    @NonNls
    public static final String FOR_ATTR_NAME = "for";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String STYLE_ID_ATTR_NAME = "styleId";
    @NonNls
    public static final String NAME_ATTR_NAME = "name";
    private static final Set<String> ourNamespacesWithoutNameReference = new HashSet<String>();

    public String[] getIdForAttributeNames() {
        return new String[]{FOR_ATTR_NAME, ID_ATTR_NAME, NAME_ATTR_NAME, STYLE_ID_ATTR_NAME};
    }

    public ElementFilter getIdForFilter() {
        return new ElementFilter(this){

            public boolean isAcceptable(Object element, PsiElement context) {
                XmlTag tag;
                PsiElement grandParent = ((PsiElement)element).getParent().getParent();
                return grandParent instanceof XmlTag && !(tag = (XmlTag)grandParent).getNamespacePrefix().isEmpty();
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            IdReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IdReferenceProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlAttributeValue) {
            boolean allowReferences;
            boolean jsfNs;
            XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)element);
            if (extension != null && extension.hasDynamicComponents(element)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    IdReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            final PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof XmlAttribute)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    IdReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String name = ((XmlAttribute)parentElement).getName();
            String ns = ((XmlAttribute)parentElement).getParent().getNamespace();
            boolean bl = jsfNs = Arrays.asList(XmlUtil.JSF_CORE_URIS).contains(ns) || Arrays.asList(XmlUtil.JSF_HTML_URIS).contains(ns);
            if (FOR_ATTR_NAME.equals(name)) {
                PsiReference[] psiReferenceArray = new PsiReference[1];
                IdRefReference idRefReference = psiReferenceArray[0] = jsfNs && element.getText().indexOf(58) == -1 ? new IdRefReference(element) : new IdRefReference(this, element){

                    @Override
                    public boolean isSoft() {
                        XmlAttributeDescriptor descriptor = ((XmlAttribute)parentElement).getDescriptor();
                        return descriptor != null && !descriptor.hasIdRefType();
                    }
                };
                if (psiReferenceArray == null) {
                    IdReferenceProvider.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }
            boolean bl2 = allowReferences = !ourNamespacesWithoutNameReference.contains(ns);
            if (ID_ATTR_NAME.equals(name) && allowReferences || STYLE_ID_ATTR_NAME.equals(name) || NAME_ATTR_NAME.equals(name) && allowReferences) {
                AttributeValueSelfReference attributeValueSelfReference;
                if (jsfNs) {
                    attributeValueSelfReference = new AttributeValueSelfReference(element);
                } else {
                    if (IdReferenceProvider.hasOuterLanguageElement(element)) {
                        if (PsiReference.EMPTY_ARRAY == null) {
                            IdReferenceProvider.$$$reportNull$$$0(5);
                        }
                        return PsiReference.EMPTY_ARRAY;
                    }
                    attributeValueSelfReference = new GlobalAttributeValueSelfReference(element, true);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{attributeValueSelfReference};
                if (psiReferenceArray == null) {
                    IdReferenceProvider.$$$reportNull$$$0(6);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            IdReferenceProvider.$$$reportNull$$$0(7);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean hasOuterLanguageElement(@NotNull PsiElement element) {
        if (element == null) {
            IdReferenceProvider.$$$reportNull$$$0(8);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof OuterLanguageElement)) continue;
            return true;
        }
        return false;
    }

    static {
        ourNamespacesWithoutNameReference.add("http://java.sun.com/JSP/Page");
        ourNamespacesWithoutNameReference.add("http://struts.apache.org/tags-bean");
        ourNamespacesWithoutNameReference.add("http://jakarta.apache.org/struts/tags-bean");
        ourNamespacesWithoutNameReference.add("http://struts.apache.org/tags-logic");
        Collections.addAll(ourNamespacesWithoutNameReference, XmlUtil.JSTL_CORE_URIS);
        ourNamespacesWithoutNameReference.add("http://struts.apache.org/tags-tiles");
        Collections.addAll(ourNamespacesWithoutNameReference, XmlUtil.SCHEMA_URIS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/IdReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasOuterLanguageElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class GlobalAttributeValueSelfReference
    extends AttributeValueSelfReference {
        private final boolean mySoft;

        public GlobalAttributeValueSelfReference(PsiElement element, boolean soft) {
            super(element);
            this.mySoft = soft;
        }

        @Override
        public boolean isSoft() {
            return this.mySoft;
        }
    }
}

