/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnector;
import com.intellij.platform.lsp.impl.connector.LspProcessHandlerCreatingDescriptor;
import com.intellij.platform.lsp.impl.connector.LspServerProcessListenerBase;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0015J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0019H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnectorSocket;", "Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lsp4jServerConnectorSocket", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "socket", "Ljava/net/Socket;", "outputStream", "Ljava/io/DataOutputStream;", "inputStream", "Ljava/io/DataInputStream;", "processHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "socketInfo", "Lcom/intellij/platform/lsp/api/LspCommunicationChannel$Socket;", "ideToServerStream", "Ljava/io/OutputStream;", "getIdeToServerStream", "()Ljava/io/OutputStream;", "serverToIdeStream", "Ljava/io/InputStream;", "getServerToIdeStream", "()Ljava/io/InputStream;", "prepareConnect", "", "P", "isConnectionAlive", "", "disconnect", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLsp4jServerConnectorSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lsp4jServerConnectorSocket.kt\ncom/intellij/platform/lsp/impl/connector/Lsp4jServerConnectorSocket\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n23#2:105\n*S KotlinDebug\n*F\n+ 1 Lsp4jServerConnectorSocket.kt\ncom/intellij/platform/lsp/impl/connector/Lsp4jServerConnectorSocket\n*L\n96#1:105\n*E\n"})
public final class Lsp4jServerConnectorSocket
extends Lsp4jServerConnector {
    @NotNull
    private final LspServerImpl lspServer;
    private Socket socket;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private BaseProcessHandler<?> processHandler;
    @NotNull
    private final LspCommunicationChannel.Socket socketInfo;

    public Lsp4jServerConnectorSocket(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        super(lspServer);
        this.lspServer = lspServer;
        LspCommunicationChannel lspCommunicationChannel = this.lspServer.getDescriptor().getLspCommunicationChannel();
        Intrinsics.checkNotNull((Object)lspCommunicationChannel, (String)"null cannot be cast to non-null type com.intellij.platform.lsp.api.LspCommunicationChannel.Socket");
        this.socketInfo = (LspCommunicationChannel.Socket)lspCommunicationChannel;
        if (this.socketInfo.getStartProcess()) {
            BaseProcessHandler<?> baseProcessHandler;
            LspServerDescriptor lspServerDescriptor = this.lspServer.getDescriptor();
            BaseProcessHandler baseProcessHandler2 = lspServerDescriptor instanceof LspProcessHandlerCreatingDescriptor ? (BaseProcessHandler)lspServerDescriptor : null;
            if (baseProcessHandler2 == null || (baseProcessHandler2 = baseProcessHandler2.createProcessHandler()) == null) {
                baseProcessHandler2 = (BaseProcessHandler)this.lspServer.getDescriptor().startServerProcess();
            }
            if ((baseProcessHandler = (this.processHandler = baseProcessHandler2)) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                baseProcessHandler = null;
            }
            LspServerImpl lspServerImpl = this.lspServer;
            baseProcessHandler.addProcessListener((ProcessListener)new LspServerProcessListenerBase(lspServerImpl){

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string2 = event.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String string3 = string = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
                    boolean bl2 = false;
                    String string4 = ((CharSequence)string3).length() > 0 ? string : null;
                    if (string4 == null) {
                        return;
                    }
                    String string5 = string4;
                    lspServer.logInfo$intellij_platform_lsp_impl((ProcessOutputType.isStderr(outputType) ? "STDERR" : "STDOUT") + ": " + event.getText());
                    if (ProcessOutputType.isStderr(outputType)) {
                        lspServer.appendServerErrorOutput$intellij_platform_lsp_impl(string5);
                        this.logStdErr(string5);
                    }
                }
            });
            BaseProcessHandler<?> baseProcessHandler3 = this.processHandler;
            if (baseProcessHandler3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                baseProcessHandler3 = null;
            }
            baseProcessHandler3.startNotify();
        }
    }

    @Override
    @NotNull
    protected OutputStream getIdeToServerStream() {
        OutputStream outputStream;
        if (this.outputStream != null) {
            DataOutputStream dataOutputStream = this.outputStream;
            if (dataOutputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputStream");
                dataOutputStream = null;
            }
            outputStream = dataOutputStream;
        } else {
            OutputStream outputStream2 = OutputStream.nullOutputStream();
            outputStream = outputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"nullOutputStream(...)");
        }
        return outputStream;
    }

    @Override
    @NotNull
    protected InputStream getServerToIdeStream() {
        InputStream inputStream;
        if (this.inputStream != null) {
            DataInputStream dataInputStream = this.inputStream;
            if (dataInputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputStream");
                dataInputStream = null;
            }
            inputStream = dataInputStream;
        } else {
            InputStream inputStream2 = InputStream.nullInputStream();
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"nullInputStream(...)");
        }
        return inputStream;
    }

    @Override
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    protected void prepareConnect() {
        Throwable throwable = null;
        if (this.socketInfo.getStartProcess()) {
            for (int i2 = 1; i2 < 11; ++i2) {
                BaseProcessHandler<?> baseProcessHandler = this.processHandler;
                if (baseProcessHandler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                    baseProcessHandler = null;
                }
                if (!baseProcessHandler.getProcess().isAlive() || this.socket != null) break;
                try {
                    this.P();
                    throwable = null;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    this.lspServer.logDebug$intellij_platform_lsp_impl("Attempt " + i2 + ": failed to create a socket connection (port=" + this.socketInfo.getPort() + "): " + throwable2.getMessage());
                    Thread.sleep(1000L);
                    continue;
                }
            }
        } else {
            this.P();
            throwable = null;
        }
        if (throwable != null) {
            LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this.lspServer, "All attempts to create a socket connection failed (port=" + this.socketInfo.getPort() + ")", null, 2, null);
            throw throwable;
        }
    }

    private final void P() {
        this.socket = new Socket(InetAddress.getLoopbackAddress().getHostAddress(), this.socketInfo.getPort());
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        Socket socket2 = this.socket;
        if (socket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket2 = null;
        }
        this.inputStream = new DataInputStream(new BufferedInputStream(socket2.getInputStream()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isConnectionAlive() {
        if (this.socket == null) return false;
        if (this.outputStream == null) return false;
        if (this.inputStream == null) return false;
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            socket = null;
        }
        if (socket.isClosed()) return false;
        if (!this.socketInfo.getStartProcess()) return true;
        BaseProcessHandler<?> baseProcessHandler = this.processHandler;
        if (baseProcessHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
            baseProcessHandler = null;
        }
        if (!baseProcessHandler.isStartNotified()) return false;
        BaseProcessHandler<?> baseProcessHandler2 = this.processHandler;
        if (baseProcessHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
            baseProcessHandler2 = null;
        }
        if (baseProcessHandler2.isProcessTerminated()) return false;
        return true;
    }

    @Override
    protected void disconnect() {
        if (this.socket != null) {
            Socket socket = this.socket;
            if (socket == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                socket = null;
            }
            if (!socket.isClosed()) {
                Closeable[] closeableArray = this;
                boolean bl2 = false;
                Logger logger = Logger.getInstance(Lsp4jServerConnectorSocket.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                closeableArray = new Closeable[1];
                Socket socket2 = this.socket;
                if (socket2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
                    socket2 = null;
                }
                closeableArray[0] = socket2;
                IOUtil.closeSafe((Logger)logger, (Closeable[])closeableArray);
            }
        }
        if (this.processHandler != null) {
            BaseProcessHandler<?> baseProcessHandler = this.processHandler;
            if (baseProcessHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                baseProcessHandler = null;
            }
            if (!baseProcessHandler.isProcessTerminated()) {
                BaseProcessHandler<?> baseProcessHandler2 = this.processHandler;
                if (baseProcessHandler2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                    baseProcessHandler2 = null;
                }
                this.lspServer.logInfo$intellij_platform_lsp_impl("Stopping LSP server process: " + baseProcessHandler2);
                BaseProcessHandler<?> baseProcessHandler3 = this.processHandler;
                if (baseProcessHandler3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"processHandler");
                    baseProcessHandler3 = null;
                }
                ExecutionManagerImpl.Companion.stopProcess((ProcessHandler)baseProcessHandler3);
            }
        }
    }
}

