/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui.settings.db;

import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.help.JpaHelpConstantsKt;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.ui.entity.SGroupCombo;
import com.intellij.jpa.jpb.model.ui.structure.StructureViewUpdateTrigger;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.ChangeLogWriterEP;
import com.intellij.liquibase.common.LiquibaseCommandManager;
import com.intellij.liquibase.common.LiquibaseFileType;
import com.intellij.liquibase.common.config.DatabaseInfo;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.config.DiffGenerationConfig;
import com.intellij.liquibase.common.gui.settings.db.DatabaseVersioningConfigurableKt;
import com.intellij.liquibase.common.gui.settings.db.DbTypeSelectionPanel;
import com.intellij.liquibase.common.gui.settings.db.LiquibaseChangesetTemplatesPanel;
import com.intellij.liquibase.common.gui.settings.db.LiquibasePanel;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.ClassUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseCommonPanel;", "Lcom/intellij/liquibase/common/gui/settings/db/LiquibasePanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "liquibaseVersionField", "Lcom/intellij/ui/components/JBTextField;", "liquibaseAuthorField", "liquibaseTypeField", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/liquibase/common/LiquibaseFileType;", "liquibaseRollbackField", "Lcom/intellij/ui/components/JBCheckBox;", "mainChangelogDirField", "mainChangelogNameField", "secondaryChangelogDirField", "secondaryChangelogNameField", "state", "Lcom/intellij/liquibase/common/config/DatabaseMigrationState;", "getState", "()Lcom/intellij/liquibase/common/config/DatabaseMigrationState;", "dbTypeCheckBoxPanel", "Lcom/intellij/liquibase/common/gui/settings/db/DbTypeSelectionPanel;", "liquibaseChangesetTemplatesPanel", "Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseChangesetTemplatesPanel;", "wrapLiquibaseVersionFieldIfNeed", "Ljavax/swing/JComponent;", "createChangeLogTemplatePanel", "Ljavax/swing/JPanel;", "loadFromState", "", "getDefaultChangeSetAuthor", "", "saveToState", "NameStrategyRender", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseCommonPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseCommonPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/LiquibaseCommonPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1563#2:195\n1634#2,3:196\n774#2:202\n865#2,2:203\n1563#2:205\n1634#2,3:206\n37#3,2:199\n1#4:201\n*S KotlinDebug\n*F\n+ 1 LiquibaseCommonPanel.kt\ncom/intellij/liquibase/common/gui/settings/db/LiquibaseCommonPanel\n*L\n58#1:195\n58#1:196,3\n133#1:202\n133#1:203,2\n133#1:205\n133#1:206,3\n58#1:199,2\n*E\n"})
public final class LiquibaseCommonPanel
extends LiquibasePanel {
    @NotNull
    private final JBTextField liquibaseVersionField;
    @NotNull
    private final JBTextField liquibaseAuthorField;
    @NotNull
    private final ComboBox<LiquibaseFileType> liquibaseTypeField;
    @NotNull
    private final JBCheckBox liquibaseRollbackField;
    @NotNull
    private final JBTextField mainChangelogDirField;
    @NotNull
    private final JBTextField mainChangelogNameField;
    @NotNull
    private final JBTextField secondaryChangelogDirField;
    @NotNull
    private final JBTextField secondaryChangelogNameField;
    @NotNull
    private final DatabaseMigrationState state;
    @NotNull
    private DbTypeSelectionPanel dbTypeCheckBoxPanel;
    @NotNull
    private LiquibaseChangesetTemplatesPanel liquibaseChangesetTemplatesPanel;

    /*
     * WARNING - void declaration
     */
    public LiquibaseCommonPanel(@NotNull Project project) {
        void $this$_init__u24lambda_u243;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.liquibaseVersionField = new JBTextField();
        this.liquibaseAuthorField = new JBTextField();
        this.liquibaseTypeField = new ComboBox();
        this.liquibaseRollbackField = new JBCheckBox(LiquibaseResourceBundle.message("changeSet.addRollback", new Object[0]));
        this.mainChangelogDirField = new JBTextField();
        this.mainChangelogNameField = new JBTextField();
        this.secondaryChangelogDirField = new JBTextField();
        this.secondaryChangelogNameField = new JBTextField();
        this.state = DatabaseMigrationConfig.Companion.getInstance(project).getState();
        this.setLayout(new BorderLayout());
        this.liquibaseVersionField.getDocument().addDocumentListener(this.getDocumentListener());
        this.liquibaseAuthorField.getDocument().addDocumentListener(this.getDocumentListener());
        this.mainChangelogNameField.getDocument().addDocumentListener(this.getDocumentListener());
        this.mainChangelogDirField.getDocument().addDocumentListener(this.getDocumentListener());
        Iterable $this$map$iv = ChangeLogWriterEP.Companion.getAll(project);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChangeLogWriterEP changeLogWriterEP = (ChangeLogWriterEP)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.supportedFileType());
        }
        Object $this$toTypedArray$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LiquibaseFileType[] fileTypeItems = thisCollection$iv.toArray(new LiquibaseFileType[0]);
        this.liquibaseTypeField.setModel((ComboBoxModel)new DefaultComboBoxModel<LiquibaseFileType>(fileTypeItems));
        this.liquibaseTypeField.addItemListener(arg_0 -> LiquibaseCommonPanel._init_$lambda$1(this, arg_0));
        this.liquibaseRollbackField.addItemListener(arg_0 -> LiquibaseCommonPanel._init_$lambda$2(this, arg_0));
        this.secondaryChangelogDirField.getDocument().addDocumentListener(this.getDocumentListener());
        this.secondaryChangelogNameField.getDocument().addDocumentListener(this.getDocumentListener());
        Object $i$f$toTypedArray22 = $this$toTypedArray$iv = new DbTypeSelectionPanel(null, 2, 1, null);
        object = this;
        boolean bl = false;
        $this$_init__u24lambda_u243.setBorder((Border)IdeBorderFactory.createTitledBorder((String)LiquibaseResourceBundle.message("liquibase.db.types", new Object[0]), (boolean)false, (Insets)((Insets)JBUI.insetsTop((int)JBUI.scale((int)4)))));
        ((LiquibaseCommonPanel)object).dbTypeCheckBoxPanel = $this$toTypedArray$iv;
        this.liquibaseChangesetTemplatesPanel = new LiquibaseChangesetTemplatesPanel(project);
        FormBuilder form = FormBuilder.createFormBuilder().addLabeledComponent(LiquibaseResourceBundle.messageWithColon("liquibase.version", new Object[0]), this.wrapLiquibaseVersionFieldIfNeed()).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("changeSet.author", new Object[0]), (JComponent)this.liquibaseAuthorField).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("changeSet.fileType", new Object[0]), (JComponent)this.liquibaseTypeField).addComponent((JComponent)this.liquibaseRollbackField).addComponent((JComponent)this.createChangeLogTemplatePanel()).addComponent((JComponent)this.dbTypeCheckBoxPanel).addComponent((JComponent)this.liquibaseChangesetTemplatesPanel);
        this.dbTypeCheckBoxPanel.addActionListener(this.getModifyListener());
        this.liquibaseChangesetTemplatesPanel.addActionListener(this.getModifyListener());
        this.add((Component)form.getPanel(), "North");
    }

    @NotNull
    public final DatabaseMigrationState getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent wrapLiquibaseVersionFieldIfNeed() {
        String detectedLiquibaseVersion = LiquibaseCommandManager.Companion.getInstance(this.getProject()).findAutoDetectLiquibaseVersion();
        if (detectedLiquibaseVersion == null && this.state.getLiquibaseVersion() == null) {
            void it;
            JLabel jLabel;
            BorderLayoutPanel borderLayoutPanel;
            BorderLayoutPanel $this$wrapLiquibaseVersionFieldIfNeed_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel();
            boolean bl = false;
            $this$wrapLiquibaseVersionFieldIfNeed_u24lambda_u240.addToCenter((Component)this.liquibaseVersionField);
            JLabel jLabel2 = jLabel = ComponentPanelBuilder.createCommentComponent((String)LiquibaseResourceBundle.message("notification.specify.liquibase.version", new Object[0]), (boolean)true);
            BorderLayoutPanel borderLayoutPanel2 = $this$wrapLiquibaseVersionFieldIfNeed_u24lambda_u240;
            boolean bl2 = false;
            it.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            borderLayoutPanel2.addToBottom((Component)jLabel);
            return (JComponent)borderLayoutPanel;
        }
        return (JComponent)this.liquibaseVersionField;
    }

    private final JPanel createChangeLogTemplatePanel() {
        String helpUrl = JpaHelpConstantsKt.helpUrlWithoutPrefix((String)JpaHelpConstants.PluginDoc.INSTANCE.getChangelogTemplates());
        JPanel panel = FormBuilder.createFormBuilder().addLabeledComponent(LiquibaseResourceBundle.messageWithColon("primary.changelog.dir", new Object[0]), DatabaseVersioningConfigurableKt.wrapToVelocityHelpPanel((JComponent)this.mainChangelogDirField, helpUrl)).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("primary.changelog.name", new Object[0]), DatabaseVersioningConfigurableKt.wrapToVelocityHelpPanel((JComponent)this.mainChangelogNameField, helpUrl)).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("secondary.changelog.dir", new Object[0]), DatabaseVersioningConfigurableKt.wrapToVelocityHelpPanel((JComponent)this.secondaryChangelogDirField, helpUrl)).addLabeledComponent(LiquibaseResourceBundle.messageWithColon("secondary.changelog.name", new Object[0]), DatabaseVersioningConfigurableKt.wrapToVelocityHelpPanel((JComponent)this.secondaryChangelogNameField, helpUrl)).getPanel();
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)LiquibaseResourceBundle.message("liquibase.changelog.templates", new Object[0]), (boolean)false, (Insets)((Insets)JBUI.insetsTop((int)JBUI.scale((int)4)))));
        Intrinsics.checkNotNull((Object)panel);
        return panel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadFromState() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DatabaseInfo it;
        void $this$filterTo$iv$iv;
        String string;
        this.mainChangelogDirField.setText(this.state.getMainChangeLogDir());
        this.mainChangelogNameField.setText(this.state.getMainChangeLogName());
        this.secondaryChangelogDirField.setText(this.state.getSecondaryChangeLogDir());
        this.secondaryChangelogNameField.setText(this.state.getSecondaryChangeLogName());
        this.liquibaseVersionField.setText(this.state.getLiquibaseVersion());
        String autoDetectLiquibaseVersion = LiquibaseCommandManager.Companion.getInstance(this.getProject()).findAutoDetectLiquibaseVersion();
        StatusText statusText = this.liquibaseVersionField.getEmptyText();
        if (autoDetectLiquibaseVersion == null) {
            string = LiquibaseResourceBundle.message("SettingsPage.liquibase.libraryNotFound", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{autoDetectLiquibaseVersion};
            string = LiquibaseResourceBundle.message("SettingsPage.liquibase.autoDetectedVersion", objectArray);
        }
        statusText.setText(string);
        DiffGenerationConfig projectUserState = DiffGenerationConfig.Companion.getInstance(this.getProject());
        this.liquibaseAuthorField.setText(projectUserState.getLiquibaseAuthor());
        this.liquibaseTypeField.setItem((Object)this.state.getLiquibaseFileType());
        this.liquibaseRollbackField.setSelected(this.state.isCreateRollback());
        this.liquibaseAuthorField.getEmptyText().setText(DiffGenerationConfig.Companion.getDefaultChangeSetAuthor());
        Iterable $this$filter$iv = this.state.getDatabaseInfos();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DatabaseInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DatabaseInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDbmsId());
        }
        List selectedDatabaseIds = (List)destination$iv$iv;
        this.dbTypeCheckBoxPanel.setSelectedDbIds(selectedDatabaseIds);
        this.liquibaseChangesetTemplatesPanel.loadFromState();
    }

    private final String getDefaultChangeSetAuthor() {
        String author = System.getProperty("user.name");
        return StringUtil.isEmpty((String)author) ? "diff-generated" : author + " (generated)";
    }

    @Override
    public void saveToState() {
        CharSequence charSequence;
        CharSequence charSequence2;
        this.dbTypeCheckBoxPanel.commit(this.state);
        this.liquibaseChangesetTemplatesPanel.saveToState();
        String string = this.mainChangelogDirField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.state.setMainChangeLogDir(((Object)StringsKt.trim((CharSequence)string)).toString());
        String string2 = this.mainChangelogNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.state.setMainChangeLogName(((Object)StringsKt.trim((CharSequence)string2)).toString());
        String string3 = this.secondaryChangelogDirField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        this.state.setSecondaryChangeLogDir(((Object)StringsKt.trim((CharSequence)string3)).toString());
        String string4 = this.secondaryChangelogNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        this.state.setSecondaryChangeLogName(((Object)StringsKt.trim((CharSequence)string4)).toString());
        Object object = this.liquibaseTypeField.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        this.state.setLiquibaseFileType((LiquibaseFileType)((Object)object));
        this.state.setCreateRollback(this.liquibaseRollbackField.isSelected());
        CharSequence charSequence3 = this.liquibaseVersionField.getText();
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            boolean bl = false;
            charSequence2 = null;
        } else {
            charSequence2 = charSequence3;
        }
        String newLiquibaseVersion = (String)charSequence2;
        if (!Intrinsics.areEqual((Object)newLiquibaseVersion, (Object)this.state.getLiquibaseVersion()) && (StringUtil.isEmpty((String)newLiquibaseVersion) || StringUtil.isEmpty((String)this.state.getLiquibaseVersion()))) {
            StructureViewUpdateTrigger.update$default((StructureViewUpdateTrigger)((StructureViewUpdateTrigger)this.getProject().getMessageBus().syncPublisher(StructureViewUpdateTrigger.TOPIC)), null, (int)1, null);
        }
        DatabaseMigrationState databaseMigrationState = this.state;
        charSequence3 = this.liquibaseVersionField.getText();
        if (StringsKt.isBlank((CharSequence)charSequence3)) {
            DatabaseMigrationState databaseMigrationState2 = databaseMigrationState;
            boolean bl = false;
            charSequence = null;
            databaseMigrationState = databaseMigrationState2;
        } else {
            charSequence = charSequence3;
        }
        databaseMigrationState.setLiquibaseVersion((String)charSequence);
        DiffGenerationConfig projectUserState = DiffGenerationConfig.Companion.getInstance(this.getProject());
        String string5 = this.liquibaseAuthorField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        projectUserState.setLiquibaseAuthor(((Object)StringsKt.trim((CharSequence)string5)).toString());
    }

    private static final void _init_$lambda$1(LiquibaseCommonPanel this$0, ItemEvent it) {
        this$0.setModified(true);
    }

    private static final void _init_$lambda$2(LiquibaseCommonPanel this$0, ItemEvent it) {
        this$0.setModified(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JF\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/LiquibaseCommonPanel$NameStrategyRender;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/jpa/jpb/model/ui/entity/SGroupCombo$ListItem;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.liquibase.common"})
    public static final class NameStrategyRender
    extends ColoredListCellRenderer<SGroupCombo.ListItem<String>> {
        @NotNull
        private final Project project;

        public NameStrategyRender(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends SGroupCombo.ListItem<String>> list, @Nullable SGroupCombo.ListItem<String> value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value == null || value.getValue() == null) {
                if (JpaUtils.isUltimate()) {
                    this.append(LiquibaseResourceBundle.message("liquibase.common.panel.use.persistent.unit.strategy", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    Object[] objectArray = new Object[]{PhysicalNamingStrategy.Companion.getDefaultNamingStrategy(this.project)};
                    this.append(LiquibaseResourceBundle.message("liquibase.common.panel.useByDefault", objectArray), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            } else {
                Object object = value.getValue();
                Intrinsics.checkNotNull((Object)object);
                String className = (String)object;
                this.append(ClassUtil.extractClassName((String)className));
                this.append(" " + ClassUtil.extractPackageName((String)className), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }
}

