/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.findUsages.JSFindUsagesDynamicFilterValue;
import com.intellij.lang.javascript.findUsages.JSFindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptFindUsagesConfiguration {
    private final Project myProject;
    private JSFindUsagesOptions myFindUsagesOptions;
    private final JSFindUsagesDynamicFilterValue myDynamicFilterValueJS = new JSFindUsagesDynamicFilterValue(false);
    private final JSFindUsagesDynamicFilterValue myDynamicFilterValueTS = new JSFindUsagesDynamicFilterValue(false);

    public JavaScriptFindUsagesConfiguration(Project project) {
        this.myProject = project;
    }

    public static JSFindUsagesOptions getFindUsagesOptions(Project project, DataContext dataContext) {
        return JavaScriptFindUsagesConfiguration.getService(project).getOptions(dataContext);
    }

    private static JavaScriptFindUsagesConfiguration getService(Project project) {
        return (JavaScriptFindUsagesConfiguration)project.getService(JavaScriptFindUsagesConfiguration.class);
    }

    private JSFindUsagesOptions getOptions(DataContext dataContext) {
        if (this.myFindUsagesOptions == null) {
            this.myFindUsagesOptions = new JSFindUsagesOptions(this.myProject, dataContext);
            this.myFindUsagesOptions.isUsages = true;
            this.myFindUsagesOptions.isSearchForTextOccurrences = false;
        }
        return this.myFindUsagesOptions;
    }

    public static JSFindUsagesDynamicFilterValue getFindUsagesDynamicFilterValue(@NotNull Project project, @Nullable Language language) {
        if (project == null) {
            JavaScriptFindUsagesConfiguration.$$$reportNull$$$0(0);
        }
        if (language instanceof JSLanguageDialect) {
            JSLanguageDialect jsLanguageDialect = (JSLanguageDialect)language;
            if (jsLanguageDialect.getOptionHolder().isTypeScript) {
                return JavaScriptFindUsagesConfiguration.getService((Project)project).myDynamicFilterValueTS;
            }
        }
        return JavaScriptFindUsagesConfiguration.getService((Project)project).myDynamicFilterValueJS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/findUsages/JavaScriptFindUsagesConfiguration", "getFindUsagesDynamicFilterValue"));
    }
}

