/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.intentions;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.intentions.util.ImportPathData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/protobuf/lang/intentions/PbAddImportPathUndoableAction;", "Lcom/intellij/openapi/command/undo/UndoableAction;", "pathToAdd", "Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/protobuf/lang/intentions/util/ImportPathData;Lcom/intellij/openapi/project/Project;)V", "currentDocumentReference", "Lcom/intellij/openapi/command/undo/DocumentReference;", "Lorg/jetbrains/annotations/NotNull;", "importPath", "Lcom/intellij/protobuf/ide/settings/PbProjectSettings$ImportPathEntry;", "undo", "", "redo", "performedNanoTime", "", "getPerformedNanoTime", "setPerformedNanoTime", "l", "getAffectedDocuments", "", "()[Lcom/intellij/openapi/command/undo/DocumentReference;", "isGlobal", "", "intellij.protoeditor.core"})
@SourceDebugExtension(value={"SMAP\nPbAddImportPathUndoableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PbAddImportPathUndoableAction.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportPathUndoableAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n774#2:42\n865#2,2:43\n*S KotlinDebug\n*F\n+ 1 PbAddImportPathUndoableAction.kt\ncom/intellij/protobuf/lang/intentions/PbAddImportPathUndoableAction\n*L\n17#1:42\n17#1:43,2\n*E\n"})
public final class PbAddImportPathUndoableAction
implements UndoableAction {
    @NotNull
    private final Project project;
    @NotNull
    private final DocumentReference currentDocumentReference;
    @NotNull
    private final PbProjectSettings.ImportPathEntry importPath;
    private long performedNanoTime;

    public PbAddImportPathUndoableAction(@NotNull ImportPathData pathToAdd, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)pathToAdd, (String)"pathToAdd");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        DocumentReference documentReference = DocumentReferenceManager.getInstance().create(pathToAdd.getOriginalPbVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"create(...)");
        this.currentDocumentReference = documentReference;
        this.importPath = new PbProjectSettings.ImportPathEntry(pathToAdd.getEffectiveImportPathUrl(), "");
        this.performedNanoTime = -1L;
    }

    /*
     * WARNING - void declaration
     */
    public void undo() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (this.project.isDisposed()) {
            return;
        }
        PbProjectSettings projectSettings = PbProjectSettings.getInstance(this.project);
        List<PbProjectSettings.ImportPathEntry> list = projectSettings.getImportPathEntries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImportPathEntries(...)");
        Iterable iterable = list;
        PbProjectSettings pbProjectSettings = projectSettings;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PbProjectSettings.ImportPathEntry it = (PbProjectSettings.ImportPathEntry)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)this.importPath))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        pbProjectSettings.setImportPathEntries((List)destination$iv$iv);
        PbProjectSettings.notifyUpdated(this.project);
    }

    public void redo() {
        if (this.project.isDisposed()) {
            return;
        }
        PbProjectSettings projectSettings = PbProjectSettings.getInstance(this.project);
        Collection collection = CollectionsKt.listOf((Object)this.importPath);
        List<PbProjectSettings.ImportPathEntry> list = projectSettings.getImportPathEntries();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getImportPathEntries(...)");
        projectSettings.setImportPathEntries(CollectionsKt.plus((Collection)collection, (Iterable)list));
        PbProjectSettings.notifyUpdated(this.project);
    }

    public long getPerformedNanoTime() {
        return this.performedNanoTime;
    }

    public void setPerformedNanoTime(long l) {
        this.performedNanoTime = l;
    }

    @NotNull
    public DocumentReference[] getAffectedDocuments() {
        DocumentReference[] documentReferenceArray = new DocumentReference[]{this.currentDocumentReference};
        return documentReferenceArray;
    }

    public boolean isGlobal() {
        return true;
    }
}

