/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.quarkus.QuarkusUtils;
import com.intellij.quarkus.config.QsConfigKeyData;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.run.QsRunConfiguration;
import com.intellij.quarkus.run.QsRunConfigurationTypeKt;
import com.intellij.quarkus.run.QsServerConfiguration;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0003J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService;", "", "<init>", "()V", "createRunConfiguration", "", "module", "Lcom/intellij/openapi/module/Module;", "getServerConfiguration", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "javaParams", "Lcom/intellij/execution/configurations/JavaParameters;", "doCreateRunConfiguration", "runManager", "Lcom/intellij/execution/RunManager;", "findPropertyValue", "", "propertyKey", "findPropertyValueInConfigs", "getActiveProfile", "Companion", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsRunConfigurationService.kt\ncom/intellij/quarkus/run/QsRunConfigurationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n808#2,11:139\n13#3:150\n*S KotlinDebug\n*F\n+ 1 QsRunConfigurationService.kt\ncom/intellij/quarkus/run/QsRunConfigurationService\n*L\n34#1:139,11\n71#1:150\n*E\n"})
public final class QsRunConfigurationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<QsServerConfiguration> SERVER_CONFIGURATION_KEY;
    @NotNull
    private static final Key<Integer> APPLICATION_SERVER_PORT_KEY;
    @NotNull
    private static final QsServerConfiguration DEFAULT_SERVER_CONFIGURATION;

    /*
     * WARNING - void declaration
     */
    public final void createRunConfiguration(@NotNull Module module) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RunManager runManager = RunManager.Companion.getInstance(project);
        Iterable iterable = runManager.getConfigurationsList((ConfigurationType)QsRunConfigurationTypeKt.qsRunConfigurationType());
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof QsRunConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allConfigs = (List)destination$iv$iv;
        for (QsRunConfiguration config : allConfigs) {
            if (!Intrinsics.areEqual((Object)module, (Object)config.getConfigurationModule().getModule())) continue;
            return;
        }
        if (module.isDisposed()) {
            return;
        }
        this.doCreateRunConfiguration(module, runManager);
    }

    @Nullable
    public final QsServerConfiguration getServerConfiguration(@NotNull JavaParameters javaParams, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)javaParams, (String)"javaParams");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return DEFAULT_SERVER_CONFIGURATION;
        }
        return (QsServerConfiguration)ReadAction.nonBlocking(() -> QsRunConfigurationService.getServerConfiguration$lambda$0(module, this, javaParams)).executeSynchronously();
    }

    private final void doCreateRunConfiguration(Module module, RunManager runManager) {
        try {
            RunnerAndConfigurationSettings settings = runManager.createConfiguration("", QsRunConfigurationTypeKt.qsRunConfigurationType().getConfigurationFactories()[0]);
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.quarkus.run.QsRunConfiguration");
            QsRunConfiguration newRunConfig = (QsRunConfiguration)runConfiguration;
            newRunConfig.setModule(module);
            settings.setName(newRunConfig.suggestedName());
            newRunConfig.setGeneratedName();
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
            if (runManager.getAllSettings().size() == 1) {
                runManager.setSelectedConfiguration(settings);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(QsRunConfigurationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error creating Quarkus run configuration for module " + module.getName(), t);
        }
    }

    @RequiresBackgroundThread
    private final QsServerConfiguration getServerConfiguration(Module module, JavaParameters javaParams) {
        int n;
        String insecureRequests;
        boolean hasQuarkusHttpConfiguration = QuarkusUtils.INSTANCE.hasQuarkusHttpConfiguration(module);
        if (!hasQuarkusHttpConfiguration) {
            return null;
        }
        String string = this.findPropertyValue(javaParams, module, "quarkus.http.insecure-requests");
        if (string == null) {
            string = "enabled";
        }
        boolean sslEnabled = !StringsKt.equals((String)"enabled", (String)(insecureRequests = string), (boolean)false);
        String portProperty = null;
        int defaultPort = 0;
        if (sslEnabled) {
            portProperty = "quarkus.http.ssl-port";
            defaultPort = 8443;
        } else {
            portProperty = "quarkus.http.port";
            defaultPort = 8080;
        }
        try {
            String string2 = this.findPropertyValue(javaParams, module, portProperty);
            n = string2 != null ? Integer.parseInt(string2) : defaultPort;
        }
        catch (NumberFormatException e) {
            n = defaultPort;
        }
        int serverPort = n;
        return new QsServerConfiguration(serverPort, sslEnabled);
    }

    private final String findPropertyValue(JavaParameters javaParams, Module module, String propertyKey) {
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(propertyKey);
        CharSequence charSequence = fromVmOptions;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return fromVmOptions;
        }
        Object object = javaParams.getProgramParametersList();
        String fromArguments = object != null && (object = object.getProperties()) != null ? (String)object.get(propertyKey) : null;
        CharSequence charSequence2 = fromArguments;
        if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
            return fromArguments;
        }
        return this.findPropertyValueInConfigs(javaParams, module, propertyKey);
    }

    private final String findPropertyValueInConfigs(JavaParameters javaParams, Module module, String propertyKey) {
        String activeProfile = this.getActiveProfile(javaParams);
        QsConfigValueSearcher searcher = new QsConfigValueSearcher(module, false, new QsConfigKeyData(propertyKey, null, 2, null), activeProfile, false, null, 48, null);
        String value = searcher.findValueText();
        CharSequence charSequence = value;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
    }

    private final String getActiveProfile(JavaParameters javaParams) {
        String value = javaParams.getVMParametersList().getPropertyValue("quarkus.profile");
        CharSequence charSequence = value;
        return charSequence == null || charSequence.length() == 0 ? "dev" : value;
    }

    private static final QsServerConfiguration getServerConfiguration$lambda$0(Module $module, QsRunConfigurationService this$0, JavaParameters $javaParams) {
        if ($module.isDisposed()) {
            return null;
        }
        return this$0.getServerConfiguration($module, $javaParams);
    }

    static {
        Key key = Key.create((String)"QUARKUS_SERVER_CONFIGURATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SERVER_CONFIGURATION_KEY = key;
        Key key2 = Key.create((String)"QUARKUS_APPLICATION_SERVER_PORT");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        APPLICATION_SERVER_PORT_KEY = key2;
        DEFAULT_SERVER_CONFIGURATION = new QsServerConfiguration(8080, false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/quarkus/run/QsRunConfigurationService$Companion;", "", "<init>", "()V", "SERVER_CONFIGURATION_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/quarkus/run/QsServerConfiguration;", "getSERVER_CONFIGURATION_KEY", "()Lcom/intellij/openapi/util/Key;", "APPLICATION_SERVER_PORT_KEY", "", "getAPPLICATION_SERVER_PORT_KEY", "DEFAULT_SERVER_CONFIGURATION", "getDEFAULT_SERVER_CONFIGURATION", "()Lcom/intellij/quarkus/run/QsServerConfiguration;", "getInstance", "Lcom/intellij/quarkus/run/QsRunConfigurationService;", "intellij.quarkus"})
    @SourceDebugExtension(value={"SMAP\nQsRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsRunConfigurationService.kt\ncom/intellij/quarkus/run/QsRunConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n*S KotlinDebug\n*F\n+ 1 QsRunConfigurationService.kt\ncom/intellij/quarkus/run/QsRunConfigurationService$Companion\n*L\n136#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<QsServerConfiguration> getSERVER_CONFIGURATION_KEY() {
            return SERVER_CONFIGURATION_KEY;
        }

        @NotNull
        public final Key<Integer> getAPPLICATION_SERVER_PORT_KEY() {
            return APPLICATION_SERVER_PORT_KEY;
        }

        @NotNull
        public final QsServerConfiguration getDEFAULT_SERVER_CONFIGURATION() {
            return DEFAULT_SERVER_CONFIGURATION;
        }

        @NotNull
        public final QsRunConfigurationService getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<QsRunConfigurationService> serviceClass$iv = QsRunConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (QsRunConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

