/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2.refactoring;

import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.util.DdlBuilder;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import com.intellij.sql.refactoring.extractFunction.SqlExtractableParameterInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/dialects/db2/refactoring/Db2ExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "<init>", "()V", "supportsTableFunctions", "", "getSupportsTableFunctions", "()Z", "generateParameter", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "param", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractableParameterInfo;", "generateBody", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateTableCallExpression", "intellij.database.dialects.db2"})
public final class Db2ExtractFunctionHelper
extends SqlExtractFunctionHelper {
    @NotNull
    public static final Db2ExtractFunctionHelper INSTANCE = new Db2ExtractFunctionHelper();

    private Db2ExtractFunctionHelper() {
    }

    public boolean getSupportsTableFunctions() {
        return true;
    }

    protected void generateParameter(@NotNull DdlBuilder builder, @NotNull SqlExtractableParameterInfo param) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        String direction = switch (WhenMappings.$EnumSwitchMapping$0[param.getDirection().ordinal()]) {
            case 1 -> "out ";
            case 2 -> "inout ";
            default -> "";
        };
        builder.keyword(direction);
        super.generateParameter(builder, param);
    }

    public void generateBody(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        this.generateBodyStatement(builder, functionInfo);
    }

    protected void generateTableCallExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        builder.keyword("table");
        builder.symbol("(");
        this.generateCallExpression(builder, functionInfo);
        builder.symbol(")");
        if (functionInfo.getCodeInfo().isTableFunction() && !(functionInfo.getCodeInfo().getOriginalExpression().getParent() instanceof SqlAsExpression)) {
            String string = SqlNamesGenerator.suggestAliasName((SqlExpression)functionInfo.getCodeInfo().getOriginalExpression());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestAliasName(...)");
            String aliasName = string;
            builder.symbol(" ").alias(aliasName);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArgumentDirection.values().length];
            try {
                nArray[ArgumentDirection.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgumentDirection.INOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

