/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.mapping;

import com.intellij.jam.model.common.BaseImpl;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerBinding;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethod;
import com.intellij.jpa.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.jpa.model.xml.persistence.mapping.EntityBase;
import com.intellij.jpa.model.xml.persistence.mapping.EntityListener;
import com.intellij.jpa.model.xml.persistence.mapping.LifecycleCallback;
import com.intellij.jpa.model.xml.persistence.mapping.PersistenceUnitDefaults;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nullable;

public abstract class EntityListenerImpl
extends BaseImpl
implements EntityListener {
    @Override
    public void processEntityListenerBindings(Processor<EntityListenerBinding> processor) {
        final EntityBase entityBase = (EntityBase)this.getParentOfType(EntityBase.class, true);
        if (entityBase != null) {
            processor.process((Object)new EntityListenerBinding(){

                @Override
                @Nullable
                public String getEntityBaseClassName() {
                    return entityBase.getClazz().getStringValue();
                }

                @Override
                public PersistentEntityBase getTargetObject() {
                    return entityBase;
                }

                @Override
                public void delete() {
                    EntityListenerImpl.this.undefine();
                }
            });
        } else {
            PersistenceUnitDefaults unitDefaults = (PersistenceUnitDefaults)this.getParentOfType(PersistenceUnitDefaults.class, true);
            if (unitDefaults != null) {
                processor.process((Object)new EntityListenerBinding(){

                    @Override
                    @Nullable
                    public String getEntityBaseClassName() {
                        return "*";
                    }

                    @Override
                    public PersistentEntityBase getTargetObject() {
                        return null;
                    }

                    @Override
                    public void delete() {
                        EntityListenerImpl.this.undefine();
                    }
                });
            }
        }
    }

    @Override
    public void processEntityListenerMethods(@Nullable PsiClass currentClass, Processor<EntityListenerMethod> processor) {
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPostLoad(), EntityListenerMethodType.POST_LOAD, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPostPersist(), EntityListenerMethodType.POST_PERSIST, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPostRemove(), EntityListenerMethodType.POST_REMOVE, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPostUpdate(), EntityListenerMethodType.POST_UPDATE, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPrePersist(), EntityListenerMethodType.PRE_PERSIST, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPreRemove(), EntityListenerMethodType.PRE_REMOVE, currentClass, processor)) {
            return;
        }
        if (!EntityListenerImpl.processLifecycleCallback((PsiClass)this.getClazz().getValue(), this.getPreUpdate(), EntityListenerMethodType.PRE_UPDATE, currentClass, processor)) {
            return;
        }
    }

    static boolean processLifecycleCallback(PsiClass rootClass, LifecycleCallback callback, EntityListenerMethodType type, PsiClass currentClass, Processor<? super EntityListenerMethod> processor) {
        PsiClass targetClass;
        boolean checkDeep = currentClass == null;
        PsiClass psiClass = targetClass = checkDeep ? rootClass : currentClass;
        if (targetClass == null || rootClass != null && !checkDeep && targetClass != rootClass) {
            return true;
        }
        for (PsiMethod psiMethod : targetClass.findMethodsByName(callback.getMethodName().getStringValue(), checkDeep)) {
            if (processor.process((Object)EntityListenerImpl.createEntityListenerMethod(psiMethod, type, callback))) continue;
            return false;
        }
        return true;
    }

    private static EntityListenerMethod createEntityListenerMethod(PsiMethod psiMethod, EntityListenerMethodType type, LifecycleCallback element) {
        return new MyEntityListenerMethod(psiMethod, type, element);
    }

    private static class MyEntityListenerMethod
    implements EntityListenerMethod {
        private final PsiMethod myPsiMethod;
        private final EntityListenerMethodType myType;
        private final LifecycleCallback myElement;

        MyEntityListenerMethod(PsiMethod psiMethod, EntityListenerMethodType type, LifecycleCallback element) {
            this.myPsiMethod = psiMethod;
            this.myType = type;
            this.myElement = element;
        }

        @Override
        public PsiMethod getMethod() {
            return this.myPsiMethod;
        }

        @Override
        public EntityListenerMethodType getType() {
            return this.myType;
        }

        @Override
        public void delete() throws IncorrectOperationException {
            this.myElement.undefine();
        }

        @Override
        public LifecycleCallback getDefiningElement() {
            return this.myElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntityListenerMethod that = (MyEntityListenerMethod)o;
            if (this.myElement != null ? !this.myElement.equals(that.myElement) : that.myElement != null) {
                return false;
            }
            if (this.myPsiMethod != null ? !this.myPsiMethod.equals((Object)that.myPsiMethod) : that.myPsiMethod != null) {
                return false;
            }
            return this.myType == that.myType;
        }

        public int hashCode() {
            int result = this.myPsiMethod != null ? this.myPsiMethod.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            result = 31 * result + (this.myElement != null ? this.myElement.hashCode() : 0);
            return result;
        }
    }
}

