/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.toolWindow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.UnifiedToolWindowWeights;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentImpl;
import com.jetbrains.rd.ide.model.RectangleModel;
import com.jetbrains.rd.ide.model.ToolWindowAnchorModel;
import com.jetbrains.rd.ide.model.ToolWindowContentUiTypeModel;
import com.jetbrains.rd.ide.model.ToolWindowInfoModel;
import com.jetbrains.rd.ide.model.ToolWindowTypeModel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022.\u0010\u0004\u001a*\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\t\u0012\u0004\u0012\u00020\n0\u0005\u001a\n\u0010\u000b\u001a\u00020\u0003*\u00020\b\u001a\n\u0010\u0000\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u0000\u001a\u00020\r*\u00020\f\u001a\f\u0010\u000b\u001a\u00020\u000e*\u00020\u000fH\u0002\u001a\f\u0010\u0000\u001a\u00020\u000f*\u00020\u000eH\u0002\u001a\f\u0010\u000b\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\u0011\u0010\u0000\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012*\u00020\u0010H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0013*\u00020\u0014H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0014*\u00020\u0013H\u0002\u001a\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"fromModel", "Lcom/intellij/openapi/wm/impl/DesktopLayout;", "", "Lcom/jetbrains/rd/ide/model/ToolWindowInfoModel;", "block", "Lkotlin/Function1;", "Ljava/util/HashMap;", "", "Lcom/intellij/openapi/wm/impl/WindowInfoImpl;", "Lkotlin/collections/HashMap;", "", "toModel", "Lcom/jetbrains/rd/ide/model/RectangleModel;", "Ljava/awt/Rectangle;", "Lcom/jetbrains/rd/ide/model/ToolWindowTypeModel;", "Lcom/intellij/openapi/wm/ToolWindowType;", "Lcom/jetbrains/rd/ide/model/ToolWindowAnchorModel;", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/rd/ide/model/ToolWindowContentUiTypeModel;", "Lcom/intellij/openapi/wm/ToolWindowContentUiType;", "updateAllToolWindowTabs", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nrdToolWindowUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 rdToolWindowUtils.kt\ncom/jetbrains/rd/platform/codeWithMe/toolWindow/RdToolWindowUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n1563#2:131\n1634#2,3:132\n1236#2,4:135\n13#3:139\n13#3:140\n*S KotlinDebug\n*F\n+ 1 rdToolWindowUtils.kt\ncom/jetbrains/rd/platform/codeWithMe/toolWindow/RdToolWindowUtilsKt\n*L\n17#1:131\n17#1:132,3\n17#1:135,4\n92#1:139\n109#1:140\n*E\n"})
public final class RdToolWindowUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DesktopLayout fromModel(@NotNull List<ToolWindowInfoModel> $this$fromModel, @NotNull Function1<? super HashMap<String, WindowInfoImpl>, Unit> block) {
        void var3_4;
        void $this$associateByTo$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$fromModel, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterable $this$map$iv = $this$fromModel;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ToolWindowInfoModel toolWindowInfoModel = (ToolWindowInfoModel)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(RdToolWindowUtilsKt.fromModel((ToolWindowInfoModel)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        Map destination$iv = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            WindowInfoImpl windowInfoImpl = (WindowInfoImpl)element$iv;
            object = destination$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNull((Object)string);
            object.put(string, element$iv);
        }
        void var2_2 = var3_4;
        block.invoke((Object)var2_2);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 2;
        UnifiedToolWindowWeights unifiedToolWindowWeights = null;
        void var15_19 = var2_2;
        return new DesktopLayout((Map)var15_19, unifiedToolWindowWeights, n, defaultConstructorMarker);
    }

    @NotNull
    public static final ToolWindowInfoModel toModel(@NotNull WindowInfoImpl $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Rectangle rectangle = $this$toModel.getFloatingBounds();
        return new ToolWindowInfoModel($this$toModel.isActiveOnStart(), $this$toModel.getToolWindowPaneId(), RdToolWindowUtilsKt.toModel($this$toModel.getAnchor()), $this$toModel.isAutoHide(), (RectangleModel)(rectangle != null ? RdToolWindowUtilsKt.toModel(rectangle) : null), $this$toModel.isMaximized(), $this$toModel.getId(), RdToolWindowUtilsKt.toModel($this$toModel.getInternalType()), RdToolWindowUtilsKt.toModel($this$toModel.getType()), $this$toModel.isVisible(), $this$toModel.isShowStripeButton(), $this$toModel.getWeight(), $this$toModel.getSideWeight(), $this$toModel.isSplit(), RdToolWindowUtilsKt.toModel($this$toModel.getContentUiType()), $this$toModel.getOrder());
    }

    @NotNull
    public static final WindowInfoImpl fromModel(@NotNull ToolWindowInfoModel $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        WindowInfoImpl info = new WindowInfoImpl();
        info.setActiveOnStart($this$fromModel.isActiveOnStart());
        info.setToolWindowPaneId($this$fromModel.getToolWindowPaneId());
        info.setAnchor(RdToolWindowUtilsKt.fromModel($this$fromModel.getAnchor()));
        info.setAutoHide($this$fromModel.isAutoHide());
        RectangleModel rectangleModel = $this$fromModel.getFloatingBounds();
        info.setFloatingBounds(rectangleModel != null ? RdToolWindowUtilsKt.fromModel(rectangleModel) : null);
        info.setMaximized($this$fromModel.isMaximized());
        info.setId($this$fromModel.getToolWindowId());
        info.setInternalType(RdToolWindowUtilsKt.fromModel($this$fromModel.getInternalType()));
        info.setType(RdToolWindowUtilsKt.fromModel($this$fromModel.getType()));
        info.setVisible($this$fromModel.isVisible());
        info.setShowStripeButton($this$fromModel.isShowStripeButton());
        info.setWeight($this$fromModel.getWeight());
        info.setSideWeight($this$fromModel.getSideWeight());
        info.setSplit($this$fromModel.isSplit());
        info.setContentUiType(RdToolWindowUtilsKt.fromModel($this$fromModel.getContentUiType()));
        info.setOrder($this$fromModel.getOrder());
        return info;
    }

    @NotNull
    public static final RectangleModel toModel(@NotNull Rectangle $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new RectangleModel($this$toModel.x, $this$toModel.y, $this$toModel.width, $this$toModel.height);
    }

    @NotNull
    public static final Rectangle fromModel(@NotNull RectangleModel $this$fromModel) {
        Intrinsics.checkNotNullParameter((Object)$this$fromModel, (String)"<this>");
        return new Rectangle($this$fromModel.getX(), $this$fromModel.getY(), $this$fromModel.getWidth(), $this$fromModel.getHeight());
    }

    private static final ToolWindowTypeModel toModel(ToolWindowType $this$toModel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toModel.ordinal()]) {
            case 1 -> ToolWindowTypeModel.Docked;
            case 2 -> ToolWindowTypeModel.Floating;
            case 3 -> ToolWindowTypeModel.Sliding;
            case 4 -> ToolWindowTypeModel.Windowed;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ToolWindowType fromModel(ToolWindowTypeModel $this$fromModel) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$fromModel.ordinal()]) {
            case 1 -> ToolWindowType.DOCKED;
            case 2 -> ToolWindowType.FLOATING;
            case 3 -> ToolWindowType.SLIDING;
            case 4 -> ToolWindowType.WINDOWED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ToolWindowAnchorModel toModel(ToolWindowAnchor $this$toModel) {
        ToolWindowAnchorModel toolWindowAnchorModel;
        ToolWindowAnchor toolWindowAnchor = $this$toModel;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP)) {
            toolWindowAnchorModel = ToolWindowAnchorModel.Top;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            toolWindowAnchorModel = ToolWindowAnchorModel.Left;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) {
            toolWindowAnchorModel = ToolWindowAnchorModel.Bottom;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            toolWindowAnchorModel = ToolWindowAnchorModel.Right;
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ToolWindowAnchor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new IllegalStateException("unexpected ToolWindowAnchor instance: text is \"" + $this$toModel + "\", class is " + $this$toModel.getClass()));
            toolWindowAnchorModel = ToolWindowAnchorModel.Bottom;
        }
        return toolWindowAnchorModel;
    }

    private static final ToolWindowAnchor fromModel(ToolWindowAnchorModel $this$fromModel) {
        ToolWindowAnchor toolWindowAnchor = switch (WhenMappings.$EnumSwitchMapping$2[$this$fromModel.ordinal()]) {
            case 1 -> ToolWindowAnchor.TOP;
            case 2 -> ToolWindowAnchor.LEFT;
            case 3 -> ToolWindowAnchor.BOTTOM;
            case 4 -> ToolWindowAnchor.RIGHT;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)toolWindowAnchor);
        return toolWindowAnchor;
    }

    private static final ToolWindowContentUiTypeModel toModel(ToolWindowContentUiType $this$toModel) {
        ToolWindowContentUiTypeModel toolWindowContentUiTypeModel;
        ToolWindowContentUiType toolWindowContentUiType = $this$toModel;
        if (Intrinsics.areEqual((Object)toolWindowContentUiType, (Object)ToolWindowContentUiType.TABBED)) {
            toolWindowContentUiTypeModel = ToolWindowContentUiTypeModel.Tabbed;
        } else if (Intrinsics.areEqual((Object)toolWindowContentUiType, (Object)ToolWindowContentUiType.COMBO)) {
            toolWindowContentUiTypeModel = ToolWindowContentUiTypeModel.Combo;
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ToolWindowContentUiType.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new IllegalStateException("unexpected ToolWindowContentUiType instance: name is \"" + $this$toModel.getName() + "\", class is " + $this$toModel.getClass()));
            toolWindowContentUiTypeModel = ToolWindowContentUiTypeModel.Tabbed;
        }
        return toolWindowContentUiTypeModel;
    }

    private static final ToolWindowContentUiType fromModel(ToolWindowContentUiTypeModel $this$fromModel) {
        ToolWindowContentUiType toolWindowContentUiType;
        switch (WhenMappings.$EnumSwitchMapping$3[$this$fromModel.ordinal()]) {
            case 1: {
                ToolWindowContentUiType toolWindowContentUiType2 = ToolWindowContentUiType.TABBED;
                toolWindowContentUiType = toolWindowContentUiType2;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUiType2, (String)"TABBED");
                break;
            }
            case 2: {
                ToolWindowContentUiType toolWindowContentUiType3 = ToolWindowContentUiType.COMBO;
                toolWindowContentUiType = toolWindowContentUiType3;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUiType3, (String)"COMBO");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return toolWindowContentUiType;
    }

    public static final void updateAllToolWindowTabs(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ToolWindowManagerEx windowManager = ToolWindowManagerEx.Companion.getInstanceEx(project);
        for (ToolWindow toolWindow : windowManager.getToolWindows()) {
            Content[] contentArray;
            ContentManager contentManager;
            if (toolWindow.getContentManagerIfCreated() == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)contentManager.getContents(), (String)"getContents(...)");
            for (Content content : contentArray) {
                if (!(content instanceof ContentImpl)) continue;
                ((ContentImpl)content).fireTabLayout();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ToolWindowType.values().length];
            try {
                nArray[ToolWindowType.DOCKED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowType.FLOATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowType.SLIDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowType.WINDOWED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ToolWindowTypeModel.values().length];
            try {
                nArray[ToolWindowTypeModel.Docked.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowTypeModel.Floating.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowTypeModel.Sliding.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowTypeModel.Windowed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ToolWindowAnchorModel.values().length];
            try {
                nArray[ToolWindowAnchorModel.Top.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowAnchorModel.Left.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowAnchorModel.Bottom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowAnchorModel.Right.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ToolWindowContentUiTypeModel.values().length];
            try {
                nArray[ToolWindowContentUiTypeModel.Tabbed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowContentUiTypeModel.Combo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

