/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.types.DasType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectModifierClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlAmbiguousColumnInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(this, manager, (SqlLanguageDialect)dialect, result){

            public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                ProblemHighlightType highlightType = 1.shouldBeError(dialect.getDbms()) ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                ObjectKind type = o.getReferenceElementType().getTargetKind();
                SqlExpression qualifier = o.getQualifierExpression();
                if (type == ObjectKind.COLUMN && qualifier != null) {
                    SqlTableType qualifierType = (SqlTableType)ObjectUtils.tryCast((Object)qualifier.getDasType(), SqlTableType.class);
                    if (qualifierType == null) {
                        return;
                    }
                    Casing casing = dialect.getCasing(type, null);
                    String effectiveRefName = SqlImplUtil.getEffectiveName((String)o.getName(), (boolean)o.isQuoted(), (Casing)casing);
                    int matches = 0;
                    for (int i = 0; i < qualifierType.getColumnCount() && matches <= 1; ++i) {
                        String effectiveColName = SqlImplUtil.getEffectiveName((String)qualifierType.getColumnName(i), (boolean)qualifierType.isColumnQuoted(i), (Casing)casing);
                        if (!effectiveColName.equals(effectiveRefName)) continue;
                        ++matches;
                    }
                    if (matches > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message((String)"ambiguous.column.short.reference", (Object[])new Object[]{o.getName()}), (LocalQuickFix)null, highlightType, onTheFly));
                    }
                }
                if ((type == SqlDbElementType.ANY || type == ObjectKind.COLUMN) && qualifier == null) {
                    SqlJoinExpression joinExpression;
                    SqlFromClause fromClause;
                    PsiElement clause = (PsiElement)SyntaxTraverser.psiApi().parents((Object)o).filter(e -> e instanceof SqlUsingClause || e instanceof SqlSelectModifierClause || e.getParent() instanceof SqlQueryExpression || e.getParent() instanceof SqlTableExpression).first();
                    if (clause instanceof SqlUsingClause || clause instanceof SqlSelectModifierClause || clause == null) {
                        return;
                    }
                    SqlQueryExpression queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlQueryExpression.class, (boolean)true);
                    SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
                    DasType queryExpressionType = queryExpression != null ? queryExpression.getDasType() : null;
                    SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
                    if (fromClause == null) {
                        return;
                    }
                    Dbms dbms = this.myDialect.getDbms();
                    SqlTableType tableType = clause instanceof SqlFromClause ? ((joinExpression = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlJoinExpression.class, (boolean)true)) == null ? tableExpression.getDasType() : joinExpression.getDasType()) : (clause instanceof SqlOrderByClause || (clause instanceof SqlGroupByClause || clause instanceof SqlHavingClause) && dbms.isMysql() ? (queryExpressionType instanceof SqlTableType ? (SqlTableType)queryExpressionType : SqlTableTypeBase.EMPTY_TABLE) : tableExpression.getDasType());
                    String columnName = o.getName();
                    int matchedAliases = 0;
                    int matchedColumns = 0;
                    int count = tableType.getColumnCount();
                    for (int i = 0; i < count; ++i) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i), (boolean)false)) continue;
                        if (tableType.getColumnElement(i) instanceof SqlAsExpression) {
                            ++matchedAliases;
                            continue;
                        }
                        ++matchedColumns;
                    }
                    if (matchedAliases + matchedColumns <= 1) {
                        return;
                    }
                    if (clause instanceof SqlOrderByClause) {
                        if (dbms.isDb2() && matchedColumns == 1 && matchedAliases == 1) {
                            return;
                        }
                        if (dbms.isSybase() && matchedAliases == 0) {
                            return;
                        }
                    }
                    ArrayList<Object> names = new ArrayList<Object>(matchedAliases + matchedColumns);
                    int count2 = tableType.getColumnCount();
                    for (int i = 0; i < count2; ++i) {
                        if (!Comparing.strEqual((String)columnName, (String)tableType.getColumnName(i), (boolean)false)) continue;
                        String tableAlias = tableType.getColumnTypeAlias(i);
                        if (tableAlias != null) {
                            names.add(tableAlias + "." + columnName);
                            continue;
                        }
                        PsiElement c = tableType.getSourceColumnElement(i);
                        names.add(c == null ? columnName : SqlAmbiguousColumnInspection.getQualifiedName(c));
                    }
                    Collections.sort(names);
                    for (SqlUsingClause usingClause : SqlAmbiguousColumnInspection.getAllUsingClauses(tableExpression)) {
                        List referenceList = SqlImplUtil.getReferenceList((SqlReferenceList)usingClause.getReferenceList());
                        if (referenceList.isEmpty()) continue;
                        if (names.isEmpty()) break;
                        for (SqlAsExpression expression : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)usingClause.getParent(), SqlAsExpression.class)) {
                            names.remove(expression.getName() + "." + columnName);
                        }
                        for (SqlReferenceExpression reference : referenceList) {
                            for (ResolveResult resolveResult : reference.multiResolve(false)) {
                                names.remove(SqlAmbiguousColumnInspection.getQualifiedName(resolveResult.getElement()));
                            }
                        }
                    }
                    if (names.size() > 1) {
                        this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message((String)"ambiguous.column.short.reference", (Object[])new Object[]{StringUtil.join((String[])ArrayUtilRt.toStringArray(names), (String)",\n")}), (LocalQuickFix)null, highlightType, onTheFly));
                    }
                }
            }

            private static boolean shouldBeError(@NotNull Dbms dbms) {
                if (dbms == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !dbms.isHsqldb() && !dbms.isSqlite();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dbms";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSqlReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldBeError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static Collection<SqlUsingClause> getAllUsingClauses(@NotNull SqlTableExpression tableExpression) {
        SqlFromClause fromClause;
        if (tableExpression == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(3);
        }
        if ((fromClause = tableExpression.getFromClause()) == null) {
            List<SqlUsingClause> list = Collections.emptyList();
            if (list == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        final ArrayList<SqlUsingClause> result = new ArrayList<SqlUsingClause>();
        fromClause.acceptChildren(new SqlVisitor(){

            public void visitSqlJoinExpression(@NotNull SqlJoinExpression o) {
                if (o == null) {
                    2.$$$reportNull$$$0(0);
                }
                o.acceptChildren((SqlVisitor)this);
            }

            public void visitSqlUsingClause(SqlUsingClause o) {
                result.add(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlAmbiguousColumnInspection$2", "visitSqlJoinExpression"));
            }
        });
        ArrayList<SqlUsingClause> arrayList = result;
        if (arrayList == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    protected boolean isDialectIgnored(SqlLanguageDialectEx dialect) {
        return super.isDialectIgnored(dialect) || dialect.getDbms() == Dbms.CLICKHOUSE;
    }

    @NotNull
    public static String getQualifiedName(@Nullable PsiElement element) {
        if (element == null) {
            return "";
        }
        if (element instanceof DbElement) {
            String string = QNameUtil.getQualifiedName((DbElement)((DbElement)element));
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (element instanceof SqlDefinition) {
            String string = QNameUtil.getQualifiedName((DasObject)((SqlDefinition)element));
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (element instanceof PsiNamedElement) {
            String string = StringUtil.notNullize((String)((PsiNamedElement)element).getName());
            if (string == null) {
                SqlAmbiguousColumnInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)element.getText());
        if (string == null) {
            SqlAmbiguousColumnInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlAmbiguousColumnInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingClauses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingClauses";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

