/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.task.state.KtorTaskState;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ktor/run/KtorCommandLineState;", "Lcom/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState;", "Lcom/intellij/ktor/run/KtorRunConfiguration;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/ktor/run/KtorRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "taskState", "Lcom/intellij/ktor/run/task/state/KtorTaskState;", "createJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "prepareTargetEnvironmentRequest", "", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "handleCreatedTargetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "intellij.ktor"})
public final class KtorCommandLineState
extends ApplicationConfiguration.JavaApplicationCommandLineState<KtorRunConfiguration> {
    @NotNull
    private final KtorTaskState taskState;

    public KtorCommandLineState(@NotNull KtorRunConfiguration configuration, @Nullable ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        super((ApplicationConfiguration)configuration, environment);
        this.taskState = new KtorTaskState(configuration, false, (Function0<? extends JavaParameters>)((Function0)new Function0<JavaParameters>((Object)this){

            public final JavaParameters invoke() {
                return ((KtorCommandLineState)((Object)this.receiver)).getJavaParameters();
            }
        }));
    }

    @NotNull
    protected JavaParameters createJavaParameters() {
        JavaParameters parameters = super.createJavaParameters();
        if (((KtorRunConfiguration)this.getConfiguration()).getKtorDevelopmentMode()) {
            parameters.getVMParametersList().add("-Dio.ktor.development=true");
        }
        Intrinsics.checkNotNull((Object)parameters);
        return parameters;
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        this.taskState.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
        super.prepareTargetEnvironmentRequest(request, targetProgressIndicator);
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        ExecutionResult executionResult = super.execute(executor, runner);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"execute(...)");
        ExecutionResult result = executionResult;
        ProcessHandler processHandler = result.getProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
        ExecutionConsole executionConsole = result.getExecutionConsole();
        Intrinsics.checkNotNullExpressionValue((Object)executionConsole, (String)"getExecutionConsole(...)");
        this.taskState.processExecutionResult(processHandler, executionConsole);
        return result;
    }

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        super.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
        this.taskState.handleCreatedTargetEnvironment(environment, targetProgressIndicator);
    }
}

