/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraphEditorComponentDrawable;
import com.intellij.openapi.graph.impl.view.JByToSwingEventsDelegatingMode;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import l.N.S;
import l.N.V;
import l.N.W;
import l.T.l7;
import l.l.CF;
import l.l.NZ;
import l.l.TA;
import l.l.VM;
import l.l.pE;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCellEditorMode
extends TA {
    @NotNull
    private final W myNodeCellEditorProvider;
    @NotNull
    private final S myUserObjectMap;
    @NotNull
    private final CellEditorListener myCellEditorListener = new MyCellEditorListener();
    @Nullable
    private NZ myCurrentEditor;
    @Nullable
    private VM myCurrentEditedNodeRealizer;
    @Nullable
    private JComponent myCurrentEditorComponent;
    @Nullable
    private JByToSwingEventsDelegatingMode myEventsDelegatingMode;
    @Nullable
    private JBGraphEditorComponentDrawable myEditorComponentDrawable;
    @Nullable
    private PropertyChangeListener myFocusOwnerChangeListener;

    public JBCellEditorMode(NZ nodeCellEditor, S userObjectMap) {
        this(l7.l(nodeCellEditor), userObjectMap);
    }

    public JBCellEditorMode(W nodeCellEditorProvider, S userObjectMap) {
        super(nodeCellEditorProvider, userObjectMap);
        this.myNodeCellEditorProvider = nodeCellEditorProvider;
        this.myUserObjectMap = userObjectMap;
    }

    @Override
    public boolean editNode(V node, EventObject event) {
        if (this.isNodeEditable(node) && (!this.isCellEditing() || this.stopCellEditing())) {
            VM vM2 = this.l().l(node);
            NZ nZ = this.getNodeCellEditor(node);
            if (nZ == null || event != null && !nZ.isCellEditable(event)) {
                return false;
            }
            this.startCellEditing(vM2, nZ);
            if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500 && this.myEventsDelegatingMode != null && this.isCellEditing()) {
                this.myEventsDelegatingMode.mouseClicked((MouseEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeEditable(V node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void N(MouseEvent mouseEvent) {
        Object object;
        pE pE2;
        if (!this.isCellEditing()) {
            if (!this.shouldStartCellEditing(mouseEvent)) {
                return;
            }
            pE2 = this.l(mouseEvent);
            if (pE2.l() == null) {
                return;
            }
            this.editNode((V)pE2.l(), mouseEvent);
            if (!VM.Y) {
                return;
            }
        }
        this.c(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.isCellEditing() && mouseEvent.getID() == 501 && ((object = (pE2 = this.l(mouseEvent)).l()) == null || object != this.myCurrentEditedNodeRealizer.l()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    @Nullable
    public Object getUserObject(V node) {
        return this.myUserObjectMap.get(this.myCurrentEditedNodeRealizer.l());
    }

    @Override
    public void setUserObject(V node, Object data) {
        this.myUserObjectMap.l((Object)node, data);
    }

    @Override
    protected boolean shouldStartCellEditing(@NotNull MouseEvent event) {
        if (event == null) {
            JBCellEditorMode.c(0);
        }
        return event.getID() == 500 && event.getClickCount() == 2;
    }

    @Override
    @Nullable
    public NZ getNodeCellEditor(V node) {
        Object object = this.myNodeCellEditorProvider != null ? this.myNodeCellEditorProvider.get(node) : null;
        return object instanceof NZ ? (NZ)object : null;
    }

    @Override
    public boolean isCellEditing() {
        return this.myCurrentEditor != null;
    }

    @Override
    public void startCellEditing(VM nodeRealizer, NZ nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.myCurrentEditor = nodeCellEditor;
            this.myCurrentEditedNodeRealizer = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.myCellEditorListener);
            JComponent jComponent = nodeCellEditor.getNodeCellEditorComponent(this.e, nodeRealizer, this.getUserObject(nodeRealizer.l()), nodeRealizer.T());
            this.installEditor(jComponent, nodeRealizer);
        }
    }

    @Override
    @Nullable
    public NZ getEditor() {
        return this.myCurrentEditor;
    }

    @Override
    @Nullable
    public V getEditingNode() {
        return this.myCurrentEditedNodeRealizer != null ? this.myCurrentEditedNodeRealizer.l() : null;
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean stopCellEditing() {
        return this.myCurrentEditor != null ? this.myCurrentEditor.stopCellEditing() : true;
    }

    @Override
    protected void cellEditingCanceled() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    protected void cellEditingStopped() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    public void reactivateParent() {
        super.reactivateParent();
    }

    @Override
    public void cancelEditing() throws UnsupportedOperationException {
        super.cancelEditing();
    }

    @Override
    protected void setEditing(boolean b2) {
        super.setEditing(b2);
    }

    @Override
    public void activate(boolean b2) {
        super.activate(b2);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseMoved(event);
        }
    }

    private void T(@NotNull MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            JBCellEditorMode.c(1);
        }
        if (mouseEvent.getID() == 501 && this.isCellEditing() && ((object = this.l(mouseEvent).l()) == null || object != this.myCurrentEditedNodeRealizer.l()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseReleased(event);
        }
        this.v(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseDragged(event);
        }
        this.v(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mousePressed(event);
        }
        this.v(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseClicked(event);
        }
        this.v(event);
    }

    private void v(MouseEvent mouseEvent) {
        this.T(mouseEvent);
        if (!VM.Y) {
            return;
        }
        this.N(mouseEvent);
    }

    @Override
    protected void installEditor(@NotNull JComponent editorComponent, VM nodeRealizer) {
        if (editorComponent == null) {
            JBCellEditorMode.c(2);
        }
        if (editorComponent.getNextFocusableComponent() == null) {
            editorComponent.setNextFocusableComponent(this.e.l());
        }
        JComponent jComponent = this.l();
        jComponent.add(editorComponent);
        this.myCurrentEditorComponent = editorComponent;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.c(), nodeRealizer.l());
        JByToSwingEventsDelegatingMode jByToSwingEventsDelegatingMode = new JByToSwingEventsDelegatingMode(true);
        this.l(jByToSwingEventsDelegatingMode, null, null, null);
        jByToSwingEventsDelegatingMode.addDelegateComponent(editorComponent, affineTransform);
        this.myEventsDelegatingMode = jByToSwingEventsDelegatingMode;
        this.myEditorComponentDrawable = new JBGraphEditorComponentDrawable(jComponent, editorComponent, affineTransform);
        this.e.l(this.myEditorComponentDrawable);
        editorComponent.setBounds(0, 0, (int)nodeRealizer.N(), (int)nodeRealizer.T());
        editorComponent.validate();
        editorComponent.requestFocusInWindow();
        editorComponent.repaint();
        if (this.myFocusOwnerChangeListener == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myFocusOwnerChangeListener = new MyFocusOwnerListener(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
        }
    }

    @Override
    protected void removeEditor() {
        if (this.myFocusOwnerChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
            this.myFocusOwnerChangeListener = null;
        }
        if (this.myCurrentEditorComponent != null) {
            this.myEventsDelegatingMode.reactivateParent();
            this.l().remove(this.myCurrentEditorComponent);
            this.e.N(this.myEditorComponentDrawable);
            this.e.l().repaint();
            this.myEventsDelegatingMode = null;
        }
        this.myCurrentEditorComponent = null;
    }

    private void c(Component component) {
        if (component instanceof CF) {
            return;
        }
        boolean bl = VM.Y;
        if (this.isCellEditing()) {
            JComponent jComponent = this.l();
            for (Component component2 = component; component2 != null && component2 != jComponent; component2 = component2.getParent()) {
                if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                    if (component2 == SwingUtilities.getRoot(this.e) && !this.stopCellEditing()) {
                        this.cancelCellEditing();
                    }
                    return;
                }
                if (!bl) continue;
                return;
            }
        }
    }

    @NotNull
    private JComponent l() {
        JComponent jComponent = this.e.l();
        if (jComponent == null) {
            JBCellEditorMode.c(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldStartCellEditing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelEditingIfAnotherNodeWasClicked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class MyCellEditorListener
    implements CellEditorListener {
        MyCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingStopped();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingCanceled();
        }
    }

    private final class MyFocusOwnerListener
    implements PropertyChangeListener {
        @NotNull
        private final KeyboardFocusManager myFocusManager;

        public MyFocusOwnerListener(KeyboardFocusManager focusManager) {
            if (focusManager == null) {
                MyFocusOwnerListener.l(0);
            }
            this.myFocusManager = focusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JBCellEditorMode.this.c(this.myFocusManager.getPermanentFocusOwner());
        }

        private static /* synthetic */ void l(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/openapi/graph/impl/view/JBCellEditorMode$MyFocusOwnerListener", "<init>"));
        }
    }
}

