/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import l.l.TS;
import l.l.VM;
import l.l.lx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JByToSwingEventsDelegatingMode
extends TS
implements MouseWheelListener {
    @Nullable
    private TS myChildMode;
    private int myCurrentMousePressedCounter;
    @Nullable
    private EventsBroker myCurrentBroker;
    @Nullable
    private EventsBroker myBrokerOnLastMousePressed;
    @Nullable
    private Cursor myCursor;
    @Nullable
    private MyRepaintManager myRepaintManager;
    @NotNull
    private final List<MyDelegateComponent> myDelegateComponents = new ArrayList<MyDelegateComponent>();
    private final boolean myDoUseOptimizingRepaintManager;
    private boolean myIsDispatchInProgress;

    public JByToSwingEventsDelegatingMode(boolean doUseOptimizingRepaintManager) {
        this(null, doUseOptimizingRepaintManager);
    }

    public JByToSwingEventsDelegatingMode(@Nullable TS childMode, boolean doUseOptimizingRepaintManager) {
        this.myChildMode = childMode;
        if (this.myChildMode != null) {
            this.myChildMode.c(false);
        }
        this.myDoUseOptimizingRepaintManager = doUseOptimizingRepaintManager;
        this.c(false);
    }

    public void addDelegateComponent(@NotNull JComponent delegate, @NotNull AffineTransform transform) {
        if (delegate == null) {
            JByToSwingEventsDelegatingMode.c(0);
        }
        if (transform == null) {
            JByToSwingEventsDelegatingMode.c(1);
        }
        this.myDelegateComponents.add(new MyDelegateComponent(delegate, transform));
    }

    public void removeDelegateComponent(@NotNull JComponent delegate) {
        MyDelegateComponent myDelegateComponent;
        if (delegate == null) {
            JByToSwingEventsDelegatingMode.c(2);
        }
        if (this.myDelegateComponents.remove(myDelegateComponent = (MyDelegateComponent)delegate.getClientProperty("FloatingJComponent.Instance"))) {
            delegate.putClientProperty("FloatingJComponent.Instance", null);
        }
    }

    public void removeAllDelegateComponents() {
        this.myDelegateComponents.clear();
    }

    @Override
    public void activate(boolean state) {
        super.activate(state);
        if (this.myDoUseOptimizingRepaintManager && state) {
            this.myRepaintManager = MyRepaintManager.setupFor(this.e.l());
            if (!VM.Y) {
                return;
            }
        }
        this.myCurrentBroker = null;
        this.myBrokerOnLastMousePressed = null;
        this.myCursor = null;
        this.myCurrentMousePressedCounter = 0;
        if (this.myDoUseOptimizingRepaintManager && this.myRepaintManager != null) {
            this.myRepaintManager.disposeAndRestoreOriginalRepaintManagerFor(this.e.l());
            this.myRepaintManager = null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.T = event;
        this.l(event);
        if (this.myCurrentBroker != null) {
            this.myCurrentBroker.adaptAndForward(event);
        }
        this.l();
        if (this.myChildMode != null && !event.isConsumed()) {
            this.myChildMode.mouseMoved(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.v = event;
        this.l(event);
        if (this.myCurrentMousePressedCounter > 0) {
            if (this.myBrokerOnLastMousePressed != null) {
                this.myBrokerOnLastMousePressed.adaptAndForward(event);
            }
            --this.myCurrentMousePressedCounter;
            if (this.myCurrentMousePressedCounter == 0) {
                this.myBrokerOnLastMousePressed = null;
            }
        }
        this.l();
        if (this.myChildMode != null && !event.isConsumed()) {
            this.myChildMode.mouseReleased(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.a = event;
        this.l(event);
        if (this.myBrokerOnLastMousePressed != null) {
            this.myBrokerOnLastMousePressed.adaptAndForward(event);
        }
        this.l();
        if (this.myChildMode != null && !event.isConsumed()) {
            this.myChildMode.mouseDragged(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.h = event;
        this.l(event);
        if (this.myCurrentBroker != null) {
            if (this.myCurrentMousePressedCounter == 0) {
                this.myBrokerOnLastMousePressed = this.myCurrentBroker;
            }
            ++this.myCurrentMousePressedCounter;
            this.myBrokerOnLastMousePressed.adaptAndForward(event);
        }
        this.l();
        if (this.myChildMode != null && !event.isConsumed()) {
            this.myChildMode.mousePressed(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.Y = event;
        this.l(event);
        if (this.myBrokerOnLastMousePressed != null) {
            this.myBrokerOnLastMousePressed.adaptAndForward(event);
        }
        if (this.myCurrentBroker != null && (this.myBrokerOnLastMousePressed == null || VM.Y)) {
            this.myCurrentBroker.adaptAndForward(event);
        }
        this.l();
        if (this.myChildMode != null && !event.isConsumed()) {
            this.myChildMode.mouseClicked(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.l(event);
        this.l();
        if (this.myChildMode != null) {
            this.myChildMode.mouseEntered(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (!this.myIsDispatchInProgress) {
            if (this.myCurrentBroker != null) {
                this.myCurrentBroker.adaptAndForward(event);
                this.e.setToolTipText(null);
                this.myCurrentBroker = null;
            }
            this.l();
            if (this.myChildMode != null) {
                this.myChildMode.mouseExited(event);
            }
        }
    }

    private void l() {
        Cursor cursor = this.myBrokerOnLastMousePressed != null && !VM.Y ? this.myBrokerOnLastMousePressed.getCursor() : (this.myCurrentBroker != null && !VM.Y ? this.myCurrentBroker.getCursor() : null);
        if (cursor != this.myCursor) {
            this.e.l(cursor);
            this.myCursor = cursor;
        }
    }

    @Nullable
    private EventsBroker l(MouseEvent mouseEvent, @Nullable EventsBroker eventsBroker) {
        if (this.myDelegateComponents.isEmpty()) {
            return null;
        }
        for (int i2 = 0; i2 < this.myDelegateComponents.size(); ++i2) {
            MyDelegateComponent myDelegateComponent = this.myDelegateComponents.get(i2);
            JComponent jComponent = myDelegateComponent.getSubcomponentAtWorldCoords(this.c(mouseEvent.getX()), this.l(mouseEvent.getY()));
            if (jComponent != null) {
                if (eventsBroker instanceof SwingComponentEventsBroker && eventsBroker.getEventsReceiver() == jComponent) {
                    return eventsBroker;
                }
                return new SwingComponentEventsBroker(myDelegateComponent, jComponent);
            }
            if (!VM.Y) continue;
            return null;
        }
        return null;
    }

    @Nullable
    static final JComponent getTheDeepestSubcomponentAt(JComponent parent, int x2, int y2) {
        boolean bl = VM.Y;
        Component component = parent;
        while (true) {
            Component component2 = component.getComponentAt(x2, y2);
            int n2 = 0;
            if (component == component2) {
                if (!bl) {
                    return component instanceof JComponent ? component : null;
                }
            } else {
                if (component2 == null) {
                    return null;
                }
                x2 -= component2.getX();
                n2 = y2 - component2.getY();
            }
            y2 = n2;
            component = component2;
        }
    }

    private void l(MouseEvent mouseEvent) {
        EventsBroker eventsBroker = this.l(mouseEvent, this.myCurrentBroker);
        if (eventsBroker != this.myCurrentBroker) {
            if (this.myCurrentBroker != null) {
                this.myCurrentBroker.adaptAndForward(mouseEvent, 505);
            }
            this.e.setToolTipText(null);
            this.myCurrentBroker = eventsBroker;
            if (this.myCurrentBroker != null) {
                this.myCurrentBroker.adaptAndForward(mouseEvent, 504);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (!this.myIsDispatchInProgress && this.myCurrentBroker != null) {
            this.myCurrentBroker.adaptAndForward(event);
        }
    }

    @Override
    public void setActiveView(lx view) {
        super.setActiveView(view);
        if (this.myChildMode != null) {
            this.myChildMode.setActiveView(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchGraphCanvasEventOnSwingComponent(Component receiver, MouseEvent originalEvent, int x2, int y2, int eventId) {
        boolean bl = this.myIsDispatchInProgress;
        this.myIsDispatchInProgress = true;
        try {
            JByToSwingEventsDelegatingMode.dispatchGraphCanvasEventOnSwingComponent(receiver, this.e, originalEvent, x2, y2, eventId);
        }
        finally {
            this.myIsDispatchInProgress = bl;
        }
    }

    public static void dispatchGraphCanvasEventOnSwingComponent(Component receiver, lx view, MouseEvent originalEvent, int x2, int y2, int eventId) {
        MouseEvent mouseEvent;
        Object object;
        if (originalEvent instanceof MouseWheelEvent && !VM.Y) {
            object = (MouseWheelEvent)originalEvent;
            mouseEvent = new MouseWheelEvent(receiver, eventId, originalEvent.getWhen(), originalEvent.getModifiers(), x2, y2, originalEvent.getClickCount(), originalEvent.isPopupTrigger(), ((MouseWheelEvent)object).getScrollType(), ((MouseWheelEvent)object).getScrollAmount(), ((MouseWheelEvent)object).getWheelRotation());
        } else {
            switch (eventId) {
                case 503: 
                case 504: 
                case 505: {
                    mouseEvent = new MouseEvent(receiver, eventId, originalEvent.getWhen(), originalEvent.getModifiers(), x2, y2, 0, false);
                    break;
                }
                default: {
                    mouseEvent = new MouseEvent(receiver, eventId, originalEvent.getWhen(), originalEvent.getModifiers(), x2, y2, originalEvent.getClickCount(), originalEvent.isPopupTrigger());
                }
            }
        }
        receiver.dispatchEvent(mouseEvent);
        if ((eventId == 503 || eventId == 504) && receiver instanceof JComponent) {
            object = ((JComponent)receiver).getToolTipText(mouseEvent);
            view.setToolTipText((String)object);
        }
        if (mouseEvent.isConsumed() && !originalEvent.isConsumed()) {
            originalEvent.consume();
        }
    }

    private static /* synthetic */ void c(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addDelegateComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDelegateComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyDelegateComponent {
        @NotNull
        private final JComponent myDelegate;
        @NotNull
        private final AffineTransform myWorldCoordsWrtDelegateTopLeftAngleTransform;
        @NotNull
        static final String d = "FloatingJComponent.Instance";

        public MyDelegateComponent(@NotNull JComponent delegate, @NotNull AffineTransform transform) {
            if (delegate == null) {
                MyDelegateComponent.l(0);
            }
            if (transform == null) {
                MyDelegateComponent.l(1);
            }
            this.myDelegate = delegate;
            this.myDelegate.putClientProperty(d, this);
            this.myWorldCoordsWrtDelegateTopLeftAngleTransform = transform;
        }

        @NotNull
        public AffineTransform getWorldCoordsWrtDelegateTopLeftAngleTransform() {
            AffineTransform affineTransform = this.myWorldCoordsWrtDelegateTopLeftAngleTransform;
            if (affineTransform == null) {
                MyDelegateComponent.l(2);
            }
            return affineTransform;
        }

        @NotNull
        public JComponent getDelegate() {
            JComponent jComponent = this.myDelegate;
            if (jComponent == null) {
                MyDelegateComponent.l(3);
            }
            return jComponent;
        }

        public void setComponentBoundsInWorldTo(@NotNull Rectangle2D.Double result) {
            if (result == null) {
                MyDelegateComponent.l(4);
            }
            this.toWorldCoordsWrtDelegateTopLeftAngle(new Rectangle2D.Double(0.0, 0.0, this.myDelegate.getWidth(), this.myDelegate.getHeight()), result);
        }

        public void toWorldCoordsWrtDelegateTopLeftAngle(@NotNull Rectangle2D source, @NotNull Rectangle2D result) {
            if (source == null) {
                MyDelegateComponent.l(5);
            }
            if (result == null) {
                MyDelegateComponent.l(6);
            }
            double[] dArray = new double[8];
            dArray[0] = dArray[2] = source.getX();
            dArray[1] = dArray[5] = source.getY();
            dArray[3] = dArray[7] = source.getMaxY();
            dArray[4] = dArray[6] = source.getMaxX();
            this.myWorldCoordsWrtDelegateTopLeftAngleTransform.transform(dArray, 0, dArray, 0, 4);
            double d2 = Math.max(Math.max(dArray[0], dArray[2]), Math.max(dArray[4], dArray[6]));
            double d3 = Math.min(Math.min(dArray[0], dArray[2]), Math.min(dArray[4], dArray[6]));
            double d4 = Math.max(Math.max(dArray[1], dArray[3]), Math.max(dArray[5], dArray[7]));
            double d5 = Math.min(Math.min(dArray[1], dArray[3]), Math.min(dArray[5], dArray[7]));
            result.setFrame(d3, d5, d2 - d3, d4 - d5);
        }

        public void getWorldCoordsOfSubcomponentPoint(@NotNull JComponent delegateSubcomponent, int x2, int y2, @NotNull Point2D.Double result) {
            if (delegateSubcomponent == null) {
                MyDelegateComponent.l(7);
            }
            if (result == null) {
                MyDelegateComponent.l(8);
            }
            if (VM.Y) {
                return;
            }
            for (Container container2 = delegateSubcomponent; container2 != this.myDelegate; container2 = container2.getParent()) {
                y2 += ((Component)container2).getY();
                x2 += ((Component)container2).getX();
            }
            result.setLocation(x2, y2);
            this.myWorldCoordsWrtDelegateTopLeftAngleTransform.transform(result, result);
        }

        public boolean getSubcomponentPointByItsWorldCoords(@NotNull JComponent child, double childCoordX, double childCoordY, @NotNull Point point) {
            if (child == null) {
                MyDelegateComponent.l(9);
            }
            if (point == null) {
                MyDelegateComponent.l(10);
            }
            double[] dArray = new double[]{childCoordX, childCoordY};
            try {
                this.myWorldCoordsWrtDelegateTopLeftAngleTransform.inverseTransform(dArray, 0, dArray, 0, 1);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return false;
            }
            int n2 = (int)dArray[0];
            int n3 = (int)dArray[1];
            if (!VM.Y) {
                for (Container container2 = child; container2 != this.myDelegate; container2 = container2.getParent()) {
                    if (container2 == null) {
                        return false;
                    }
                    n2 -= ((Component)container2).getX();
                    n3 -= ((Component)container2).getY();
                }
            }
            result.x = n2;
            result.y = n3;
            return true;
        }

        @Nullable
        public JComponent getSubcomponentAtWorldCoords(double x2, double y2) {
            double[] dArray = new double[]{x2, y2};
            try {
                this.myWorldCoordsWrtDelegateTopLeftAngleTransform.inverseTransform(dArray, 0, dArray, 0, 1);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
            int n2 = (int)dArray[0];
            int n3 = (int)dArray[1];
            if (n2 >= 0 && n3 >= 0 && n2 < this.myDelegate.getWidth() && n3 < this.myDelegate.getHeight()) {
                return JByToSwingEventsDelegatingMode.getTheDeepestSubcomponentAt(this.myDelegate, n2, n3);
            }
            return null;
        }

        private static /* synthetic */ void l(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$MyDelegateComponent";
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateSubcomponent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$MyDelegateComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWorldCoordsWrtDelegateTopLeftAngleTransform";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setComponentBoundsInWorldTo";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "toWorldCoordsWrtDelegateTopLeftAngle";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getWorldCoordsOfSubcomponentPoint";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubcomponentPointByItsWorldCoords";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class MyRepaintManager
    extends RepaintManager {
        @NotNull
        private final RepaintManager myOriginalManager;
        static final String c = "CustomRepaintManager.Instance";

        protected MyRepaintManager(RepaintManager originalManager) {
            this.myOriginalManager = originalManager;
        }

        @NotNull
        public static MyRepaintManager setupFor(JComponent component) {
            RepaintManager repaintManager = RepaintManager.currentManager(component);
            if (repaintManager.getClass() != MyRepaintManager.class) {
                MyRepaintManager myRepaintManager = new MyRepaintManager(repaintManager);
                component.putClientProperty(c, myRepaintManager);
                RepaintManager.setCurrentManager(myRepaintManager);
                MyRepaintManager myRepaintManager2 = myRepaintManager;
                if (myRepaintManager2 == null) {
                    MyRepaintManager.l(0);
                }
                return myRepaintManager2;
            }
            MyRepaintManager myRepaintManager = (MyRepaintManager)repaintManager;
            if (myRepaintManager == null) {
                MyRepaintManager.l(1);
            }
            return myRepaintManager;
        }

        public void disposeAndRestoreOriginalRepaintManagerFor(JComponent component) {
            if (RepaintManager.currentManager(component) == this) {
                component.putClientProperty(c, null);
                RepaintManager.setCurrentManager(this.myOriginalManager);
            }
        }

        @Override
        public Image getOffscreenBuffer(Component component, int proposedWidth, int proposedHeight) {
            return this.myOriginalManager.getOffscreenBuffer(component, proposedWidth, proposedHeight);
        }

        @Override
        public Image getVolatileOffscreenBuffer(Component component, int proposedWidth, int proposedHeight) {
            return this.myOriginalManager.getVolatileOffscreenBuffer(component, proposedWidth, proposedHeight);
        }

        @Override
        public void setDoubleBufferingEnabled(boolean state) {
            this.myOriginalManager.setDoubleBufferingEnabled(state);
        }

        @Override
        public void setDoubleBufferMaximumSize(Dimension d2) {
            this.myOriginalManager.setDoubleBufferMaximumSize(d2);
        }

        @Override
        public void removeInvalidComponent(JComponent component) {
            this.myOriginalManager.removeInvalidComponent(component);
        }

        @Override
        public void markCompletelyDirty(@NotNull JComponent component) {
            if (component == null) {
                MyRepaintManager.l(2);
            }
            if (component.getClientProperty("JCOMPONENT_PARENT_KEY") != null) {
                this.addDirtyRegion(component, 0, 0, component.getWidth(), component.getHeight());
                if (!VM.Y) {
                    return;
                }
            }
            this.myOriginalManager.markCompletelyDirty(component);
        }

        @Override
        public void addInvalidComponent(@NotNull JComponent invalidComponent) {
            block5: {
                Object object;
                boolean bl;
                block6: {
                    if (invalidComponent == null) {
                        MyRepaintManager.l(3);
                    }
                    bl = VM.Y;
                    object = invalidComponent.getClientProperty("JCOMPONENT_PARENT_KEY");
                    if (object == null) break block5;
                    if (invalidComponent.getParent() == object || invalidComponent.isValidateRoot()) break block6;
                    invalidComponent = (JComponent)invalidComponent.getParent();
                    if (bl) break block5;
                }
                this.myOriginalManager.addInvalidComponent((JComponent)object);
                if (!bl) {
                    return;
                }
            }
            this.myOriginalManager.addInvalidComponent(invalidComponent);
        }

        @Override
        public Rectangle getDirtyRegion(@NotNull JComponent component) {
            if (component == null) {
                MyRepaintManager.l(4);
            }
            if (component.getClientProperty("JCOMPONENT_PARENT_KEY") != null) {
                return new Rectangle();
            }
            return this.myOriginalManager.getDirtyRegion(component);
        }

        @Override
        public boolean isCompletelyDirty(@NotNull JComponent component) {
            if (component == null) {
                MyRepaintManager.l(5);
            }
            if (component.getClientProperty("JCOMPONENT_PARENT_KEY") != null && !VM.Y) {
                return false;
            }
            return this.myOriginalManager.isCompletelyDirty(component);
        }

        @Override
        public void markCompletelyClean(@NotNull JComponent component) {
            if (component == null) {
                MyRepaintManager.l(6);
            }
            if (component.getClientProperty("JCOMPONENT_PARENT_KEY") == null) {
                this.myOriginalManager.markCompletelyClean(component);
            }
        }

        @Override
        public void addDirtyRegion(JComponent c10, int x2, int y2, int w2, int h2) {
            boolean bl = VM.Y;
            if (w2 <= 0 || h2 <= 0) {
                return;
            }
            JComponent jComponent = (JComponent)c10.getClientProperty("JCOMPONENT_PARENT_KEY");
            if (jComponent == null || jComponent.getClass().isInstance(c10)) {
                return;
            }
            MyDelegateComponent myDelegateComponent = (MyDelegateComponent)c10.getClientProperty("FloatingJComponent.Instance");
            while (myDelegateComponent == null && c10 != jComponent) {
                x2 += c10.getX();
                y2 += c10.getY();
                c10 = (JComponent)c10.getParent();
                myDelegateComponent = (MyDelegateComponent)c10.getClientProperty("FloatingJComponent.Instance");
                if (!bl) continue;
            }
            if (myDelegateComponent == null) {
                return;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            myDelegateComponent.toWorldCoordsWrtDelegateTopLeftAngle(new Rectangle(x2, y2, w2, h2), double_);
            lx lx2 = (lx)((JComponent)jComponent.getParent()).getParent();
            x2 = lx2.l(double_.x);
            y2 = lx2.c(double_.y);
            w2 = (int)Math.ceil(double_.width * lx2.c());
            h2 = (int)Math.ceil(double_.height * lx2.c());
            if (x2 < 1) {
                w2 += x2;
                x2 = 1;
            }
            if (y2 < 1) {
                h2 += y2;
                y2 = 1;
            }
            this.myOriginalManager.addDirtyRegion((JComponent)jComponent.getParent(), x2 - 1, y2 - 1, w2 + 2, h2 + 2);
            if (!bl) {
                return;
            }
            this.myOriginalManager.addDirtyRegion(c10, x2, y2, w2, h2);
        }

        @Override
        public void validateInvalidComponents() {
            this.myOriginalManager.validateInvalidComponents();
        }

        @Override
        @NotNull
        public String toString() {
            String string = "Wrapped : " + this.myOriginalManager.toString();
            if (string == null) {
                MyRepaintManager.l(7);
            }
            return string;
        }

        @Override
        public void paintDirtyRegions() {
            this.myOriginalManager.paintDirtyRegions();
        }

        @Override
        public Dimension getDoubleBufferMaximumSize() {
            return this.myOriginalManager.getDoubleBufferMaximumSize();
        }

        @Override
        public boolean isDoubleBufferingEnabled() {
            return this.myOriginalManager.isDoubleBufferingEnabled();
        }

        private static /* synthetic */ void l(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 2;
                case 2, 3, 4, 5, 6 -> 3;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$MyRepaintManager";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invalidComponent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setupFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$MyRepaintManager";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "markCompletelyDirty";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addInvalidComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDirtyRegion";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompletelyDirty";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "markCompletelyClean";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    abstract class EventsBroker {
        @NotNull
        private final JComponent myEventsReceiver;

        EventsBroker(JComponent eventsReceiver) {
            this.myEventsReceiver = eventsReceiver;
        }

        @NotNull
        public JComponent getEventsReceiver() {
            JComponent jComponent = this.myEventsReceiver;
            if (jComponent == null) {
                EventsBroker.l(0);
            }
            return jComponent;
        }

        @NotNull
        public abstract Cursor getCursor();

        public void adaptAndForward(MouseEvent event) {
            this.adaptAndForward(event, event.getID());
        }

        public abstract void adaptAndForward(MouseEvent var1, int var2);

        protected void dispatchGraphCanvasEventOnSwingComponent(Component receiver, MouseEvent originalEvent, int x2, int y2, int eventId) {
            JByToSwingEventsDelegatingMode.this.dispatchGraphCanvasEventOnSwingComponent(receiver, originalEvent, x2, y2, eventId);
        }

        private static /* synthetic */ void l(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$EventsBroker", "getEventsReceiver"));
        }
    }

    final class SwingComponentEventsBroker
    extends EventsBroker {
        @NotNull
        private final MyDelegateComponent myDelegateComponent;

        SwingComponentEventsBroker(@NotNull MyDelegateComponent delegate, JComponent eventsReceiver) {
            if (delegate == null) {
                SwingComponentEventsBroker.c(0);
            }
            if (eventsReceiver == null) {
                SwingComponentEventsBroker.c(1);
            }
            super(eventsReceiver);
            this.myDelegateComponent = delegate;
        }

        @Override
        public void adaptAndForward(@NotNull MouseEvent event, int eventId) {
            if (event == null) {
                SwingComponentEventsBroker.c(2);
            }
            this.myDelegateComponent.setComponentBoundsInWorldTo(new Rectangle2D.Double());
            double d2 = JByToSwingEventsDelegatingMode.this.c(event.getX());
            double d3 = JByToSwingEventsDelegatingMode.this.l(event.getY());
            Point point = new Point();
            if (this.myDelegateComponent.getSubcomponentPointByItsWorldCoords(this.getEventsReceiver(), d2, d3, point)) {
                super.dispatchGraphCanvasEventOnSwingComponent(this.getEventsReceiver(), event, point.x, point.y, eventId);
            }
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            Cursor cursor = this.getEventsReceiver().getCursor();
            if (cursor == null) {
                SwingComponentEventsBroker.c(3);
            }
            return cursor;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventsReceiver";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$SwingComponentEventsBroker";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$SwingComponentEventsBroker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCursor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "adaptAndForward";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    final class NodeRealizerEventsBroker
    extends EventsBroker {
        private final VM myNodeRealizer;
        private final JComponent myDelegateComponent;

        NodeRealizerEventsBroker(JComponent var2, JComponent eventsReceiver, VM nodeRealizer) {
            super(eventsReceiver);
            this.myDelegateComponent = var2;
            this.myNodeRealizer = nodeRealizer;
        }

        @Override
        public void adaptAndForward(@NotNull MouseEvent event, int eventId) {
            if (event == null) {
                NodeRealizerEventsBroker.c(0);
            }
            boolean bl = VM.Y;
            int n2 = (int)(JByToSwingEventsDelegatingMode.this.c(event.getX()) - this.myNodeRealizer.c());
            int n3 = (int)(JByToSwingEventsDelegatingMode.this.l(event.getY()) - this.myNodeRealizer.l());
            Container container2 = this.getEventsReceiver();
            if (container2.isVisible()) {
                while (container2 != this.myDelegateComponent && !bl && container2 != null) {
                    n2 -= ((Component)container2).getX();
                    n3 -= ((Component)container2).getY();
                    container2 = container2.getParent();
                    if (!bl) continue;
                }
                if (container2 != null) {
                    super.dispatchGraphCanvasEventOnSwingComponent(this.getEventsReceiver(), event, n2, n3, eventId);
                }
            }
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            Cursor cursor = this.getEventsReceiver().getCursor();
            if (cursor == null) {
                NodeRealizerEventsBroker.c(1);
            }
            return cursor;
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$NodeRealizerEventsBroker";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/graph/impl/view/JByToSwingEventsDelegatingMode$NodeRealizerEventsBroker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCursor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "adaptAndForward";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

