/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.LspServerManagerListener;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.impl.LspDynamicCapabilities;
import com.intellij.platform.lsp.impl.LspRequestExecutorImpl;
import com.intellij.platform.lsp.impl.LspServerImplKt;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.LspServerNotificationsHandlerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnector;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorSocket;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorStdio;
import com.intellij.platform.lsp.impl.connector.LspInitializationException;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticAndLazyQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLink;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticToken;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.impl.highlightingCommon.LspHighlightingCacheRegistry;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.StringKt;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.FileSystemWatcher;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RelativePattern;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.SignatureHelpRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\b\b\u0007\u0018\u0000 \u00eb\u00012\u00020\u0001:\u0006\u00e9\u0001\u00ea\u0001\u00eb\u0001B)\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0002\bLJ%\u0010M\u001a\u00020N2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020N0PH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\bQJ \u0010R\u001a\u00020N2\u0016\u0010S\u001a\u0012\u0012\b\u0012\u00060=j\u0002`>\u0012\u0004\u0012\u00020N0PH\u0016J4\u0010T\u001a\u0004\u0018\u0001HU\"\u0004\b\u0000\u0010U2\u001c\u0010S\u001a\u0018\u0012\b\u0012\u00060=j\u0002`>\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0V0PH\u0096@\u00a2\u0006\u0002\u0010WJ;\u0010X\u001a\u0004\u0018\u0001HU\"\u0004\b\u0000\u0010U2\u0006\u0010Y\u001a\u00020Z2\u001c\u0010S\u001a\u0018\u0012\b\u0012\u00060=j\u0002`>\u0012\n\u0012\b\u0012\u0004\u0012\u0002HU0V0PH\u0017\u00a2\u0006\u0002\u0010[J\u0010\u0010\\\u001a\u00020]2\u0006\u0010K\u001a\u00020.H\u0016J\u0010\u0010^\u001a\u00020Z2\u0006\u0010_\u001a\u00020`H\u0016J\u0015\u0010a\u001a\u00020N2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0002\bbJ\r\u0010c\u001a\u00020NH\u0000\u00a2\u0006\u0002\bdJ\u0015\u0010e\u001a\u00020N2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0002\bfJ\u0015\u0010g\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0002\bhJ\u0013\u0010i\u001a\b\u0012\u0004\u0012\u00020.0jH\u0001\u00a2\u0006\u0002\bkJ\u001b\u0010l\u001a\u00020N2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020n0jH\u0000\u00a2\u0006\u0002\boJ \u0010p\u001a\u0004\u0018\u00010q2\u0006\u0010r\u001a\u00020n2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020u0tH\u0002J\"\u0010v\u001a\u00020J2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u0002002\b\u0010z\u001a\u0004\u0018\u000100H\u0002J\u0015\u0010{\u001a\u00020N2\u0006\u0010|\u001a\u00020}H\u0000\u00a2\u0006\u0002\b~J \u0010\u007f\u001a\u00020N2\u0006\u0010K\u001a\u00020.2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0000\u00a2\u0006\u0003\b\u0082\u0001J\u000f\u0010\u0083\u0001\u001a\u00020NH\u0000\u00a2\u0006\u0003\b\u0084\u0001J%\u0010\u0085\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0087\u00010\u0086\u00010t2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0088\u0001J\u0018\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u00030\u008a\u00010t2\u0006\u0010K\u001a\u00020.H\u0007J(\u0010\u008b\u0001\u001a\t\u0012\u0005\u0012\u00030\u008a\u00010t2\u0006\u0010K\u001a\u00020.2\u000e\u0010\u008c\u0001\u001a\t\u0012\u0005\u0012\u00030\u008d\u00010tH\u0002J%\u0010\u008e\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u008f\u00010\u0086\u00010t2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0090\u0001J%\u0010\u0091\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0092\u00010\u0086\u00010t2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0093\u0001J%\u0010\u0094\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0095\u00010\u0086\u00010t2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0096\u0001J%\u0010\u0097\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0098\u00010\u0086\u00010t2\u0006\u0010K\u001a\u00020.H\u0001\u00a2\u0006\u0003\b\u0099\u0001J\u0017\u0010\u009a\u0001\u001a\u00020N2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u009b\u0001J\u000f\u0010\u009c\u0001\u001a\u00020NH\u0000\u00a2\u0006\u0003\b\u009d\u0001J\t\u0010\u009e\u0001\u001a\u000204H\u0002J(\u0010\u009f\u0001\u001a\u00020N2\u0007\u0010\u00a0\u0001\u001a\u00020J2\u000e\u0010\u00a1\u0001\u001a\t\u0012\u0004\u0012\u00020N0\u00a2\u0001H\u0000\u00a2\u0006\u0003\b\u00a3\u0001J\t\u0010\u00a4\u0001\u001a\u00020NH\u0002J\u0017\u0010\u00a5\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00a6\u0001J\u0017\u0010\u00a7\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00a8\u0001J\u0017\u0010\u00a9\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00aa\u0001J\u0017\u0010\u00ab\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00ac\u0001J\u0017\u0010\u00ad\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00ae\u0001J*\u0010\u00af\u0001\u001a\u00020J2\u0019\u0010\u00b0\u0001\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000t\u0012\u0004\u0012\u00020J0PH\u0000\u00a2\u0006\u0003\b\u00b1\u0001J\u000f\u0010\u00b2\u0001\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u00b3\u0001J\u000f\u0010\u00b4\u0001\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u00b5\u0001J\u000f\u0010\u00b6\u0001\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u00b7\u0001J\u0017\u0010\u00b8\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00b9\u0001J\u0017\u0010\u00ba\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00bb\u0001J\u0017\u0010\u00bc\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00bd\u0001J\u000f\u0010\u00be\u0001\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u00bf\u0001J\u0017\u0010\u00c0\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00c1\u0001J\u0017\u0010\u00c2\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00c3\u0001J\u0017\u0010\u00c4\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00c5\u0001J\u0017\u0010\u00c6\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00c7\u0001J\u001a\u0010\u00c8\u0001\u001a\u0005\u0018\u00010\u00c9\u00012\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00ca\u0001J\u000f\u0010\u00cb\u0001\u001a\u00020JH\u0000\u00a2\u0006\u0003\b\u00cc\u0001J\u0017\u0010\u00cd\u0001\u001a\u00020J2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00ce\u0001J\u001f\u0010\u00cf\u0001\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010t2\u0006\u0010K\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u00d0\u0001J:\u0010\u00d1\u0001\u001a\u00020J\"\n\b\u0000\u0010\u00d2\u0001*\u00030\u00d3\u00012\u0006\u0010K\u001a\u00020.2\u001b\u0010\u00d4\u0001\u001a\u0016\u0012\u0004\u0012\u000200\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u00d2\u00010\u00030\u00d5\u0001H\u0002JC\u0010\u00d6\u0001\u001a\u0005\u0018\u0001H\u00d2\u0001\"\n\b\u0000\u0010\u00d2\u0001*\u00030\u00d3\u00012\u0006\u0010K\u001a\u00020.2\u001b\u0010\u00d4\u0001\u001a\u0016\u0012\u0004\u0012\u000200\u0012\u000b\u0012\t\u0012\u0005\u0012\u0003H\u00d2\u00010\u00030\u00d5\u0001H\u0002\u00a2\u0006\u0003\u0010\u00d7\u0001J\u0018\u0010\u00d8\u0001\u001a\u00020N2\u0007\u0010\u00d9\u0001\u001a\u000200H\u0000\u00a2\u0006\u0003\b\u00da\u0001J\t\u0010\u00db\u0001\u001a\u000200H\u0016J\u001e\u0010\u00dc\u0001\u001a\u00020N2\r\u0010\u00dd\u0001\u001a\b00\u00a2\u0006\u0003\b\u00de\u0001H\u0000\u00a2\u0006\u0003\b\u00df\u0001J\u001e\u0010\u00e0\u0001\u001a\u00020N2\r\u0010\u00dd\u0001\u001a\b00\u00a2\u0006\u0003\b\u00de\u0001H\u0000\u00a2\u0006\u0003\b\u00e1\u0001J,\u0010\u00e2\u0001\u001a\u00020N2\r\u0010\u00dd\u0001\u001a\b00\u00a2\u0006\u0003\b\u00de\u00012\f\b\u0002\u0010\u00e3\u0001\u001a\u0005\u0018\u00010\u00e4\u0001H\u0000\u00a2\u0006\u0003\b\u00e5\u0001J\u001e\u0010\u00e6\u0001\u001a\u00020N2\r\u0010\u00dd\u0001\u001a\b00\u00a2\u0006\u0003\b\u00de\u0001H\u0000\u00a2\u0006\u0003\b\u00e7\u0001J\u0012\u0010\u00e8\u0001\u001a\u0002002\u0007\u0010\u00dd\u0001\u001a\u000200H\u0002R\u001c\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u001c@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00106\u001a\u000607j\u0002`8X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\u0004\u0018\u0001008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010<\u001a\u00060=j\u0002`>8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0016\u0010A\u001a\u0004\u0018\u00010B8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0016\u0010E\u001a\u0004\u0018\u00010F8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u00ec\u0001"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lcom/intellij/platform/lsp/api/LspServer;", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "eventBroadcaster", "Lcom/intellij/platform/lsp/api/LspServerManagerListener;", "LspServerImpl", "(Ljava/lang/Class;Lcom/intellij/platform/lsp/api/LspServerDescriptor;Lcom/intellij/platform/lsp/api/LspServerManagerListener;)V", "getProviderClass", "()Ljava/lang/Class;", "getDescriptor", "()Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/intellij/platform/lsp/api/LspServerState;", "state", "getState", "()Lcom/intellij/platform/lsp/api/LspServerState;", "l", "(Lcom/intellij/platform/lsp/api/LspServerState;)V", "stateLock", "", "Lorg/eclipse/lsp4j/InitializeResult;", "initializeResult", "getInitializeResult", "()Lorg/eclipse/lsp4j/InitializeResult;", "requestExecutor", "Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "getRequestExecutor", "()Lcom/intellij/platform/lsp/impl/LspRequestExecutorImpl;", "dynamicCapabilities", "Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "getDynamicCapabilities$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "serverNotificationsHandler", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "getServerNotificationsHandler$intellij_platform_lsp_impl", "()Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "openedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "unsupportedFilePaths", "", "highlightingCacheRegistry", "Lcom/intellij/platform/lsp/impl/highlightingCommon/LspHighlightingCacheRegistry;", "lsp4jServerConnector", "Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "connectorLock", "errorOutputBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "errorOutput", "getErrorOutput$intellij_platform_lsp_impl", "()Ljava/lang/String;", "lsp4jServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServer$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "serverCapabilities", "Lorg/eclipse/lsp4j/ServerCapabilities;", "getServerCapabilities$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/ServerCapabilities;", "textDocumentSyncKind", "Lorg/eclipse/lsp4j/TextDocumentSyncKind;", "getTextDocumentSyncKind$intellij_platform_lsp_impl", "()Lorg/eclipse/lsp4j/TextDocumentSyncKind;", "isFileOpened", "", "file", "isFileOpened$intellij_platform_lsp_impl", "forEachOpenedFile", "", "action", "Lkotlin/Function1;", "forEachOpenedFile$intellij_platform_lsp_impl", "sendNotification", "lsp4jSender", "sendRequest", "Lsp4jResponse", "Ljava/util/concurrent/CompletableFuture;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendRequestSync", "timeoutMs", "", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getDocumentIdentifier", "Lorg/eclipse/lsp4j/TextDocumentIdentifier;", "getDocumentVersion", "document", "Lcom/intellij/openapi/editor/Document;", "sendDidOpenRequest", "sendDidOpenRequest$intellij_platform_lsp_impl", "sendOpenedFiles", "sendOpenedFiles$intellij_platform_lsp_impl", "sendDidCloseRequest", "sendDidCloseRequest$intellij_platform_lsp_impl", "isSupportedFile", "isSupportedFile$intellij_platform_lsp_impl", "getFilesToClose", "", "getFilesToClose$intellij_platform_lsp_impl", "processFileEvents", "fileChangeInfos", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileChangeInfo;", "processFileEvents$intellij_platform_lsp_impl", "l", "Lorg/eclipse/lsp4j/FileEvent;", "fileChangeInfo", "options", "", "Lorg/eclipse/lsp4j/DidChangeWatchedFilesRegistrationOptions;", "l", "fileInfo", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "globPattern", "basePath", "diagnosticsReceived", "params", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "diagnosticsReceived$intellij_platform_lsp_impl", "fileEdited", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "fileEdited$intellij_platform_lsp_impl", "refreshSemanticTokens", "refreshSemanticTokens$intellij_platform_lsp_impl", "getSemanticTokens", "Lcom/intellij/platform/lsp/impl/highlightingCommon/LspCachedHighlighting;", "Lcom/intellij/platform/lsp/impl/highlighting/LspSemanticToken;", "getSemanticTokens$intellij_platform_lsp_impl", "getDiagnosticsAndQuickFixes", "Lcom/intellij/platform/lsp/impl/highlighting/DiagnosticAndQuickFixes;", "l", "alreadyKnownDiagnostics", "Lorg/eclipse/lsp4j/Diagnostic;", "getColorInfos", "Lorg/eclipse/lsp4j/Color;", "getColorInfos$intellij_platform_lsp_impl", "getDocumentLinkInfos", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;", "getDocumentLinkInfos$intellij_platform_lsp_impl", "getFoldingRangeInfos", "Lorg/eclipse/lsp4j/FoldingRange;", "getFoldingRangeInfos$intellij_platform_lsp_impl", "getInlayHints", "Lorg/eclipse/lsp4j/InlayHint;", "getInlayHints$intellij_platform_lsp_impl", "notifyDocumentLinksReceived", "notifyDocumentLinksReceived$intellij_platform_lsp_impl", "start", "start$intellij_platform_lsp_impl", "l", "ensureServerStopped", "explicitStop", "updateLspServerManagerState", "Lkotlin/Function0;", "ensureServerStopped$intellij_platform_lsp_impl", "l", "supportsPullDiagnostics", "supportsPullDiagnostics$intellij_platform_lsp_impl", "supportsDocumentColor", "supportsDocumentColor$intellij_platform_lsp_impl", "supportsDocumentLink", "supportsDocumentLink$intellij_platform_lsp_impl", "supportsDocumentSymbol", "supportsDocumentSymbol$intellij_platform_lsp_impl", "supportsFoldingRange", "supportsFoldingRange$intellij_platform_lsp_impl", "supportsCodeActions", "codeActionKindsFilter", "supportsCodeActions$intellij_platform_lsp_impl", "supportsGotoDefinition", "supportsGotoDefinition$intellij_platform_lsp_impl", "supportsGotoTypeDefinition", "supportsGotoTypeDefinition$intellij_platform_lsp_impl", "supportsHover", "supportsHover$intellij_platform_lsp_impl", "supportsFindReferences", "supportsFindReferences$intellij_platform_lsp_impl", "supportsInlayHints", "supportsInlayHints$intellij_platform_lsp_impl", "supportsDocumentHighlights", "supportsDocumentHighlights$intellij_platform_lsp_impl", "supportsGoToSymbol", "supportsGoToSymbol$intellij_platform_lsp_impl", "supportsSignatureHelp", "supportsSignatureHelp$intellij_platform_lsp_impl", "supportsCallHierarchy", "supportsCallHierarchy$intellij_platform_lsp_impl", "supportsTypeHierarchy", "supportsTypeHierarchy$intellij_platform_lsp_impl", "supportsSelectionRange", "supportsSelectionRange$intellij_platform_lsp_impl", "getDidSaveOptions", "Lorg/eclipse/lsp4j/SaveOptions;", "getDidSaveOptions$intellij_platform_lsp_impl", "hasFormattingRelatedCapabilities", "hasFormattingRelatedCapabilities$intellij_platform_lsp_impl", "doesServerExplicitlyWantToFormatThisFile", "doesServerExplicitlyWantToFormatThisFile$intellij_platform_lsp_impl", "getSignatureHelpTriggerCharacters", "getSignatureHelpTriggerCharacters$intellij_platform_lsp_impl", "l", "T", "Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "capabilityAndOptionsClass", "Lkotlin/Pair;", "l", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/Pair;)Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "appendServerErrorOutput", "text", "appendServerErrorOutput$intellij_platform_lsp_impl", "toString", "logDebug", "message", "Lorg/jetbrains/annotations/NonNls;", "logDebug$intellij_platform_lsp_impl", "logInfo", "logInfo$intellij_platform_lsp_impl", "logWarn", "t", "", "logWarn$intellij_platform_lsp_impl", "logError", "logError$intellij_platform_lsp_impl", "l", "FileInfo", "FileChangeInfo", "Companion", "intellij.platform.lsp.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,676:1\n1#2:677\n1#2:693\n1#2:714\n1869#3,2:678\n774#3:680\n865#3,2:681\n1617#3,9:683\n1869#3:692\n1870#3:694\n1626#3:695\n1563#3:696\n1634#3,3:697\n1563#3:700\n1634#3,3:701\n1617#3,9:704\n1869#3:713\n1870#3:715\n1626#3:716\n1869#3,2:717\n*S KotlinDebug\n*F\n+ 1 LspServerImpl.kt\ncom/intellij/platform/lsp/impl/LspServerImpl\n*L\n230#1:693\n350#1:714\n106#1:678,2\n218#1:680\n218#1:681,2\n230#1:683,9\n230#1:692\n230#1:694\n230#1:695\n330#1:696\n330#1:697,3\n331#1:700\n331#1:701,3\n350#1:704,9\n350#1:713\n350#1:715\n350#1:716\n181#1:717,2\n*E\n"})
public final class LspServerImpl
implements LspServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? extends LspServerSupportProvider> providerClass;
    @NotNull
    private final LspServerDescriptor descriptor;
    @NotNull
    private final LspServerManagerListener eventBroadcaster;
    @NotNull
    private final Project project;
    @NotNull
    private LspServerState state;
    @NotNull
    private final Object stateLock;
    @Nullable
    private InitializeResult initializeResult;
    @NotNull
    private final LspRequestExecutorImpl requestExecutor;
    @NotNull
    private final LspDynamicCapabilities dynamicCapabilities;
    @NotNull
    private final LspServerNotificationsHandler serverNotificationsHandler;
    @NotNull
    private final Set<VirtualFile> openedFiles;
    @NotNull
    private final Set<String> unsupportedFilePaths;
    @NotNull
    private final LspHighlightingCacheRegistry highlightingCacheRegistry;
    private Lsp4jServerConnector lsp4jServerConnector;
    @NotNull
    private final Object connectorLock;
    @NotNull
    private final StringBuilder errorOutputBuffer;
    public static final int NOT_CANCELLABLE_REQUEST_TIMEOUT_MS = 300;
    private static final int MAX_ERROR_OUTPUT_SIZE = 0x100000;

    public LspServerImpl(@NotNull Class<? extends LspServerSupportProvider> providerClass, @NotNull LspServerDescriptor descriptor, @NotNull LspServerManagerListener eventBroadcaster) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)eventBroadcaster, (String)"eventBroadcaster");
        this.providerClass = providerClass;
        this.descriptor = descriptor;
        this.eventBroadcaster = eventBroadcaster;
        this.project = this.getDescriptor().getProject();
        this.state = LspServerState.Initializing;
        this.stateLock = new Object();
        this.requestExecutor = new LspRequestExecutorImpl(this);
        this.dynamicCapabilities = new LspDynamicCapabilities();
        this.serverNotificationsHandler = new LspServerNotificationsHandlerImpl(this);
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.openedFiles = set;
        Set set2 = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set2, (String)"synchronizedSet(...)");
        this.unsupportedFilePaths = set2;
        this.highlightingCacheRegistry = new LspHighlightingCacheRegistry(this);
        this.connectorLock = new Object();
        this.errorOutputBuffer = new StringBuilder();
    }

    @Override
    @NotNull
    public Class<? extends LspServerSupportProvider> getProviderClass() {
        return this.providerClass;
    }

    @Override
    @NotNull
    public LspServerDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public LspServerState getState() {
        return this.state;
    }

    private void l(LspServerState lspServerState) {
        if (lspServerState == LspServerState.Initializing || this.state != LspServerState.Initializing && lspServerState == LspServerState.Running || this.state == LspServerState.ShutdownNormally || this.state == LspServerState.ShutdownUnexpectedly) {
            LspServerImplKt.access$getLogger$p().error("Incorrect state change: " + this.state + " -> " + lspServerState);
            return;
        }
        this.state = lspServerState;
        this.eventBroadcaster.serverStateChanged(this);
    }

    @Override
    @Nullable
    public InitializeResult getInitializeResult() {
        return this.initializeResult;
    }

    @NotNull
    public final LspRequestExecutorImpl getRequestExecutor() {
        return this.requestExecutor;
    }

    @NotNull
    public final LspDynamicCapabilities getDynamicCapabilities$intellij_platform_lsp_impl() {
        return this.dynamicCapabilities;
    }

    @NotNull
    public final LspServerNotificationsHandler getServerNotificationsHandler$intellij_platform_lsp_impl() {
        return this.serverNotificationsHandler;
    }

    @Nullable
    public final String getErrorOutput$intellij_platform_lsp_impl() {
        return StringKt.nullize$default((String)this.errorOutputBuffer.toString(), (boolean)false, (int)1, null);
    }

    @NotNull
    public final LanguageServer getLsp4jServer$intellij_platform_lsp_impl() {
        Lsp4jServerConnector lsp4jServerConnector = this.lsp4jServerConnector;
        if (lsp4jServerConnector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
            lsp4jServerConnector = null;
        }
        return lsp4jServerConnector.getLsp4jServer();
    }

    @Nullable
    public final ServerCapabilities getServerCapabilities$intellij_platform_lsp_impl() {
        Object object;
        if (this.getState() == LspServerState.Running) {
            InitializeResult initializeResult = this.getInitializeResult();
            object = initializeResult != null ? initializeResult.getCapabilities() : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final TextDocumentSyncKind getTextDocumentSyncKind$intellij_platform_lsp_impl() {
        TextDocumentSyncKind textDocumentSyncKind;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTextDocumentSync()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            textDocumentSyncKind = (TextDocumentSyncKind)serverCapabilities2.getLeft();
            if (textDocumentSyncKind == null) {
                textDocumentSyncKind = ((TextDocumentSyncOptions)serverCapabilities2.getRight()).getChange();
            }
        } else {
            textDocumentSyncKind = null;
        }
        return textDocumentSyncKind;
    }

    public final boolean isFileOpened$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOriginFileIfBacked(...)");
        VirtualFile virtualFile2 = virtualFile;
        return this.openedFiles.contains(virtualFile2);
    }

    public final void forEachOpenedFile$intellij_platform_lsp_impl(@NotNull Function1<? super VirtualFile, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean bl = false;
        Iterable iterable = this.openedFiles;
        boolean bl2 = false;
        for (Object t2 : iterable) {
            action.invoke(t2);
        }
    }

    @Override
    public void sendNotification(@NotNull Function1<? super LanguageServer, Unit> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        this.requestExecutor.sendNotification$intellij_platform_lsp_impl(lsp4jSender);
    }

    @Override
    @Nullable
    public <Lsp4jResponse> Object sendRequest(@NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender, @NotNull Continuation<? super Lsp4jResponse> $completion) {
        return this.requestExecutor.sendRequest$intellij_platform_lsp_impl(lsp4jSender, $completion);
    }

    @Override
    @RequiresBackgroundThread
    @Nullable
    public <Lsp4jResponse> Lsp4jResponse sendRequestSync(int timeoutMs, @NotNull Function1<? super LanguageServer, ? extends CompletableFuture<Lsp4jResponse>> lsp4jSender) {
        Intrinsics.checkNotNullParameter(lsp4jSender, (String)"lsp4jSender");
        return this.requestExecutor.sendRequestSync$intellij_platform_lsp_impl(timeoutMs, lsp4jSender);
    }

    @Override
    @NotNull
    public TextDocumentIdentifier getDocumentIdentifier(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new TextDocumentIdentifier(this.getDescriptor().getFileUri(file));
    }

    @Override
    public int getDocumentVersion(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DocumentEx documentEx = document instanceof DocumentEx ? (DocumentEx)document : null;
        return documentEx != null ? documentEx.getModificationSequence() : (int)document.getModificationStamp();
    }

    @RequiresWriteLock
    public final void sendDidOpenRequest$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.getState() != LspServerState.Running) {
            this.logError$intellij_platform_lsp_impl("Server is not in the Running state. Ignoring sendDidOpenRequest(" + file + ")");
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            this.logInfo$intellij_platform_lsp_impl("Skipping didOpen request because there's no document for file " + file);
            return;
        }
        if (this.openedFiles.add(file)) {
            TextDocumentItem textDocumentItem = new TextDocumentItem(this.getDescriptor().getFileUri(file), this.getDescriptor().getLanguageId(file), this.getDocumentVersion(document), document.getText());
            this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.l(textDocumentItem, arg_0)));
            this.eventBroadcaster.fileOpened(this, file);
            MessageBus messageBus = ApplicationKt.getApplication().getMessageBus();
            Topic topic = BreadcrumbsXmlWrapper.FORCE_RELOAD_BREADCRUMBS;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FORCE_RELOAD_BREADCRUMBS");
            ((Runnable)messageBus.syncPublisher(topic)).run();
        } else {
            this.logError$intellij_platform_lsp_impl("sendDidOpenRequest() cannot be called for already opened files. Ignoring: " + file);
        }
    }

    public final void sendOpenedFiles$intellij_platform_lsp_impl() {
        ReadAction.nonBlocking(() -> LspServerImpl.l(this)).expireWhen(() -> LspServerImpl.l(this)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> LspServerImpl.l(arg_0 -> LspServerImpl.l(this, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @RequiresWriteLock
    public final void sendDidCloseRequest$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.openedFiles.remove(file)) {
            this.logError$intellij_platform_lsp_impl("sendDidCloseRequest() cannot be called for files that haven't been opened. Ignoring: " + file);
            return;
        }
        DidCloseTextDocumentParams didCloseTextDocumentParams = new DidCloseTextDocumentParams(this.getDocumentIdentifier(file));
        this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.l(didCloseTextDocumentParams, arg_0)));
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    public final boolean isSupportedFile$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isInLocalFileSystem()) {
            return false;
        }
        if (this.unsupportedFilePaths.contains(file.getPath())) {
            return false;
        }
        if (!ProjectFileIndex.getInstance((Project)this.getProject()).isInContent(file)) {
            return false;
        }
        boolean bl2 = bl = this.getDescriptor().isSupportedFile(file);
        boolean bl3 = false;
        if (!bl2) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.unsupportedFilePaths.add(string);
        }
        return bl;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final Collection<VirtualFile> getFilesToClose$intellij_platform_lsp_impl() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.getProject());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Iterable iterable = this.openedFiles;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            Document document;
            boolean bl3;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = (VirtualFile)t2;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)BackedVirtualFile.getOriginFileIfBacked((VirtualFile)virtualFile2), (String)"getOriginFileIfBacked(...)");
            if (!(fileEditorManager.isFileOpen(virtualFile) ? false : (bl3 = (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) == null || !fileDocumentManager2.isDocumentUnsaved(document)))) continue;
            collection.add(t2);
        }
        return (List)collection;
    }

    public final void processFileEvents$intellij_platform_lsp_impl(@NotNull Collection<FileChangeInfo> fileChangeInfos) {
        Intrinsics.checkNotNullParameter(fileChangeInfos, (String)"fileChangeInfos");
        List<DidChangeWatchedFilesRegistrationOptions> list = this.dynamicCapabilities.getCapabilityRegistrationOptions(LspDynamicCapabilities.Companion.getDidChangeWatchedFiles());
        Iterable iterable = fileChangeInfos;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            FileEvent fileEvent;
            Object t2;
            Object t3 = t2 = iterator.next();
            boolean bl4 = false;
            FileChangeInfo fileChangeInfo = (FileChangeInfo)t3;
            boolean bl5 = false;
            if (this.l(fileChangeInfo, list) == null) continue;
            boolean bl6 = false;
            collection.add(fileEvent);
        }
        List list2 = (List)collection;
        if (!((Collection)list2).isEmpty()) {
            this.sendNotification((Function1<? super LanguageServer, Unit>)((Function1)arg_0 -> LspServerImpl.l(list2, arg_0)));
        }
    }

    private final FileEvent l(FileChangeInfo fileChangeInfo, List<? extends DidChangeWatchedFilesRegistrationOptions> list) {
        for (DidChangeWatchedFilesRegistrationOptions didChangeWatchedFilesRegistrationOptions : list) {
            for (FileSystemWatcher fileSystemWatcher : didChangeWatchedFilesRegistrationOptions.getWatchers()) {
                String string;
                if (!fileChangeInfo.doesFileWatcherKindMatchFileChangeType(fileSystemWatcher.getKind())) continue;
                if (fileSystemWatcher.getGlobPattern().isLeft()) {
                    string = (String)fileSystemWatcher.getGlobPattern().getLeft();
                    FileInfo fileInfo = fileChangeInfo;
                    Intrinsics.checkNotNull((Object)string);
                    if (!this.l(fileInfo, string, null)) continue;
                    return new FileEvent(fileChangeInfo.getUri(), fileChangeInfo.getChangeType());
                }
                string = (RelativePattern)fileSystemWatcher.getGlobPattern().getRight();
                Object object = string.getBaseUri();
                if (object == null || (object = (WorkspaceFolder)object.getLeft()) == null || (object = object.getUri()) == null) {
                    object = (String)string.getBaseUri().getRight();
                }
                Object object2 = object;
                LspServerDescriptor lspServerDescriptor = this.getDescriptor();
                Intrinsics.checkNotNull((Object)object2);
                VirtualFile virtualFile = lspServerDescriptor.findFileByUri((String)object2);
                if (virtualFile == null || !virtualFile.isDirectory()) continue;
                String string2 = string.getPattern();
                FileInfo fileInfo = fileChangeInfo;
                Intrinsics.checkNotNull((Object)string2);
                if (!this.l(fileInfo, string2, virtualFile.getPath())) continue;
                return new FileEvent(fileChangeInfo.getUri(), fileChangeInfo.getChangeType());
            }
        }
        return null;
    }

    private final boolean l(FileInfo fileInfo, String string, String string2) {
        String string3;
        if (string2 == null) {
            string3 = fileInfo.getPath();
        } else if (Intrinsics.areEqual((Object)fileInfo.getPath(), (Object)string2)) {
            string3 = "";
        } else if (StringsKt.startsWith$default((String)fileInfo.getPath(), (String)(string2 + "/"), (boolean)false, (int)2, null)) {
            String string4 = fileInfo.getPath().substring(string2.length() + 1);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            return false;
        }
        String string5 = string3;
        if (fileInfo.isDirectory()) {
            return true;
        }
        PathMatcher pathMatcher = this.dynamicCapabilities.getPathMatcherCaching(string);
        return pathMatcher.matches(Path.of(string5, new String[0]));
    }

    public final void diagnosticsReceived$intellij_platform_lsp_impl(@NotNull PublishDiagnosticsParams params) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LspServerDescriptor lspServerDescriptor = this.getDescriptor();
        String string = params.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        VirtualFile virtualFile = lspServerDescriptor.findFileByUri(string);
        if (virtualFile != null && params.getVersion() != null && this.openedFiles.contains(virtualFile) && (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) != null) {
            Integer n2 = params.getVersion();
            if (n2 == null || this.getDocumentVersion(document) != n2.intValue()) {
                this.logDebug$intellij_platform_lsp_impl("Ignoring diagnostics (version " + params.getVersion() + ") for " + virtualFile.getName() + "; current document version: " + this.getDocumentVersion(document));
                return;
            }
        }
        this.highlightingCacheRegistry.getPublishDiagnosticsCache$intellij_platform_lsp_impl().diagnosticsReceived$intellij_platform_lsp_impl(virtualFile, params);
        if (virtualFile != null) {
            BuildersKt.launch$default((CoroutineScope)LspServerManagerImpl.Companion.getInstanceImpl(this.getProject()).getCs$intellij_platform_lsp_impl(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
                int label;
                final /* synthetic */ LspServerImpl this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = LspServerManagerImpl.Companion.restartCodeHighlighting$intellij_platform_lsp_impl(this.this$0.getProject(), this.$file, "LspServerImpl.diagnosticsReceived", (Continuation<? super Unit>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            LspServerImpl.access$getEventBroadcaster$p(this.this$0).diagnosticsReceived(this.this$0, this.$file);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p12, Continuation<? super Unit> p22) {
                    return (this.create(p12, p22)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void fileEdited$intellij_platform_lsp_impl(@NotNull VirtualFile file, @NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        this.highlightingCacheRegistry.fileEdited$intellij_platform_lsp_impl(file, e2);
    }

    public final void refreshSemanticTokens$intellij_platform_lsp_impl() {
        this.highlightingCacheRegistry.getSemanticTokensCache$intellij_platform_lsp_impl().clearCache$intellij_platform_lsp_impl();
        DaemonCodeAnalyzerEx.getInstanceEx((Project)this.getProject()).restart((Object)"LspServerImpl.refreshSemanticTokens");
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<LspSemanticToken>> getSemanticTokens$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.highlightingCacheRegistry.getSemanticTokensCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<DiagnosticAndQuickFixes> getDiagnosticsAndQuickFixes(@NotNull VirtualFile file) {
        Collection collection;
        LspDiagnosticAndLazyQuickFixes lspDiagnosticAndLazyQuickFixes;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<LspDiagnosticAndLazyQuickFixes> list = this.highlightingCacheRegistry.getPublishDiagnosticsCache$intellij_platform_lsp_impl().getDiagnostics$intellij_platform_lsp_impl(file);
        Iterable iterable = list;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Iterable iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object object2 : iterable2) {
            lspDiagnosticAndLazyQuickFixes = (LspDiagnosticAndLazyQuickFixes)object2;
            collection = iterable3;
            boolean bl3 = false;
            collection.add(lspDiagnosticAndLazyQuickFixes.getDiagnostic());
        }
        List list2 = (List)iterable3;
        List<DiagnosticAndQuickFixes> list3 = (List<DiagnosticAndQuickFixes>)list;
        boolean bl4 = false;
        iterable3 = list3;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)list3, (int)10));
        boolean bl5 = false;
        object2 = iterable3.iterator();
        while (object2.hasNext()) {
            LspDiagnosticAndLazyQuickFixes lspDiagnosticAndLazyQuickFixes2 = lspDiagnosticAndLazyQuickFixes = object2.next();
            collection = collection2;
            boolean bl6 = false;
            collection.add(new DiagnosticAndQuickFixes(lspDiagnosticAndLazyQuickFixes2.getDiagnostic(), lspDiagnosticAndLazyQuickFixes2.getQuickFixes(this, file)));
        }
        iterable = (List)collection2;
        list3 = this.l(file, list2);
        return CollectionsKt.plus((Collection)((Collection)iterable), (Iterable)list3);
    }

    private final List<DiagnosticAndQuickFixes> l(VirtualFile virtualFile, List<? extends Diagnostic> list) {
        List list2 = this.highlightingCacheRegistry.getPullDiagnosticsCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(virtualFile);
        if (list2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document document2 = document;
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            DiagnosticAndQuickFixes diagnosticAndQuickFixes;
            Object t2;
            Object t3 = t2 = iterator.next();
            boolean bl4 = false;
            LspCachedHighlighting lspCachedHighlighting = (LspCachedHighlighting)t3;
            boolean bl5 = false;
            Diagnostic diagnostic = ((LspDiagnosticAndLazyQuickFixes)lspCachedHighlighting.getHighlightingInfo()).getDiagnostic();
            if (list.contains(diagnostic)) {
                diagnosticAndQuickFixes = null;
            } else {
                Diagnostic diagnostic2;
                TextRange textRange = lspCachedHighlighting.getTextRange();
                Range range = Lsp4jUtilKt.getLsp4jRange(document2, textRange.getStartOffset(), textRange.getLength());
                Diagnostic diagnostic3 = diagnostic2 = new Diagnostic();
                boolean bl6 = false;
                diagnostic3.setRange(range);
                diagnostic3.setSeverity(diagnostic.getSeverity());
                diagnostic3.setCode(diagnostic.getCode());
                diagnostic3.setCodeDescription(diagnostic.getCodeDescription());
                diagnostic3.setSource(diagnostic.getSource());
                diagnostic3.setMessage(diagnostic.getMessage());
                diagnostic3.setTags(diagnostic.getTags());
                diagnostic3.setRelatedInformation(diagnostic.getRelatedInformation());
                diagnostic3.setData(diagnostic.getData());
                Diagnostic diagnostic4 = diagnostic2;
                diagnosticAndQuickFixes = new DiagnosticAndQuickFixes(diagnostic4, ((LspDiagnosticAndLazyQuickFixes)lspCachedHighlighting.getHighlightingInfo()).getQuickFixes(this, virtualFile));
            }
            if (diagnosticAndQuickFixes == null) continue;
            DiagnosticAndQuickFixes diagnosticAndQuickFixes2 = diagnosticAndQuickFixes;
            boolean bl7 = false;
            collection.add(diagnosticAndQuickFixes2);
        }
        return (List)collection;
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<Color>> getColorInfos$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.highlightingCacheRegistry.getDocumentColorCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<LspDocumentLink>> getDocumentLinkInfos$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.highlightingCacheRegistry.getDocumentLinkCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<FoldingRange>> getFoldingRangeInfos$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.highlightingCacheRegistry.getFoldingRangeCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(file);
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    public final List<LspCachedHighlighting<InlayHint>> getInlayHints$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.highlightingCacheRegistry.getInlayHintsCache$intellij_platform_lsp_impl().getHighlightings$intellij_platform_lsp_impl(file);
    }

    public final void notifyDocumentLinksReceived$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.eventBroadcaster.documentLinksReceived(this, file);
    }

    public final void start$intellij_platform_lsp_impl() {
        if (!TrustedProjects.isProjectTrusted((Project)this.getProject())) {
            throw new IllegalStateException("Project is not trusted");
        }
        if (this.getState() != LspServerState.Initializing) {
            this.logError$intellij_platform_lsp_impl("start() cannot be called for a server twice");
            return;
        }
        this.logInfo$intellij_platform_lsp_impl("Starting LSP server");
        long l10 = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        ApplicationManager.getApplication().executeOnPooledThread(() -> LspServerImpl.l(this, l10));
    }

    private final Lsp4jServerConnector l() {
        Lsp4jServerConnector lsp4jServerConnector;
        LspCommunicationChannel lspCommunicationChannel = this.getDescriptor().getLspCommunicationChannel();
        if (lspCommunicationChannel instanceof LspCommunicationChannel.StdIO) {
            lsp4jServerConnector = new Lsp4jServerConnectorStdio(this);
        } else if (lspCommunicationChannel instanceof LspCommunicationChannel.Socket) {
            lsp4jServerConnector = new Lsp4jServerConnectorSocket(this);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lsp4jServerConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureServerStopped$intellij_platform_lsp_impl(boolean explicitStop, @NotNull Function0<Unit> updateLspServerManagerState) {
        Intrinsics.checkNotNullParameter(updateLspServerManagerState, (String)"updateLspServerManagerState");
        Object object = this.stateLock;
        synchronized (object) {
            boolean bl = false;
            updateLspServerManagerState.invoke();
            LspServerState[] lspServerStateArray = new LspServerState[]{LspServerState.ShutdownNormally, LspServerState.ShutdownUnexpectedly};
            if (ArraysKt.contains((Object[])lspServerStateArray, (Object)((Object)this.getState()))) {
                return;
            }
            this.logInfo$intellij_platform_lsp_impl("Stopping LSP server " + (explicitStop ? "normally" : "unexpectedly"));
            this.l(explicitStop ? LspServerState.ShutdownNormally : LspServerState.ShutdownUnexpectedly);
            this.openedFiles.clear();
            this.requestExecutor.shutdownNow$intellij_platform_lsp_impl();
            this.highlightingCacheRegistry.clearCache$intellij_platform_lsp_impl();
            LspServerManagerImpl.Companion.refreshInlayHints$intellij_platform_lsp_impl(this.getProject());
            Unit unit = Unit.INSTANCE;
        }
        this.l();
    }

    private final void l() {
        Runnable runnable = () -> LspServerImpl.l(this);
        if (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed()) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
            Intrinsics.checkNotNull((Object)future);
        } else {
            runnable.run();
        }
    }

    public final boolean supportsPullDiagnostics$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        return (serverCapabilities != null ? serverCapabilities.getDiagnosticProvider() : null) != null || this.l(file, LspDynamicCapabilities.Companion.getDiagnostic()) != false;
    }

    public final boolean supportsDocumentColor$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getColorProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getDocumentColor());
        }
        return (boolean)object;
    }

    public final boolean supportsDocumentLink$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        return (serverCapabilities != null ? serverCapabilities.getDocumentLinkProvider() : null) != null || this.l(file, LspDynamicCapabilities.Companion.getDocumentLink()) != false;
    }

    public final boolean supportsDocumentSymbol$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        return (serverCapabilities != null ? serverCapabilities.getDocumentSymbolProvider() : null) != null || this.l(file, LspDynamicCapabilities.Companion.getDocumentSymbol()) != false;
    }

    public final boolean supportsFoldingRange$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getFoldingRangeProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getFoldingRange());
        }
        return (boolean)object;
    }

    public final boolean supportsCodeActions$intellij_platform_lsp_impl(@NotNull Function1<? super List<String>, Boolean> codeActionKindsFilter) {
        Either either;
        Intrinsics.checkNotNullParameter(codeActionKindsFilter, (String)"codeActionKindsFilter");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (either = serverCapabilities.getCodeActionProvider()) != null) {
            Either either2 = either;
            boolean bl = false;
            if (either2.isLeft()) {
                Object object = either2.getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLeft(...)");
                return (Boolean)object;
            }
            List list = ((CodeActionOptions)either2.getRight()).getCodeActionKinds();
            if (list == null) {
                return true;
            }
            return (Boolean)codeActionKindsFilter.invoke((Object)list);
        }
        return false;
    }

    public final boolean supportsGotoDefinition$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getDefinitionProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsGotoTypeDefinition$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTypeDefinitionProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsHover$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getHoverProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean supportsFindReferences$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getReferencesProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getReferences());
        }
        return (boolean)object;
    }

    public final boolean supportsInlayHints$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getInlayHintProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getInlayHint());
        }
        return (boolean)object;
    }

    public final boolean supportsDocumentHighlights$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getDocumentHighlightProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getDocumentHighlight());
        }
        return (boolean)object;
    }

    public final boolean supportsGoToSymbol$intellij_platform_lsp_impl() {
        boolean bl;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getWorkspaceSymbolProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)serverCapabilities2.getLeft();
            bl = bl3 != null ? bl3 : true;
        } else {
            bl = false;
        }
        return bl || this.dynamicCapabilities.hasCapability(LspDynamicCapabilities.Companion.getSymbol());
    }

    public final boolean supportsSignatureHelp$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        return (serverCapabilities != null ? serverCapabilities.getSignatureHelpProvider() : null) != null || this.l(file, LspDynamicCapabilities.Companion.getSignatureHelp()) != false;
    }

    public final boolean supportsCallHierarchy$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getCallHierarchyProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getPrepareCallHierarchy());
        }
        return (boolean)object;
    }

    public final boolean supportsTypeHierarchy$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTypeHierarchyProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getPrepareTypeHierarchy());
        }
        return (boolean)object;
    }

    public final boolean supportsSelectionRange$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getSelectionRangeProvider()) != null) {
            ServerCapabilities serverCapabilities2 = serverCapabilities;
            boolean bl = false;
            Boolean bl2 = (Boolean)serverCapabilities2.getLeft();
            object = bl2 != null ? (Object)bl2 : (Object)true;
        } else {
            object = this.l(file, LspDynamicCapabilities.Companion.getSelectionRange());
        }
        return (boolean)object;
    }

    @Nullable
    public final SaveOptions getDidSaveOptions$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        SaveOptions saveOptions;
        Either either;
        TextDocumentSyncOptions textDocumentSyncOptions;
        Either either2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities != null && (serverCapabilities = serverCapabilities.getTextDocumentSync()) != null && (serverCapabilities = (TextDocumentSyncOptions)serverCapabilities.getRight()) != null && (serverCapabilities = serverCapabilities.getSave()) != null ? Intrinsics.areEqual((Object)serverCapabilities.getLeft(), (Object)true) : false) {
            return new SaveOptions(Boolean.valueOf(false));
        }
        ServerCapabilities serverCapabilities2 = this.getServerCapabilities$intellij_platform_lsp_impl();
        if (serverCapabilities2 != null && (either2 = serverCapabilities2.getTextDocumentSync()) != null && (textDocumentSyncOptions = (TextDocumentSyncOptions)either2.getRight()) != null && (either = textDocumentSyncOptions.getSave()) != null && (saveOptions = (SaveOptions)either.getRight()) != null) {
            SaveOptions saveOptions2 = saveOptions;
            boolean bl = false;
            return saveOptions2;
        }
        serverCapabilities2 = this.l(file, LspDynamicCapabilities.Companion.getDidSave());
        if (serverCapabilities2 != null) {
            textDocumentSyncOptions = serverCapabilities2;
            boolean bl = false;
            return new SaveOptions(textDocumentSyncOptions.getIncludeText());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasFormattingRelatedCapabilities$intellij_platform_lsp_impl() {
        if (this.dynamicCapabilities.hasCapability(LspDynamicCapabilities.Companion.getFormatting())) return true;
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        ServerCapabilities serverCapabilities2 = serverCapabilities;
        if (serverCapabilities == null) return false;
        Either either = serverCapabilities2.getDocumentFormattingProvider();
        serverCapabilities2 = either;
        if (either == null) return false;
        ServerCapabilities serverCapabilities3 = serverCapabilities2;
        boolean bl = false;
        Boolean bl2 = (Boolean)serverCapabilities3.getLeft();
        if (bl2 == null) return true;
        boolean bl3 = bl2;
        if (!bl3) return false;
        return true;
    }

    public final boolean doesServerExplicitlyWantToFormatThisFile$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (boolean)this.l(file, LspDynamicCapabilities.Companion.getFormatting());
    }

    @Nullable
    public final List<String> getSignatureHelpTriggerCharacters$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        SignatureHelpRegistrationOptions signatureHelpRegistrationOptions;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ServerCapabilities serverCapabilities = this.getServerCapabilities$intellij_platform_lsp_impl();
        List list = serverCapabilities != null && (serverCapabilities = serverCapabilities.getSignatureHelpProvider()) != null ? serverCapabilities.getTriggerCharacters() : null;
        SignatureHelpRegistrationOptions signatureHelpRegistrationOptions2 = signatureHelpRegistrationOptions = this.l(file, LspDynamicCapabilities.Companion.getSignatureHelp());
        List list2 = signatureHelpRegistrationOptions2 != null ? signatureHelpRegistrationOptions2.getTriggerCharacters() : null;
        List list3 = list2;
        if (list3 == null && (list3 = list) == null) {
            list3 = null;
        }
        return list3;
    }

    private final <T extends TextDocumentRegistrationOptions> boolean l(VirtualFile virtualFile, Pair<String, Class<T>> pair) {
        return this.l(virtualFile, pair) != null;
    }

    private final <T extends TextDocumentRegistrationOptions> T l(VirtualFile virtualFile, Pair<String, Class<T>> pair) {
        if (virtualFile.isDirectory()) {
            LspServerImpl.logWarn$intellij_platform_lsp_impl$default(this, "Directory not expected here. Capability: " + pair.getFirst() + ", file: " + virtualFile.getPath(), null, 2, null);
            return null;
        }
        for (TextDocumentRegistrationOptions textDocumentRegistrationOptions : this.dynamicCapabilities.getCapabilityRegistrationOptions(pair)) {
            List list;
            if (textDocumentRegistrationOptions.getDocumentSelector() == null) {
                return (T)textDocumentRegistrationOptions;
            }
            for (DocumentFilter documentFilter : list) {
                if (documentFilter.getScheme() != null && !Intrinsics.areEqual((Object)documentFilter.getScheme(), (Object)"file")) continue;
                String string = documentFilter.getLanguage();
                String string2 = documentFilter.getPattern();
                if (string == null && string2 == null || string != null && !Intrinsics.areEqual((Object)string, (Object)this.getDescriptor().getLanguageId(virtualFile))) continue;
                if (string2 != null) {
                    String string3 = virtualFile.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    if (!this.l(new FileInfo(string3, false), string2, null)) continue;
                }
                return (T)textDocumentRegistrationOptions;
            }
        }
        return null;
    }

    public final void appendServerErrorOutput$intellij_platform_lsp_impl(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(((CharSequence)this.errorOutputBuffer).length() == 0)) {
            this.errorOutputBuffer.append("\n");
        }
        if (text.length() > 0x100000) {
            int n2 = this.errorOutputBuffer.length();
            String string = text.substring(text.length() - 0x100000);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            v2 = this.errorOutputBuffer.replace(0, n2, string);
        } else if (this.errorOutputBuffer.length() + text.length() > 0x100000) {
            this.errorOutputBuffer.delete(0, this.errorOutputBuffer.length() + text.length() - 0x100000);
            v2 = this.errorOutputBuffer.append(text);
        } else {
            v2 = this.errorOutputBuffer.append(text);
        }
    }

    @NotNull
    public String toString() {
        return this.getDescriptor() + "(" + this.getState() + ";" + this.openedFiles.size() + ")";
    }

    public final void logDebug$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().debug(this.l(message));
    }

    public final void logInfo$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().info(this.l(message));
    }

    public final void logWarn$intellij_platform_lsp_impl(@NotNull String message, @Nullable Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().warn(this.l(message), t2);
    }

    public static /* synthetic */ void logWarn$intellij_platform_lsp_impl$default(LspServerImpl lspServerImpl, String string, Throwable throwable, int n2, Object object) {
        if ((n2 & 2) != 0) {
            throwable = null;
        }
        lspServerImpl.logWarn$intellij_platform_lsp_impl(string, throwable);
    }

    public final void logError$intellij_platform_lsp_impl(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LspServerImplKt.access$getLogger$p().error(this.l(message));
    }

    private final String l(String string) {
        return this + ": " + string;
    }

    private static final Unit l(TextDocumentItem textDocumentItem, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didOpen(new DidOpenTextDocumentParams(textDocumentItem));
        return Unit.INSTANCE;
    }

    private static final Set l(LspServerImpl lspServerImpl) {
        Set set = new HashSet();
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)lspServerImpl.getProject()).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        for (VirtualFile virtualFile : virtualFileArray) {
            if (lspServerImpl.openedFiles.contains(virtualFile)) continue;
            Intrinsics.checkNotNull((Object)virtualFile);
            if (!lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile)) continue;
            set.add(virtualFile);
        }
        Document[] documentArray = FileDocumentManager.getInstance().getUnsavedDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)documentArray, (String)"getUnsavedDocuments(...)");
        for (VirtualFile virtualFile : documentArray) {
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)virtualFile);
            if (virtualFile2 == null || lspServerImpl.openedFiles.contains(virtualFile2) || !lspServerImpl.isSupportedFile$intellij_platform_lsp_impl(virtualFile2)) continue;
            set.add(virtualFile2);
        }
        return set;
    }

    private static final boolean l(LspServerImpl lspServerImpl) {
        return lspServerImpl.getState() != LspServerState.Running;
    }

    private static final Unit l(LspServerImpl lspServerImpl, Set set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"files");
        if (set.isEmpty()) {
            return Unit.INSTANCE;
        }
        WriteAction.run(() -> LspServerImpl.l(lspServerImpl, set));
        return Unit.INSTANCE;
    }

    private static final void l(LspServerImpl lspServerImpl, Set set) {
        lspServerImpl.logDebug$intellij_platform_lsp_impl("Opening files after server initialization or after move/rename: " + set);
        Iterable iterable = set;
        boolean bl = false;
        for (Object t2 : iterable) {
            VirtualFile virtualFile = (VirtualFile)t2;
            boolean bl2 = false;
            lspServerImpl.sendDidOpenRequest$intellij_platform_lsp_impl(virtualFile);
        }
    }

    private static final void l(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit l(DidCloseTextDocumentParams didCloseTextDocumentParams, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getTextDocumentService().didClose(didCloseTextDocumentParams);
        return Unit.INSTANCE;
    }

    private static final Unit l(List list, LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"it");
        languageServer.getWorkspaceService().didChangeWatchedFiles(new DidChangeWatchedFilesParams(list));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void l(LspServerImpl lspServerImpl, long l10) {
        block7: {
            try {
                Object object = lspServerImpl.connectorLock;
                synchronized (object) {
                    boolean bl = false;
                    lspServerImpl.lsp4jServerConnector = lspServerImpl.l();
                    Lsp4jServerConnector lsp4jServerConnector = lspServerImpl.lsp4jServerConnector;
                    if (lsp4jServerConnector == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
                        lsp4jServerConnector = null;
                    }
                    lsp4jServerConnector.connect$intellij_platform_lsp_impl((Function1<? super InitializeResult, Unit>)((Function1)arg_0 -> LspServerImpl.l(lspServerImpl, l10, arg_0)));
                    Unit unit = Unit.INSTANCE;
                }
                lspServerImpl.sendOpenedFiles$intellij_platform_lsp_impl();
                LspServerManagerImpl.Companion.restartStructureView$intellij_platform_lsp_impl();
                LspServerManagerImpl.Companion.refreshInlayHints$intellij_platform_lsp_impl(lspServerImpl.getProject());
            }
            catch (Exception exception) {
                Throwable throwable = exception instanceof LspInitializationException ? (LspInitializationException)exception : null;
                if (throwable == null || (throwable = throwable.getCause()) == null) {
                    throwable = exception;
                }
                Throwable throwable2 = throwable;
                lspServerImpl.logWarn$intellij_platform_lsp_impl("Failed to start LSP server", throwable2);
                LspServerManagerImpl lspServerManagerImpl = (LspServerManagerImpl)ReadAction.compute(() -> LspServerImpl.l(lspServerImpl));
                String string = (String)(exception instanceof LspInitializationException ? exception + "\nCaused by:\n" : "") + ExceptionsKt.stackTraceToString((Throwable)throwable2);
                LspServerManagerImpl lspServerManagerImpl2 = lspServerManagerImpl;
                if (lspServerManagerImpl2 == null) break block7;
                lspServerManagerImpl2.handleMaybeUnexpectedServerStop$intellij_platform_lsp_impl(lspServerImpl, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit l(LspServerImpl lspServerImpl, long l10, InitializeResult initializeResult) {
        block9: {
            Object object;
            LspServerImpl lspServerImpl2;
            block8: {
                String string;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)initializeResult, (String)"initializeResult");
                    lspServerImpl.initializeResult = initializeResult;
                    Object object2 = lspServerImpl.stateLock;
                    synchronized (object2) {
                        boolean bl = false;
                        if (lspServerImpl.getState() == LspServerState.Initializing) {
                            lspServerImpl.l(LspServerState.Running);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    string = "LSP server initialized in " + Duration.toString-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)l10), (DurationUnit)DurationUnit.SECONDS, (int)3);
                    lspServerImpl2 = lspServerImpl;
                    object = initializeResult.getServerInfo();
                    if (object == null) break block7;
                    ServerInfo serverInfo = object;
                    LspServerImpl lspServerImpl3 = lspServerImpl2;
                    boolean bl = false;
                    String string2 = string + ", name = " + serverInfo.getName() + ", version = " + serverInfo.getVersion();
                    lspServerImpl2 = lspServerImpl3;
                    object = string2;
                    if (string2 != null) break block8;
                }
                object = string;
            }
            lspServerImpl2.logInfo$intellij_platform_lsp_impl((String)object);
            LspServerListener lspServerListener = lspServerImpl.getDescriptor().getLspServerListener();
            if (lspServerListener == null) break block9;
            lspServerListener.serverInitialized(initializeResult);
        }
        return Unit.INSTANCE;
    }

    private static final LspServerManagerImpl l(LspServerImpl lspServerImpl) {
        return !lspServerImpl.getProject().isDisposed() ? LspServerManagerImpl.Companion.getInstanceImpl(lspServerImpl.getProject()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void l(LspServerImpl lspServerImpl) {
        Object object = lspServerImpl.connectorLock;
        synchronized (object) {
            boolean bl = false;
            if (lspServerImpl.lsp4jServerConnector != null) {
                Lsp4jServerConnector lsp4jServerConnector = lspServerImpl.lsp4jServerConnector;
                if (lsp4jServerConnector == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServerConnector");
                    lsp4jServerConnector = null;
                }
                lsp4jServerConnector.shutdownExitDisconnect$intellij_platform_lsp_impl();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ LspServerManagerListener access$getEventBroadcaster$p(LspServerImpl $this) {
        return $this.eventBroadcaster;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$Companion;", "", "LspServerImpl$Companion", "()V", "NOT_CANCELLABLE_REQUEST_TIMEOUT_MS", "", "MAX_ERROR_OUTPUT_SIZE", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$FileChangeInfo;", "Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "path", "", "uri", "isDirectory", "", "changeType", "Lorg/eclipse/lsp4j/FileChangeType;", "LspServerImpl$FileChangeInfo", "(Ljava/lang/String;Ljava/lang/String;ZLorg/eclipse/lsp4j/FileChangeType;)V", "getUri", "()Ljava/lang/String;", "getChangeType", "()Lorg/eclipse/lsp4j/FileChangeType;", "doesFileWatcherKindMatchFileChangeType", "watchKind", "", "(Ljava/lang/Integer;)Z", "intellij.platform.lsp.impl"})
    public static final class FileChangeInfo
    extends FileInfo {
        @NotNull
        private final String uri;
        @NotNull
        private final FileChangeType changeType;

        public FileChangeInfo(@NotNull String path, @NotNull String uri, boolean isDirectory, @NotNull FileChangeType changeType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
            super(path, isDirectory);
            this.uri = uri;
            this.changeType = changeType;
        }

        @NotNull
        public final String getUri() {
            return this.uri;
        }

        @NotNull
        public final FileChangeType getChangeType() {
            return this.changeType;
        }

        public final boolean doesFileWatcherKindMatchFileChangeType(@Nullable Integer watchKind) {
            if (watchKind == null) {
                return true;
            }
            return switch (WhenMappings.$EnumSwitchMapping$0[this.changeType.ordinal()]) {
                case 1 -> {
                    if ((watchKind & 1) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if ((watchKind & 2) != 0) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if ((watchKind & 4) != 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FileChangeType.values().length];
                try {
                    nArray[FileChangeType.Created.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileChangeType.Changed.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FileChangeType.Deleted.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/LspServerImpl$FileInfo;", "", "path", "", "isDirectory", "", "LspServerImpl$FileInfo", "(Ljava/lang/String;Z)V", "getPath", "()Ljava/lang/String;", "()Z", "intellij.platform.lsp.impl"})
    public static class FileInfo {
        @NotNull
        private final String path;
        private final boolean isDirectory;

        public FileInfo(@NotNull String path, boolean isDirectory) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.isDirectory = isDirectory;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

