/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.logging;

import com.intellij.platform.lsp.impl.logging.LanguageServiceLogger;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerServiceKt;
import com.intellij.util.ApplicationKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/lsp/impl/logging/LoggerBucket;", "", "fileName", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "LoggerBucket", "(Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "lock", "Ljava/lang/Object;", "activeLoggers", "", "Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLogger;", "connect", "writeStandardLogIfLimitReached", "", "l", "", "l", "millis", "", "containsLogger", "logger", "disconnect", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLanguageServiceLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LoggerBucket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1761#2,3:145\n1869#2,2:148\n1761#2,3:150\n*S KotlinDebug\n*F\n+ 1 LanguageServiceLoggerService.kt\ncom/intellij/platform/lsp/impl/logging/LoggerBucket\n*L\n72#1:145,3\n114#1:148,2\n104#1:150,3\n*E\n"})
final class LoggerBucket {
    @NotNull
    private final String fileName;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Object lock;
    @NotNull
    private final List<LanguageServiceLogger> activeLoggers;

    public LoggerBucket(@NotNull String fileName, @NotNull CoroutineScope cs2) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)cs2, (String)"cs");
        this.fileName = fileName;
        this.cs = cs2;
        this.lock = new Object();
        this.activeLoggers = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final LanguageServiceLogger connect(boolean writeStandardLogIfLimitReached) {
        Object object = this.lock;
        synchronized (object) {
            Iterable iterable;
            block9: {
                boolean bl = false;
                if (this.activeLoggers.size() < 5) break block9;
                LanguageServiceLoggerServiceKt.access$getLOG$p().warn("Cannot create a logger for " + this.fileName + ", too many active loggers");
                LanguageServiceLogger languageServiceLogger = null;
                return languageServiceLogger;
            }
            long l10 = System.currentTimeMillis();
            String string = null;
            while (true) {
                boolean bl;
                block10: {
                    string = this.fileName + "-" + this.l(l10) + ".log";
                    iterable = this.activeLoggers;
                    boolean bl2 = false;
                    if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object t2 : iterable) {
                            LanguageServiceLogger languageServiceLogger = (LanguageServiceLogger)t2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)((Object)languageServiceLogger.getLogPath$intellij_platform_lsp_impl().getFileName()).toString(), (Object)string)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    Path path = LanguageServiceLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(string);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                    if (!Files.exists(path, new LinkOption[0])) break;
                }
                long l11 = l10;
                l10 = l11 + 1L;
            }
            Files.createDirectories(LanguageServiceLoggerServiceKt.access$getLOG_PATH_DIR$p(), new FileAttribute[0]);
            Path path = LanguageServiceLoggerServiceKt.access$getLOG_PATH_DIR$p().resolve(string);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            iterable = path;
            LanguageServiceLogger languageServiceLogger = new LanguageServiceLogger((Path)iterable, this.cs, writeStandardLogIfLimitReached);
            this.activeLoggers.add(languageServiceLogger);
            LanguageServiceLoggerServiceKt.access$getLOG$p().info("Created service logger at: " + iterable.toUri());
            ApplicationKt.getApplication().executeOnPooledThread(() -> LoggerBucket.l(this));
            LanguageServiceLogger languageServiceLogger2 = languageServiceLogger;
            return languageServiceLogger2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void l() {
        Regex regex = new Regex(this.fileName + "-\\d{8}-\\d{6}-\\d{3}\\.log");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            List<Object> list = Files.list(LanguageServiceLoggerServiceKt.access$getLOG_PATH_DIR$p()).filter(arg_0 -> LoggerBucket.l(arg_0 -> LoggerBucket.l(regex, this, arg_0), arg_0)).sorted().toList();
            int n2 = 5 - this.activeLoggers.size();
            if (n2 >= list.size()) {
                return;
            }
            int n3 = Math.min(list.size(), list.size() - n2);
            Intrinsics.checkNotNull(list);
            Iterable iterable = CollectionsKt.take((Iterable)list, (int)n3);
            boolean bl2 = false;
            for (Object t2 : iterable) {
                Path path = (Path)t2;
                boolean bl3 = false;
                Files.deleteIfExists(path);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String l(long l10) {
        String string = LanguageServiceLoggerServiceKt.access$getLOG_FILENAME_SUFFIX_FORMAT$p().format(LanguageServiceLoggerServiceKt.millisToDate(l10));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsLogger(@NotNull LanguageServiceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.activeLoggers.contains(logger);
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(@NotNull LanguageServiceLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.close$intellij_platform_lsp_impl();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!this.activeLoggers.remove(logger)) {
                LanguageServiceLoggerServiceKt.access$getLOG$p().error("Logger " + logger.getLogPath$intellij_platform_lsp_impl().getFileName() + " was not registered.");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void l(LoggerBucket loggerBucket) {
        loggerBucket.l();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean l(Regex regex, LoggerBucket loggerBucket, Path path) {
        LanguageServiceLogger languageServiceLogger;
        String string = ((Object)path.getFileName()).toString();
        if (!regex.matches((CharSequence)string)) return false;
        Iterable iterable = loggerBucket.activeLoggers;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return true;
        }
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object t2 = iterator.next();
            languageServiceLogger = (LanguageServiceLogger)t2;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual((Object)((Object)languageServiceLogger.getLogPath$intellij_platform_lsp_impl().getFileName()).toString(), (Object)string));
        return false;
    }

    private static final boolean l(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }
}

