/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "", "tiles", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;)V", "geomInnerBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getGeomInnerBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomOuterBounds", "getGeomOuterBounds", "geomWithAxisBounds", "getGeomWithAxisBounds", "hasBottomAxis", "", "getHasBottomAxis", "()Z", "hasLeftAxis", "getHasLeftAxis", "hasLeftAxisTitle", "getHasLeftAxisTitle", "hasTopAxisTitle", "getHasTopAxisTitle", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getSize", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getTiles", "()Ljava/util/List;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotLayoutInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotLayoutInfo.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1549#2:46\n1620#2,3:47\n2661#2,7:50\n1549#2:57\n1620#2,3:58\n2661#2,7:61\n1549#2:68\n1620#2,3:69\n2661#2,7:72\n*S KotlinDebug\n*F\n+ 1 PlotLayoutInfo.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo\n*L\n28#1:46\n28#1:47,3\n28#1:50,7\n33#1:57\n33#1:58,3\n33#1:61,7\n38#1:68\n38#1:69,3\n38#1:72,7\n*E\n"})
public final class PlotLayoutInfo {
    @NotNull
    private final List<TileLayoutInfo> tiles;
    @NotNull
    private final Insets insets;
    private final boolean hasTopAxisTitle;
    private final boolean hasLeftAxisTitle;
    private final boolean hasBottomAxis;
    private final boolean hasLeftAxis;
    @NotNull
    private final DoubleVector size;

    public PlotLayoutInfo(@NotNull List<TileLayoutInfo> tiles, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter(tiles, (String)"tiles");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this.tiles = tiles;
        this.insets = insets;
        Object object = (TileLayoutInfo)CollectionsKt.firstOrNull(this.tiles);
        this.hasTopAxisTitle = (object != null && (object = ((TileLayoutInfo)object).getAxisInfos()) != null ? ((AxisLayoutInfoQuad)object).getHAxisTitleOrientation() : null) == Orientation.TOP;
        Object object2 = (TileLayoutInfo)CollectionsKt.firstOrNull(this.tiles);
        this.hasLeftAxisTitle = (object2 != null && (object2 = ((TileLayoutInfo)object2).getAxisInfos()) != null ? ((AxisLayoutInfoQuad)object2).getVAxisTitleOrientation() : null) == Orientation.LEFT;
        Object object3 = (TileLayoutInfo)CollectionsKt.firstOrNull(this.tiles);
        this.hasBottomAxis = (object3 != null && (object3 = ((TileLayoutInfo)object3).getAxisInfos()) != null ? ((AxisLayoutInfoQuad)object3).getBottom() : null) != null;
        Object object4 = (TileLayoutInfo)CollectionsKt.firstOrNull(this.tiles);
        this.hasLeftAxis = (object4 != null && (object4 = ((TileLayoutInfo)object4).getAxisInfos()) != null ? ((AxisLayoutInfoQuad)object4).getLeft() : null) != null;
        this.size = this.getGeomWithAxisBounds().getDimension().add(this.insets.getLeftTop()).add(this.insets.getRightBottom());
    }

    @NotNull
    public final List<TileLayoutInfo> getTiles() {
        return this.tiles;
    }

    public final boolean getHasTopAxisTitle() {
        return this.hasTopAxisTitle;
    }

    public final boolean getHasLeftAxisTitle() {
        return this.hasLeftAxisTitle;
    }

    public final boolean getHasBottomAxis() {
        return this.hasBottomAxis;
    }

    public final boolean getHasLeftAxis() {
        return this.hasLeftAxis;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle getGeomInnerBounds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGeomInnerBounds());
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void el;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle acc = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)el);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle getGeomOuterBounds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGeomOuterBounds());
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void el;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle acc = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)el);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleRectangle getGeomWithAxisBounds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TileLayoutInfo tileLayoutInfo = (TileLayoutInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGeomWithAxisBounds());
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void el;
            DoubleRectangle $i$f$mapTo2 = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle acc = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.union((DoubleRectangle)el);
        }
        return (DoubleRectangle)accumulator$iv;
    }

    @NotNull
    public final DoubleVector getSize() {
        return this.size;
    }
}

