/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.JdbcConsoleEvaluationSupport;
import com.intellij.database.console.evaluation.OwnerBasedEvaluationRequestor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiRequestor
extends OwnerBasedEvaluationRequestor {
    private static final List<Class<? extends SqlExpression>> UNSUPPORTED_EXPRESSIONS = Arrays.asList(SqlTableExpression.class, SqlBetweenExpression.class, SqlCaseExpression.class, SqlReferenceExpression.class, SqlJoinExpression.class, SqlTableColumnsList.class);
    private final JdbcConsole myConsole;
    private final SqlElement myElement;

    protected PsiRequestor(@Nullable JdbcConsole console, @NotNull SqlElement expression, @NotNull Project project, @NotNull DbDataSource source) {
        if (expression == null) {
            PsiRequestor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PsiRequestor.$$$reportNull$$$0(1);
        }
        if (source == null) {
            PsiRequestor.$$$reportNull$$$0(2);
        }
        super(project, source);
        this.myConsole = console;
        this.myElement = expression;
    }

    @Override
    @Nullable
    public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
        if (owner == null) {
            PsiRequestor.$$$reportNull$$$0(3);
        }
        if (future == null) {
            PsiRequestor.$$$reportNull$$$0(4);
        }
        return new EvaluationRequest(owner, this.myProject, future, this.getQuery(), this.mySource);
    }

    @Override
    @NotNull
    public String getQuery() {
        return PsiRequestor.getQuery(this.myConsole, this.myElement, this.mySource);
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull DbDataSource source) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(5);
        }
        if (source == null) {
            PsiRequestor.$$$reportNull$$$0(6);
        }
        return PsiRequestor.getQuery(console, element, source.getDbms());
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull Dbms id) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(7);
        }
        if (id == null) {
            PsiRequestor.$$$reportNull$$$0(8);
        }
        SqlElement deep = PsiRequestor.findDeepestExpression(element);
        String text = PsiRequestor.getText(console, deep);
        ExecutionEnvironmentHelper helper = (ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(id);
        String string = helper.getQuery(text, deep);
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static SqlExpression getExpression(@NotNull EditorEx editor2, @NotNull Project project, @NotNull JdbcConsoleEvaluationSupport.PositionInfo position) {
        VirtualFile file;
        if (editor2 == null) {
            PsiRequestor.$$$reportNull$$$0(10);
        }
        if (project == null) {
            PsiRequestor.$$$reportNull$$$0(11);
        }
        if (position == null) {
            PsiRequestor.$$$reportNull$$$0(12);
        }
        if ((file = editor2.getVirtualFile()) == null) {
            return null;
        }
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)file);
        int start = position.offset;
        return position.range != null ? PsiRequestor.getSelectedExpression(position.range, psiFile) : PsiRequestor.getExpressionAtCaret(psiFile, start);
    }

    @Override
    public boolean isEmpty() {
        return !(this.myElement instanceof SqlExpression);
    }

    public static boolean isUnsupportedExpression(@Nullable SqlExpression expression) {
        SqlElement deep = expression == null ? null : PsiRequestor.findDeepestExpression((SqlElement)expression);
        return deep == null || ContainerUtil.exists(UNSUPPORTED_EXPRESSIONS, c2 -> c2.isInstance(deep));
    }

    @Nullable
    private static SqlExpression getSelectedExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        int start;
        SqlExpression expression;
        if (range == null) {
            PsiRequestor.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            PsiRequestor.$$$reportNull$$$0(14);
        }
        return PsiRequestor.isUnsupportedExpression(expression = (SqlExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)(start = range.getStartOffset()), (int)(end = range.getEndOffset()), SqlExpression.class)) ? PsiRequestor.getAsExpression(range, psiFile) : expression;
    }

    @Nullable
    private static SqlExpression getAsExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        int start;
        SqlIdentifier identifier;
        SqlAsExpression asExpression;
        if (range == null) {
            PsiRequestor.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            PsiRequestor.$$$reportNull$$$0(16);
        }
        return PsiRequestor.isUnsupportedExpression((SqlExpression)(asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)(identifier = (SqlIdentifier)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)(start = range.getStartOffset()), (int)(end = range.getEndOffset()), SqlIdentifier.class)), SqlAsExpression.class))) ? null : asExpression;
    }

    @Nullable
    private static SqlExpression getExpressionAtCaret(@NotNull PsiFile file, int offset) {
        if (file == null) {
            PsiRequestor.$$$reportNull$$$0(17);
        }
        PsiElement element = file.findElementAt(offset);
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlExpression.class, (boolean)false);
        while (expression != null && PsiRequestor.isUnsupportedExpression(expression)) {
            expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlExpression.class);
        }
        return expression;
    }

    @NotNull
    private static String getText(@Nullable JdbcConsole console, @NotNull SqlElement element) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(18);
        }
        String string = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)(console == null ? null : JdbcConsole.getQueryText(console, element.getTextRange())), (String)element.getText()));
        if (string == null) {
            PsiRequestor.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static SqlElement findDeepestExpression(@NotNull SqlElement element) {
        if (element == null) {
            PsiRequestor.$$$reportNull$$$0(20);
        }
        SqlElement cur = element;
        while (true) {
            List list;
            if (cur instanceof SqlAsExpression) {
                SqlExpression expression = ((SqlAsExpression)cur).getExpression();
                if (expression == null) break;
                cur = expression;
                continue;
            }
            if (!(cur instanceof SqlParenthesizedExpression) || (list = ((SqlParenthesizedExpression)cur).getExpressionList()).size() != 1) break;
            cur = (SqlElement)list.get(0);
        }
        SqlElement sqlElement = cur;
        if (sqlElement == null) {
            PsiRequestor.$$$reportNull$$$0(21);
        }
        return sqlElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 5: 
            case 7: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/PsiRequestor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/PsiRequestor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuery";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeepestExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequest";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 9: 
            case 19: 
            case 21: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAsExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAtCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 19, 21 -> new IllegalStateException(string);
        };
    }
}

