/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.daemon.util;

import com.intellij.execution.process.mediator.daemon.util.NativeCall;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnixUtil {
    private static final boolean IS_UNIX = !System.getProperty("os.name").startsWith("Windows");
    @Nullable
    private static final LibC LIBC = IS_UNIX ? UnixUtil.tryLoadLibC() : null;

    private UnixUtil() {
    }

    @Nullable
    private static LibC tryLoadLibC() {
        try {
            return (LibC)Native.load((String)"c", LibC.class);
        }
        catch (UnsatisfiedLinkError e) {
            return null;
        }
    }

    public static boolean isUnix() {
        return IS_UNIX;
    }

    public static void setup(boolean daemonize) {
        UnixUtil.checkLibc();
        NativeCall.tryRun(UnixUtil::setupSignals, "Failed to setup signals");
        if (daemonize) {
            NativeCall.tryRun(UnixUtil::leadSession, "Failed to make session leader");
        }
    }

    @NotNull
    private static LibC checkLibc() {
        if (!IS_UNIX) {
            throw new IllegalStateException("Not a Unix system");
        }
        if (LIBC == null) {
            throw new IllegalStateException("Unable to load libc");
        }
        LibC libC = LIBC;
        if (libC == null) {
            UnixUtil.$$$reportNull$$$0(0);
        }
        return libC;
    }

    private static void leadSession() throws NativeCall.NativeCallException {
        LibC libc = UnixUtil.checkLibc();
        int sid = libc.setsid();
        if (sid == -1) {
            throw UnixUtil.libcCallError("setsid");
        }
    }

    private static void setupSignals() throws NativeCall.NativeCallException {
        Memory sigset;
        LibC libc = UnixUtil.checkLibc();
        if (libc.sigfillset((Pointer)(sigset = new Memory(256L))) == -1) {
            throw UnixUtil.libcCallError("sigfillset");
        }
        if (libc.sigprocmask(LibCConstants.SIG_UNBLOCK, (Pointer)sigset, Pointer.NULL) == -1) {
            throw UnixUtil.libcCallError("sigprocmask");
        }
        UnixUtil.tryResetSignal(1, "SIGHUP");
        UnixUtil.tryResetSignal(2, "SIGINT");
        UnixUtil.tryResetSignal(3, "SIGQUIT");
        UnixUtil.tryResetSignal(4, "SIGILL");
        UnixUtil.tryResetSignal(5, "SIGTRAP");
        UnixUtil.tryResetSignal(6, "SIGABRT");
        UnixUtil.tryResetSignal(8, "SIGFPE");
        UnixUtil.tryResetSignal(11, "SIGSEGV");
        UnixUtil.tryResetSignal(13, "SIGPIPE");
        UnixUtil.tryResetSignal(14, "SIGALRM");
        UnixUtil.tryResetSignal(15, "SIGTERM");
    }

    private static void tryResetSignal(int signo, @NotNull String signalName) {
        if (signalName == null) {
            UnixUtil.$$$reportNull$$$0(1);
        }
        NativeCall.tryRun(() -> UnixUtil.resetSignal(signo), "Failed to reset " + signalName);
    }

    private static void resetSignal(int signo) throws NativeCall.NativeCallException {
        Memory sa;
        LibC libc = UnixUtil.checkLibc();
        if (libc.sigaction(signo, Pointer.NULL, (Pointer)(sa = new Memory(320L))) == -1) {
            throw UnixUtil.libcCallError("sigaction(" + signo + ")");
        }
        if (!LibCConstants.SIG_IGN.equals((Object)sa.getPointer(0L))) {
            return;
        }
        if (libc.signal(signo, LibCConstants.SIG_DFL) == LibCConstants.SIG_ERR) {
            throw UnixUtil.libcCallError("signal(" + signo + ")");
        }
        System.err.println("Restored ignored signal " + signo + " handler to default");
    }

    @NotNull
    private static NativeCall.NativeCallException libcCallError(@NotNull String message) {
        int lastError;
        if (message == null) {
            UnixUtil.$$$reportNull$$$0(2);
        }
        if (LIBC != null && (lastError = Native.getLastError()) != 0) {
            message = (String)message + ": " + LIBC.strerror(lastError);
        }
        return new NativeCall.NativeCallException((String)message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/mediator/daemon/util/UnixUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "checkLibc";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/mediator/daemon/util/UnixUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryResetSignal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "libcCallError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static interface LibC
    extends Library {
        public int setsid();

        public int sigfillset(Pointer var1);

        public int sigprocmask(int var1, Pointer var2, Pointer var3);

        public int sigaction(int var1, Pointer var2, Pointer var3);

        public Pointer signal(int var1, Pointer var2);

        public String strerror(int var1);
    }

    private static interface LibCConstants {
        public static final int MAX_SIGNAL_NR = 2048;
        public static final int MAX_SIZEOF_SIGSET_T = 256;
        public static final int MAX_SIZEOF_STRUCT_SIGACTION = 320;
        public static final int SIG_UNBLOCK = Platform.isLinux() ? 1 : 2;
        public static final Pointer SIG_DFL = new Pointer(0L);
        public static final Pointer SIG_IGN = new Pointer(1L);
        public static final Pointer SIG_ERR = new Pointer(-1L);
        public static final int SIGHUP = 1;
        public static final int SIGINT = 2;
        public static final int SIGQUIT = 3;
        public static final int SIGILL = 4;
        public static final int SIGTRAP = 5;
        public static final int SIGABRT = 6;
        public static final int SIGFPE = 8;
        public static final int SIGSEGV = 11;
        public static final int SIGPIPE = 13;
        public static final int SIGALRM = 14;
        public static final int SIGTERM = 15;
    }
}

