/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenTestConsoleFilter
implements Filter {
    private static final Pattern REPORT_DIR_PATTERN = Pattern.compile("\\s*(?:\\[INFO\\] +Surefire report directory:|\\[ERROR\\] Please refer to) +(.+?)(?: for the individual test results.)?\\s*");

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Matcher matcherReportDir;
        if (line == null) {
            MavenTestConsoleFilter.$$$reportNull$$$0(0);
        }
        if ((matcherReportDir = REPORT_DIR_PATTERN.matcher(line)).matches()) {
            final String path = matcherReportDir.group(1);
            return new Filter.Result(entireLength - line.length() + matcherReportDir.start(1), entireLength - line.length() + matcherReportDir.end(1), new HyperlinkInfo(){

                public void navigate(@NotNull Project project) {
                    File f;
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((f = new File(path)).isDirectory()) {
                        RevealFileAction.openDirectory((File)f);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenTestConsoleFilter$1", "navigate"));
                }
            });
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/idea/maven/project/MavenTestConsoleFilter", "applyFilter"));
    }
}

