/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.protobuf.ide.PbCompositeModificationTracker;
import com.intellij.protobuf.ide.settings.PbProjectSettings;
import com.intellij.protobuf.lang.PbFileType;
import com.intellij.protobuf.lang.PbLanguage;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.descriptor.DescriptorOptionType;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbImportStatement;
import com.intellij.protobuf.lang.psi.PbOptionStatement;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbPackageStatement;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbSyntaxStatement;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PbFileImpl
extends PsiFileBase
implements PbFile {
    private static final Logger logger = Logger.getInstance(PbFileImpl.class);

    public PbFileImpl(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            PbFileImpl.$$$reportNull$$$0(0);
        }
        super(viewProvider, (Language)PbLanguage.INSTANCE);
    }

    @NotNull
    public FileType getFileType() {
        PbFileType pbFileType = PbFileType.INSTANCE;
        if (pbFileType == null) {
            PbFileImpl.$$$reportNull$$$0(1);
        }
        return pbFileType;
    }

    public String toString() {
        return "Protocol Buffer File";
    }

    @Override
    @Nullable
    public PbSyntaxStatement getSyntaxStatement() {
        return (PbSyntaxStatement)PsiTreeUtil.getChildOfType((PsiElement)this, PbSyntaxStatement.class);
    }

    @Override
    @Nullable
    public PbPackageStatement getPackageStatement() {
        return (PbPackageStatement)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)((PbPackageStatement)PsiTreeUtil.getChildOfType((PsiElement)this, PbPackageStatement.class)), (Object[])new Object[]{PbCompositeModificationTracker.byElement(this)}));
    }

    @Override
    @NotNull
    public List<PbImportStatement> getImportStatements() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PbImportStatement.class), (Object[])new Object[]{PbCompositeModificationTracker.byElement(this)}));
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public SyntaxLevel getSyntaxLevel() {
        PbSyntaxStatement statement = this.getSyntaxStatement();
        SyntaxLevel level = null;
        if (statement != null) {
            level = statement.getSyntaxLevel();
        }
        return level != null ? level : new SyntaxLevel.DeprecatedSyntax("proto2");
    }

    @Override
    @NotNull
    public QualifiedName getPackageQualifiedName() {
        QualifiedName packageQualifiedName;
        PbPackageName packageName;
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement != null && (packageName = packageStatement.getPackageName()) != null && (packageQualifiedName = packageName.getQualifiedName()) != null) {
            QualifiedName qualifiedName = packageQualifiedName;
            if (qualifiedName == null) {
                PbFileImpl.$$$reportNull$$$0(3);
            }
            return qualifiedName;
        }
        QualifiedName qualifiedName = PbPsiUtil.EMPTY_QUALIFIED_NAME;
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(4);
        }
        return qualifiedName;
    }

    @Override
    @Nullable
    public QualifiedName getChildScope() {
        return PbPsiUtil.EMPTY_QUALIFIED_NAME;
    }

    @Override
    public PbFile getPbFile() {
        return this;
    }

    @Override
    @NotNull
    public List<PbStatement> getStatements() {
        List<PbStatement> list = PbPsiImplUtil.getStatements(this);
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PbOptionStatement> getOptionStatements() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PbOptionStatement.class);
        if (list == null) {
            PbFileImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public QualifiedName getDescriptorOptionsTypeName(Descriptor descriptor) {
        QualifiedName qualifiedName = DescriptorOptionType.FILE_OPTIONS.forDescriptor(descriptor);
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(7);
        }
        return qualifiedName;
    }

    @Override
    @NotNull
    public Map<String, Collection<PbSymbol>> getSymbolMap() {
        Map<String, Collection<PbSymbol>> map = this.getPackageSymbolMap(PbPsiUtil.EMPTY_QUALIFIED_NAME);
        if (map == null) {
            PbFileImpl.$$$reportNull$$$0(8);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, Collection<PbSymbol>> getPackageSymbolMap(QualifiedName packageName) {
        QualifiedName declaredPackageName = this.getPackageQualifiedName();
        if (declaredPackageName.equals((Object)packageName)) {
            Map<String, Collection<PbSymbol>> map = PbPsiImplUtil.getCachedSymbolMap(this);
            if (map == null) {
                PbFileImpl.$$$reportNull$$$0(9);
            }
            return map;
        }
        if (declaredPackageName.matchesPrefix(packageName)) {
            PbPackageName packageElement = this.findPackageChildForName(packageName);
            if (packageElement == null) {
                logger.error(String.format("Failed to find a child package for name '%s' even though getPackageQualifiedName() returned '%s'", packageName, declaredPackageName));
                ImmutableMap immutableMap = ImmutableMap.of();
                if (immutableMap == null) {
                    PbFileImpl.$$$reportNull$$$0(10);
                }
                return immutableMap;
            }
            String packageElementName = packageElement.getName();
            if (packageElementName == null) {
                ImmutableMap immutableMap = ImmutableMap.of();
                if (immutableMap == null) {
                    PbFileImpl.$$$reportNull$$$0(11);
                }
                return immutableMap;
            }
            ImmutableMap immutableMap = ImmutableListMultimap.of((Object)packageElementName, (Object)packageElement).asMap();
            if (immutableMap == null) {
                PbFileImpl.$$$reportNull$$$0(12);
            }
            return immutableMap;
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        if (immutableMap == null) {
            PbFileImpl.$$$reportNull$$$0(13);
        }
        return immutableMap;
    }

    @Override
    @NotNull
    public PbSymbolOwner getPrimarySymbolOwner() {
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement == null) {
            PbFileImpl pbFileImpl = this;
            if (pbFileImpl == null) {
                PbFileImpl.$$$reportNull$$$0(14);
            }
            return pbFileImpl;
        }
        PbPackageName packageName = packageStatement.getPackageName();
        if (packageName == null) {
            PbFileImpl pbFileImpl = this;
            if (pbFileImpl == null) {
                PbFileImpl.$$$reportNull$$$0(15);
            }
            return pbFileImpl;
        }
        PbPackageName pbPackageName = packageName;
        if (pbPackageName == null) {
            PbFileImpl.$$$reportNull$$$0(16);
        }
        return pbPackageName;
    }

    @Override
    @NotNull
    public QualifiedName getExtensionOptionScope() {
        QualifiedName qualifiedName = this.getPackageQualifiedName();
        if (qualifiedName == null) {
            PbFileImpl.$$$reportNull$$$0(17);
        }
        return qualifiedName;
    }

    @Override
    @NotNull
    public Map<QualifiedName, Collection<PbSymbol>> getLocalQualifiedSymbolMap() {
        ImmutableMap immutableMap = ((ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeLocalQualifiedSymbolMap(), (Object[])new Object[]{PbCompositeModificationTracker.byElement(this)}))).asMap();
        if (immutableMap == null) {
            PbFileImpl.$$$reportNull$$$0(18);
        }
        return immutableMap;
    }

    @Override
    @NotNull
    public Map<QualifiedName, Collection<PbSymbol>> getExportedQualifiedSymbolMap() {
        ImmutableMap immutableMap = ((ImmutableMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeExportedQualifiedSymbolMap(), (Object[])new Object[]{PbCompositeModificationTracker.byElement(this)}))).asMap();
        if (immutableMap == null) {
            PbFileImpl.$$$reportNull$$$0(19);
        }
        return immutableMap;
    }

    @Override
    @NotNull
    public Map<QualifiedName, Collection<PbSymbol>> getFullQualifiedSymbolMap() {
        ImmutableMap immutableMap = ((ImmutableSetMultimap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.computeFullQualifiedSymbolMap(), (Object[])new Object[]{PbCompositeModificationTracker.byElement(this)}))).asMap();
        if (immutableMap == null) {
            PbFileImpl.$$$reportNull$$$0(20);
        }
        return immutableMap;
    }

    private ImmutableMultimap<QualifiedName, PbSymbol> computeLocalQualifiedSymbolMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        PbFileImpl.addSymbolsRecursively(this, (ImmutableMultimap.Builder<QualifiedName, PbSymbol>)builder);
        return builder.build();
    }

    private static void addSymbolsRecursively(PbSymbolOwner parent, ImmutableMultimap.Builder<QualifiedName, PbSymbol> builder) {
        for (PbSymbol symbol : parent.getSymbols()) {
            QualifiedName symbolQualifiedName = symbol.getQualifiedName();
            if (symbolQualifiedName != null) {
                builder.put((Object)symbolQualifiedName, (Object)symbol);
            }
            if (!(symbol instanceof PbSymbolOwner)) continue;
            PbFileImpl.addSymbolsRecursively((PbSymbolOwner)((Object)symbol), builder);
        }
    }

    private ImmutableMultimap<QualifiedName, PbSymbol> computeExportedQualifiedSymbolMap() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        this.getLocalQualifiedSymbolMap().forEach((arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).putAll(arg_0, arg_1));
        for (PbFile importedFile : this.getImportedFileList(false)) {
            importedFile.getLocalQualifiedSymbolMap().forEach((arg_0, arg_1) -> ((ImmutableMultimap.Builder)builder).putAll(arg_0, arg_1));
        }
        return builder.build();
    }

    private ImmutableSetMultimap<QualifiedName, PbSymbol> computeFullQualifiedSymbolMap() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        this.getLocalQualifiedSymbolMap().forEach((arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)builder).putAll(arg_0, arg_1));
        for (PbFile importedFile : this.getImportedFileList(true)) {
            importedFile.getLocalQualifiedSymbolMap().forEach((arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)builder).putAll(arg_0, arg_1));
        }
        return builder.build();
    }

    private PbPackageName findPackageChildForName(QualifiedName name) {
        PbPackageName lastChild = null;
        PbPackageStatement packageStatement = this.getPackageStatement();
        if (packageStatement == null) {
            return null;
        }
        for (PbPackageName currentPackage = packageStatement.getPackageName(); currentPackage != null && currentPackage.getQualifiedName() != null && currentPackage.getQualifiedName().matchesPrefix(name); currentPackage = currentPackage.getQualifier()) {
            if (currentPackage.getQualifiedName().equals((Object)name)) {
                return lastChild;
            }
            lastChild = currentPackage;
        }
        return name.getComponentCount() == 0 ? lastChild : null;
    }

    private List<PbFile> getImportedFileList(boolean includePrivate) {
        LinkedHashSet<PbFile> importedFiles = new LinkedHashSet<PbFile>();
        PbFileImpl.findImportsRecursively(this, importedFiles, includePrivate);
        return new ArrayList<PbFile>(importedFiles);
    }

    private static void findImportsRecursively(PbFile file, Collection<PbFile> imports, boolean includePrivate) {
        for (PbImportStatement pbImport : file.getImportStatements()) {
            PbFile importedFile;
            PsiElement possibleFile;
            PsiReference ref;
            PbImportName importName;
            if (!includePrivate && !pbImport.isPublic() || (importName = pbImport.getImportName()) == null || (ref = importName.getReference()) == null || !((possibleFile = PbProjectSettings.getInstance(file.getProject()).isIndexBasedResolveEnabled() && ref instanceof PsiPolyVariantReference ? (PsiElement)Arrays.stream(((PsiPolyVariantReference)ref).multiResolve(false)).map(it -> it.getElement()).filter(it -> it instanceof PbFile).findFirst().orElse(null) : ref.resolve()) instanceof PbFile) || imports.contains(importedFile = (PbFile)possibleFile)) continue;
            imports.add(importedFile);
            PbFileImpl.findImportsRecursively(importedFile, imports, false);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PbFileImpl.$$$reportNull$$$0(21);
        }
        if (state == null) {
            PbFileImpl.$$$reportNull$$$0(22);
        }
        if (place == null) {
            PbFileImpl.$$$reportNull$$$0(23);
        }
        for (PbStatement statement : this.getStatements()) {
            if (processor2.execute((PsiElement)statement, state)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/lang/psi/impl/PbFileImpl";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/lang/psi/impl/PbFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionStatements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptorOptionsTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolMap";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageSymbolMap";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimarySymbolOwner";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionOptionScope";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalQualifiedSymbolMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedQualifiedSymbolMap";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullQualifiedSymbolMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

